---
generated_at: 2026-01-30 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-install.py.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードで確認可能

## 2) 参照した情報（Evidence一覧）

- E-01: `tools/install.py` 1-437行目
- E-02: `バッチ一覧.csv` 5行目（install.pyの説明）
- E-03: `tools/install.py` 397-400行目（argparseコマンド定義）
- E-04: `tools/install.py` 401-406行目（--dest-dir, --prefix引数）
- E-05: `tools/install.py` 405-406行目（--headers-only引数）
- E-06: `tools/install.py` 152-156行目（nodeバイナリインストール）
- E-07: `tools/install.py` 158-196行目（共有ライブラリインストール）
- E-08: `tools/install.py` 116-120行目（npmインストール）
- E-09: `tools/install.py` 122-141行目（corepackインストール）
- E-10: `tools/install.py` 214-378行目（ヘッダインストール）
- E-11: `tools/install.py` 201-204行目（manページインストール）
- E-12: `tools/install.py` 198-199行目（デバッグツールインストール）
- E-13: `tools/install.py` 94-95行目（npmシンボリックリンクスキップ）
- E-14: `tools/install.py` 351-352行目（AIX/OS400 node.exp）
- E-15: `tools/install.py` 134-141行目（z/OS対応）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Node.jsバイナリをシステムにインストールする | E-01, E-02, E-06 | ○ |
| C-02 | installとuninstallコマンドをサポート | E-03 | ○ |
| C-03 | --dest-dirでDESTDIRをサポート | E-04 | ○ |
| C-04 | --prefixでインストール先を指定 | E-04 | ○ |
| C-05 | --headers-onlyでヘッダのみインストール | E-05 | ○ |
| C-06 | nodeバイナリをインストール | E-06 | ○ |
| C-07 | 共有ライブラリをインストール（--shared時） | E-07 | ○ |
| C-08 | npmをインストール | E-08 | ○ |
| C-09 | corepackをインストール | E-09 | ○ |
| C-10 | ヘッダファイルをインストール | E-10 | ○ |
| C-11 | manページをインストール | E-11 | ○ |
| C-12 | gdbinit/lldb_commands.pyをインストール | E-12 | ○ |
| C-13 | config.gypiから設定を読み込む | E-01 (行428-431) | ○ |
| C-14 | npmがシンボリックリンクの場合はスキップ | E-13 | ○ |
| C-15 | AIX/OS400でnode.expをインストール | E-14 | ○ |
| C-16 | z/OSで追加のシンボリックリンクを作成 | E-15 | ○ |
| C-17 | OpenBSDではman/man1/に配置 | E-11 (行201-204) | ○ |
| C-18 | デフォルトプレフィックスは/usr/local | E-04 (行403) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] プラットフォーム固有の処理が最新の状態か確認
- [ ] インストールされるヘッダファイルの一覧が網羅的か確認
