---
generated_at: 2026-01-30 17:46:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-lint-sh.mjs

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/lint-sh.mjs` (ソースコード全体)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (バッチ一覧情報)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | --fixオプションで自動修正モードを有効化 | E-01 (L8, L13, L63-73, L101-103) | ○ |
| C-02 | --from-npxオプションでnpx経由実行 | E-01 (L9, L89-94) | ○ |
| C-03 | SHELLCHECK環境変数でパスを指定可能 | E-01 (L89-93) | ○ |
| C-04 | GIT環境変数でgitパスを指定可能 | E-01 (L112-113) | ○ |
| C-05 | shellcheckオプションは--shell=sh --severity=info --enable=all | E-01 (L12) | ○ |
| C-06 | 再帰的にディレクトリを検索する | E-01 (L22-45) | ○ |
| C-07 | build, changelogs, deps等のディレクトリを除外する | E-01 (L29-38) | ○ |
| C-08 | .sh拡張子のファイルを対象とする | E-01 (L41) | ○ |
| C-09 | ハッシュバンは#!/bin/shを期待する | E-01 (L47) | ○ |
| C-10 | hasInvalidHashBang関数でハッシュバンを検証する | E-01 (L48-54) | ○ |
| C-11 | --fix時にハッシュバンを修正する | E-01 (L63-73) | ○ |
| C-12 | shellcheckの結果をgit applyで適用する | E-01 (L115-123) | ○ |
| C-13 | GITHUB_ACTIONS環境ではJSON形式で出力する | E-01 (L14, L124-127, L137-143) | ○ |
| C-14 | アノテーション形式で出力する | E-01 (L77-80, L139-142) | ○ |
| C-15 | spawnでshellcheckを実行する | E-01 (L96-106) | ○ |
| C-16 | parseArgsでコマンドライン引数をパースする | E-01 (L2, L11) | ○ |
| C-17 | statSyncでファイル/ディレクトリを判定する | E-01 (L167) | ○ |
| C-18 | バッチ一覧.csvでの説明と一致 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - スクリプトの処理内容は全てソースコードから確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトの処理フローは明確でソースコードから直接確認可能
- 1: 中リスク - --fixオプション使用時はファイルが変更される

## 6) レビュアーチェックリスト（最小）
- [ ] shellcheckのインストール方法を確認
- [ ] 除外ディレクトリのリストが最新か確認
- [ ] --fixオプションの使用ポリシーを確認
- [ ] GitHub Actionsでの動作を確認
