---
generated_at: 2026-01-30 10:20:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-test.py.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードで確認可能

## 2) 参照した情報（Evidence一覧）

- E-01: `tools/test.py` 1-1863行目
- E-02: `バッチ一覧.csv` 6行目（test.pyの説明）
- E-03: `tools/test.py` 1386-1467行目（BuildOptions関数 - 引数定義）
- E-04: `tools/test.py` 536-544行目（PROGRESS_INDICATORS辞書）
- E-05: `tools/test.py` 945-951行目（TIMEOUT_SCALEFACTOR）
- E-06: `tools/test.py` 1594-1607行目（IGNORED_SUITES）
- E-07: `tools/test.py` 151-179行目（Run関数 - 並列実行）
- E-08: `tools/test.py` 181-239行目（RunSingle関数）
- E-09: `tools/test.py` 216-226行目（フレーキーテスト処理）
- E-10: `tools/test.py` 1007-1009行目（RunTestCases関数）
- E-11: `tools/test.py` 336-414行目（TapProgressIndicator）
- E-12: `tools/test.py` 90-91行目（NODE_OPTIONS除去、umask設定）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Node.jsテストスイートを実行するスクリプト | E-01, E-02 | ○ |
| C-02 | 並列テスト実行をサポート | E-07 | ○ |
| C-03 | デフォルトタイムアウトは120秒 | E-03 (行1401-1402) | ○ |
| C-04 | デフォルトプログレスはmono | E-03 (行1395-1396) | ○ |
| C-05 | verbose/dots/color/tap/monoプログレスインジケータ | E-04 | ○ |
| C-06 | アーキテクチャごとのタイムアウトスケールファクター | E-05 | ○ |
| C-07 | armのDebugは8倍、Releaseは3倍 | E-05 | ○ |
| C-08 | riscv64のDebugは8倍、Releaseは3倍 | E-05 | ○ |
| C-09 | loong64のDebugは4倍、Releaseは1倍 | E-05 | ○ |
| C-10 | IGNORED_SUITESにaddons等が含まれる | E-06 | ○ |
| C-11 | --flaky-testsでフレーキーテスト処理を制御 | E-03 (行1420-1422) | ○ |
| C-12 | keep_retryingで最大99回リトライ | E-09 (行220) | ○ |
| C-13 | --valgrindでValgrind経由実行 | E-03 (行1412-1413) | ○ |
| C-14 | --check-deoptsで脱最適化チェック | E-03 (行1416-1417) | ○ |
| C-15 | --workerでWorkerコンテキスト実行 | E-03 (行1414-1415) | ○ |
| C-16 | TAP形式で結果出力 | E-11 | ○ |
| C-17 | NODE_OPTIONSを環境変数から除去 | E-12 | ○ |
| C-18 | .statusファイルでテスト期待値設定 | E-01 (行1341-1375: ReadConfigurationInto) | ○ |
| C-19 | parallel/sequentialキューで管理 | E-01 (行105-111: ProgressIndicator.__init__) | ○ |
| C-20 | 終了コード0以外でテスト失敗 | E-01 (行1833: exitcode) | ○ |
| C-21 | --skip-testsでテストをスキップ | E-03 (行1426-1428) | ○ |
| C-22 | wpt, benchmark等のスイートが存在 | E-06 | ○ |
| C-23 | GitHub Actions形式のアノテーション出力 | E-04 (actions) | ○ |
| C-24 | deoptsプログレスインジケータが存在 | E-04 | ○ |
| C-25 | SmartOSのECONNREFUSEDでリトライ | E-01 (行202-209) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 新しいテストスイートが追加された場合のドキュメント更新
- [ ] タイムアウトスケールファクターが最新のハードウェアに適切か確認
- [ ] IGNORED_SUITESの一覧が最新か確認
