---
generated_at: 2026-01-30 17:48:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-lint-md.mjs

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/lint-md/lint-md.mjs` (ソースコード全体)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (バッチ一覧情報)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | parseArgsでコマンドライン引数をパースする | E-01 (L2, L11-16) | ○ |
| C-02 | --formatオプションで自動フォーマットモードを有効化 | E-01 (L12-13, L45-48) | ○ |
| C-03 | パスが指定されていない場合はUsageを表示して終了 | E-01 (L18-21) | ○ |
| C-04 | unified().use(remarkParse).use(presetLintNode).use(remarkStringify)でlinter作成 | E-01 (L23-26) | ○ |
| C-05 | to-vfileのread関数でファイルを読み込む | E-01 (L8, L29) | ○ |
| C-06 | linter.processでリント処理を実行する | E-01 (L35) | ○ |
| C-07 | 元ファイルとprocessed結果を比較して差分を検出する | E-01 (L34, L36) | ○ |
| C-08 | doc/api/配下でintroduced_inの存在をチェックする | E-01 (L38-43) | ○ |
| C-09 | --format時に差分があればfs.writeFileSyncで上書き | E-01 (L45-48) | ○ |
| C-10 | 通常時に差分があればprocess.exitCode = 1 | E-01 (L50-51) | ○ |
| C-11 | プラットフォームに応じた修正コマンドを表示 | E-01 (L52-53) | ○ |
| C-12 | messagesがあればvfile-reporterで出力 | E-01 (L9, L55-58) | ○ |
| C-13 | unified、remark-parse、remark-stringifyを使用 | E-01 (L4-6) | ○ |
| C-14 | remark-preset-lint-nodeを使用 | E-01 (L7) | ○ |
| C-15 | 非同期処理でファイルを処理する | E-01 (L28-29, L35) async/await | ○ |
| C-16 | バッチ一覧.csvでの説明と一致 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - スクリプトの処理内容は全てソースコードから確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトの処理フローは明確でソースコードから直接確認可能
- 1: 中リスク - --formatオプション使用時はファイルが変更される

## 6) レビュアーチェックリスト（最小）
- [ ] remark-preset-lint-nodeのルールセットを確認
- [ ] introduced_inの具体的なフォーマットを確認
- [ ] --formatオプションの使用ポリシーを確認
- [ ] npm依存関係のインストール方法を確認
