---
generated_at: 2026-01-30 17:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：51-lint-pr-url.mjs

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **処理時間目標「1秒以内」**：根拠不足（推測値）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/lint-pr-url.mjs` 1-37行目（ソースコード全体）
- E-02: `tools/lint-pr-url.mjs` 4-5行目（Usageコメント）
- E-03: `tools/lint-pr-url.mjs` 10行目（引数取得処理）
- E-04: `tools/lint-pr-url.mjs` 12-15行目（正規表現定義）
- E-05: `tools/lint-pr-url.mjs` 16行目（validatePrUrl関数）
- E-06: `tools/lint-pr-url.mjs` 21行目（readline作成）
- E-07: `tools/lint-pr-url.mjs` 22-36行目（メインループ処理）
- E-08: `tools/lint-pr-url.mjs` 29-32行目（警告出力形式）
- E-09: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 51行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PR URL整合性チェックスクリプトである | E-02, E-09 | ○ |
| C-02 | git diff出力を標準入力から受け取る | E-02, E-06 | ○ |
| C-03 | expected-pr-urlを引数で受け取る | E-03 | ○ |
| C-04 | ファイル区切り検出（+++ b/パターン） | E-04（fileDelimiter） | ○ |
| C-05 | チャンク区切り検出（@@パターン） | E-04（changeDelimiter） | ○ |
| C-06 | pr-url定義行検出 | E-04（prUrlDefinition） | ○ |
| C-07 | URL検証ロジック | E-05 | ○ |
| C-08 | readlineでストリーム処理 | E-06 | ○ |
| C-09 | for await...ofで非同期イテレーション | E-07 | ○ |
| C-10 | GitHub Actions警告形式で出力 | E-08 | ○ |
| C-11 | 削除行は行カウントしない | E-07（33-36行目） | ○ |
| C-12 | ファイル処理時にログ出力 | E-07（25行目） | ○ |
| C-13 | データベース操作なし | E-01 | ○ |
| C-14 | ファイル書き込みなし | E-01 | ○ |
| C-15 | 処理時間目標1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 処理時間目標「1秒以内」は実測値やパフォーマンス要件の明示的な記載がない
  - 候補：CI/CDパイプライン設定 / パフォーマンステスト結果 / 開発者ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能面の主張はすべてソースコードから確認可能
- 0: 低リスク - 処理時間目標は運用上の推測値であり、機能的な誤りではない

## 6) レビュアーチェックリスト（最小）
- [ ] git diff出力形式との互換性を確認
- [ ] GitHub Actions環境での警告形式が正しく動作するか確認
- [ ] 処理時間目標が実際の運用に適切か確認
