---
generated_at: 2026-01-30 17:32:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：53-generate.mjs

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **メモリ使用量「100MB未満」**：根拠不足（推測値）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/doc/generate.mjs` 1-136行目（ソースコード全体）
- E-02: `tools/doc/generate.mjs` 22-36行目（importステートメント）
- E-03: `tools/doc/generate.mjs` 37-38行目（links-mapper.json読み込み）
- E-04: `tools/doc/generate.mjs` 43-48行目（変数初期化）
- E-05: `tools/doc/generate.mjs` 51-73行目（引数パース処理）
- E-06: `tools/doc/generate.mjs` 75-81行目（入力検証）
- E-07: `tools/doc/generate.mjs` 83行目（ファイル読み込み）
- E-08: `tools/doc/generate.mjs` 85-98行目（unifiedパイプライン）
- E-09: `tools/doc/generate.mjs` 100-104行目（出力ファイルパス構築）
- E-10: `tools/doc/generate.mjs` 106-109行目（Promise.allSettled書き込み）
- E-11: `tools/doc/generate.mjs` 112-135行目（結果処理とexit）
- E-12: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 53行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIドキュメント生成スクリプトである | E-12 | ○ |
| C-02 | MarkdownをHTML/JSONに変換 | E-08, E-09 | ○ |
| C-03 | unified/remark/rehypeを使用 | E-02 | ○ |
| C-04 | filenameを引数で取得 | E-05（52-53行目） | ○ |
| C-05 | --node-versionオプション | E-05（54-55行目） | ○ |
| C-06 | --output-directoryオプション | E-05（56-57行目） | ○ |
| C-07 | --apilinksオプション | E-05（58-64行目） | ○ |
| C-08 | --versions-fileオプション | E-05（65-71行目） | ○ |
| C-09 | デフォルトのnodeVersionはprocess.version | E-05（75行目） | ○ |
| C-10 | 入力ファイル必須チェック | E-06（77-78行目） | ○ |
| C-11 | 出力ディレクトリ必須チェック | E-06（79-81行目） | ○ |
| C-12 | frontmatterプラグイン使用 | E-08（86行目） | ○ |
| C-13 | replaceLinksプラグイン使用 | E-08（87行目） | ○ |
| C-14 | markdownパースプラグイン使用 | E-08（88行目） | ○ |
| C-15 | gfmプラグイン使用 | E-08（89行目） | ○ |
| C-16 | jsonAPIプラグイン使用 | E-08（91行目） | ○ |
| C-17 | buildTocプラグイン使用 | E-08（94行目） | ○ |
| C-18 | HTMLとJSONを出力 | E-09, E-10 | ○ |
| C-19 | Promise.allSettledで並列書き込み | E-10 | ○ |
| C-20 | エラー時exit(1) | E-11（124-126行目） | ○ |
| C-21 | 成功時exit(0) | E-11（129行目） | ○ |
| C-22 | メモリ使用量100MB未満 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- メモリ使用量「100MB未満」は実測値やパフォーマンス要件の明示的な記載がない
  - 候補：パフォーマンステスト結果 / ビルドシステム設定 / 開発者ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能面の主張はすべてソースコードから確認可能
- 0: 低リスク - メモリ使用量は運用上の推測値であり、機能的な誤りではない

## 6) レビュアーチェックリスト（最小）
- [ ] unifiedパイプラインのプラグイン順序が正しいか確認
- [ ] html.mjs, json.mjs, markdown.mjsとの依存関係を確認
- [ ] links-mapper.jsonの形式と内容を確認
- [ ] 出力HTMLのテンプレート構造を確認
