---
generated_at: 2026-01-30 17:36:00
metrics:
  claims_total: 19
  claims_with_evidence: 19
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：54-addon-verify.mjs

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：19 / 19、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/doc/addon-verify.mjs` 1-93行目（ソースコード全体）
- E-02: `tools/doc/addon-verify.mjs` 1-5行目（コメント：目的説明）
- E-03: `tools/doc/addon-verify.mjs` 7-12行目（importステートメント）
- E-04: `tools/doc/addon-verify.mjs` 14-16行目（パス定義）
- E-05: `tools/doc/addon-verify.mjs` 18-19行目（ファイル読み込みとパース）
- E-06: `tools/doc/addon-verify.mjs` 24行目（validNames正規表現）
- E-07: `tools/doc/addon-verify.mjs` 25-37行目（AST走査処理）
- E-08: `tools/doc/addon-verify.mjs` 44-57行目（verifyFiles関数）
- E-09: `tools/doc/addon-verify.mjs` 53行目（ディレクトリ名変換）
- E-10: `tools/doc/addon-verify.mjs` 59-74行目（ファイル処理とtest.js修正）
- E-11: `tools/doc/addon-verify.mjs` 76-87行目（binding.gyp生成）
- E-12: `tools/doc/addon-verify.mjs` 89-92行目（ファイル書き出し）
- E-13: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 54行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アドオンドキュメント検証スクリプトである | E-02, E-13 | ○ |
| C-02 | doc/api/addons.mdを読み込む | E-04, E-05 | ○ |
| C-03 | unified/remarkでパース | E-03, E-05 | ○ |
| C-04 | ヘッダーでセクション名を取得 | E-07（26-30行目） | ○ |
| C-05 | コードブロックからコード抽出 | E-07（31-36行目） | ○ |
| C-06 | ファイル名コメント検出 | E-06（validNames正規表現） | ○ |
| C-07 | .ccと.jsの両方必須でテスト対象 | E-08（47-51行目） | ○ |
| C-08 | 連番ディレクトリ名生成 | E-08（54-57行目） | ○ |
| C-09 | セクション名の正規化（小文字、_変換） | E-09 | ○ |
| C-10 | test.jsのrequireパス修正 | E-10（61-66行目） | ○ |
| C-11 | common.buildType参照に変換 | E-10（64-66行目） | ○ |
| C-12 | binding.gyp自動生成 | E-11 | ○ |
| C-13 | target_name: 'addon'固定 | E-11（80行目） | ○ |
| C-14 | includes: ['../common.gypi']参照 | E-11（83行目） | ○ |
| C-15 | mkdirでディレクトリ作成 | E-12（89行目） | ○ |
| C-16 | writeFileでファイル書き出し | E-12（91-92行目） | ○ |
| C-17 | Promise.allで並列実行 | E-01（39-42行目） | ○ |
| C-18 | test/addons/に出力 | E-04（16行目） | ○ |
| C-19 | コマンドライン引数なし | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] validNames正規表現が想定するファイル名形式をカバーしているか確認
- [ ] binding.gypの構造がnode-gypで正しくビルドできるか確認
- [ ] common.gypiとの依存関係を確認
- [ ] test.js修正のrequireパス変換が正しいか確認
