---
generated_at: 2026-01-30 17:44:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：56-getnodeversion.py

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/getnodeversion.py` 1-21行目（ソースコード全体）
- E-02: `tools/getnodeversion.py` 1行目（from __future__ import print_function）
- E-03: `tools/getnodeversion.py` 5-13行目（get_major_minor_patch関数）
- E-04: `tools/getnodeversion.py` 7-8行目（NODE_MAJOR_VERSION検出）
- E-05: `tools/getnodeversion.py` 9-10行目（NODE_MINOR_VERSION検出）
- E-06: `tools/getnodeversion.py` 11-12行目（NODE_PATCH_VERSION検出）
- E-07: `tools/getnodeversion.py` 16-19行目（node_version.hパス構築）
- E-08: `tools/getnodeversion.py` 20-21行目（ファイル読み込みと出力）
- E-09: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 56行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バージョン取得スクリプトである | E-09 | ○ |
| C-02 | src/node_version.hを読み込む | E-07, E-08 | ○ |
| C-03 | get_major_minor_patch関数で抽出 | E-03 | ○ |
| C-04 | NODE_MAJOR_VERSIONを検出 | E-04 | ○ |
| C-05 | NODE_MINOR_VERSIONを検出 | E-05 | ○ |
| C-06 | NODE_PATCH_VERSIONを検出 | E-06 | ○ |
| C-07 | 3番目のトークンを抽出 | E-04, E-05, E-06（line.split()[2]） | ○ |
| C-08 | major.minor.patch形式で出力 | E-08（'.'.join） | ○ |
| C-09 | コマンドライン引数なし | E-01 | ○ |
| C-10 | Python 2/3両対応 | E-02 | ○ |
| C-11 | ファイル出力なし | E-01 | ○ |
| C-12 | データベース操作なし | E-01 | ○ |
| C-13 | 読み取り専用処理 | E-01 | ○ |
| C-14 | __file__からパス計算 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] node_version.hのパスが正しいか確認
- [ ] バージョン定義の形式が想定通りか確認
- [ ] Python 2/3両環境で動作するか確認
