---
generated_at: 2026-01-30 17:52:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：58-getnapibuildversion.py

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/getnapibuildversion.py` 1-26行目（ソースコード全体）
- E-02: `tools/getnapibuildversion.py` 1行目（from __future__ import print_function）
- E-03: `tools/getnapibuildversion.py` 6-22行目（get_napi_version関数）
- E-04: `tools/getnapibuildversion.py` 7-11行目（napi_version_hパス構築）
- E-05: `tools/getnapibuildversion.py` 13行目（ファイルオープン）
- E-06: `tools/getnapibuildversion.py` 15行目（正規表現パターン）
- E-07: `tools/getnapibuildversion.py` 17-20行目（ループとマッチング）
- E-08: `tools/getnapibuildversion.py` 22行目（Exception発生）
- E-09: `tools/getnapibuildversion.py` 25-26行目（メイン処理）
- E-10: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 58行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | N-APIビルドバージョン取得スクリプトである | E-10 | ○ |
| C-02 | src/node_version.hを読み込む | E-04, E-05 | ○ |
| C-03 | get_napi_version関数で抽出 | E-03 | ○ |
| C-04 | 正規表現でNODE_API_SUPPORTED_VERSION_MAXを検出 | E-06 | ○ |
| C-05 | ^#define NODE_API_SUPPORTED_VERSION_MAXパターン | E-06 | ○ |
| C-06 | 行単位でループ | E-07 | ○ |
| C-07 | マッチ時に即座にreturn | E-07（19-20行目） | ○ |
| C-08 | 3番目のトークンを抽出 | E-07（line.split()[2]） | ○ |
| C-09 | パターン未検出時はException | E-08 | ○ |
| C-10 | コマンドライン引数なし | E-01 | ○ |
| C-11 | Python 2/3両対応 | E-02 | ○ |
| C-12 | ファイル出力なし | E-01 | ○ |
| C-13 | データベース操作なし | E-01 | ○ |
| C-14 | __name__ == '__main__'でメイン実行 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] node_version.hのパスが正しいか確認
- [ ] NODE_API_SUPPORTED_VERSION_MAX定義の形式が想定通りか確認
- [ ] 正規表現パターンがすべてのケースをカバーするか確認
- [ ] Python 2/3両環境で動作するか確認
