---
generated_at: 2026-01-30 10:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-build_addons.py.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードで確認可能

## 2) 参照した情報（Evidence一覧）

- E-01: `tools/build_addons.py` 1-152行目
- E-02: `バッチ一覧.csv` 7行目（build_addons.pyの説明）
- E-03: `tools/build_addons.py` 106-131行目（argparse引数定義）
- E-04: `tools/build_addons.py` 14-24行目（generate_headers関数）
- E-05: `tools/build_addons.py` 26-91行目（rebuild_addons関数）
- E-06: `tools/build_addons.py` 89-91行目（ThreadPoolExecutor使用）
- E-07: `tools/build_addons.py` 40-44行目（Windows node.libコピー）
- E-08: `tools/build_addons.py` 74-87行目（ビルド対象検出）
- E-09: `tools/build_addons.py` 107-108行目（cygwin非サポート）
- E-10: `tools/build_addons.py` 142-147行目（一時ディレクトリ処理）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ネイティブアドオンをビルドするスクリプト | E-01, E-02 | ○ |
| C-02 | node-gypを使用してビルド | E-05 (行46-57) | ○ |
| C-03 | ThreadPoolExecutorで並列ビルド | E-06 | ○ |
| C-04 | デフォルトログレベルはsilent | E-03 (行119-120) | ○ |
| C-05 | デフォルト設定はRelease | E-03 (行129-130) | ○ |
| C-06 | --headers-dir未指定時は一時ディレクトリ生成 | E-10 | ○ |
| C-07 | install.pyを使用してヘッダ生成 | E-04 | ○ |
| C-08 | Windowsでnode.libをコピー | E-07 | ○ |
| C-09 | binding.gypを持つディレクトリを検出 | E-08 | ○ |
| C-10 | --skip-testsでスキップ可能 | E-03 (行121-122) | ○ |
| C-11 | --only-testsで指定テストのみビルド | E-03 (行123-124) | ○ |
| C-12 | cygwin pythonは非サポート | E-09 | ○ |
| C-13 | 終了時に一時ディレクトリを削除 | E-10 (行147: shutil.rmtree) | ○ |
| C-14 | node-gypパスはデフォルトでdeps/npm配下 | E-03 (行125-126) | ○ |
| C-15 | ビルド失敗時はエラーメッセージを出力 | E-05 (行63-68) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] node-gypのパスがnpmの構造変更で変わっていないか確認
- [ ] ThreadPoolExecutorのデフォルトワーカー数が適切か確認
