---
generated_at: 2026-01-30 17:32:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：62-osx-codesign.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間30秒以内**：根拠不足（推定値）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/osx-codesign.sh` 1-21行目（スクリプト本体）
- E-02: `tools/osx-codesign.sh` 7-9行目（SIGN環境変数チェック）
- E-03: `tools/osx-codesign.sh` 11-14行目（コメント：Hardened Runtime要件）
- E-04: `tools/osx-codesign.sh` 16-21行目（codesignコマンド）
- E-05: `tools/osx-entitlements.plist` 1-18行目（entitlements定義）
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 62行目（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SIGN環境変数が未設定の場合はスキップする | E-02 | ○ |
| C-02 | codesignコマンドでコード署名を実行する | E-04 | ○ |
| C-03 | --sign オプションでSIGN環境変数を使用する | E-04 | ○ |
| C-04 | --entitlements オプションでosx-entitlements.plistを使用する | E-04 | ○ |
| C-05 | --options runtime でHardened Runtimeを有効化する | E-04 | ○ |
| C-06 | --timestamp でタイムスタンプを付与する | E-04 | ○ |
| C-07 | $PKGDIR/bin/nodeを署名対象とする | E-04 | ○ |
| C-08 | macOS Catalina以降のGatekeeper要件に対応 | E-03 | ○ |
| C-09 | JITコンパイル権限を宣言している | E-05 | ○ |
| C-10 | 未署名実行可能メモリ権限を宣言している | E-05 | ○ |
| C-11 | ライブラリバリデーション無効化権限を宣言している | E-05 | ○ |
| C-12 | set -eでエラー時に即座に終了する | E-01 | ○ |
| C-13 | set -xでコマンドをデバッグ出力する | E-01 | ○ |
| C-14 | 目標処理時間は30秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間30秒の根拠がソースコードから確認できない
  - 候補：リリースCI設定 / パフォーマンステスト結果 / 運用ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 署名処理は標準的なcodesignコマンドを使用しており、処理フローはソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Apple Developer ID証明書が有効期限内であることを確認
- [ ] entitlementsファイルの権限設定がNode.jsの要件を満たしているか確認
- [ ] https://github.com/nodejs/node/pull/31459 の変更内容を確認
- [ ] 目標処理時間の妥当性を運用実績から確認
