---
generated_at: 2026-01-30 17:34:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：63-osx-notarize.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間10分以内**：根拠不足（推定値、Appleサーバー応答時間依存）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/osx-notarize.sh` 1-59行目（スクリプト本体）
- E-02: `tools/osx-notarize.sh` 3-5行目（コメント：公証目的説明）
- E-03: `tools/osx-notarize.sh` 8-11行目（pkgid引数チェック）
- E-04: `tools/osx-notarize.sh` 14-17行目（NOTARIZATION_ID確認）
- E-05: `tools/osx-notarize.sh` 19-22行目（NOTARIZATION_PASSWORD確認）
- E-06: `tools/osx-notarize.sh` 24-27行目（NOTARIZATION_TEAM_ID確認）
- E-07: `tools/osx-notarize.sh` 31-35行目（notarytool存在確認）
- E-08: `tools/osx-notarize.sh` 39-42行目（notarytool submit実行）
- E-09: `tools/osx-notarize.sh` 44-49行目（提出結果確認）
- E-10: `tools/osx-notarize.sh` 51-56行目（spctl検証）
- E-11: `tools/osx-notarize.sh` 58-59行目（stapler実行）
- E-12: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 63行目（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pkgid引数が未指定の場合はUsageを表示して終了 | E-03 | ○ |
| C-02 | NOTARIZATION_ID未設定の場合はスキップ | E-04 | ○ |
| C-03 | NOTARIZATION_PASSWORD未設定の場合はスキップ | E-05 | ○ |
| C-04 | NOTARIZATION_TEAM_ID未設定の場合はスキップ | E-06 | ○ |
| C-05 | notarytoolが存在しない場合はエラー終了 | E-07 | ○ |
| C-06 | xcrun notarytool submitで公証を提出 | E-08 | ○ |
| C-07 | --keychain-profileでNODE_RELEASE_PROFILEを使用 | E-08 | ○ |
| C-08 | --waitオプションで完了を待機 | E-08 | ○ |
| C-09 | 提出失敗時はエラーメッセージを出力して終了 | E-09 | ○ |
| C-10 | xcrun spctlで署名検証を実行 | E-10 | ○ |
| C-11 | spctl検証失敗時はエラーメッセージを出力して終了 | E-10 | ○ |
| C-12 | xcrun stapler stapleで公証チケットを埋め込み | E-11 | ○ |
| C-13 | Xcode 13以降が必要 | E-02 | ○ |
| C-14 | macOS Catalina以降のGatekeeper要件に対応 | E-02 | ○ |
| C-15 | node-{pkgid}.pkgファイルを対象とする | E-08 | ○ |
| C-16 | Notarytoolを使用した公証処理であることをログ出力 | E-01 | ○ |
| C-17 | 成功時に"Stapler was successful."を出力 | E-11 | ○ |
| C-18 | 目標処理時間は10分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間10分の根拠がソースコードから確認できない
  - 候補：リリースCI設定 / 運用実績データ / Apple公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 公証処理はAppleサーバーに依存するため、処理時間が不安定になる可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] NODE_RELEASE_PROFILEがKeychainに正しく設定されているか確認
- [ ] Apple Developer Programアカウントのステータスを確認
- [ ] App-Specific Passwordの有効期限を確認
- [ ] 公証処理のタイムアウト設定の妥当性を確認
