---
generated_at: 2026-01-30 17:36:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：64-osx-productsign.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間30秒以内**：根拠不足（推定値）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/osx-productsign.sh` 1-14行目（スクリプト本体）
- E-02: `tools/osx-productsign.sh` 7-9行目（SIGN環境変数チェック）
- E-03: `tools/osx-productsign.sh` 12行目（productsignコマンド実行）
- E-04: `tools/osx-productsign.sh` 14行目（mvコマンドによるファイル置き換え）
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 64行目（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SIGN環境変数が未設定の場合はスキップする | E-02 | ○ |
| C-02 | productsignコマンドでインストーラー署名を実行する | E-03 | ○ |
| C-03 | --sign オプションでSIGN環境変数を使用する | E-03 | ○ |
| C-04 | $PKG環境変数で署名対象ファイルを指定する | E-03 | ○ |
| C-05 | 署名済みファイルを$PKG-SIGNEDとして出力する | E-03 | ○ |
| C-06 | mvコマンドで署名済みファイルを元ファイルに置き換える | E-04 | ○ |
| C-07 | set -eでエラー時に即座に終了する | E-01 | ○ |
| C-08 | set -xでコマンドをデバッグ出力する | E-01 | ○ |
| C-09 | macOS専用のスクリプトである | E-05 | ○ |
| C-10 | インストーラーに署名を行う | E-05 | ○ |
| C-11 | スキップ時のメッセージが"Skipping codesign."である | E-02 | ○ |
| C-12 | 目標処理時間は30秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間30秒の根拠がソースコードから確認できない
  - 候補：リリースCI設定 / パフォーマンステスト結果 / 運用ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトはシンプルで、処理フローは明確にソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Developer ID Installer証明書が有効期限内であることを確認
- [ ] Developer ID Application証明書との違いを理解しているか確認
- [ ] osx-codesign.shとの処理順序が正しいか確認
- [ ] 目標処理時間の妥当性を運用実績から確認
