---
generated_at: 2026-01-30 17:46:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：69-cpu.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間1秒以内**：根拠不足（推定値）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `benchmark/cpu.sh` 1-77行目（スクリプト本体）
- E-02: `benchmark/cpu.sh` 3行目（CPUPATH定義）
- E-03: `benchmark/cpu.sh` 5行目（MAXID取得）
- E-04: `benchmark/cpu.sh` 7-8行目（Linux確認と警告）
- E-05: `benchmark/cpu.sh` 10-11行目（root確認と警告）
- E-06: `benchmark/cpu.sh` 13-21行目（get_default_governor関数）
- E-07: `benchmark/cpu.sh` 23-35行目（set_governor関数）
- E-08: `benchmark/cpu.sh` 37-51行目（usage関数）
- E-09: `benchmark/cpu.sh` 53-73行目（caseによるコマンド分岐）
- E-10: `benchmark/cpu.sh` 54-58行目（fast/performanceコマンド処理）
- E-11: `benchmark/cpu.sh` 60-63行目（reset/defaultコマンド処理）
- E-12: `benchmark/cpu.sh` 65-68行目（get/statusコマンド処理）
- E-13: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 69行目（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CPUPATHを/sys/devices/system/cpuに設定する | E-02 | ○ |
| C-02 | /sys/devices/system/cpu/presentからMAXIDを取得する | E-03 | ○ |
| C-03 | Linux以外で実行時に警告を表示する | E-04 | ○ |
| C-04 | 非root時に警告を表示しsudoを推奨する | E-05 | ○ |
| C-05 | デフォルトガバナーの優先順位はschedutil>ondemand>conservative>powersave | E-06 | ○ |
| C-06 | set_governor関数で全コアにガバナーを設定する | E-07 | ○ |
| C-07 | 0からMAXIDまでのコアに対してループ処理を行う | E-07 | ○ |
| C-08 | usage関数でヘルプメッセージを表示する | E-08 | ○ |
| C-09 | fast/performanceコマンドでperformanceガバナーに設定する | E-10 | ○ |
| C-10 | fastモード時に最高速度ロックの警告を表示する | E-10 | ○ |
| C-11 | resetコマンド後にリセットを推奨するメッセージを表示する | E-10 | ○ |
| C-12 | reset/defaultコマンドでデフォルトガバナーに戻す | E-11 | ○ |
| C-13 | get/statusコマンドで現在のガバナーを表示する | E-12 | ○ |
| C-14 | grepで全コアのガバナーを一括取得する | E-12 | ○ |
| C-15 | 不正なコマンドでexit 1する | E-09 | ○ |
| C-16 | パフォーマンス測定用のスクリプトである | E-13 | ○ |
| C-17 | 目標処理時間は1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間1秒の根拠がソースコードから確認できない
  - 候補：パフォーマンステスト結果 / ユーザビリティ要件

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - システム設定を変更するスクリプトであり、root権限が必要。誤った使用でシステムの発熱や電力消費に影響を与える可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] sysfsのパス（/sys/devices/system/cpu/cpu*/cpufreq/）が現在のLinuxカーネルで有効か確認
- [ ] performanceモードでの発熱・電力消費についてドキュメントに十分な警告があるか確認
- [ ] ベンチマーク完了後のreset実行を促すメッセージが十分か確認
