---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-test-npm-package.js.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードで確認可能

## 2) 参照した情報（Evidence一覧）

- E-01: `tools/test-npm-package.js` 1-140行目
- E-02: `バッチ一覧.csv` 8行目（test-npm-package.jsの説明）
- E-03: `tools/test-npm-package.js` 109-137行目（parseArgs関数 - 引数定義）
- E-04: `tools/test-npm-package.js` 39-107行目（runNPMPackageTests関数）
- E-05: `tools/test-npm-package.js` 40-43行目（MD5ハッシュによる一時ディレクトリ生成）
- E-06: `tools/test-npm-package.js` 31-37行目（spawnCopyDeepSync関数）
- E-07: `tools/test-npm-package.js` 53-70行目（npm環境変数設定）
- E-08: `tools/test-npm-package.js` 72-86行目（rebuild/install処理）
- E-09: `tools/test-npm-package.js` 88-101行目（テスト実行とログ出力）
- E-10: `tools/test-npm-package.js` 103-106行目（終了時クリーンアップ）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NPMパッケージを隔離環境でテスト | E-01, E-02, E-04 | ○ |
| C-02 | ソースディレクトリのMD5ハッシュで一時ディレクトリ作成 | E-05 | ○ |
| C-03 | --installでnpm installを実行 | E-03 (行121-122), E-08 | ○ |
| C-04 | --rebuildでnpm rebuildを実行 | E-03 (行123-124), E-08 | ○ |
| C-05 | --logfileでstdoutをファイル出力 | E-03 (行127-128), E-09 | ○ |
| C-06 | Windowsではxcopy.exeを使用 | E-06 (行32-34) | ○ |
| C-07 | Unixではcp -rを使用 | E-06 (行36) | ○ |
| C-08 | npm_config_cache等を環境変数で設定 | E-07 | ○ |
| C-09 | npm installは--ignore-scripts --no-saveで実行 | E-08 (行83-84) | ○ |
| C-10 | npm runは--silentモードで実行 | E-09 (行90) | ○ |
| C-11 | テスト終了時に一時ディレクトリ削除 | E-10 | ○ |
| C-12 | deps/npm/bin/npm-cli.jsを使用 | E-01 (行28) | ○ |
| C-13 | test/common/tmpdirモジュールを使用 | E-01 (行25) | ○ |
| C-14 | ソースディレクトリ未指定でエラー | E-03 (行133-135) | ○ |
| C-15 | 認識できないオプションでエラー | E-03 (行130) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] deps/npm配下のパス構造が変更されていないか確認
- [ ] test/common/tmpdirモジュールの仕様変更がないか確認
