---
generated_at: 2026-01-30 17:48:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：70-js2c.cc

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **目標処理時間10秒以内**：根拠不足（推定値）
  2. **メモリ使用量上限1GB以下**：根拠不足（推定値）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/js2c.cc` 1-965行目（ソースコード本体）
- E-02: `tools/js2c.cc` 27-29行目（Main関数宣言、is_verbose変数）
- E-03: `tools/js2c.cc` 74-76行目（FilenameIsConfigGypi関数）
- E-04: `tools/js2c.cc` 81-130行目（SearchFiles関数）
- E-05: `tools/js2c.cc` 132-146行目（拡張子定義とHasAllowedExtensions関数）
- E-06: `tools/js2c.cc` 174-209行目（kTemplate定義）
- E-07: `tools/js2c.cc` 237-271行目（ReadFileSync関数）
- E-08: `tools/js2c.cc` 301-326行目（WriteIfChanged関数）
- E-09: `tools/js2c.cc` 328-362行目（GetFileId、GetVariableName関数）
- E-10: `tools/js2c.cc` 445-593行目（GetDefinitionImpl関数）
- E-11: `tools/js2c.cc` 595-634行目（Simplify関数）
- E-12: `tools/js2c.cc` 636-670行目（GetDefinition関数）
- E-13: `tools/js2c.cc` 672-722行目（AddModule関数）
- E-14: `tools/js2c.cc` 743-804行目（JSONify関連関数）
- E-15: `tools/js2c.cc` 806-825行目（AddGypi関数）
- E-16: `tools/js2c.cc` 827-859行目（JS2C関数）
- E-17: `tools/js2c.cc` 870-956行目（Main関数）
- E-18: `tools/js2c.cc` 946-950行目（eslint.config_partial.mjs除外）
- E-19: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 70行目（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | --verboseオプションで詳細ログを出力する | E-02, E-17 | ○ |
| C-02 | --rootオプションでプロジェクトルートを指定できる | E-17 | ○ |
| C-03 | SearchFilesで.js/.mjsファイルを再帰的に検索する | E-04 | ○ |
| C-04 | config.gypiが入力に必須である | E-03, E-17 | ○ |
| C-05 | .js、.mjs、.gypi拡張子のみサポートする | E-05 | ○ |
| C-06 | kTemplateを使用してC++コードを生成する | E-06 | ○ |
| C-07 | ReadFileSyncでファイルを読み込む | E-07 | ○ |
| C-08 | WriteIfChangedで差分がある場合のみ書き込む | E-08 | ○ |
| C-09 | GetFileIdでパスからファイルIDを生成する | E-09 | ○ |
| C-10 | GetVariableNameでC++変数名を生成する | E-09 | ○ |
| C-11 | simdutfでUTF変換を行う | E-10, E-12 | ○ |
| C-12 | ASCII、Latin-1、UTF-16のエンコーディングを判定する | E-12 | ○ |
| C-13 | GetDefinitionImplでC++データ定義を生成する | E-10 | ○ |
| C-14 | undiciの特殊文字をSimplifyで変換する | E-11 | ○ |
| C-15 | AddModuleで各ファイルの処理を行う | E-13 | ○ |
| C-16 | JSONifyでconfig.gypiをJSON化する | E-14 | ○ |
| C-17 | StripCommentsでコメントを除去する | E-14 | ○ |
| C-18 | AddGypiでconfig.gypiを処理する | E-15 | ○ |
| C-19 | JS2C関数がメイン処理を実行する | E-16 | ○ |
| C-20 | eslint.config_partial.mjsは除外される | E-18 | ○ |
| C-21 | NODE_JS2C_USE_STRING_LITERALSで文字列リテラル出力が可能 | E-10 | ○ |
| C-22 | BuiltinSourceMapの初期化子を生成する | E-06, E-13 | ○ |
| C-23 | 目標処理時間は10秒以内 | **根拠なし** | △ |
| C-24 | メモリ使用量上限は1GB以下 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間10秒、メモリ使用量1GBの根拠がソースコードから確認できない
  - 候補：パフォーマンステスト結果 / ビルドシステム要件 / CI設定

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - コード生成ツールであり、生成されたコードがNode.jsのビルドに直接影響する。エンコーディング変換のバグは起動時クラッシュにつながる可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] simdutfライブラリのバージョンと互換性を確認
- [ ] lib/ディレクトリの新規追加モジュールが正しく処理されるか確認
- [ ] NODE_JS2C_USE_STRING_LITERALS使用時の出力が正しいか確認
- [ ] undici以外に特殊文字変換が必要なファイルがないか確認
