---
generated_at: 2026-01-30 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-release.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードで確認可能

## 2) 参照した情報（Evidence一覧）

- E-01: `tools/release.sh` 1-252行目
- E-02: `バッチ一覧.csv` 9行目（release.shの説明）
- E-03: `tools/release.sh` 24-50行目（getoptsオプション解析）
- E-04: `tools/release.sh` 52-98行目（GPGキー選択処理）
- E-05: `tools/release.sh` 100-107行目（checktag関数 - Gitタグ検証）
- E-06: `tools/release.sh` 112-191行目（sign関数 - 署名処理）
- E-07: `tools/release.sh` 200-213行目（プロモート可能リリース検出）
- E-08: `tools/release.sh` 225-251行目（プロモート実行ループ）
- E-09: `tools/release.sh` 11-22行目（定数定義）
- E-10: `tools/release.sh` 172-186行目（Cloudflare R2アップロード）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リリースのプロモートとGPG署名を行う | E-01, E-02 | ○ |
| C-02 | -sオプションで署名のみ実行 | E-03 (行37-39), E-01 (行194-198) | ○ |
| C-03 | -iオプションでカスタムSSHキー指定 | E-03 (行31-33), E-09 (行19) | ○ |
| C-04 | -rオプションでREADMEパス指定 | E-03 (行34-36), E-09 (行20) | ○ |
| C-05 | -aオプションで全GPGキー使用 | E-03 (行26-30), E-04 (行58-66) | ○ |
| C-06 | GPGフィンガープリントをREADMEで検証 | E-04 (行92-95) | ○ |
| C-07 | 複数GPGキーがある場合は選択を促す | E-04 (行75-88) | ○ |
| C-08 | Gitタグの署名を検証 | E-05 | ○ |
| C-09 | dist-promotableでプロモート可能リリース検出 | E-07 (行208) | ○ |
| C-10 | dist-promoteでプロモート実行 | E-08 (行246) | ○ |
| C-11 | dist-signでSHASUMS256.txt生成 | E-06 (行126) | ○ |
| C-12 | GPGでクリア署名（.asc）を作成 | E-06 (行144) | ○ |
| C-13 | GPGでデタッチ署名（.sig）を作成 | E-06 (行145) | ○ |
| C-14 | SCPでサーバーにアップロード | E-06 (行168) | ○ |
| C-15 | rcloneでCloudflare R2にアップロード | E-10 | ○ |
| C-16 | デフォルトホストはdirect.nodejs.org | E-09 (行11) | ○ |
| C-17 | Cloudflare R2バケットはr2:dist-prod | E-09 (行22) | ○ |
| C-18 | SHA256ダイジェストアルゴリズム使用 | E-06 (行144-145: --digest-algo SHA256) | ○ |
| C-19 | GitHubでnode_version.hを確認 | E-06 (行117-122) | ○ |
| C-20 | 一時ディレクトリは/tmp/_node_release.$$ | E-06 (行137) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] リリースサーバーのホスト名・ユーザー名が最新か確認
- [ ] Cloudflare R2のバケット名が正しいか確認
- [ ] GPGキーの要件（ビット数等）が現在のセキュリティ基準を満たすか確認
