---
generated_at: 2026-01-30 18:30:00
metrics:
  claims_total: 80
  claims_with_evidence: 80
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lib-internal-assert.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：80 / 80、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースがソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/assert/myers_diff.js`
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/assert/utils.js`
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/assert/assertion_error.js`

## 3) Claims と根拠の対応（レビューの主戦場）

### myers_diff.js 関連（UT-ASS-001 〜 UT-ASS-018）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | areLinesEqual関数は同一文字列でtrueを返す | E-01 (L24-32) `if (actual === expected) { return true; }` | ○ |
| C-02 | areLinesEqual関数はcheckCommaDisparityがtrueでカンマ差異を許容 | E-01 (L28-30) `return (actual + ',') === expected \|\| actual === (expected + ',');` | ○ |
| C-03 | areLinesEqual関数は異なる文字列でfalseを返す | E-01 (L31) `return false;` | ○ |
| C-04 | myersDiff関数は入力サイズ上限チェックを行う | E-01 (L39-45) `if (max > 2 ** 31 - 1) { throw new ERR_OUT_OF_RANGE(...) }` | ○ |
| C-05 | myersDiff関数はInt32Arrayを使用して差分計算 | E-01 (L47) `const v = new Int32Array(2 * max + 1);` | ○ |
| C-06 | backtrack関数はトレースから差分結果を復元 | E-01 (L80-125) backtrack関数の実装 | ○ |
| C-07 | printSimpleMyersDiff関数は差分をカラー付き文字列に変換 | E-01 (L127-144) printSimpleMyersDiff関数の実装 | ○ |
| C-08 | printMyersDiff関数はNOP行を5行で折りたたむ | E-01 (L17, L157-166) `kNopLinesToCollapse = 5` と折りたたみロジック | ○ |
| C-09 | kOperationsは-1(DELETE), 0(NOP), 1(INSERT)を定義 | E-01 (L18-22) kOperationsオブジェクトの定義 | ○ |

### utils.js 関連（UT-ASS-019 〜 UT-ASS-036）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | getErrMessage関数はスタックトレースからソース式を取得 | E-02 (L79-96) getErrMessage関数の実装 | ○ |
| C-11 | innerFail関数は空メッセージをundefinedに変換 | E-02 (L102-103) `if (obj.message.length === 0) { obj.message = undefined; }` | ○ |
| C-12 | innerFail関数は文字列配列をformat処理 | E-02 (L104-109) format関数呼び出しのロジック | ○ |
| C-13 | innerFail関数はErrorオブジェクトをそのままスロー | E-02 (L110-117) isError判定とthrow処理 | ○ |
| C-14 | innerFail関数はError+後続引数でERR_AMBIGUOUS_ARGUMENTをスロー | E-02 (L111-115) 後続引数チェックとエラースロー | ○ |
| C-15 | innerFail関数は関数メッセージを呼び出して文字列取得 | E-02 (L118-133) 関数呼び出しとtry-catch処理 | ○ |
| C-16 | innerFail関数は無効な型でERR_INVALID_ARG_TYPEをスロー | E-02 (L134-140) else節での型エラースロー | ○ |
| C-17 | innerOk関数はtruthy値で何もスローしない | E-02 (L154-155) `if (!args[0])` の条件分岐 | ○ |
| C-18 | innerOk関数は引数なしで特定メッセージを生成 | E-02 (L159-161) `'No value argument passed to \`assert.ok()\`'` | ○ |

### assertion_error.js 関連（UT-ASS-037 〜 UT-ASS-080）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | copyError関数はエラーオブジェクトをディープコピー | E-03 (L51-70) copyError関数の実装 | ○ |
| C-20 | copyError関数はcauseを再帰的にコピー | E-03 (L60-68) cause処理のロジック | ○ |
| C-21 | inspectValue関数は特定のinspectオプションを使用 | E-03 (L72-88) inspectオプション設定（depth:1000, sorted:true等） | ○ |
| C-22 | checkOperator関数はオブジェクト同士でstrictEqualObjectに変換 | E-03 (L94-109) checkOperator関数のロジック | ○ |
| C-23 | getColoredMyersDiff関数は文字単位のMyersDiffを実行 | E-03 (L111-123) StringPrototypeSplitで文字分割 | ○ |
| C-24 | getStackedDiff関数は2行のスタック形式差分を生成 | E-03 (L125-153) getStackedDiff関数の実装 | ○ |
| C-25 | getSimpleDiff関数は短い文字列で!==形式を返す | E-03 (L155-175) kMaxShortStringLength判定 | ○ |
| C-26 | isSimpleDiff関数は単一行プリミティブでtrueを返す | E-03 (L177-183) isSimpleDiff関数の実装 | ○ |
| C-27 | createErrDiff関数はoperatorをcheckOperatorで変換 | E-03 (L185-186) `operator = checkOperator(...)` | ○ |
| C-28 | createErrDiff関数は同一構造でnotIdenticalに変換 | E-03 (L206-215) inspectedActual === inspectedExpectedの判定 | ○ |
| C-29 | addEllipsis関数は10行以上で省略 | E-03 (L238-247) lines.length > 10の判定 | ○ |
| C-30 | AssertionErrorクラスはvalidateObjectでオプション検証 | E-03 (L251) `validateObject(options, 'options')` | ○ |
| C-31 | AssertionErrorクラスはkMethodsWithCustomMessageDiffで差分生成 | E-03 (L270-271, L290-291) kMethodsWithCustomMessageDiff.has(operator)判定 | ○ |
| C-32 | AssertionErrorクラスはdetails配列を個別プロパティに展開 | E-03 (L364-374) for文でdetails処理 | ○ |
| C-33 | AssertionErrorクラスはnameを'AssertionError [ERR_ASSERTION]'で初期化 | E-03 (L356-362) ObjectDefinePropertyでname設定 | ○ |
| C-34 | AssertionErrorクラスはcodeを'ERR_ASSERTION'に設定 | E-03 (L363) `this.code = 'ERR_ASSERTION'` | ○ |
| C-35 | AssertionError.toStringは特定フォーマットで返却 | E-03 (L388-390) toString実装 | ○ |
| C-36 | AssertionError[inspect.custom]は長い文字列を省略してインスペクト | E-03 (L392-419) カスタムインスペクトの実装 | ○ |

## 4) 不足情報（Unknown / Missing）
- **なし**：全てのテストケースは実際のソースコードファイルに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードの実装に直接対応しており、根拠が明確です

### 注意点
1. テストケースはNode.js内部モジュールであるため、実際のテスト実行にはNode.jsの内部テスト環境が必要
2. `primordials`オブジェクトへの依存があるため、モック化が必要な可能性あり
3. `colors`モジュールの状態（hasColors）によって出力が変化するテストケースあり

## 6) レビュアーチェックリスト（最小）
- [ ] myers_diff.jsのテストケース（UT-ASS-001〜018）がアルゴリズムの主要パスをカバーしているか確認
- [ ] utils.jsのテストケース（UT-ASS-019〜036）がエラーハンドリングの全分岐をカバーしているか確認
- [ ] assertion_error.jsのテストケース（UT-ASS-037〜080）がAssertionErrorの全プロパティ設定をカバーしているか確認
- [ ] 境界値テスト（空配列、空文字列、最大値）が適切に定義されているか確認
- [ ] primordialsのモック化方針が明確か確認
- [ ] colors.hasColorsの状態による分岐テストが網羅されているか確認
