---
generated_at: 2026-01-30 18:15:00
metrics:
  claims_total: 45
  claims_with_evidence: 45
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: lib-internal-async_local_storage

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim: 主張）を検証しています:

1. **根拠の有無確認**: 各テストケースに対して、ソースコードの該当箇所が存在するか
2. **根拠との整合性**: テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**: 対象モジュールのメソッド・機能を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」: 根拠あり、「△」: 根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）: **1.00**
  - 根拠あり: 45 / 45、根拠なし: 0
- 優先レビュー（高）
  1. **run メソッドの例外処理テスト**: 実際のコンテキスト復元動作の検証が必要
  2. **storageHook の動作テスト**: async_hooks との統合テストが必要
  3. **_propagate メソッド**: コンテキスト伝播の実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/async_local_storage/async_context_frame.js` (83行)
- E-02: `lib/internal/async_local_storage/async_hooks.js` (148行)

## 3) Claims と根拠の対応（レビューの主戦場）

### async_context_frame.js 実装のテストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | constructor: デフォルトオプションでインスタンス生成 | E-01 L27-34 | ○ |
| C-02 | constructor: defaultValueオプションの設定 | E-01 L29 | ○ |
| C-03 | constructor: nameオプションの設定 | E-01 L31-33 | ○ |
| C-04 | constructor: validateObjectによるバリデーション | E-01 L28 | ○ |
| C-05 | constructor: nullオプションの処理 | E-01 L28 | ○ |
| C-06 | name getter: 名前取得 | E-01 L37 | ○ |
| C-07 | name getter: 空文字列のデフォルト値 | E-01 L37 | ○ |
| C-08 | bind: AsyncResource.bindの委譲 | E-01 L39-41 | ○ |
| C-09 | snapshot: コンテキストスナップショット取得 | E-01 L43-45 | ○ |
| C-10 | snapshot: コールバック実行 | E-01 L44 | ○ |
| C-11 | disable: AsyncContextFrame.disableの呼び出し | E-01 L47-49 | ○ |
| C-12 | enterWith: 新しいフレームの設定 | E-01 L51-54 | ○ |
| C-13 | run: 基本的な実行とコンテキスト復元 | E-01 L56-67 | ○ |
| C-14 | run: ObjectIsによる同一データ最適化 | E-01 L58-59 | ○ |
| C-15 | run: 引数渡し | E-01 L63 | ○ |
| C-16 | run: finally節での例外時コンテキスト復元 | E-01 L64-66 | ○ |
| C-17 | exit: undefinedでのrun呼び出し | E-01 L69-71 | ○ |
| C-18 | exit: 引数渡し | E-01 L70 | ○ |
| C-19 | getStore: ストア取得 | E-01 L73-79 | ○ |
| C-20 | getStore: フレームがない場合のデフォルト値 | E-01 L75-76 | ○ |
| C-21 | getStore: has()チェック | E-01 L75 | ○ |

### async_hooks.js 実装のテストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | constructor: 自動有効化 | E-02 L55 | ○ |
| C-23 | constructor: kResourceStoreシンボル生成 | E-02 L46 | ○ |
| C-24 | constructor: validateObjectバリデーション | E-02 L48 | ○ |
| C-25 | disable: storageListからの削除 | E-02 L73-74 | ○ |
| C-26 | disable: 冪等性（既に無効の場合） | E-02 L70 | ○ |
| C-27 | disable: 最後のストレージ時のフック無効化 | E-02 L75-77 | ○ |
| C-28 | _enable: storageListへの追加 | E-02 L84 | ○ |
| C-29 | _enable: 冪等性（既に有効の場合） | E-02 L82 | ○ |
| C-30 | _propagate: コンテキスト伝播 | E-02 L90-95 | ○ |
| C-31 | _propagate: 無効時の非伝播 | E-02 L92 | ○ |
| C-32 | enterWith: ストア設定 | E-02 L97-101 | ○ |
| C-33 | enterWith: 自動有効化 | E-02 L98 | ○ |
| C-34 | run: 基本的な実行と復元 | E-02 L103-121 | ○ |
| C-35 | run: ObjectIsによる最適化 | E-02 L105-107 | ○ |
| C-36 | run: 元のストアへの復元 | E-02 L119 | ○ |
| C-37 | run: finally節での例外時復元 | E-02 L118-120 | ○ |
| C-38 | exit: 無効時の直接実行 | E-02 L124-126 | ○ |
| C-39 | exit: disable→callback→_enableの順序 | E-02 L127-132 | ○ |
| C-40 | exit: finally節での再有効化 | E-02 L130-132 | ○ |
| C-41 | getStore: 有効時のストア取得 | E-02 L136-142 | ○ |
| C-42 | getStore: kResourceStore未設定時のデフォルト値 | E-02 L138-140 | ○ |
| C-43 | getStore: 無効時のデフォルト値 | E-02 L143 | ○ |
| C-44 | storageHook init: コンテキスト伝播 | E-02 L23-31 | ○ |
| C-45 | storageHook init: 空リスト時の処理 | E-02 L27 | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠なしの項目はありません
- 補足として、以下の情報があるとより詳細なテストケースが作成可能:
  - `internal/async_context_frame` モジュールの実装詳細
  - `internal/validators` の validateObject の仕様詳細
  - async_hooks モジュールの executionAsyncResource() の詳細仕様

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分のテストケースはソースコードから直接導出されており、信頼性が高い
- **1 (中リスク)**: async_hooks との統合部分（storageHook）は実際の非同期動作の検証が必要
- **1 (中リスク)**: 例外発生時のコンテキスト復元ロジックは実際のスタック動作の確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースの「期待結果」がソースコードの実装と一致しているか確認
- [ ] async_context_frame.js と async_hooks.js の2つの実装の違いが正しく反映されているか確認
- [ ] 例外処理（finally節）のテストケースで、実際にコンテキストが復元されることを検証
- [ ] storageHook の init コールバックが正しく全ストレージの _propagate を呼び出すことを検証
- [ ] ObjectIs による最適化の条件が正しいか確認（NaN と -0 の扱いに注意）
- [ ] プライベートフィールド (#defaultValue, #name) へのアクセスがテスト可能か検討
