---
generated_at: 2026-01-30 18:30:00
metrics:
  claims_total: 176
  claims_with_evidence: 176
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lib-internal-bootstrap単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：176 / 176、根拠なし：0
- 優先レビュー（高）
  - 全てのテストケースはソースコードに基づいて生成されており、根拠不足の項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/bootstrap/node.js` - Node.jsのブートストラップメイン処理
- E-02: `lib/internal/bootstrap/realm.js` - Realm初期化とモジュールローダー
- E-03: `lib/internal/bootstrap/shadow_realm.js` - ShadowRealm初期化
- E-04: `lib/internal/bootstrap/switches/does_not_own_process_state.js` - ワーカースレッドのプロセス状態制限
- E-05: `lib/internal/bootstrap/switches/does_own_process_state.js` - メインスレッドのプロセス状態管理
- E-06: `lib/internal/bootstrap/switches/is_not_main_thread.js` - 非メインスレッドのstdio設定
- E-07: `lib/internal/bootstrap/switches/is_main_thread.js` - メインスレッドのstdio設定
- E-08: `lib/internal/bootstrap/web/exposed-wildcard.js` - グローバルWeb API（[Exposed=*]）
- E-09: `lib/internal/bootstrap/web/exposed-window-or-worker.js` - グローバルWeb API（Window/Worker）

## 3) Claims と根拠の対応（レビューの主戦場）

### realm.js関連（C-01〜C-43）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BuiltinModuleコンストラクタでfilename、loaded、loadingが設定される | E-02 (line 236-258) | ○ |
| C-02 | BuiltinModule.exportsが空オブジェクトで初期化される | E-02 (line 241) | ○ |
| C-03 | BuiltinModule.existsがmapにIDが存在するか確認 | E-02 (line 287-289) | ○ |
| C-04 | BuiltinModule.existsが存在しないIDでfalseを返す | E-02 (line 287-289) | ○ |
| C-05 | BuiltinModule.canBeRequiredByUsersがリストを確認 | E-02 (line 291-293) | ○ |
| C-06 | BuiltinModule.canBeRequiredByUsersが内部モジュールでfalse | E-02 (line 291-293) | ○ |
| C-07 | BuiltinModule.canBeRequiredWithoutSchemeがリストを確認 | E-02 (line 295-297) | ○ |
| C-08 | schemelessBlockListに基づくスキーマ必須判定 | E-02 (line 126-132, 295-297) | ○ |
| C-09 | normalizeRequirableIdがnode:プレフィックスを除去 | E-02 (line 299-310) | ○ |
| C-10 | normalizeRequirableIdがプレフィックスなしIDをそのまま返す | E-02 (line 305-307) | ○ |
| C-11 | normalizeRequirableIdが利用不可モジュールでundefined | E-02 (line 309) | ○ |
| C-12 | isBuiltinが組み込みモジュール判定 | E-02 (line 312-318) | ○ |
| C-13 | isBuiltinがnode:プレフィックス付きも対応 | E-02 (line 314-317) | ○ |
| C-14 | isBuiltinが非組み込みでfalse | E-02 (line 312-318) | ○ |
| C-15 | allowRequireByUsersがリストに追加 | E-02 (line 260-270) | ○ |
| C-16 | allowRequireByUsersがselfIdでエラー | E-02 (line 261-265) | ○ |
| C-17 | setRealmAllowRequireByUsersが許可リスト設定 | E-02 (line 272-277) | ○ |
| C-18 | exposeInternalsが内部モジュールを公開 | E-02 (line 281-285) | ○ |
| C-19 | getSchemeOnlyModuleNamesがschemelessBlockListを返す | E-02 (line 320-322) | ○ |
| C-20 | getAllBuiltinModuleIdsが全IDを返す | E-02 (line 324-328) | ○ |
| C-21 | compileForPublicLoaderが公開モジュールをコンパイル | E-02 (line 331-345) | ○ |
| C-22 | compileForPublicLoaderが非公開モジュールでエラー | E-02 (line 332-336) | ○ |
| C-23 | compileForInternalLoaderがモジュールをコンパイル | E-02 (line 383-409) | ○ |
| C-24 | compileForInternalLoaderがロード済みでそのまま返す | E-02 (line 384-386) | ○ |
| C-25 | compileForInternalLoaderがロード中でそのまま返す | E-02 (line 384-386) | ○ |
| C-26 | getESMFacadeがModuleWrapを作成 | E-02 (line 347-365) | ○ |
| C-27 | getESMFacadeがキャッシュを返す | E-02 (line 348) | ○ |
| C-28 | syncExportsがエクスポートを同期 | E-02 (line 371-380) | ○ |
| C-29 | process.bindingが許可リストのモジュールを返す | E-02 (line 140-163) | ○ |
| C-30 | process.bindingがレガシーラッパーを返す | E-02 (line 155-157) | ○ |
| C-31 | process.bindingが非推奨モジュールで警告 | E-02 (line 148-154) | ○ |
| C-32 | process.bindingが許可されていないモジュールでエラー | E-02 (line 161-162) | ○ |
| C-33 | process._linkedBindingがバインディング取得 | E-02 (line 165-171) | ○ |
| C-34 | process._linkedBindingがキャッシュを返す | E-02 (line 167-168) | ○ |
| C-35 | internalBindingが内部バインディング取得 | E-02 (line 179-190) | ○ |
| C-36 | internalBindingがmoduleLoadListに記録 | E-02 (line 186) | ○ |
| C-37 | requireBuiltinがモジュール要求 | E-02 (line 420-430) | ○ |
| C-38 | requireBuiltinがselfIdでloaderExports | E-02 (line 421-423) | ○ |
| C-39 | requireBuiltinが存在しないモジュールでTypeError | E-02 (line 427-428) | ○ |
| C-40 | requireWithFallbackInDepsがnode:除去 | E-02 (line 434-441) | ○ |
| C-41 | requireWithFallbackInDepsがdepsフォールバック | E-02 (line 437-438) | ○ |
| C-42 | getOwnがプロパティ取得 | E-02 (line 202-206) | ○ |
| C-43 | getOwnが存在しないでundefined | E-02 (line 202-206) | ○ |

### node.js関連（C-44〜C-77）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | process.exitCode getterが未設定でundefined | E-01 (line 109-111) | ○ |
| C-45 | process.exitCode getterが設定済みで値を返す | E-01 (line 109-111) | ○ |
| C-46 | process.exitCode setterが整数設定 | E-01 (line 112-128) | ○ |
| C-47 | process.exitCode setterが文字列数値を変換 | E-01 (line 115-118) | ○ |
| C-48 | process.exitCode setterがnullでkHasExitCode=0 | E-01 (line 122-124) | ○ |
| C-49 | process.exitCode setterがundefinedでkHasExitCode=0 | E-01 (line 122-124) | ○ |
| C-50 | process.exitCode setterが非整数文字列でエラー | E-01 (line 119) | ○ |
| C-51 | process._exiting getterがkExiting=0でfalse | E-01 (line 97-99) | ○ |
| C-52 | process._exiting getterがkExiting=1でtrue | E-01 (line 97-99) | ○ |
| C-53 | process._exiting setterがtrue設定 | E-01 (line 100-102) | ○ |
| C-54 | process._exiting setterがfalse設定 | E-01 (line 100-102) | ○ |
| C-55 | process.configが凍結オブジェクト | E-01 (line 135-147) | ○ |
| C-56 | process.featuresに必須プロパティ | E-01 (line 270-304) | ○ |
| C-57 | process.features.cached_builtins getter | E-01 (line 282-284) | ○ |
| C-58 | process.features.require_module getter | E-01 (line 285-287) | ○ |
| C-59 | process.features.quic getter | E-01 (line 288-295) | ○ |
| C-60 | process.features.typescript getter | E-01 (line 332-348) | ○ |
| C-61 | process.allowedNodeEnvironmentFlags getter | E-01 (line 245-265) | ○ |
| C-62 | process.allowedNodeEnvironmentFlags setter | E-01 (line 254-262) | ○ |
| C-63 | process.finalization getter遅延ロード | E-01 (line 184-202) | ○ |
| C-64 | process.finalization getterキャッシュ | E-01 (line 187-189) | ○ |
| C-65 | process.finalization setter | E-01 (line 197-199) | ○ |
| C-66 | process.openStdin | E-01 (line 207-210) | ○ |
| C-67 | process.sourceMapsEnabled getter | E-01 (line 388-395) | ○ |
| C-68 | process.setSourceMapsEnabled有効化 | E-01 (line 396-405) | ○ |
| C-69 | process.setSourceMapsEnabled無効化 | E-01 (line 396-405) | ○ |
| C-70 | process.getBuiltinModule | E-01 (line 412-415) | ○ |
| C-71 | setupProcessObjectでEventEmitter継承 | E-01 (line 417-445) | ○ |
| C-72 | setupProcessObjectでSymbol.toStringTag | E-01 (line 422-428) | ○ |
| C-73 | setupProcessObjectでglobalThis.process定義 | E-01 (line 433-444) | ○ |
| C-74 | setupGlobalProxyでSymbol.toStringTag | E-01 (line 447-456) | ○ |
| C-75 | setupGlobalProxyでglobal自己参照 | E-01 (line 455) | ○ |
| C-76 | setupBufferでglobalThis.Buffer定義 | E-01 (line 458-483) | ○ |
| C-77 | setupBufferでBufferプロトタイプ設定 | E-01 (line 464-466) | ○ |

### does_not_own_process_state.js関連（C-78〜C-82）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | wrappedUmaskが引数なしで取得 | E-04 (line 31-38) | ○ |
| C-79 | wrappedUmaskが引数ありでエラー | E-04 (line 33-34) | ○ |
| C-80 | process.abortがunavailable | E-04 (line 8) | ○ |
| C-81 | process.chdirがunavailable | E-04 (line 9) | ○ |
| C-82 | process.cwdが取得可能 | E-04 (line 11) | ○ |

### does_own_process_state.js関連（C-83〜C-100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | wrappedUmaskが引数なしで取得 | E-05 (line 133-138) | ○ |
| C-84 | wrappedUmaskが引数ありで設定 | E-05 (line 134-136) | ○ |
| C-85 | wrappedChdirがディレクトリ変更 | E-05 (line 126-131) | ○ |
| C-86 | wrappedChdirが非文字列でエラー | E-05 (line 127) | ○ |
| C-87 | wrappedCwdがキャッシュ空で取得 | E-05 (line 140-144) | ○ |
| C-88 | wrappedCwdがキャッシュあり | E-05 (line 141-142) | ○ |
| C-89 | initgroupsが正常処理 | E-05 (line 56-66) | ○ |
| C-90 | initgroupsがユーザー不在でエラー | E-05 (line 61-62) | ○ |
| C-91 | initgroupsがグループ不在でエラー | E-05 (line 63-65) | ○ |
| C-92 | setgroupsが正常処理 | E-05 (line 68-79) | ○ |
| C-93 | setgroupsが非配列でエラー | E-05 (line 69) | ○ |
| C-94 | setgroupsがグループ不在でエラー | E-05 (line 76-78) | ○ |
| C-95 | wrapIdSetterが数値ID処理 | E-05 (line 81-91) | ○ |
| C-96 | wrapIdSetterが文字列ID処理 | E-05 (line 81-91) | ○ |
| C-97 | wrapIdSetterが不在IDでエラー | E-05 (line 87-89) | ○ |
| C-98 | validateIdが数値検証 | E-05 (line 93-99) | ○ |
| C-99 | validateIdが文字列検証 | E-05 (line 96) | ○ |
| C-100 | validateIdが不正型でエラー | E-05 (line 97) | ○ |

### is_not_main_thread.js関連（C-101〜C-108）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | defineStreamがgetter定義 | E-06 (line 10-17) | ○ |
| C-102 | lazyWorkerStdioが遅延生成 | E-06 (line 40-47) | ○ |
| C-103 | lazyWorkerStdioがキャッシュ返却 | E-06 (line 41) | ○ |
| C-104 | flushSyncがフラッシュ | E-06 (line 49-52) | ○ |
| C-105 | getStdoutがワーカーstdout | E-06 (line 54) | ○ |
| C-106 | getStderrがワーカーstderr | E-06 (line 56) | ○ |
| C-107 | getStdinがワーカーstdin | E-06 (line 58) | ○ |
| C-108 | シグナルリスナー除去 | E-06 (line 28-29) | ○ |

### is_main_thread.js関連（C-109〜C-128）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 | createWritableStdioStreamがTTY処理 | E-07 (line 54-59) | ○ |
| C-110 | createWritableStdioStreamがFILE処理 | E-07 (line 61-66) | ○ |
| C-111 | createWritableStdioStreamがPIPE処理 | E-07 (line 68-92) | ○ |
| C-112 | createWritableStdioStreamがIPCハンドル使用 | E-07 (line 75-82) | ○ |
| C-113 | createWritableStdioStreamがダミーWritable | E-07 (line 94-103) | ○ |
| C-114 | dummyDestroyがコールバック実行 | E-07 (line 114-128) | ○ |
| C-115 | dummyDestroyがclose発行 | E-07 (line 122-127) | ○ |
| C-116 | getStdoutがstdout取得 | E-07 (line 151-171) | ○ |
| C-117 | getStdoutがキャッシュ返却 | E-07 (line 152) | ○ |
| C-118 | getStdoutがSIGWINCHリスナー登録 | E-07 (line 158-160) | ○ |
| C-119 | getStderrがstderr取得 | E-07 (line 173-192) | ○ |
| C-120 | getStderrがキャッシュ返却 | E-07 (line 174) | ○ |
| C-121 | getStdinがTTY処理 | E-07 (line 199-203) | ○ |
| C-122 | getStdinがFILE処理 | E-07 (line 205-208) | ○ |
| C-123 | getStdinがPIPE処理 | E-07 (line 210-237) | ○ |
| C-124 | getStdinがダミーReadable | E-07 (line 239-245) | ○ |
| C-125 | getStdinがpaused開始 | E-07 (line 254-258) | ○ |
| C-126 | pauseイベントでreadStop | E-07 (line 263-275) | ○ |
| C-127 | resetStdioForTestingがリセット | E-07 (line 287-291) | ○ |
| C-128 | シグナルリスナー登録 | E-07 (line 42-43) | ○ |

### shadow_realm.js関連（C-129〜C-130）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 | setRealmAllowRequireByUsersが空リスト設定 | E-03 (line 12-19) | ○ |
| C-130 | prepareShadowRealmExecution呼び出し | E-03 (line 21) | ○ |

### exposed-wildcard.js関連（C-131〜C-146）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | createGlobalConsoleがコンソール作成 | E-08 (line 51-64) | ○ |
| C-132 | createGlobalConsoleがインスペクタでラップ | E-08 (line 54-61) | ○ |
| C-133 | globalThis.console公開 | E-08 (line 22-23) | ○ |
| C-134 | globalThis.URL公開 | E-08 (line 27) | ○ |
| C-135 | globalThis.URLSearchParams公開 | E-08 (line 29) | ○ |
| C-136 | globalThis.DOMException公開 | E-08 (line 30) | ○ |
| C-137 | globalThis.AbortController公開 | E-08 (line 34-36) | ○ |
| C-138 | globalThis.AbortSignal公開 | E-08 (line 34-36) | ○ |
| C-139 | globalThis.Event公開 | E-08 (line 41) | ○ |
| C-140 | globalThis.EventTarget公開 | E-08 (line 42) | ○ |
| C-141 | globalThis.CustomEvent公開 | E-08 (line 43) | ○ |
| C-142 | globalThis.TextEncoder公開 | E-08 (line 47-49) | ○ |
| C-143 | globalThis.TextDecoder公開 | E-08 (line 47-49) | ○ |
| C-144 | TransformStream公開 | E-08 (line 67-70) | ○ |
| C-145 | WritableStream公開 | E-08 (line 72-75) | ○ |
| C-146 | ReadableStream公開 | E-08 (line 77-84) | ○ |

### exposed-window-or-worker.js関連（C-147〜C-176）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-147 | globalThis.clearInterval公開 | E-09 (line 32) | ○ |
| C-148 | globalThis.clearTimeout公開 | E-09 (line 33) | ○ |
| C-149 | globalThis.setInterval公開 | E-09 (line 34) | ○ |
| C-150 | globalThis.setTimeout公開 | E-09 (line 35) | ○ |
| C-151 | globalThis.queueMicrotask公開 | E-09 (line 40) | ○ |
| C-152 | globalThis.structuredClone公開 | E-09 (line 42-46) | ○ |
| C-153 | globalThis.atob公開 | E-09 (line 47) | ○ |
| C-154 | globalThis.btoa公開 | E-09 (line 47) | ○ |
| C-155 | globalThis.BroadcastChannel公開 | E-09 (line 50) | ○ |
| C-156 | globalThis.MessageChannel公開 | E-09 (line 51-53) | ○ |
| C-157 | globalThis.MessagePort公開 | E-09 (line 51-53) | ○ |
| C-158 | globalThis.Blob公開 | E-09 (line 55) | ○ |
| C-159 | globalThis.File公開 | E-09 (line 57) | ○ |
| C-160 | globalThis.performance公開 | E-09 (line 64) | ○ |
| C-161 | globalThis.URLPattern公開 | E-09 (line 69) | ○ |
| C-162 | globalThis.fetch公開 | E-09 (line 73-85) | ○ |
| C-163 | fetch遅延ロード | E-09 (line 79-82) | ○ |
| C-164 | globalThis.FormData公開 | E-09 (line 91-93) | ○ |
| C-165 | globalThis.Headers公開 | E-09 (line 91-93) | ○ |
| C-166 | globalThis.Request公開 | E-09 (line 91-93) | ○ |
| C-167 | globalThis.Response公開 | E-09 (line 91-93) | ○ |
| C-168 | globalThis.EventSource公開 | E-09 (line 97) | ○ |
| C-169 | globalThis.WebSocket公開 | E-09 (line 97) | ○ |
| C-170 | globalThis.crypto公開(OpenSSLあり) | E-09 (line 106-121) | ○ |
| C-171 | globalThis.crypto ERR_NO_CRYPTO(OpenSSLなし) | E-09 (line 122-128) | ○ |
| C-172 | crypto thisチェック | E-09 (line 112-116) | ○ |
| C-173 | globalThis.Crypto公開 | E-09 (line 118-121) | ○ |
| C-174 | globalThis.CryptoKey公開 | E-09 (line 118-121) | ○ |
| C-175 | globalThis.SubtleCrypto公開 | E-09 (line 118-121) | ○ |
| C-176 | wasmStreamingCallback設定 | E-09 (line 101-103) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全てのテストケースはソースコードから直接導出されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースに明確な根拠が存在

## 6) レビュアーチェックリスト（最小）
- [ ] BuiltinModuleクラスのテストケースがモジュールロードの全パターンをカバーしているか
- [ ] process.exitCode/process._exitingの境界値テストが十分か
- [ ] POSIX認証情報関連（setuid, setgid等）のエラーハンドリングが網羅されているか
- [ ] メインスレッド/ワーカースレッドのstdio設定の差異がテストされているか
- [ ] Web API公開（globalThis.*）の遅延ロードが正しくテストされているか
- [ ] OpenSSLの有無によるcrypto動作の分岐がテストされているか
