---
generated_at: 2026-01-30 18:30:00
metrics:
  claims_total: 143
  claims_with_evidence: 143
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lib-internal-child_process 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：143 / 143、根拠なし：0
- 優先レビュー（高）
  1. **UT-CHP-004〜008**: spawn関連テスト - 実際のプロセス生成に依存するため環境差異の可能性
  2. **UT-CHP-041〜052**: IPC send関連テスト - 実際のIPC通信の検証が必要
  3. **UT-CHP-091〜096**: spawnSync関連テスト - 同期処理のため実行環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/child_process.js` - メインの子プロセス実装（1119行）
- E-02: `lib/internal/child_process/serialization.js` - シリアライゼーション実装（170行）
- E-03: `lib/internal/errors.js` - エラーコード定義（参照）
- E-04: `lib/internal/validators.js` - バリデータ関数（参照）
- E-05: `lib/net.js` - net.Socket/Server（参照）
- E-06: `lib/dgram.js` - dgram.Socket（参照）
- E-07: `lib/events.js` - EventEmitter基底クラス（参照）

## 3) Claims と根拠の対応（レビューの主戦場）

### ChildProcessクラス関連（C-01〜C-32）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ChildProcess.constructor初期化 | E-01 L254-311 | ○ |
| C-02 | EventEmitter継承 | E-01 L312-313 | ○ |
| C-03 | _handleプロパティ初期化 | E-01 L266-267 | ○ |
| C-04 | spawn正常動作 | E-01 L354-479 | ○ |
| C-05 | stdio=pipe設定 | E-01 L462-467 | ○ |
| C-06 | stdio=ignore設定 | E-01 L429, L997-998 | ○ |
| C-07 | stdio=inherit設定 | E-01 L244, L1029-1033 | ○ |
| C-08 | IPC setupChannel | E-01 L476 | ○ |
| C-09 | serialization=json | E-01 L369-371, E-02 L136-167 | ○ |
| C-10 | serialization=advanced | E-01 L369-371, E-02 L54-134 | ○ |
| C-11 | options型バリデーション | E-01 L357 | ○ |
| C-12 | options.file型バリデーション | E-01 L385 | ○ |
| C-13 | ファイル不存在エラー | E-01 L398-408 | ○ |
| C-14 | 権限エラー | E-01 L398-408 | ○ |
| C-15 | serializationバリデーション | E-01 L369-370 | ○ |
| C-16 | 空args処理 | E-01 L388-393 | ○ |
| C-17 | undefined args処理 | E-01 L388-389 | ○ |
| C-18 | kill()デフォルト動作 | E-01 L492-517 | ○ |
| C-19 | kill('SIGTERM') | E-01 L492-517 | ○ |
| C-20 | kill('SIGKILL') | E-01 L492-517 | ○ |
| C-21 | kill(0)存在確認 | E-01 L494 | ○ |
| C-22 | kill終了済みプロセス | E-01 L504-505 | ○ |
| C-23 | 不正シグナルエラー | E-01 L494-495 | ○ |
| C-24 | _handle=null時のkill | E-01 L497 | ○ |
| C-25 | Symbol.dispose | E-01 L519-523 | ○ |
| C-26 | killed=true時のdispose | E-01 L520 | ○ |
| C-27 | ref() | E-01 L526-528 | ○ |
| C-28 | unref() | E-01 L531-533 | ○ |
| C-29 | 正常終了exitイベント | E-01 L269-293 | ○ |
| C-30 | シグナル終了signalCode | E-01 L270-271 | ○ |
| C-31 | 終了時stdin.destroy | E-01 L276-278 | ○ |
| C-32 | 負exitCodeでerror | E-01 L283-291 | ○ |

### Controlクラス関連（C-33〜C-40）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | Control.constructor | E-01 L535-544 | ○ |
| C-34 | refCounted増加 | E-01 L550-554 | ○ |
| C-35 | refExplicitlySet時 | E-01 L551 | ○ |
| C-36 | unrefCounted減少 | E-01 L556-560 | ○ |
| C-37 | ref()明示的設定 | E-01 L562-565 | ○ |
| C-38 | unref()明示的設定 | E-01 L567-570 | ○ |
| C-39 | fd取得 | E-01 L572-574 | ○ |
| C-40 | channel=null時fd | E-01 L573 | ○ |

### setupChannel/IPC関連（C-41〜C-61）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | send文字列メッセージ | E-01 L720-744 | ○ |
| C-42 | sendオブジェクト | E-01 L756-762 | ○ |
| C-43 | send数値 | E-01 L756-762 | ○ |
| C-44 | sendブール値 | E-01 L756-762 | ○ |
| C-45 | net.Socketハンドル送信 | E-01 L780-781, L118-204 | ○ |
| C-46 | net.Serverハンドル送信 | E-01 L782-783, L103-116 | ○ |
| C-47 | dgram.Socketハンドル送信 | E-01 L786-787, L218-234 | ○ |
| C-48 | コールバック呼び出し | E-01 L845-853 | ○ |
| C-49 | connected=false時エラー | E-01 L737-743 | ○ |
| C-50 | message undefined | E-01 L749-750 | ○ |
| C-51 | 不正型メッセージ | E-01 L756-762 | ○ |
| C-52 | 不正ハンドル型 | E-01 L791 | ○ |
| C-53 | disconnect正常 | E-01 L884-898 | ○ |
| C-54 | キューフラッシュ後disconnect | E-01 L893-897 | ○ |
| C-55 | 二重disconnect | E-01 L885-887 | ○ |
| C-56 | _disconnect内部処理 | E-01 L900-928 | ○ |
| C-57 | pendingMessage処理 | E-01 L907-908 | ○ |
| C-58 | messageイベント発火 | E-01 L597-621 | ○ |
| C-59 | internalMessage発火 | E-01 L611-617 | ○ |
| C-60 | ハンドル付きメッセージ | E-01 L612-614 | ○ |
| C-61 | 接続終了disconnect | E-01 L622-629 | ○ |

### stdio/ユーティリティ関連（C-62〜C-96）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | stdioStringToArray pipe | E-01 L237-252, L243 | ○ |
| C-63 | stdioStringToArray ignore | E-01 L243 | ○ |
| C-64 | stdioStringToArray inherit | E-01 L244 | ○ |
| C-65 | stdioStringToArray overlapped | E-01 L243 | ○ |
| C-66 | channel追加 | E-01 L249 | ○ |
| C-67 | 不正stdio値エラー | E-01 L246 | ○ |
| C-68 | getValidStdio文字列変換 | E-01 L967-976 | ○ |
| C-69 | getValidStdio配列処理 | E-01 L974, L986-1063 | ○ |
| C-70 | ipc設定 | E-01 L1011-1028 | ○ |
| C-71 | 数値fd処理 | E-01 L1034-1038 | ○ |
| C-72 | オブジェクトfd処理 | E-01 L1034-1038 | ○ |
| C-73 | stdio型バリデーション | E-01 L974-976 | ○ |
| C-74 | sync+ipcエラー | E-01 L1012-1018 | ○ |
| C-75 | ipc重複エラー | E-01 L1012-1016 | ○ |
| C-76 | sync+ArrayBufferView | E-01 L1051-1055 | ○ |
| C-77 | async+ArrayBufferView | E-01 L1051-1055 | ○ |
| C-78 | 配列長補完 | E-01 L982 | ○ |
| C-79 | getHandleWrapType Pipe | E-01 L339-340 | ○ |
| C-80 | getHandleWrapType TCP | E-01 L342 | ○ |
| C-81 | getHandleWrapType TTY | E-01 L341 | ○ |
| C-82 | getHandleWrapType UDP | E-01 L343 | ○ |
| C-83 | getHandleWrapType未知型 | E-01 L345 | ○ |
| C-84 | isInternal NODE_プレフィックス | E-01 L955-963 | ○ |
| C-85 | isInternal 非NODE_ | E-01 L955-963 | ○ |
| C-86 | isInternal null | E-01 L957 | ○ |
| C-87 | isInternal非オブジェクト | E-01 L958 | ○ |
| C-88 | isInternal cmd非文字列 | E-01 L959 | ○ |
| C-89 | maybeClose発火 | E-01 L1080-1086 | ○ |
| C-90 | maybeClose未完了 | E-01 L1083 | ○ |
| C-91 | spawnSync正常 | E-01 L1088-1109 | ○ |
| C-92 | spawnSync encoding変換 | E-01 L1091-1096 | ○ |
| C-93 | spawnSync buffer出力 | E-01 L1091 | ○ |
| C-94 | spawnSyncエラー設定 | E-01 L1102-1106 | ○ |
| C-95 | spawnSync stdout | E-01 L1099 | ○ |
| C-96 | spawnSync stderr | E-01 L1100 | ○ |

### handleConversion関連（C-97〜C-111）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | net.Native send | E-01 L94-96 | ○ |
| C-98 | net.Native got | E-01 L98-100 | ○ |
| C-99 | net.Server send | E-01 L106-108 | ○ |
| C-100 | net.Server got | E-01 L110-115 | ○ |
| C-101 | net.Socket send handle返却 | E-01 L119-165 | ○ |
| C-102 | net.Socket send keepOpen | E-01 L145-161 | ○ |
| C-103 | net.Socket send connectionKey | E-01 L124-138 | ○ |
| C-104 | net.Socket send _handle null | E-01 L120-121 | ○ |
| C-105 | net.Socket postSend target存在 | E-01 L167-183, L176-178 | ○ |
| C-106 | net.Socket postSend targetなし | E-01 L179-181 | ○ |
| C-107 | net.Socket got | E-01 L185-203 | ○ |
| C-108 | net.Socket got socketList | E-01 L193-200 | ○ |
| C-109 | dgram.Socket send | E-01 L221-224 | ○ |
| C-110 | dgram.Socket send dgramType | E-01 L222 | ○ |
| C-111 | dgram.Socket got | E-01 L227-233 | ○ |

### その他関連（C-112〜C-143）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | flushStdio resume | E-01 L316-331 | ○ |
| C-113 | flushStdio null | E-01 L319 | ○ |
| C-114 | flushStdio kIsUsedAsStdio | E-01 L326 | ○ |
| C-115 | getSocketList send | E-01 L1069-1077, L1073 | ○ |
| C-116 | getSocketList got | E-01 L1069-1077, L1073 | ○ |
| C-117 | getSocketListキャッシュ | E-01 L1071-1074 | ○ |
| C-118 | closePendingHandle | E-01 L348-351 | ○ |
| C-119 | createSocket | E-01 L334-336 | ○ |
| C-120 | ChildProcessSerializer ArrayBufferView | E-02 L28-36, L30-32 | ○ |
| C-121 | ChildProcessSerializer非ArrayBufferView | E-02 L34-35 | ○ |
| C-122 | ChildProcessDeserializer ArrayBufferView | E-02 L39-47, L42-43 | ○ |
| C-123 | ChildProcessDeserializer オブジェクト | E-02 L45-46 | ○ |
| C-124 | advanced.initMessageChannel | E-02 L55-59 | ○ |
| C-125 | advanced.parseChannelMessages完全 | E-02 L61-107 | ○ |
| C-126 | advanced.parseChannelMessagesバッファ | E-02 L84, L106 | ○ |
| C-127 | advanced.parseChannelMessages複数 | E-02 L74-104 | ○ |
| C-128 | advanced.parseChannelMessages空 | E-02 L62 | ○ |
| C-129 | advanced.writeChannelMessage | E-02 L109-133 | ○ |
| C-130 | advanced.writeChannelMessageハンドル | E-02 L126 | ○ |
| C-131 | json.initMessageChannel | E-02 L137-140 | ○ |
| C-132 | json.parseChannelMessages | E-02 L142-161 | ○ |
| C-133 | json.parseChannelMessagesバッファ | E-02 L152-153, L160 | ○ |
| C-134 | json.parseChannelMessages複数 | E-02 L156-157 | ○ |
| C-135 | json.parseChannelMessages空 | E-02 L143 | ○ |
| C-136 | json.writeChannelMessage | E-02 L163-166 | ○ |
| C-137 | json.writeChannelMessageハンドル | E-02 L165 | ○ |
| C-138 | NODE_HANDLE_ACK処理 | E-01 L638-672, L643 | ○ |
| C-139 | NODE_HANDLE_NACK再送 | E-01 L644-649 | ○ |
| C-140 | NODE_HANDLE_NACK最大再送 | E-01 L644-649 | ○ |
| C-141 | NODE_HANDLEハンドルなしNACK | E-01 L680-681 | ○ |
| C-142 | NODE_HANDLEハンドルありACK | E-01 L687 | ○ |
| C-143 | newListener保留メッセージ | E-01 L702-718 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全てのテストケースはソースコードに基づいて生成されており、根拠が明確です。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全てのテストケースにソースコードの根拠があります
- 以下の点は実行環境に依存するため、テスト実行時に注意が必要：
  1. プロセス生成（spawn/spawnSync）: OSおよびファイルシステムに依存
  2. IPC通信: 実際のパイプ通信が必要
  3. シグナル処理: OS固有のシグナル動作
  4. ハンドル送受信: ソケット/サーバーのライフサイクル管理

## 6) レビュアーチェックリスト（最小）
- [ ] ChildProcessクラスの初期化とライフサイクル管理が正しくテストされているか確認
- [ ] spawn/spawnSyncの正常系・異常系が網羅されているか確認
- [ ] IPC通信（send/disconnect）の各パターンがテストされているか確認
- [ ] シリアライゼーション（json/advanced）の両方がカバーされているか確認
- [ ] ハンドル送受信（net.Socket、net.Server、dgram.Socket）の各パターンを確認
- [ ] エラーハンドリング（ERR_*）が適切にテストされているか確認
- [ ] 境界値テスト（null、undefined、空配列等）が含まれているか確認
- [ ] リソースクリーンアップ（close、destroy、dispose）のテストを確認
