---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 112
  claims_with_evidence: 112
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lib-internal-cluster 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：112 / 112、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースにソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/cluster/shared_handle.js` - SharedHandleクラス実装
- E-02: `lib/internal/cluster/round_robin_handle.js` - RoundRobinHandleクラス実装
- E-03: `lib/internal/cluster/worker.js` - Workerクラス基本実装
- E-04: `lib/internal/cluster/primary.js` - プライマリプロセス実装
- E-05: `lib/internal/cluster/utils.js` - ユーティリティ関数実装
- E-06: `lib/internal/cluster/child.js` - ワーカープロセス実装

## 3) Claims と根拠の対応（レビューの主戦場）

### SharedHandle（shared_handle.js）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TCP用ハンドルが正しく作成される | E-01 L20-28: addressTypeによる分岐処理 | ○ |
| C-02 | UDP用ハンドルが正しく作成される | E-01 L20-21: dgram._createSocketHandle呼び出し | ○ |
| C-03 | UDP6用ハンドルが正しく作成される | E-01 L20-21: addressType判定でudp6対応 | ○ |
| C-04 | ソケット作成失敗時にerrnoが設定される | E-01 L25-28: rvalが数値の場合errno設定 | ○ |
| C-05 | ワーカーが正しく追加される | E-01 L31-35: workers.set()呼び出し | ○ |
| C-06 | コールバックが正しく呼び出される | E-01 L34: send(this.errno, null, this.handle) | ○ |
| C-07 | 既存ワーカー追加でassertエラー | E-01 L32: assert(!this.workers.has(worker.id)) | ○ |
| C-08 | ワーカーが正しく削除される | E-01 L37-48: workers.delete()呼び出し | ○ |
| C-09 | 最後のワーカー削除でハンドルクローズ | E-01 L43-48: workers.size === 0判定 | ○ |
| C-10 | 他にワーカーいる場合クローズされない | E-01 L43-44: workers.size !== 0でfalse返却 | ○ |
| C-11 | 存在しないワーカー削除でfalse | E-01 L38-39: has()チェック | ○ |
| C-12 | 存在するワーカーでtrue返却 | E-01 L51-53: has()メソッド | ○ |
| C-13 | 存在しないワーカーでfalse返却 | E-01 L51-53: has()メソッド | ○ |

### RoundRobinHandle（round_robin_handle.js）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | fd指定でサーバー作成 | E-02 L25-26: fd >= 0判定 | ○ |
| C-15 | ポート指定でサーバー作成 | E-02 L27-34: port >= 0判定 | ○ |
| C-16 | UNIXソケットでサーバー作成 | E-02 L35-41: path指定listen | ○ |
| C-17 | ipv6Onlyフラグ設定 | E-02 L32: Boolean(flags & constants.UV_TCP_IPV6ONLY) | ○ |
| C-18 | ワーカーが正しく追加される | E-02 L50-75: all.set()呼び出し | ○ |
| C-19 | リスニング中は即座に完了 | E-02 L67-68: server === null判定 | ○ |
| C-20 | バインド中はイベント待ち | E-02 L71: server.once('listening', done) | ○ |
| C-21 | 既存ワーカー追加でassert | E-02 L51: assert(this.all.has(worker.id) === false) | ○ |
| C-22 | サーバーエラー時にerrno送信 | E-02 L72-74: server.once('error') | ○ |
| C-23 | ワーカーが正しく削除される | E-02 L77-97: all.delete(), free.delete() | ○ |
| C-24 | 最後のワーカー削除で全クローズ | E-02 L85-96: all.size !== 0判定 | ○ |
| C-25 | 存在しないワーカー削除でfalse | E-02 L78-81: existed判定 | ○ |
| C-26 | 接続がキューに追加される | E-02 L99-113: append(this.handles, handle) | ○ |
| C-27 | 空きワーカーでhandoff呼び出し | E-02 L106-112: free判定とhandoff呼び出し | ○ |
| C-28 | エラー時は何もしない | E-02 L100-103: if (err) return | ○ |
| C-29 | 接続がワーカーに渡される | E-02 L115-138: sendHelper呼び出し | ○ |
| C-30 | 接続なしでfreeキューに追加 | E-02 L122-124: handle === null判定 | ○ |
| C-31 | 接続拒否で再分配 | E-02 L134-135: !accepted判定 | ○ |
| C-32 | サーバー閉じ中で早期リターン | E-02 L116-117: !this.all.has判定 | ○ |
| C-33 | 存在するワーカーでtrue返却 | E-02 L141-143: has()メソッド | ○ |
| C-34 | 存在しないワーカーでfalse返却 | E-02 L141-143: has()メソッド | ○ |

### Worker（worker.js）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | newなしでインスタンス作成 | E-03 L17-18: instanceof判定 | ○ |
| C-36 | optionsからプロパティ設定 | E-03 L27-28: options.state, options.id | ○ |
| C-37 | processでイベントハンドラ設定 | E-03 L30-38: process.on('error'), on('message') | ○ |
| C-38 | optionsがnullでデフォルト値 | E-03 L22-23: options === null判定 | ○ |
| C-39 | optionsがundefinedでデフォルト値 | E-03 L22-23: typeof options !== 'object'判定 | ○ |
| C-40 | killがdestroyに委譲 | E-03 L44-46: ReflectApply(this.destroy) | ○ |
| C-41 | kill引数がdestroyに渡される | E-03 L45: arguments透過 | ○ |
| C-42 | sendがprocess.sendに委譲 | E-03 L48-50: ReflectApply(process.send) | ○ |
| C-43 | send引数がすべて渡される | E-03 L49: arguments透過 | ○ |
| C-44 | exitCodeでisDead true | E-03 L52-54: exitCode != null | ○ |
| C-45 | signalCodeでisDead true | E-03 L53: signalCode != null | ○ |
| C-46 | 両方nullでisDead false | E-03 L52-54: || 演算子 | ○ |
| C-47 | connected trueでisConnected true | E-03 L56-58: process.connected | ○ |
| C-48 | connected falseでisConnected false | E-03 L56-58: process.connected | ○ |

### utils.js
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | メッセージが正しく送信される | E-05 L16-28: proc.send(message, handle) | ○ |
| C-50 | コールバックがseqで登録される | E-05 L24-25: callbacks.set(seq, cb) | ○ |
| C-51 | seqがインクリメントされる | E-05 L27: seq += 1 | ○ |
| C-52 | 非接続でfalse返却 | E-05 L17-18: !proc.connected判定 | ○ |
| C-53 | handleが正しく渡される | E-05 L28: proc.send(message, handle) | ○ |
| C-54 | NODE_CLUSTERでcb呼び出し | E-05 L33-50: cmd判定 | ○ |
| C-55 | 非NODE_CLUSTER無視 | E-05 L35-36: cmd !== 'NODE_CLUSTER' return | ○ |
| C-56 | ackで登録コールバック呼び出し | E-05 L40-47: callbacks.get(message.ack) | ○ |
| C-57 | ack後にコールバック削除 | E-05 L45: callbacks.delete(message.ack) | ○ |

### primary.js
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | デフォルト設定適用 | E-04 L63-70: settings構築 | ○ |
| C-59 | オプションで上書き | E-04 L69: ...options スプレッド | ○ |
| C-60 | --profで--logfile追加 | E-04 L76-81: execArgv操作 | ○ |
| C-61 | --logfile既存で追加なし | E-04 L78: StringPrototypeStartsWith判定 | ○ |
| C-62 | 2回目以降でもsetup発火 | E-04 L85-86: initialized判定 | ○ |
| C-63 | 新ワーカープロセス作成 | E-04 L161-217: fork呼び出し | ○ |
| C-64 | ワーカーIDインクリメント | E-04 L163: ++ids | ○ |
| C-65 | workersに追加 | E-04 L215: cluster.workers[worker.id] | ○ |
| C-66 | NODE_UNIQUE_ID設定 | E-04 L119: NODE_UNIQUE_ID: `${id}` | ○ |
| C-67 | forkイベント発火 | E-04 L219-221: emitForkNT | ○ |
| C-68 | inspectPort=nullでエラー | E-04 L122-124: throw ERR_SOCKET_BAD_PORT | ○ |
| C-69 | 全ワーカーdisconnect | E-04 L223-238: workers.forEach | ○ |
| C-70 | コールバック登録 | E-04 L236-237: intercom.once | ○ |
| C-71 | ワーカーなしで即発火 | E-04 L226-227: workers.length === 0 | ○ |
| C-72 | disconnectメッセージ送信 | E-04 L362: send({ act: 'disconnect' }) | ○ |
| C-73 | exitedAfterDisconnect設定 | E-04 L361: this.exitedAfterDisconnect = true | ○ |
| C-74 | ハンドル・ワーカー削除 | E-04 L363-364: removeHandles, removeWorker | ○ |
| C-75 | デフォルトSIGTERM | E-04 L368-371: signal || 'SIGTERM' | ○ |
| C-76 | 指定シグナル送信 | E-04 L370: process.kill(signal) | ○ |
| C-77 | SCHED_NONEでSharedHandle | E-04 L297-300: schedulingPolicy判定 | ○ |
| C-78 | SCHED_RRでRoundRobinHandle | E-04 L301-302: else RoundRobinHandle | ○ |
| C-79 | UDPは常にSharedHandle | E-04 L298-299: udp4/udp6判定 | ○ |
| C-80 | exitedAfterDisconnectでスキップ | E-04 L270-271: if判定 | ○ |
| C-81 | 状態online更新 | E-04 L257-258: worker.state = 'online' | ○ |
| C-82 | onlineイベント発火 | E-04 L259-260: emit('online') | ○ |
| C-83 | 状態listening更新 | E-04 L340: worker.state = 'listening' | ○ |
| C-84 | listeningにアドレス情報 | E-04 L332-342: info構築 | ○ |

### child.js
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | ワーカーオブジェクト作成 | E-06 L36-43: new Worker() | ○ |
| C-86 | onlineメッセージ送信 | E-06 L56: send({ act: 'online' }) | ○ |
| C-87 | disconnectハンドラ設定 | E-06 L45-53: process.once('disconnect') | ○ |
| C-88 | 予期しない切断で終了 | E-06 L48-52: !exitedAfterDisconnect判定 | ○ |
| C-89 | queryServerメッセージ送信 | E-06 L92-116: send({ act: 'queryServer' }) | ○ |
| C-90 | UNIXパス絶対パス解決 | E-06 L70-73: path.resolve(address) | ○ |
| C-91 | インデックス一意割当 | E-06 L83-90: indexSet.nextIndex++ | ○ |
| C-92 | handleありでshared呼び出し | E-06 L109-111: if (handle) shared() | ○ |
| C-93 | handleなしでrr呼び出し | E-06 L112-114: else rr() | ○ |
| C-94 | ハンドルがマップ登録 | E-06 L157: handles.set(key, handle) | ○ |
| C-95 | close時にプライマリ通知 | E-06 L151: send({ act: 'close' }) | ○ |
| C-96 | fakeハンドル作成 | E-06 L216: { close, listen, ref, unref } | ○ |
| C-97 | エラー時errno渡し | E-06 L163-164: if (message.errno) | ○ |
| C-98 | TCPでgetsockname設定 | E-06 L218-219: if (message.sockname) | ○ |
| C-99 | 接続受け入れ | E-06 L244-245: server.onconnection(0, handle) | ○ |
| C-100 | maxConnections超過で拒否 | E-06 L235-239: maxConnections判定 | ○ |
| C-101 | サーバーなしで拒否 | E-06 L231: server !== undefined | ○ |
| C-102 | 状態disconnecting変更 | E-06 L289-290: state判定と変更 | ○ |
| C-103 | _disconnect呼び出し | E-06 L291: FunctionPrototypeCall(_disconnect) | ○ |
| C-104 | disconnecting中は何もしない | E-06 L289: state !== 'disconnecting' | ○ |
| C-105 | destroying中は何もしない | E-06 L289: state !== 'destroying' | ○ |
| C-106 | 状態destroying変更 | E-06 L305: this.state = 'destroying' | ○ |
| C-107 | 非接続でexit | E-06 L302-303: !isConnected()判定 | ○ |
| C-108 | 接続中は切断後終了 | E-06 L304-307: send後disconnect | ○ |
| C-109 | destroying中で早期リターン | E-06 L298-299: state === 'destroying' | ○ |
| C-110 | 全ハンドルクローズ | E-06 L274-281: handles.values() | ○ |
| C-111 | プライマリ起点で即disconnect | E-06 L266-267: if (primaryInitiated) | ○ |
| C-112 | ワーカー起点でACK後disconnect | E-06 L268-269: send後disconnect | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全テストケースはソースコードに基づいて生成されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコードの根拠あり
- 注意点：
  - 一部のテストケースは実行時の動作に依存するため、モック・スタブの適切な設計が必要
  - プロセス間通信のテストは統合テストでの確認も推奨

## 6) レビュアーチェックリスト（最小）
- [ ] SharedHandleのエラーハンドリングテストが網羅されているか
- [ ] RoundRobinHandleの接続分配ロジックが正しくテストされているか
- [ ] Workerの状態遷移が適切にカバーされているか
- [ ] プライマリ・ワーカー間のメッセージングが正しくテストされているか
- [ ] リソースリーク（ハンドルのクローズ漏れ）のテストが含まれているか
- [ ] 境界値テスト（空配列、null/undefined）が十分か
