---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート: lib-internal-console 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim: 主張）を検証しています:

1. **根拠の有無確認**: 各テストケースに対して、ソースコード内の該当実装が存在するか
2. **根拠との整合性**: テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**: モジュール内の主要な機能・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」: 根拠あり、「△」: 根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）: **0.98**
  - 根拠あり: 98 / 100、根拠なし: 2
- 優先レビュー（高）
  1. **UT-CON-095（スナップショット対応）**: internalBinding('config').hasInspectorの動作確認が必要
  2. **UT-CON-088（遅延初期化）**: 実際のprocess.stdout/stderrへのアクセスタイミングの検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/console/constructor.js` (L1-720)
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/console/global.js` (L1-52)
- E-03: Consoleコンストラクタ実装 (constructor.js L102-174)
- E-04: kBindStreamsEager実装 (constructor.js L196-206)
- E-05: kBindStreamsLazy実装 (constructor.js L207-236)
- E-06: kBindProperties実装 (constructor.js L237-281)
- E-07: kWriteToConsole実装 (constructor.js L282-324)
- E-08: kGetInspectOptions実装 (constructor.js L325-345)
- E-09: kFormatForStdout/kFormatForStderr実装 (constructor.js L346-379)
- E-10: consoleMethods定義 (constructor.js L411-666)
- E-11: log/info/debug/warn/errorメソッド (constructor.js L412-445)
- E-12: dirメソッド (constructor.js L447-453)
- E-13: time/timeEnd/timeLogメソッド (constructor.js L455-465)
- E-14: traceメソッド (constructor.js L467-474)
- E-15: assertメソッド (constructor.js L476-487)
- E-16: clearメソッド (constructor.js L489-503)
- E-17: count/countResetメソッド (constructor.js L505-530)
- E-18: group/groupEndメソッド (constructor.js L532-551)
- E-19: tableメソッド (constructor.js L553-665)
- E-20: createWriteErrorHandler関数 (constructor.js L383-401)
- E-21: timeLogImpl関数 (constructor.js L403-409)
- E-22: initializeGlobalConsole関数 (constructor.js L683-712)
- E-23: SymbolHasInstance定義 (constructor.js L183-188)
- E-24: globalConsole初期化 (global.js L27-51)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Consoleコンストラクタがstdout/stderrで初期化される | E-03 | ○ |
| C-02 | new演算子なしでも動作する（ReflectConstruct） | E-03 L106-108 | ○ |
| C-03 | レガシー引数形式（stdout, stderr, ignoreErrors）対応 | E-03 L110-116 | ○ |
| C-04 | stdoutがnull/undefinedでERR_CONSOLE_WRITABLE_STREAM | E-03 L127-129 | ○ |
| C-05 | stdoutにwriteがなければエラー | E-03 L127-129 | ○ |
| C-06 | stderrがnull/undefinedでエラー | E-03 L130-132 | ○ |
| C-07 | stderr省略時はstdoutが使用される | E-03 L119 | ○ |
| C-08 | ignoreErrors=trueでエラー無視 | E-07 L302-322 | ○ |
| C-09 | ignoreErrors=falseでエラー伝播 | E-07 L302 | ○ |
| C-10 | colorMode='auto'で初期化 | E-03 L122, E-08 L329-331 | ○ |
| C-11 | colorMode=trueで初期化 | E-03 L134, E-08 | ○ |
| C-12 | colorMode=falseで初期化 | E-03 L134, E-08 | ○ |
| C-13 | colorMode無効値でエラー | E-03 L134 | ○ |
| C-14 | groupIndentation指定可能 | E-03 L136-139, E-06 L240 | ○ |
| C-15 | groupIndentation負の値でエラー | E-03 L137-138 | ○ |
| C-16 | groupIndentation > 1000でエラー | E-03 L137-138, L76 | ○ |
| C-17 | inspectOptionsが設定される | E-03 L141-158, E-08 | ○ |
| C-18 | inspectOptions非オブジェクトでエラー | E-03 L142 | ○ |
| C-19 | inspectOptions.colors + colorMode競合エラー | E-03 L151-156 | ○ |
| C-20 | logがstdoutに出力 | E-11 L412-417 | ○ |
| C-21 | log複数引数フォーマット | E-09 L346-361 | ○ |
| C-22 | logフォーマット文字列処理 | E-09 L359-360 | ○ |
| C-23 | log引数なしで空行 | E-11, E-07 L300 | ○ |
| C-24 | log diagnostics_channel発行 | E-11 L413-415 | ○ |
| C-25 | infoがstdoutに出力 | E-11 L419-424 | ○ |
| C-26 | info diagnostics_channel発行 | E-11 L420-422 | ○ |
| C-27 | debugがstdoutに出力 | E-11 L426-431 | ○ |
| C-28 | debug diagnostics_channel発行 | E-11 L427-429 | ○ |
| C-29 | warnがstderrに出力 | E-11 L433-438 | ○ |
| C-30 | warn diagnostics_channel発行 | E-11 L434-436 | ○ |
| C-31 | errorがstderrに出力 | E-11 L440-445 | ○ |
| C-32 | error diagnostics_channel発行 | E-11 L441-443 | ○ |
| C-33 | dirがinspect形式で出力 | E-12 L447-453 | ○ |
| C-34 | dirオプション適用 | E-12 L448-452 | ○ |
| C-35 | dir customInspect:false | E-12 L449 | ○ |
| C-36 | dirxmlはlogのエイリアス | E-10 L680 | ○ |
| C-37 | timeがタイマー開始 | E-13 L455-457 | ○ |
| C-38 | timeデフォルトラベル'default' | E-13 L455 | ○ |
| C-39 | timeEnd経過時間出力 | E-13 L459-461 | ○ |
| C-40 | timeEndデフォルトラベル | E-13 L459 | ○ |
| C-41 | timeEnd存在しないタイマー警告 | E-13（internal/util/debuglog依存） | ○ |
| C-42 | timeLog継続出力 | E-13 L463-465 | ○ |
| C-43 | timeLog追加データ | E-13 L463, E-21 L406-408 | ○ |
| C-44 | timeLog存在しないタイマー警告 | E-13（internal/util/debuglog依存） | ○ |
| C-45 | traceスタックトレース出力 | E-14 L467-474 | ○ |
| C-46 | trace引数なし | E-14 | ○ |
| C-47 | assert true時出力なし | E-15 L478 | ○ |
| C-48 | assert false時Assertion failed | E-15 L478-486 | ○ |
| C-49 | assertカスタムメッセージ | E-15 L479-480 | ○ |
| C-50 | assert非文字列引数 | E-15 L481-483 | ○ |
| C-51 | clear TTY画面クリア | E-16 L490-502 | ○ |
| C-52 | clear非TTYで何もしない | E-16 L493 | ○ |
| C-53 | clear TERM=dumbで何もしない | E-16 L493 | ○ |
| C-54 | countカウント1開始 | E-17 L506-518 | ○ |
| C-55 | countインクリメント | E-17 L513-516 | ○ |
| C-56 | countデフォルトラベル | E-17 L506 | ○ |
| C-57 | count異なるラベル分離 | E-17 | ○ |
| C-58 | countResetリセット | E-17 L522-530 | ○ |
| C-59 | countResetデフォルト | E-17 L522 | ○ |
| C-60 | countReset存在しない警告 | E-17 L524-526 | ○ |
| C-61 | groupインデント追加 | E-18 L532-540 | ○ |
| C-62 | groupラベル出力 | E-18 L533-535 | ○ |
| C-63 | groupネスト累積 | E-18 L537-539 | ○ |
| C-64 | groupCollapsedはgroupエイリアス | E-10 L681 | ○ |
| C-65 | groupEndインデント削除 | E-18 L542-551 | ○ |
| C-66 | groupEnd境界値（インデント0） | E-18 L544-548 | ○ |
| C-67 | table配列表示 | E-19 | ○ |
| C-68 | tableオブジェクト配列 | E-19 L630-665 | ○ |
| C-69 | tableプロパティ指定 | E-19 L555-556, L643 | ○ |
| C-70 | table Map対応 | E-19 L589-613 | ○ |
| C-71 | table Set対応 | E-19 L615-628 | ○ |
| C-72 | tableプリミティブlog出力 | E-19 L558-559 | ○ |
| C-73 | table null処理 | E-19 L558 | ○ |
| C-74 | tableプロパティ非配列エラー | E-19 L555-556 | ○ |
| C-75 | kWriteToConsoleグループインデント | E-07 L287, L294-299 | ○ |
| C-76 | kWriteToConsole複数行インデント | E-07 L295-296 | ○ |
| C-77 | kWriteToConsole末尾改行 | E-07 L300 | ○ |
| C-78 | スタックオーバーフロー再スロー | E-07 L317-318 | ○ |
| C-79 | kGetInspectOptions auto判定 | E-08 L329-331 | ○ |
| C-80 | kGetInspectOptions true | E-08 L343 | ○ |
| C-81 | kGetInspectOptions false | E-08 L343 | ○ |
| C-82 | kGetInspectOptionsマージ | E-08 L334-341 | ○ |
| C-83 | kFormatForStdout単一文字列最適化 | E-09 L350-356 | ○ |
| C-84 | kFormatForStderr単一文字列最適化 | E-09 L367-373 | ○ |
| C-85 | SymbolHasInstance Consoleインスタンス | E-23 L183-188 | ○ |
| C-86 | SymbolHasInstance kIsConsole | E-23 L186 | ○ |
| C-87 | SymbolHasInstance一般オブジェクト | E-23 | ○ |
| C-88 | kBindStreamsLazy遅延初期化 | E-05 L207-236 | △ |
| C-89 | kBindStreamsLazy setter | E-05 L223, L232 | ○ |
| C-90 | globalConsoleメソッドバインド | E-24 L34-43 | ○ |
| C-91 | globalConsole thisバインド | E-24 L39 | ○ |
| C-92 | globalConsoleプロトタイプチェーン | E-24 L27 | ○ |
| C-93 | globalConsole.Console参照 | E-24 L49 | ○ |
| C-94 | initializeGlobalConsole遅延バインド | E-22 L684 | ○ |
| C-95 | initializeGlobalConsoleスナップショット | E-22 L686-711 | △ |
| C-96 | createWriteErrorHandler noopリスナー追加 | E-20 L396-398 | ○ |
| C-97 | createWriteErrorHandler既存リスナー確認 | E-20 L396 | ○ |
| C-98 | createWriteErrorHandler errorEmitted確認 | E-20 L390 | ○ |
| C-99 | timeLogImpl基本形式 | E-21 L404-405 | ○ |
| C-100 | timeLogImpl追加データ | E-21 L406-408 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-88 (kBindStreamsLazy遅延初期化)**: 実際のprocess.stdout/stderrへのアクセスタイミングについて、統合テストでの検証が必要
  - 候補: test/parallel/test-console-async-output.js / test/parallel/test-console.js
- **C-95 (スナップショット対応)**: `internalBinding('config').hasInspector` と `isBuildingSnapshot()` の条件分岐の検証
  - 候補: test/fixtures/snapshot/ / internal/v8/startup_snapshot.js

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分のテストケース - ソースコードから直接導出可能
- **1（中リスク）**: C-41, C-44 (timeEnd/timeLog警告) - internal/util/debuglogモジュールの動作に依存
- **1（中リスク）**: C-88 (遅延初期化) - 実行時のタイミング依存
- **1（中リスク）**: C-95 (スナップショット) - ビルド設定依存

## 6) レビュアーチェックリスト（最小）
- [ ] コンストラクタのバリデーションテスト（C-04〜C-06, C-13, C-15〜C-16, C-18〜C-19）が網羅的か確認
- [ ] 各出力メソッド（log/info/debug/warn/error）のstdout/stderr出力先が正しいか確認
- [ ] diagnostics_channelのテストが実際のNode.jsテスト基盤で動作可能か確認
- [ ] time/timeEnd/timeLogの警告出力テストがinternal/util/debuglogと整合するか確認
- [ ] tableメソッドのMap/Set/Iterator対応が網羅的か確認
- [ ] ignoreErrorsのエラーハンドリングテストがスタックオーバーフローを含むか確認
- [ ] globalConsoleのthisバインドテストが実際の利用パターンをカバーしているか確認
