---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 226
  claims_with_evidence: 226
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lib-internal-crypto 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：226 / 226、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/crypto/hash.js` - Hash, Hmac, asyncDigest, hash関数
- E-02: `lib/internal/crypto/cipher.js` - Cipheriv, Decipheriv, publicEncrypt/Decrypt, privateEncrypt/Decrypt, getCipherInfo
- E-03: `lib/internal/crypto/sig.js` - Sign, Verify, signOneShot, verifyOneShot
- E-04: `lib/internal/crypto/keys.js` - KeyObject, SecretKeyObject, PublicKeyObject, PrivateKeyObject, CryptoKey, createSecretKey, createPublicKey, createPrivateKey
- E-05: `lib/internal/crypto/random.js` - randomBytes, randomFillSync, randomFill, randomInt, randomUUID, getRandomValues, generatePrime, generatePrimeSync, checkPrime, checkPrimeSync
- E-06: `lib/internal/crypto/pbkdf2.js` - pbkdf2, pbkdf2Sync
- E-07: `lib/internal/crypto/hkdf.js` - hkdf, hkdfSync
- E-08: `lib/internal/crypto/scrypt.js` - scrypt, scryptSync
- E-09: `lib/internal/crypto/diffiehellman.js` - DiffieHellman, DiffieHellmanGroup, ECDH, diffieHellman
- E-10: `lib/internal/crypto/keygen.js` - generateKeyPair, generateKeyPairSync, generateKey, generateKeySync
- E-11: `lib/internal/crypto/x509.js` - X509Certificate
- E-12: `lib/internal/crypto/certificate.js` - Certificate, verifySpkac, exportPublicKey, exportChallenge
- E-13: `lib/internal/crypto/webcrypto.js` - SubtleCrypto, Crypto (digest, generateKey, importKey, exportKey, encrypt, decrypt, sign, verify, deriveBits, deriveKey, wrapKey, unwrapKey)
- E-14: `lib/internal/crypto/util.js` - getCiphers, getHashes, getCurves, setEngine, getArrayBufferOrView, normalizeAlgorithm, secureHeapUsed
- E-15: `lib/internal/crypto/aes.js` - aesCipher, aesGenerateKey, aesImportKey
- E-16: `lib/internal/crypto/rsa.js` - rsaCipher, rsaExportKey, rsaImportKey, rsaKeyGenerate, rsaSignVerify
- E-17: `lib/internal/crypto/ec.js` - ecExportKey, ecImportKey, ecGenerateKey, ecdsaSignVerify
- E-18: `lib/internal/crypto/mac.js` - hmacGenerateKey, hmacSignVerify, kmacGenerateKey, kmacSignVerify, macImportKey

## 3) Claims と根拠の対応（レビューの主戦場）

### Hash/Hmac関連 (UT-CRY-001〜023)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Hash constructorでインスタンスが作成される | E-01 (hash.js L88-109) | ○ |
| C-02 | new演算子なしでもインスタンス作成される | E-01 (hash.js L89-90) | ○ |
| C-03 | outputLengthオプションでXOF対応 | E-01 (hash.js L94-97) | ○ |
| C-04 | 不正なアルゴリズムでvalidateString実行 | E-01 (hash.js L93) | ○ |
| C-05 | update()でチェーン可能 | E-01 (hash.js L132-147) | ○ |
| C-06 | Bufferデータ対応 | E-01 (hash.js L139) | ○ |
| C-07 | TypedArray対応 | E-01 (hash.js L139) | ○ |
| C-08 | finalized後のupdateでエラー | E-01 (hash.js L134-135) | ○ |
| C-09 | 不正な型でERR_INVALID_ARG_TYPE | E-01 (hash.js L140-141) | ○ |
| C-10 | digest()でBuffer返却 | E-01 (hash.js L150-159) | ○ |
| C-11 | hex形式エンコーディング | E-01 (hash.js L156) | ○ |
| C-12 | base64形式エンコーディング | E-01 (hash.js L156) | ○ |
| C-13 | 2回目digestでERR_CRYPTO_HASH_FINALIZED | E-01 (hash.js L152-153) | ○ |
| C-14 | copy()でHashコピー作成 | E-01 (hash.js L114-120) | ○ |
| C-15 | finalized後のcopyでエラー | E-01 (hash.js L116-117) | ○ |
| C-16 | hash()ワンショット関数 | E-01 (hash.js L232-276) | ○ |
| C-17 | outputEncodingデフォルトhex | E-01 (hash.js L248) | ○ |
| C-18 | hash()の不正アルゴリズム検証 | E-01 (hash.js L233) | ○ |
| C-19 | Hmac constructor | E-01 (hash.js L161-173) | ○ |
| C-20 | Hmacの不正アルゴリズム検証 | E-01 (hash.js L164) | ○ |
| C-21 | Hmac.update() | E-01 (hash.js L178) | ○ |
| C-22 | Hmac.digest() | E-01 (hash.js L180-194) | ○ |
| C-23 | finalized後のHmac digestで空Buffer | E-01 (hash.js L183-187) | ○ |

### Cipher関連 (UT-CRY-024〜043)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | Cipheriv constructor | E-02 (cipher.js L214-219) | ○ |
| C-25 | new演算子なしでもインスタンス作成 | E-02 (cipher.js L215-216) | ○ |
| C-26 | 不正なcipher名でエラー | E-02 (cipher.js L124 validateString) | ○ |
| C-27 | update()で暗号化 | E-02 (cipher.js L151-167) | ○ |
| C-28 | 出力エンコーディング指定 | E-02 (cipher.js L161-163) | ○ |
| C-29 | final()で最終ブロック | E-02 (cipher.js L169-178) | ○ |
| C-30 | setAutoPadding() | E-02 (cipher.js L180-184) | ○ |
| C-31 | final後のsetAutoPaddingでエラー | E-02 (cipher.js L181-182) | ○ |
| C-32 | getAuthTag() GCMモード | E-02 (cipher.js L186-191) | ○ |
| C-33 | 非AEADモードでgetAuthTagエラー | E-02 (cipher.js L188-189) | ○ |
| C-34 | setAAD() | E-02 (cipher.js L200-207) | ○ |
| C-35 | 不正タイミングのsetAADでエラー | E-02 (cipher.js L204-205) | ○ |
| C-36 | Decipheriv constructor | E-02 (cipher.js L243-248) | ○ |
| C-37 | setAuthTag() GCMモード | E-02 (cipher.js L193-198) | ○ |
| C-38 | 不正タイミングのsetAuthTagでエラー | E-02 (cipher.js L195-196) | ○ |
| C-39 | getCipherInfo()文字列 | E-02 (cipher.js L256-282) | ○ |
| C-40 | getCipherInfo() NID | E-02 (cipher.js L271-275) | ○ |
| C-41 | 空文字列でundefined | E-02 (cipher.js L269) | ○ |
| C-42 | 範囲外NIDでundefined | E-02 (cipher.js L272-274) | ○ |
| C-43 | 不正な型でエラー | E-02 (cipher.js L278-281) | ○ |

### RSA暗号化関連 (UT-CRY-044〜047)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | publicEncrypt | E-02 (cipher.js L84-85) | ○ |
| C-45 | publicDecrypt | E-02 (cipher.js L86-87) | ○ |
| C-46 | privateEncrypt | E-02 (cipher.js L88-89) | ○ |
| C-47 | privateDecrypt | E-02 (cipher.js L90-91) | ○ |

### Sign/Verify関連 (UT-CRY-048〜061)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | Sign constructor | E-03 (sig.js L54-62) | ○ |
| C-49 | Signの不正アルゴリズム検証 | E-03 (sig.js L57) | ○ |
| C-50 | Sign.update() | E-03 (sig.js L72-82) | ○ |
| C-51 | updateの不正な型でエラー | E-03 (sig.js L75-77) | ○ |
| C-52 | Sign.sign() | E-03 (sig.js L133-153) | ○ |
| C-53 | signのエンコーディング指定 | E-03 (sig.js L149-150) | ○ |
| C-54 | 鍵なしでエラー | E-03 (sig.js L134-135) | ○ |
| C-55 | signOneShot | E-03 (sig.js L155-212) | ○ |
| C-56 | signOneShotコールバック | E-03 (sig.js L159-160, L207-211) | ○ |
| C-57 | signOneShot鍵なしでエラー | E-03 (sig.js L164-165) | ○ |
| C-58 | Verify constructor | E-03 (sig.js L214-222) | ○ |
| C-59 | Verify.verify()有効署名 | E-03 (sig.js L230-249) | ○ |
| C-60 | Verify.verify()無効署名 | E-03 (sig.js L247) | ○ |
| C-61 | verifyOneShot | E-03 (sig.js L251-321) | ○ |

### KeyObject関連 (UT-CRY-062〜090)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | KeyObject constructor | E-04 (keys.js L108-126) | ○ |
| C-63 | 不正なtypeでエラー | E-04 (keys.js L110-111) | ○ |
| C-64 | 不正なハンドルでエラー | E-04 (keys.js L112-113) | ○ |
| C-65 | typeプロパティ | E-04 (keys.js L128-130) | ○ |
| C-66 | KeyObject.from() | E-04 (keys.js L132-136) | ○ |
| C-67 | fromの不正引数でエラー | E-04 (keys.js L133-134) | ○ |
| C-68 | equals()同一鍵 | E-04 (keys.js L138-146) | ○ |
| C-69 | equals()異なる鍵 | E-04 (keys.js L144-145) | ○ |
| C-70 | equalsの不正引数でエラー | E-04 (keys.js L139-142) | ○ |
| C-71 | symmetricKeySize | E-04 (keys.js L164-166) | ○ |
| C-72 | SecretKeyObject.export() | E-04 (keys.js L168-178) | ○ |
| C-73 | JWK形式エクスポート | E-04 (keys.js L173-174) | ○ |
| C-74 | PublicKeyObject.export() PEM | E-04 (keys.js L342-351) | ○ |
| C-75 | PublicKeyObject.export() DER | E-04 (keys.js L350) | ○ |
| C-76 | asymmetricKeyType | E-04 (keys.js L257-259) | ○ |
| C-77 | asymmetricKeyDetails | E-04 (keys.js L261-273) | ○ |
| C-78 | PrivateKeyObject.export() PEM | E-04 (keys.js L359-374) | ○ |
| C-79 | 暗号化付きエクスポート | E-04 (keys.js L373) | ○ |
| C-80 | JWK+passphraseでエラー | E-04 (keys.js L361-363) | ○ |
| C-81 | createSecretKey | E-04 (keys.js L769-774) | ○ |
| C-82 | createSecretKeyエンコーディング | E-04 (keys.js L770) | ○ |
| C-83 | createSecretKey不正型でエラー | E-04 (keys.js L758-764) | ○ |
| C-84 | createPublicKey PEM | E-04 (keys.js L776-787) | ○ |
| C-85 | createPublicKey DER | E-04 (keys.js L783-784) | ○ |
| C-86 | createPublicKey JWK | E-04 (keys.js L780-781) | ○ |
| C-87 | createPublicKey不正PEMでエラー | E-04 (keys.js L784) | ○ |
| C-88 | createPrivateKey PEM | E-04 (keys.js L789-800) | ○ |
| C-89 | 暗号化PEMとパスフレーズ | E-04 (keys.js L797) | ○ |
| C-90 | 不正パスフレーズでエラー | E-04 (keys.js L797) | ○ |

### CryptoKey関連 (UT-CRY-091〜095)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | CryptoKey.type | E-04 (keys.js L838-842) | ○ |
| C-92 | CryptoKey.extractable | E-04 (keys.js L844-848) | ○ |
| C-93 | CryptoKey.algorithm | E-04 (keys.js L850-859) | ○ |
| C-94 | CryptoKey.usages | E-04 (keys.js L861-866) | ○ |
| C-95 | constructorでエラー | E-04 (keys.js L813-814) | ○ |

### Random関連 (UT-CRY-096〜125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | randomBytes | E-05 (random.js L99-117) | ○ |
| C-97 | randomBytesコールバック | E-05 (random.js L112-116) | ○ |
| C-98 | size=0で空Buffer | E-05 (random.js L137-138) | ○ |
| C-99 | 負サイズでエラー | E-05 (random.js L87-89) | ○ |
| C-100 | 非整数でエラー | E-05 (random.js L84) | ○ |
| C-101 | randomFillSync | E-05 (random.js L119-151) | ○ |
| C-102 | randomFillSyncオフセット | E-05 (random.js L129-134) | ○ |
| C-103 | randomFillSync不正バッファ | E-05 (random.js L120-125) | ○ |
| C-104 | オフセット範囲エラー | E-05 (random.js L76-78) | ○ |
| C-105 | randomFill | E-05 (random.js L153-195) | ○ |
| C-106 | randomInt | E-05 (random.js L210-278) | ○ |
| C-107 | randomInt maxのみ | E-05 (random.js L214-221) | ○ |
| C-108 | randomIntコールバック | E-05 (random.js L224-226) | ○ |
| C-109 | max<=minでエラー | E-05 (random.js L233-236) | ○ |
| C-110 | 非整数でエラー | E-05 (random.js L227-231) | ○ |
| C-111 | RAND_MAX超過でエラー | E-05 (random.js L242-244) | ○ |
| C-112 | randomUUID | E-05 (random.js L405-415) | ○ |
| C-113 | disableEntropyCacheオプション | E-05 (random.js L408-414) | ○ |
| C-114 | 不正オプションでエラー | E-05 (random.js L412) | ○ |
| C-115 | getRandomValues | E-05 (random.js L318-337) | ○ |
| C-116 | Float型でエラー | E-05 (random.js L319-328) | ○ |
| C-117 | 65536バイト超過でエラー | E-05 (random.js L330-333) | ○ |
| C-118 | generatePrime | E-05 (random.js L471-491) | ○ |
| C-119 | bigint形式 | E-05 (random.js L423, L467) | ○ |
| C-120 | safeオプション | E-05 (random.js L421, L429) | ○ |
| C-121 | generatePrimeSync | E-05 (random.js L493-501) | ○ |
| C-122 | サイズ0以下でエラー | E-05 (random.js L472, L494) | ○ |
| C-123 | checkPrime素数true | E-05 (random.js L539-571) | ○ |
| C-124 | checkPrime合成数false | E-05 (random.js L569) | ○ |
| C-125 | checkPrimeSync | E-05 (random.js L573-603) | ○ |

### 鍵導出関連 (UT-CRY-126〜136)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | pbkdf2 | E-06 (pbkdf2.js L34-61) | ○ |
| C-127 | iterations=0でエラー | E-06 (pbkdf2.js L89) | ○ |
| C-128 | 不正digestでエラー | E-06 (pbkdf2.js L83) | ○ |
| C-129 | pbkdf2Sync | E-06 (pbkdf2.js L63-80) | ○ |
| C-130 | hkdf | E-07 (hkdf.js L102-121) | ○ |
| C-131 | info1024バイト超過でエラー | E-07 (hkdf.js L60-64) | ○ |
| C-132 | hkdfSync | E-07 (hkdf.js L123-138) | ○ |
| C-133 | scrypt | E-08 (scrypt.js L40-63) | ○ |
| C-134 | scryptオプション | E-08 (scrypt.js L87-127) | ○ |
| C-135 | N/cost競合でエラー | E-08 (scrypt.js L94-95) | ○ |
| C-136 | scryptSync | E-08 (scrypt.js L65-77) | ○ |

### DiffieHellman/ECDH関連 (UT-CRY-137〜153)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-137 | DiffieHellman constructorサイズ | E-09 (diffiehellman.js L78-132) | ○ |
| C-138 | DiffieHellman constructorプライム | E-09 (diffiehellman.js L107-108) | ○ |
| C-139 | generateKeys | E-09 (diffiehellman.js L148-155) | ○ |
| C-140 | computeSecret | E-09 (diffiehellman.js L158-168) | ○ |
| C-141 | 不正公開鍵でエラー | E-09 (diffiehellman.js L165-166) | ○ |
| C-142 | getPrime | E-09 (diffiehellman.js L171-178) | ○ |
| C-143 | getGenerator | E-09 (diffiehellman.js L181-188) | ○ |
| C-144 | DiffieHellmanGroup constructor | E-09 (diffiehellman.js L135-145) | ○ |
| C-145 | ECDH constructor | E-09 (diffiehellman.js L225-231) | ○ |
| C-146 | ECDH不正カーブでエラー | E-09 (diffiehellman.js L229) | ○ |
| C-147 | ECDH generateKeys | E-09 (diffiehellman.js L240-244) | ○ |
| C-148 | compressed形式 | E-09 (diffiehellman.js L246-250, L267-276) | ○ |
| C-149 | ECDH computeSecret | E-09 (diffiehellman.js L233) | ○ |
| C-150 | ECDH.convertKey | E-09 (diffiehellman.js L252-258) | ○ |
| C-151 | diffieHellman KeyObject | E-09 (diffiehellman.js L280-326) | ○ |
| C-152 | privateKey非private型でエラー | E-09 (diffiehellman.js L293-294) | ○ |
| C-153 | 鍵タイプ不一致でエラー | E-09 (diffiehellman.js L303-305) | ○ |

### KeyGen関連 (UT-CRY-154〜164)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-154 | generateKeyPair RSA | E-10 (keygen.js L92-111, L217-238) | ○ |
| C-155 | generateKeyPair EC | E-10 (keygen.js L301-319) | ○ |
| C-156 | generateKeyPair Ed25519 | E-10 (keygen.js L183-184) | ○ |
| C-157 | generateKeyPair X25519 | E-10 (keygen.js L187) | ○ |
| C-158 | generateKeyPair DH | E-10 (keygen.js L320-357) | ○ |
| C-159 | 不正タイプでエラー | E-10 (keygen.js L359-361) | ○ |
| C-160 | generateKeyPairSync | E-10 (keygen.js L119-121) | ○ |
| C-161 | generateKey AES | E-10 (keygen.js L401-417, L377-378) | ○ |
| C-162 | generateKey HMAC | E-10 (keygen.js L374-375) | ○ |
| C-163 | 不正鍵長でエラー | E-10 (keygen.js L377-378) | ○ |
| C-164 | generateKeySync | E-10 (keygen.js L419-422) | ○ |

### X509Certificate関連 (UT-CRY-165〜182)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-165 | X509Certificate constructor | E-11 (x509.js L106-120) | ○ |
| C-166 | DER形式対応 | E-11 (x509.js L111-117) | ○ |
| C-167 | 不正証明書でエラー | E-11 (x509.js L112-116) | ○ |
| C-168 | subject | E-11 (x509.js L162-169) | ○ |
| C-169 | issuer | E-11 (x509.js L180-187) | ○ |
| C-170 | validFrom | E-11 (x509.js L209-216) | ○ |
| C-171 | validTo | E-11 (x509.js L218-225) | ○ |
| C-172 | fingerprint | E-11 (x509.js L245-251) | ○ |
| C-173 | fingerprint256 | E-11 (x509.js L253-260) | ○ |
| C-174 | publicKey | E-11 (x509.js L317-324) | ○ |
| C-175 | checkHost | E-11 (x509.js L348-351) | ○ |
| C-176 | checkEmail | E-11 (x509.js L353-356) | ○ |
| C-177 | checkIP | E-11 (x509.js L358-366) | ○ |
| C-178 | checkIssued | E-11 (x509.js L368-372) | ○ |
| C-179 | checkPrivateKey | E-11 (x509.js L374-380) | ○ |
| C-180 | verify | E-11 (x509.js L382-388) | ○ |
| C-181 | toString | E-11 (x509.js L326-333) | ○ |
| C-182 | toJSON | E-11 (x509.js L337) | ○ |

### Certificate関連 (UT-CRY-183〜185)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-183 | verifySpkac | E-12 (certificate.js L17-20) | ○ |
| C-184 | exportPublicKey | E-12 (certificate.js L22-25) | ○ |
| C-185 | exportChallenge | E-12 (certificate.js L27-30) | ○ |

### WebCrypto SubtleCrypto関連 (UT-CRY-186〜210)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-186 | digest | E-13 (webcrypto.js L71-89) | ○ |
| C-187 | digest不正アルゴリズムでエラー | E-13 (webcrypto.js L86) | ○ |
| C-188 | generateKey AES | E-13 (webcrypto.js L96-213, L154-165) | ○ |
| C-189 | generateKey RSA | E-13 (webcrypto.js L122-129) | ○ |
| C-190 | generateKey ECDSA | E-13 (webcrypto.js L142-147) | ○ |
| C-191 | 空usagesでエラー | E-13 (webcrypto.js L201-209) | ○ |
| C-192 | importKey raw | E-13 (webcrypto.js L746-856) | ○ |
| C-193 | importKey JWK | E-13 (webcrypto.js L873-874) | ○ |
| C-194 | importKey spki | E-13 (webcrypto.js L755-757) | ○ |
| C-195 | exportKey raw | E-13 (webcrypto.js L656-734) | ○ |
| C-196 | exportKey jwk | E-13 (webcrypto.js L574-654) | ○ |
| C-197 | extractable=falseでエラー | E-13 (webcrypto.js L678-679) | ○ |
| C-198 | encrypt | E-13 (webcrypto.js L1173-1200) | ○ |
| C-199 | decrypt | E-13 (webcrypto.js L1202-1229) | ○ |
| C-200 | encrypt用途でない鍵でエラー | E-13 (webcrypto.js L1136-1141) | ○ |
| C-201 | sign RSASSA | E-13 (webcrypto.js L1082-1102, L1049-1053) | ○ |
| C-202 | sign ECDSA | E-13 (webcrypto.js L1054-1056) | ○ |
| C-203 | verify | E-13 (webcrypto.js L1104-1128) | ○ |
| C-204 | deriveBits PBKDF2 | E-13 (webcrypto.js L215-267, L255-257) | ○ |
| C-205 | deriveBits HKDF | E-13 (webcrypto.js L252-254) | ○ |
| C-206 | deriveBits ECDH | E-13 (webcrypto.js L244-251) | ○ |
| C-207 | deriveBits用途でない鍵でエラー | E-13 (webcrypto.js L237-240) | ○ |
| C-208 | deriveKey | E-13 (webcrypto.js L308-386) | ○ |
| C-209 | wrapKey | E-13 (webcrypto.js L902-951) | ○ |
| C-210 | unwrapKey | E-13 (webcrypto.js L955-1032) | ○ |

### Crypto関連 (UT-CRY-211〜212)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-211 | Crypto.getRandomValues | E-13 (webcrypto.js L1731-1739) | ○ |
| C-212 | Crypto.randomUUID | E-13 (webcrypto.js L91-94) | ○ |

### util関連 (UT-CRY-213〜226)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-213 | getCiphers | E-14 (util.js L126) | ○ |
| C-214 | getHashes | E-14 (util.js L127) | ○ |
| C-215 | getCurves | E-14 (util.js L128) | ○ |
| C-216 | setEngine | E-14 (util.js L130-144) | ○ |
| C-217 | setEngine不明エンジンでエラー | E-14 (util.js L142-143) | ○ |
| C-218 | getArrayBufferOrView文字列変換 | E-14 (util.js L146-168) | ○ |
| C-219 | getArrayBufferOrViewパススルー | E-14 (util.js L147-148) | ○ |
| C-220 | getArrayBufferOrView不正型でエラー | E-14 (util.js L154-166) | ○ |
| C-221 | normalizeAlgorithm文字列 | E-14 (util.js L529-531) | ○ |
| C-222 | normalizeAlgorithmオブジェクト | E-14 (util.js L536-601) | ○ |
| C-223 | normalizeAlgorithm未サポートでエラー | E-14 (util.js L558-559) | ○ |
| C-224 | secureHeapUsed | E-14 (util.js L791-800) | ○ |
| C-225 | asyncDigest | E-01 (hash.js L201-230) | ○ |
| C-226 | asyncDigest未サポートでエラー | E-01 (hash.js L229) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - すべてのテストケースはソースコードに基づいて生成されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードの実装に基づいている
- 注意点:
  - 実際のNode.js環境でのOpenSSLバージョンによって、一部のアルゴリズム（ML-DSA、ML-KEM等のポスト量子暗号）がサポートされない場合がある
  - BoringSSLビルドでは一部機能が制限される可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] 各クラスの基本機能（constructor、主要メソッド）がカバーされているか
- [ ] 正常系・異常系・境界値の観点が網羅されているか
- [ ] エラーハンドリングのテストケースが適切か
- [ ] WebCrypto APIとの互換性テストが含まれているか
- [ ] 暗号化・復号の対称性テストが考慮されているか
- [ ] 鍵のエクスポート・インポートの相互運用性テストが含まれているか
- [ ] セキュリティ上重要な機能（署名検証、乱数生成等）のテストが十分か
