---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 143
  claims_with_evidence: 143
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lib-internal-debugger 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードから該当する関数・メソッド・クラスが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：対象モジュールの主要な機能を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：143 / 143、根拠なし：0
- 優先レビュー（高）
  1. **WebSocket関連処理**：encodeFrameHybi17/decodeFrameHybi17のペイロード長処理は境界値テストが重要
  2. **接続リトライ処理**：NodeInspector.runの5回リトライ処理は実環境でのテストが必要
  3. **ブレークポイント管理**：setBreakpoint/clearBreakpointは複雑な条件分岐があり注意が必要

## 2) 参照した情報（Evidence一覧）
> 実在するソースファイルを列挙

- E-01: `lib/internal/debugger/inspect.js` - メインインスペクターモジュール
- E-02: `lib/internal/debugger/inspect_client.js` - WebSocketクライアント実装
- E-03: `lib/internal/debugger/inspect_repl.js` - REPL実装とデバッグコマンド

## 3) Claims と根拠の対応（レビューの主戦場）

### inspect.js 関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-DBG-001) | portIsFree: ポート0は即座に終了 | E-01 L52-54 `if (port === 0) return;` | ○ |
| C-02 (UT-DBG-002) | portIsFree: ポートが空いている場合は正常終了 | E-01 L76-78 `if (error?.code === 'ECONNREFUSED') return;` | ○ |
| C-03 (UT-DBG-003) | portIsFree: タイムアウト時にエラー | E-01 L64-66 `throw new ERR_DEBUGGER_STARTUP_ERROR` | ○ |
| C-04 (UT-DBG-004) | runScript: スクリプト実行とデバッガー情報取得 | E-01 L83-109 | ○ |
| C-05 (UT-DBG-005) | runScript: debugRegexによるホスト・ポート抽出 | E-01 L82 `const debugRegex = /Debugger listening on ws:\/\/\[?(.+?)\]?:(\d+)\//;` | ○ |
| C-06 (UT-DBG-006) | createAgentProxy: Proxyオブジェクト生成 | E-01 L111-132 | ○ |
| C-07 (UT-DBG-007) | createAgentProxy: メソッド委譲 | E-01 L127-129 `return client.callMethod(...)` | ○ |
| C-08 (UT-DBG-008) | NodeInspector.constructor: 初期化 | E-01 L134-188 | ○ |
| C-09 (UT-DBG-009) | NodeInspector.constructor: リモート接続モード | E-01 L151-153 | ○ |
| C-10 (UT-DBG-010) | NodeInspector.suspendReplWhile: REPL一時停止 | E-01 L190-209 | ○ |
| C-11 (UT-DBG-011) | NodeInspector.killChild: 子プロセス終了 | E-01 L211-217 | ○ |
| C-12 (UT-DBG-012) | NodeInspector.killChild: nullチェック | E-01 L213 `if (this.child)` | ○ |
| C-13 (UT-DBG-013) | NodeInspector.run: 接続成功 | E-01 L219-233 | ○ |
| C-14 (UT-DBG-014) | NodeInspector.run: 5回リトライ後失敗 | E-01 L226, L239-240 | ○ |
| C-15 (UT-DBG-015) | NodeInspector.clearLine: TTY時のカーソル操作 | E-01 L243-250 | ○ |
| C-16 (UT-DBG-016) | NodeInspector.clearLine: 非TTY時のバックスペース | E-01 L248 | ○ |
| C-17 (UT-DBG-017) | NodeInspector.print: テキスト出力 | E-01 L252-255 | ○ |
| C-18 (UT-DBG-018) | NodeInspector.childPrint: 出力整形 | E-01 L258-279 | ○ |
| C-19 (UT-DBG-019) | NodeInspector.childPrint: デバッガー切断検出 | E-01 L280-285 | ○ |
| C-20 (UT-DBG-020) | parseArgv: host:port形式パース | E-01 L297, L300-305 | ○ |
| C-21 (UT-DBG-021) | parseArgv: --port=形式パース | E-01 L298, L306-310 | ○ |
| C-22 (UT-DBG-022) | parseArgv: -p pid形式パース | E-01 L311-326 | ○ |
| C-23 (UT-DBG-023) | parseArgv: 存在しないPIDエラー | E-01 L317-320 | ○ |
| C-24 (UT-DBG-024) | parseArgv: スクリプト名のみ | E-01 L291-295 (デフォルト値) | ○ |
| C-25 (UT-DBG-025) | startInspect: インスペクター起動 | E-01 L333-365 | ○ |
| C-26 (UT-DBG-026) | startInspect: 引数なしUsage表示 | E-01 L336-344 | ○ |

### inspect_client.js 関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 (UT-DBG-027) | unpackError: エラーオブジェクト生成 | E-02 L44-49 | ○ |
| C-28 (UT-DBG-028) | validateHandshake: ハンドシェイク検証 | E-02 L51-62 | ○ |
| C-29 (UT-DBG-029) | validateHandshake: 不正キーエラー | E-02 L57-60 | ○ |
| C-30 (UT-DBG-030) | encodeFrameHybi17: 小ペイロードエンコード | E-02 L64-99, L82-85 | ○ |
| C-31 (UT-DBG-031) | encodeFrameHybi17: 中ペイロードエンコード | E-02 L77-81 | ○ |
| C-32 (UT-DBG-032) | encodeFrameHybi17: 大ペイロードエンコード | E-02 L69-76 | ○ |
| C-33 (UT-DBG-033) | decodeFrameHybi17: テキストフレームデコード | E-02 L101-166 | ○ |
| C-34 (UT-DBG-034) | decodeFrameHybi17: クローズフレーム検出 | E-02 L129-132 `case kOpCodeClose: closed = true;` | ○ |
| C-35 (UT-DBG-035) | decodeFrameHybi17: 不完全フレーム処理 | E-02 L103, L105, L158 | ○ |
| C-36 (UT-DBG-036) | decodeFrameHybi17: 圧縮フレームエラー | E-02 L117-119 | ○ |
| C-37 (UT-DBG-037) | decodeFrameHybi17: マスク付きフレームエラー | E-02 L124-126 | ○ |
| C-38 (UT-DBG-038) | decodeFrameHybi17: 非対応opCodeエラー | E-02 L135-136 | ○ |
| C-39 (UT-DBG-039) | Client.constructor: 初期化 | E-02 L168-177 | ○ |
| C-40 (UT-DBG-040) | Client.reset: 状態リセット | E-02 L226-238 | ○ |
| C-41 (UT-DBG-041) | Client._handleChunk: レスポンス処理 | E-02 L179-224, L211-216 | ○ |
| C-42 (UT-DBG-042) | Client._handleChunk: イベント通知 | E-02 L217-219 | ○ |
| C-43 (UT-DBG-043) | Client._handleChunk: JSONパースエラー | E-02 L203-208 | ○ |
| C-44 (UT-DBG-044) | Client._handleChunk: 非JSONペイロードエラー | E-02 L199-201 | ○ |
| C-45 (UT-DBG-045) | Client._handleChunk: クローズ時reset | E-02 L190-193 | ○ |
| C-46 (UT-DBG-046) | Client.callMethod: WebSocket送信 | E-02 L240-254 | ○ |
| C-47 (UT-DBG-047) | Client.callMethod: 成功レスポンス | E-02 L247-249 | ○ |
| C-48 (UT-DBG-048) | Client.callMethod: 未接続エラー | E-02 L242-245 | ○ |
| C-49 (UT-DBG-049) | Client.callMethod: エラーレスポンス | E-02 L247-248 | ○ |
| C-50 (UT-DBG-050) | Client._fetchJSON: HTTP JSON取得 | E-02 L257-290 | ○ |
| C-51 (UT-DBG-051) | Client._fetchJSON: HTTPエラー | E-02 L270-272 | ○ |
| C-52 (UT-DBG-052) | Client._fetchJSON: 非JSONエラー | E-02 L276-278 | ○ |
| C-53 (UT-DBG-053) | Client.connect: WebSocket接続 | E-02 L292-297 | ○ |
| C-54 (UT-DBG-054) | Client._discoverWebsocketPath: パス探索 | E-02 L299-303 | ○ |
| C-55 (UT-DBG-055) | Client._connectWebsocket: アップグレード成功 | E-02 L305-351 | ○ |
| C-56 (UT-DBG-056) | Client._connectWebsocket: アップグレード失敗 | E-02 L322-324 | ○ |

### inspect_repl.js 関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 (UT-DBG-057) | extractFunctionName: 関数名抽出 | E-03 L115-120 | ○ |
| C-58 (UT-DBG-058) | extractFunctionName: ジェネレーター関数名 | E-03 L115 正規表現 `function\*? ` | ○ |
| C-59 (UT-DBG-059) | extractFunctionName: 無名関数 | E-03 L119 `return fnNameMatch ? ... : ''` | ○ |
| C-60 (UT-DBG-060) | isNativeUrl: node:internal/判定 | E-03 L123-128 | ○ |
| C-61 (UT-DBG-061) | isNativeUrl: ビルトイン判定 | E-03 L127 | ○ |
| C-62 (UT-DBG-062) | isNativeUrl: ユーザースクリプト判定 | E-03 L126-127 | ○ |
| C-63 (UT-DBG-063) | getRelativePath: file://URL処理 | E-03 L130-141 | ○ |
| C-64 (UT-DBG-064) | getRelativePath: 相対パス変換 | E-03 L137-140 | ○ |
| C-65 (UT-DBG-065) | leftPad: 左パディング | E-03 L145-151 | ○ |
| C-66 (UT-DBG-066) | leftPad: 最小幅保証 | E-03 L147 `MathMax(2, ...)` | ○ |
| C-67 (UT-DBG-067) | markSourceColumn: カラムハイライト | E-03 L153-167 | ○ |
| C-68 (UT-DBG-068) | markSourceColumn: 空ソース処理 | E-03 L154 `if (!sourceText) return ''` | ○ |
| C-69 (UT-DBG-069) | extractErrorMessage: メッセージ抽出 | E-03 L169-173 | ○ |
| C-70 (UT-DBG-070) | extractErrorMessage: null処理 | E-03 L170 `if (!stack) return '<unknown>'` | ○ |
| C-71 (UT-DBG-071) | convertResultToError: エラー変換 | E-03 L175-181 | ○ |
| C-72-79 | PropertyPreview/ObjectPreview | E-03 L183-270 | ○ |
| C-80-83 | RemoteObject | E-03 L272-324 | ○ |
| C-84 (UT-DBG-084) | ScopeSnapshot | E-03 L326-346 | ○ |
| C-85-86 | copyOwnProperties/aliasProperties | E-03 L348-362 | ○ |
| C-87-88 | createRepl/resetOnStart | E-03 L364-392 | ○ |
| C-89-90 | getCurrentLocation | E-03 L404-409 | ○ |
| C-91-92 | formatScripts | E-03 L415-429 | ○ |
| C-93 | Profile.save | E-03 L456-461 | ○ |
| C-94-97 | SourceSnippet/getSourceSnippet | E-03 L464-512 | ○ |
| C-98-100 | CallFrame | E-03 L514-538 | ○ |
| C-101-102 | Backtrace | E-03 L540-571 | ○ |
| C-103-105 | prepareControlCode | E-03 L573-590 | ○ |
| C-106-108 | evalInCurrentContext | E-03 L592-615 | ○ |
| C-109-111 | formatWatchers | E-03 L656-677 | ○ |
| C-112-113 | list | E-03 L684-692 | ○ |
| C-114-115 | setContextLineNumber | E-03 L694-701 | ○ |
| C-116-117 | handleBreakpointResolved | E-03 L703-719 | ○ |
| C-118-119 | listBreakpoints | E-03 L721-739 | ○ |
| C-120-126 | setBreakpoint | E-03 L741-846 | ○ |
| C-127-128 | clearBreakpoint | E-03 L848-868 | ○ |
| C-129-130 | restoreBreakpoints | E-03 L870-883 | ○ |
| C-131 | setPauseOnExceptions | E-03 L885-891 | ○ |
| C-132 | initializeContext | E-03 L948-1181 | ○ |
| C-133 | initAfterStart | E-03 L1183-1193 | ○ |
| C-134-137 | watch/unwatch | E-03 L1085-1098 | ○ |
| C-138-139 | takeHeapSnapshot | E-03 L1025-1079 | ○ |
| C-140-141 | Debugger.paused handler | E-03 L893-922 | ○ |
| C-142-143 | Debugger.scriptParsed handler | E-03 L933-938 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全テストケースにソースコードの根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 全テストケースはソースコードから直接抽出されており、根拠が明確
- 以下の点に追加注意が必要：
  1. **WebSocket HyBi-17フレーム処理**: RFC 6455準拠の実装であり、プロトコル仕様との整合性確認が望ましい
  2. **非同期処理**: Promise/async-awaitパターンが多用されており、タイミング依存のテストケースは実行環境に注意
  3. **子プロセス管理**: spawnを使用した子プロセス制御は、OSレベルのテストが必要な場合がある

## 6) レビュアーチェックリスト（最小）
- [ ] WebSocket関連テスト（UT-DBG-028〜038）のRFC 6455準拠を確認
- [ ] 接続リトライ処理（UT-DBG-013, 014）のタイムアウト設定が適切か確認
- [ ] ブレークポイント管理（UT-DBG-120〜130）の境界条件が網羅されているか確認
- [ ] 子プロセス管理（UT-DBG-011, 012, 019）がプラットフォーム間で一貫性があるか確認
- [ ] REPL関連テスト（UT-DBG-103〜108）のユーザー入力パターンが十分か確認
