---
generated_at: 2026-01-30 18:30:00
metrics:
  claims_total: 116
  claims_with_evidence: 116
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lib-internal-dns 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：116 / 116、根拠なし：0
- 優先レビュー（高）
  1. **c-ares ネイティブバインディングの動作**：ネイティブコードとの連携部分は実際の動作確認が必要
  2. **DNSエラーコードの網羅性**：全エラーコードの挙動確認が必要
  3. **スナップショット機能**：isBuildingSnapshot()の条件下でのテストが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/dns/utils.js` - ResolverBase クラス、バリデーション関数、ユーティリティ関数
- E-02: `lib/internal/dns/promises.js` - Promise ベースの DNS API (lookup, lookupService, Resolver)
- E-03: `lib/internal/dns/callback_resolver.js` - コールバックベースの Resolver クラス
- E-04: `lib/internal/errors.js` (参照) - DNSException, ERR_INVALID_ARG_TYPE, ERR_INVALID_ARG_VALUE 等
- E-05: `lib/internal/validators.js` (参照) - validateString, validateInt32, validateArray 等
- E-06: `internalBinding('cares_wrap')` (参照) - ChannelWrap, QueryReqWrap, GetAddrInfoReqWrap 等

## 3) Claims と根拠の対応（レビューの主戦場）

### utils.js - ResolverBase クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ResolverBase constructor でデフォルトオプション（timeout=-1, tries=4, maxTimeout=0）が使用される | E-01 L47-63, L74-84 | ○ |
| C-02 | validateTimeout で timeout < -1 の場合エラー | E-01 L47-51 (validateInt32) | ○ |
| C-03 | validateTries で tries < 1 の場合エラー | E-01 L59-63 (validateInt32) | ○ |
| C-04 | validateMaxTimeout で maxTimeout < 0 の場合エラー | E-01 L53-57 (validateUint32) | ○ |
| C-05 | cancel() で _handle.cancel() が呼ばれる | E-01 L91-93 | ○ |
| C-06 | getServers() で IPv6 アドレスがブラケット形式で返却される | E-01 L95-103 | ○ |
| C-07 | getServers() でデフォルトポート53の場合ポートが省略される | E-01 L97-98 | ○ |
| C-08 | setServers() で validateArray による配列検証 | E-01 L105-106 | ○ |
| C-09 | setServers() で IPv4/IPv6 アドレスのパース処理 | E-01 L112-148 | ○ |
| C-10 | setServers() で無効なIPの場合 ERR_INVALID_IP_ADDRESS | E-01 L147 | ○ |
| C-11 | setServers() で c-ares エラー時に元のサーバーを復元 | E-01 L153-166 | ○ |
| C-12 | setLocalAddress() で validateString による検証 | E-01 L174-179 | ○ |

### utils.js - ユーティリティ関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | validateHints で無効なフラグがエラー | E-01 L273-278 | ○ |
| C-14 | setDefaultResultOrder で validDnsOrders による検証 | E-01 L280-283 | ○ |
| C-15 | getDefaultResultOrder で現在の dnsOrder を返却 | E-01 L285-287 | ○ |
| C-16 | bindDefaultResolver で resolverKeys のメソッドをバインド | E-01 L266-271 | ○ |
| C-17 | getDefaultResolver で遅延初期化 | E-01 L253-260 | ○ |
| C-18 | createResolverClass で Resolver クラスと resolveMap を生成 | E-01 L289-313 | ○ |
| C-19 | initializeDns で CLI オプション --dns-result-order を処理 | E-01 L215-232 | ○ |

### promises.js - lookup 関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | lookup で hostname が IP アドレスの場合そのまま返却 | E-02 L142-148 | ○ |
| C-21 | lookup で空の hostname の場合 ERR_INVALID_ARG_VALUE | E-02 L136-140 | ○ |
| C-22 | lookup で family オプションによる IPv4/IPv6 フィルタリング | E-02 L217-220 | ○ |
| C-23 | lookup で all オプションによる全アドレス取得 | E-02 L221-224 | ○ |
| C-24 | lookup で hints オプションの検証と反映 | E-02 L212-216 | ○ |
| C-25 | lookup で order オプションによる結果順序制御 | E-02 L229-232 | ○ |
| C-26 | lookup で verbatim オプション（後方互換性） | E-02 L225-228 | ○ |
| C-27 | createLookupPromise で getaddrinfo ネイティブ呼び出し | E-02 L166 | ○ |
| C-28 | onlookup で address と family を含むオブジェクトを返却 | E-02 L85-96 | ○ |
| C-29 | onlookupall で配列形式で全アドレスを返却 | E-02 L98-119 | ○ |

### promises.js - lookupService 関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | lookupService で引数不足時 ERR_MISSING_ARGS | E-02 L279-280 | ○ |
| C-31 | lookupService で無効な IP の場合 ERR_INVALID_ARG_VALUE | E-02 L282-283 | ○ |
| C-32 | lookupService で validatePort による検証 | E-02 L285 | ○ |
| C-33 | onlookupservice で hostname と service を含むオブジェクトを返却 | E-02 L239-249 | ○ |

### promises.js - Resolver クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | resolve で rrtype 未指定時デフォルト A レコード | E-02 L357-359 | ○ |
| C-35 | resolve で無効な rrtype の場合 ERR_INVALID_ARG_VALUE | E-02 L355-356 | ○ |
| C-36 | resolve4/resolve6 等のメソッドが createResolverClass で生成 | E-01 L294-307, E-02 L365 | ○ |
| C-37 | ttl オプションで TTL 付き結果を返却 | E-02 L297-299, L339 | ○ |
| C-38 | onresolve で ttl=true の場合 address と ttl を含むオブジェクト | E-02 L297-299 | ○ |
| C-39 | defaultResolverSetServers で新しい Resolver を作成しデフォルトに設定 | E-02 L368-374 | ○ |

### callback_resolver.js

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | resolve で rrtype が関数の場合コールバックとして扱う | E-03 L99-101 | ○ |
| C-41 | resolve で rrtype が文字列でも関数でもない場合 ERR_INVALID_ARG_TYPE | E-03 L103 | ○ |
| C-42 | resolve で無効な rrtype の場合 ERR_INVALID_ARG_VALUE | E-03 L109 | ○ |
| C-43 | resolver 関数で query 関数を生成 | E-03 L54-87 | ○ |
| C-44 | query で validateString による name 検証 | E-03 L62 | ○ |
| C-45 | query で validateFunction による callback 検証 | E-03 L63 | ○ |
| C-46 | onresolve でエラー時 DNSException をコールバックに渡す | E-03 L44-45 | ○ |
| C-47 | onresolve で ttl=true の場合 address と ttl を含むオブジェクト | E-03 L40-42 | ○ |

### エラーコード定数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | errorCodes に NODATA〜CANCELLED の全エラーコードが定義 | E-01 L316-341 | ○ |
| C-49 | promises.js で errorCodes をエクスポート | E-02 L384-408 | ○ |

### スナップショット関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | isBuildingSnapshot() 時に kSnapshotStates に設定を保存 | E-01 L80-82 | ○ |
| C-51 | kSerializeResolver で _handle を null 化 | E-01 L190-195 | ○ |
| C-52 | kDeserializeResolver でハンドルと設定を復元 | E-01 L197-207 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの主張はありません
- 以下の点は実装の動作確認で補完が必要：
  - c-ares ネイティブバインディング（ChannelWrap, QueryReqWrap 等）の詳細な動作仕様
  - パフォーマンスフック（hasObserver, startPerf, stopPerf）との連携動作
  - 実際のネットワーク環境での DNS 解決動作

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: バリデーション関数のテストケース - ソースコードから直接導出
- **0（低リスク）**: ResolverBase クラスのメソッドテスト - 実装が明確
- **1（中リスク）**: ネイティブバインディング連携 - c-ares の動作に依存
- **1（中リスク）**: スナップショット機能 - 特殊な実行環境が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ResolverBase のコンストラクタオプションのデフォルト値が正しいか確認
- [ ] setServers の IPv4/IPv6 パース処理が全パターン網羅されているか確認
- [ ] lookup 関数のオプション処理が仕様と一致しているか確認
- [ ] エラーコード定数が Node.js 公式ドキュメントと一致しているか確認
- [ ] c-ares バインディングとの連携テストが実行環境で動作するか確認
- [ ] パフォーマンスフック連携のテストケースが適切か確認
