---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 35
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lib-internal-encoding.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：35 / 35、根拠なし：0
- 優先レビュー（高）
  1. なし - すべてのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/encoding/single-byte.js` (行1-156) - シングルバイトエンコーディング実装
- E-02: `lib/internal/encoding/single-byte.js` 行86-100 - `getEncoding`関数
- E-03: `lib/internal/encoding/single-byte.js` 行102-103 - `isSinglebyteEncoding`関数
- E-04: `lib/internal/encoding/single-byte.js` 行108-149 - `createSinglebyteDecoder`関数
- E-05: `lib/internal/encoding/single-byte.js` 行49-78 - `encodings`オブジェクト（24種類のエンコーディングマッピング）
- E-06: `lib/internal/encoding/single-byte.js` 行27-29 - エラー定義（ERR_ENCODING_NOT_SUPPORTED, ERR_ENCODING_INVALID_ENCODED_DATA）
- E-07: `lib/internal/encoding/single-byte.js` 行37 - 置換文字定数 `r = 0xfffd`
- E-08: `lib/internal/encoding/single-byte.js` 行105-106 - デコーダーキャッシュ（decodersLoose, decodersFatal）
- E-09: `lib/internal/encoding/single-byte.js` 行31 - エンディアン判定（isBigEndian）
- E-10: `lib/internal/encoding/single-byte.js` 行119-120 - 空バッファ・ASCII最適化パス

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | x-user-definedエンコーディングでマッピングテーブルが取得できること | E-02 (行87-90) | ○ |
| C-02 | ibm866エンコーディングでマッピングテーブルが取得できること | E-02, E-05 (行51) | ○ |
| C-03 | iso-8859-2エンコーディングでマッピングテーブルが取得できること | E-02, E-05 (行57) | ○ |
| C-04 | windows-1252エンコーディングでマッピングテーブルが取得できること | E-02, E-05 (行69) | ○ |
| C-05 | koi8-rエンコーディングでマッピングテーブルが取得できること | E-02, E-05 (行64) | ○ |
| C-06 | サポートされていないエンコーディングでERR_ENCODING_NOT_SUPPORTEDがスローされること | E-02 (行92-94), E-06 | ○ |
| C-07 | 空文字列でERR_ENCODING_NOT_SUPPORTEDがスローされること | E-02 (行92-94), E-06 | ○ |
| C-08 | __proto__プロパティでエラーがスローされること | E-05 (行50: '__proto__': null), E-02 (行92) | ○ |
| C-09 | ibm866でisSinglebyteEncodingがtrueを返すこと | E-03, E-05 | ○ |
| C-10 | iso-8859-8-iでtrueが返却されること | E-03 (行102: .add('iso-8859-8-i')) | ○ |
| C-11 | x-user-definedでtrueが返却されること | E-03 (行102: .add('x-user-defined')) | ○ |
| C-12 | windows-1252でtrueが返却されること | E-03, E-05 | ○ |
| C-13 | utf-8でfalseが返却されること | E-03 (supportedセットに含まれない) | ○ |
| C-14 | 空文字列でfalseが返却されること | E-03 (supportedセットに含まれない) | ○ |
| C-15 | 空バッファで空文字列が返却されること | E-04 (行119) | ○ |
| C-16 | ASCII文字列がlatin1Sliceで高速デコードされること | E-04 (行120), E-10 | ○ |
| C-17 | 非ASCII文字を含むバッファが正しくデコードされること | E-04 (行121-144) | ○ |
| C-18 | iso-8859-8-iがiso-8859-8にマッピングされること | E-04 (行109) | ○ |
| C-19 | デコーダーがキャッシュされること | E-04 (行111-112, 147), E-08 | ○ |
| C-20 | fatal=trueとfalseで異なるキャッシュが使用されること | E-04 (行110), E-08 | ○ |
| C-21 | fatal=trueでマッピングされていないバイトでエラーがスローされること | E-04 (行141-143), E-06, E-07 | ○ |
| C-22 | fatal=falseでマッピングされていないバイトがU+FFFDに置換されること | E-04 (行141), E-07 | ○ |
| C-23 | 1バイトのバッファが正しくデコードされること | E-04 (行136) | ○ |
| C-24 | 7バイトのバッファが正しくデコードされること（ループ境界前） | E-04 (行125, 136) | ○ |
| C-25 | 8バイトのバッファが正しくデコードされること（ループ1回） | E-04 (行125-134) | ○ |
| C-26 | 15バイトのバッファが正しくデコードされること（ループ+余り） | E-04 (行125-136) | ○ |
| C-27 | 全サポートエンコーディングでデコーダーが作成できること | E-04, E-05 (24種類) | ○ |
| C-28 | バイト0x00-0x7Fがそのままデコードされること | E-04 (行96: マップ初期化), E-02 | ○ |
| C-29 | バイト0x80-0xFFがエンコーディングに従ってデコードされること | E-04 (行98), E-05 | ○ |
| C-30 | ビッグエンディアン環境でバイトスワップが適用されること | E-04 (行139), E-09 | ○ |
| C-31 | macintoshエンコーディングでマッピングテーブルが取得できること | E-02, E-05 (行66) | ○ |
| C-32 | iso-8859-5エンコーディングでマッピングテーブルが取得できること | E-02, E-05 (行60) | ○ |
| C-33 | iso-8859-7エンコーディングでマッピングテーブルが取得できること | E-02, E-05 (行62) | ○ |
| C-34 | x-mac-cyrillicエンコーディングでデコードできること | E-04, E-05 (行77) | ○ |
| C-35 | nullでfalseが返却されること | E-03 (Set.has()の動作) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべてのテストケースにソースコード根拠があります

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードに基づいており、信頼性は高い
- 注意点:
  - ビッグエンディアン環境でのテスト（C-30）は実機での確認が必要
  - 全24種類のエンコーディング（C-27）のテストは網羅的に実施すべき

## 6) レビュアーチェックリスト（最小）
- [ ] getEncoding関数の各エンコーディングマッピングが仕様通りか確認
- [ ] isSinglebyteEncoding関数のサポート対象エンコーディング一覧が正しいか確認
- [ ] createSinglebyteDecoder関数のfatalモード動作が仕様通りか確認
- [ ] エンディアン処理（swap16）が正しく動作するか確認
- [ ] デコーダーキャッシュの動作が正しいか確認
- [ ] 8バイトループ最適化の境界条件が正しく処理されるか確認
