---
generated_at: 2026-01-30 18:20:00
metrics:
  claims_total: 136
  claims_with_evidence: 134
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：lib-internal-errors.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：134 / 136、根拠なし：2
- 優先レビュー（高）
  1. **UT-ERR-113**: fatalExceptionStackEnhancers.beforeInspectorのエラーハンドリング挙動（try-catch動作の詳細確認）
  2. **UT-ERR-115**: fatalExceptionStackEnhancers.afterInspectorのinspectエラー時の挙動

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/errors.js` (1939行) - Node.js内部エラー処理モジュール
- E-02: `lib/internal/errors.js:281-397` - SystemErrorクラス定義
- E-03: `lib/internal/errors.js:202-215` - NodeAggregateErrorクラス定義
- E-04: `lib/internal/errors.js:641-681` - UVExceptionクラス定義
- E-05: `lib/internal/errors.js:688-720` - UVExceptionWithHostPortクラス定義
- E-06: `lib/internal/errors.js:725-751` - ErrnoExceptionクラス定義
- E-07: `lib/internal/errors.js:764-802` - ExceptionWithHostPortクラス定義
- E-08: `lib/internal/errors.js:804-844` - DNSExceptionクラス定義
- E-09: `lib/internal/errors.js:846-855` - ConnResetExceptionクラス定義
- E-10: `lib/internal/errors.js:979-988` - AbortErrorクラス定義
- E-11: `lib/internal/errors.js:95-111` - defaultPrepareStackTrace関数
- E-12: `lib/internal/errors.js:135-161` - prepareStackTraceCallback関数
- E-13: `lib/internal/errors.js:171-200` - aggregateTwoErrors関数
- E-14: `lib/internal/errors.js:540-551` - hideStackFrames関数
- E-15: `lib/internal/errors.js:555-586` - E関数（エラーコード登録）
- E-16: `lib/internal/errors.js:595-618` - getMessage関数
- E-17: `lib/internal/errors.js:588-593` - getExpectedArgumentLength関数
- E-18: `lib/internal/errors.js:867-880` - isStackOverflowError関数
- E-19: `lib/internal/errors.js:1008-1056` - determineSpecificType関数
- E-20: `lib/internal/errors.js:1066-1075` - formatList関数
- E-21: `lib/internal/errors.js:263-271` - inspectWithNoCustomRetry関数
- E-22: `lib/internal/errors.js:246-261` - isErrorStackTraceLimitWritable関数
- E-23: `lib/internal/errors.js:629-633` - uvErrmapGet関数
- E-24: `lib/internal/errors.js:996-1001` - genericNodeError関数
- E-25: `lib/internal/errors.js:961-974` - hideInternalStackFrames関数
- E-26: `lib/internal/errors.js:956-958` - setArrowMessage関数
- E-27: `lib/internal/errors.js:117-119` - isPermissionModelError関数
- E-28: `lib/internal/errors.js:898-948` - fatalExceptionStackEnhancers
- E-29: `lib/internal/errors.js:883-891` - addNumericalSeparator関数
- E-30: `lib/internal/errors.js:434-532` - makeNodeErrorWithCode関数
- E-31: `lib/internal/errors.js:399-405` - makeSystemErrorWithCode関数
- E-32: `lib/internal/errors.js:411-432` - makeNodeErrorForHideStackFrame関数
- E-33: `lib/internal/errors.js:113-115` - setInternalPrepareStackTrace関数
- E-34: `lib/internal/errors.js:167-169` - ErrorPrepareStackTrace関数
- E-35: `lib/internal/errors.js:1395-1465` - ERR_INVALID_ARG_TYPEエラー定義
- E-36: `lib/internal/errors.js:1466-1473` - ERR_INVALID_ARG_VALUEエラー定義
- E-37: `lib/internal/errors.js:1640-1659` - ERR_OUT_OF_RANGEエラー定義
- E-38: `lib/internal/errors.js:1594-1608` - ERR_MISSING_ARGSエラー定義
- E-39: `lib/internal/errors.js:1558-1568` - ERR_INVALID_URLエラー定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SystemError constructorの正常系動作 | E-02 | ○ |
| C-02 | SystemError pathプロパティの生成 | E-02 | ○ |
| C-03 | SystemError destプロパティの生成 | E-02 | ○ |
| C-04 | SystemError toString()メソッド | E-02 | ○ |
| C-05 | SystemError errno getter/setter | E-02 | ○ |
| C-06 | SystemError errno setter | E-02 | ○ |
| C-07 | SystemError syscall getter | E-02 | ○ |
| C-08 | SystemError path getter (Buffer変換) | E-02 | ○ |
| C-09 | SystemError path setter | E-02 | ○ |
| C-10 | SystemError dest getter | E-02 | ○ |
| C-11 | SystemError kIsNodeError | E-02 | ○ |
| C-12 | NodeAggregateError 複数エラー集約 | E-03 | ○ |
| C-13 | NodeAggregateError 空配列処理 | E-03 | ○ |
| C-14 | NodeAggregateError kIsNodeError | E-03 | ○ |
| C-15 | NodeAggregateError constructor getter | E-03 | ○ |
| C-16 | UVException 基本動作 | E-04 | ○ |
| C-17 | UVException pathプロパティ | E-04 | ○ |
| C-18 | UVException destプロパティ | E-04 | ○ |
| C-19 | UVException 未知errno処理 | E-04 | ○ |
| C-20 | UVException constructor getter | E-04 | ○ |
| C-21 | UVExceptionWithHostPort 基本動作 | E-05 | ○ |
| C-22 | UVExceptionWithHostPort ポートなし | E-05 | ○ |
| C-23 | UVExceptionWithHostPort port=0 | E-05 | ○ |
| C-24 | UVExceptionWithHostPort プロパティ | E-05 | ○ |
| C-25 | ErrnoException 基本動作 | E-06 | ○ |
| C-26 | ErrnoException original付き | E-06 | ○ |
| C-27 | ErrnoException 不正err | E-06 | ○ |
| C-28 | ExceptionWithHostPort 基本動作 | E-07 | ○ |
| C-29 | ExceptionWithHostPort additional付き | E-07 | ○ |
| C-30 | ExceptionWithHostPort PermissionModelError | E-07 | ○ |
| C-31 | DNSException 数値コード | E-08 | ○ |
| C-32 | DNSException 文字列コード | E-08 | ○ |
| C-33 | DNSException hostnameなし | E-08 | ○ |
| C-34 | DNSException PermissionModelError | E-08 | ○ |
| C-35 | ConnResetException 基本動作 | E-09 | ○ |
| C-36 | ConnResetException constructor getter | E-09 | ○ |
| C-37 | AbortError デフォルトメッセージ | E-10 | ○ |
| C-38 | AbortError カスタムメッセージ | E-10 | ○ |
| C-39 | AbortError options cause | E-10 | ○ |
| C-40 | AbortError 不正options | E-10 | ○ |
| C-41 | defaultPrepareStackTrace kIsNodeError | E-11 | ○ |
| C-42 | defaultPrepareStackTrace 通常Error | E-11 | ○ |
| C-43 | defaultPrepareStackTrace スタックトレース | E-11 | ○ |
| C-44 | defaultPrepareStackTrace 空trace | E-11 | ○ |
| C-45 | prepareStackTraceCallback override | E-12 | ○ |
| C-46 | prepareStackTraceCallback globalThis | E-12 | ○ |
| C-47 | prepareStackTraceCallback MainContext | E-12 | ○ |
| C-48 | prepareStackTraceCallback デフォルト | E-12 | ○ |
| C-49 | aggregateTwoErrors 2エラー集約 | E-13 | ○ |
| C-50 | aggregateTwoErrors 既存AggregateError | E-13 | ○ |
| C-51 | aggregateTwoErrors null inner | E-13 | ○ |
| C-52 | aggregateTwoErrors null outer | E-13 | ○ |
| C-53 | aggregateTwoErrors 両方null | E-13 | ○ |
| C-54 | aggregateTwoErrors 同一エラー | E-13 | ○ |
| C-55 | hideStackFrames 正常実行 | E-14 | ○ |
| C-56 | hideStackFrames エラー時スタック調整 | E-14 | ○ |
| C-57 | hideStackFrames withoutStackTrace | E-14 | ○ |
| C-58 | hideStackFrames thisコンテキスト | E-14 | ○ |
| C-59 | E関数 エラーコード登録 | E-15 | ○ |
| C-60 | E関数 SystemError登録 | E-15 | ○ |
| C-61 | E関数 フォーマット付き | E-15 | ○ |
| C-62 | E関数 関数メッセージ | E-15 | ○ |
| C-63 | E関数 otherClasses | E-15 | ○ |
| C-64 | E関数 HideStackFramesError | E-15 | ○ |
| C-65 | getMessage 文字列メッセージ | E-16 | ○ |
| C-66 | getMessage フォーマット付き | E-16 | ○ |
| C-67 | getMessage 関数メッセージ | E-16 | ○ |
| C-68 | getMessage 引数不一致 | E-16 | ○ |
| C-69 | getExpectedArgumentLength カウント | E-17 | ○ |
| C-70 | getExpectedArgumentLength 指定子なし | E-17 | ○ |
| C-71 | getExpectedArgumentLength 全指定子 | E-17 | ○ |
| C-72 | isStackOverflowError 検出 | E-18 | ○ |
| C-73 | isStackOverflowError 通常エラー | E-18 | ○ |
| C-74 | isStackOverflowError null | E-18 | ○ |
| C-75 | isStackOverflowError undefined | E-18 | ○ |
| C-76 | determineSpecificType null | E-19 | ○ |
| C-77 | determineSpecificType undefined | E-19 | ○ |
| C-78 | determineSpecificType bigint | E-19 | ○ |
| C-79 | determineSpecificType 0 | E-19 | ○ |
| C-80 | determineSpecificType -0 | E-19 | ○ |
| C-81 | determineSpecificType NaN | E-19 | ○ |
| C-82 | determineSpecificType Infinity | E-19 | ○ |
| C-83 | determineSpecificType -Infinity | E-19 | ○ |
| C-84 | determineSpecificType boolean | E-19 | ○ |
| C-85 | determineSpecificType symbol | E-19 | ○ |
| C-86 | determineSpecificType function | E-19 | ○ |
| C-87 | determineSpecificType object | E-19 | ○ |
| C-88 | determineSpecificType 短い文字列 | E-19 | ○ |
| C-89 | determineSpecificType 長い文字列 | E-19 | ○ |
| C-90 | determineSpecificType クォート処理 | E-19 | ○ |
| C-91 | formatList 空配列 | E-20 | ○ |
| C-92 | formatList 1要素 | E-20 | ○ |
| C-93 | formatList 2要素 | E-20 | ○ |
| C-94 | formatList 3要素 | E-20 | ○ |
| C-95 | formatList 4要素以上 | E-20 | ○ |
| C-96 | formatList type='or' | E-20 | ○ |
| C-97 | inspectWithNoCustomRetry 通常 | E-21 | ○ |
| C-98 | inspectWithNoCustomRetry リトライ | E-21 | ○ |
| C-99 | isErrorStackTraceLimitWritable 書き込み可能 | E-22 | ○ |
| C-100 | isErrorStackTraceLimitWritable スナップショット | E-22 | ○ |
| C-101 | uvErrmapGet 既知errno | E-23 | ○ |
| C-102 | uvErrmapGet 未知errno | E-23 | ○ |
| C-103 | genericNodeError 基本動作 | E-24 | ○ |
| C-104 | genericNodeError カスタムプロパティ | E-24 | ○ |
| C-105 | hideInternalStackFrames フィルタ | E-25 | ○ |
| C-106 | hideInternalStackFrames ユーザーフレーム | E-25 | ○ |
| C-107 | setArrowMessage 設定 | E-26 | ○ |
| C-108 | isPermissionModelError 検出 | E-27 | ○ |
| C-109 | isPermissionModelError 他コード | E-27 | ○ |
| C-110 | isPermissionModelError 数値 | E-27 | ○ |
| C-111 | fatalExceptionStackEnhancers.beforeInspector 拡張 | E-28 | ○ |
| C-112 | fatalExceptionStackEnhancers.beforeInspector 拡張なし | E-28 | ○ |
| C-113 | fatalExceptionStackEnhancers.beforeInspector エラー時 | E-28 | △ |
| C-114 | fatalExceptionStackEnhancers.afterInspector inspect | E-28 | ○ |
| C-115 | fatalExceptionStackEnhancers.afterInspector エラー時 | E-28 | △ |
| C-116 | addNumericalSeparator 大きな数値 | E-29 | ○ |
| C-117 | addNumericalSeparator 負の数値 | E-29 | ○ |
| C-118 | addNumericalSeparator 4桁未満 | E-29 | ○ |
| C-119 | makeNodeErrorWithCode 0引数 | E-30 | ○ |
| C-120 | makeNodeErrorWithCode 動的引数 | E-30 | ○ |
| C-121 | makeNodeErrorWithCode 固定引数 | E-30 | ○ |
| C-122 | makeNodeErrorWithCode 引数不一致 | E-30 | ○ |
| C-123 | makeSystemErrorWithCode サブクラス | E-31 | ○ |
| C-124 | makeNodeErrorForHideStackFrame クラス | E-32 | ○ |
| C-125 | setInternalPrepareStackTrace 設定 | E-33 | ○ |
| C-126 | ErrorPrepareStackTrace 呼び出し | E-34 | ○ |
| C-127 | ERR_INVALID_ARG_TYPE 基本 | E-35 | ○ |
| C-128 | ERR_INVALID_ARG_TYPE 複数型 | E-35 | ○ |
| C-129 | ERR_INVALID_ARG_TYPE instanceof | E-35 | ○ |
| C-130 | ERR_INVALID_ARG_VALUE 基本 | E-36 | ○ |
| C-131 | ERR_OUT_OF_RANGE 基本 | E-37 | ○ |
| C-132 | ERR_OUT_OF_RANGE セパレータ | E-37 | ○ |
| C-133 | ERR_MISSING_ARGS 単一 | E-38 | ○ |
| C-134 | ERR_MISSING_ARGS 複数 | E-38 | ○ |
| C-135 | ERR_INVALID_URL 基本 | E-39 | ○ |
| C-136 | ERR_INVALID_URL base付き | E-39 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-113 (fatalExceptionStackEnhancers.beforeInspector エラー時)**：try-catchブロック内での挙動は確認できるが、実際のエラー発生時の詳細な動作は実行時テストでの確認が必要
  - 候補：実行時テスト / V8インスペクター連携テスト
- **C-115 (fatalExceptionStackEnhancers.afterInspector エラー時)**：inspectがエラーをスローする具体的なケースの特定が困難
  - 候補：循環参照オブジェクト / ゲッターでエラーをスローするオブジェクト

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分のテストケースはソースコードから直接確認可能
- **1（中リスク）**: fatalExceptionStackEnhancersのエラーハンドリング部分は実行時の挙動確認が推奨される
- **0（低リスク）**: エラーコード定義（E関数呼び出し）は静的に確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] SystemErrorクラスのpath/destプロパティのBuffer変換ロジックが正しいか確認
- [ ] UVException/DNSExceptionでのerrno→コード変換が正確か確認
- [ ] aggregateTwoErrorsのisErrorStackTraceLimitWritable()判定時の動作確認
- [ ] fatalExceptionStackEnhancersの実行時動作（Windows/非Windows環境差異）
- [ ] determineSpecificType関数の全型分岐が正しくカバーされているか確認
- [ ] ERR_INVALID_ARG_TYPEのメッセージ生成ロジック（types/instances/other分類）が正確か確認
- [ ] hideStackFramesのError.stackTraceLimitの操作が副作用を起こさないか確認
