---
generated_at: 2026-01-30 18:20:00
metrics:
  claims_total: 35
  claims_with_evidence: 35
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lib-internal-events 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：35 / 35、根拠なし：0
- 優先レビュー（高）
  - 全てのテストケースに根拠があり、優先度高のレビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/events/abort_listener.js` - addAbortListener関数の実装
- E-02: `lib/internal/events/symbols.js` - kFirstEventParamシンボル定義
- E-03: `test/parallel/test-events-add-abort-listener.mjs` - 既存テストケース
- E-04: `lib/internal/validators.js` - validateAbortSignal、validateFunction関数
- E-05: `lib/internal/errors.js` - ERR_INVALID_ARG_TYPEエラー定義
- E-06: `lib/events.js` - kFirstEventParamの使用箇所

## 3) Claims と根拠の対応（レビューの主戦場）

### addAbortListener関数 - 正常系テスト

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 有効なAbortSignalとリスナーで正常に登録できること | E-01 (L24-48), E-03 (L24-29) | ○ |
| C-02 | 返却されたDisposableがSymbol.disposeメソッドを持つこと | E-01 (L43-48), E-03 (L24-29) | ○ |
| C-03 | abortイベント発火時にリスナーが実行されること | E-01 (L38), E-03 (L36-47) | ○ |
| C-04 | 既にabortedなシグナルの場合リスナーがマイクロタスクで即時実行されること | E-01 (L32-34), E-03 (L31-34) | ○ |
| C-05 | stopImmediatePropagation()が呼ばれてもリスナーが実行されること | E-01 (L36-38 kResistStopPropagation), E-03 (L36-47) | ○ |
| C-06 | onceオプションによりリスナーが1回のみ実行されること | E-01 (L38 once: true) | ○ |
| C-07 | dispose()呼び出し後はリスナーが実行されないこと | E-01 (L39-41, L45-47), E-03 (L49-54) | ○ |
| C-08 | 既にabortedなシグナルでdispose()が安全に呼び出せること | E-01 (L46 オプショナルチェーン) | ○ |

### addAbortListener関数 - 異常系テスト

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | signalがundefinedの場合ERR_INVALID_ARG_TYPEがスローされること | E-01 (L25-27), E-03 (L7-9, L11-15) | ○ |
| C-10 | signalがnullの場合ERR_INVALID_ARG_TYPEがスローされること | E-01 (L28), E-04 (L444-450), E-03 (L11-15) | ○ |
| C-11 | signalが空オブジェクトの場合ERR_INVALID_ARG_TYPEがスローされること | E-01 (L28), E-04 (L444-450), E-03 (L11-15) | ○ |
| C-12 | signalがabortedプロパティを持たないオブジェクトの場合エラーがスローされること | E-04 (L447 'aborted' in signal) | ○ |
| C-13 | signalが文字列の場合ERR_INVALID_ARG_TYPEがスローされること | E-04 (L446 typeof signal !== 'object') | ○ |
| C-14 | signalが数値の場合ERR_INVALID_ARG_TYPEがスローされること | E-04 (L446 typeof signal !== 'object') | ○ |
| C-15 | listenerがundefinedの場合ERR_INVALID_ARG_TYPEがスローされること | E-01 (L29), E-03 (L17-22) | ○ |
| C-16 | listenerがnullの場合ERR_INVALID_ARG_TYPEがスローされること | E-01 (L29 validateFunction) | ○ |
| C-17 | listenerが空オブジェクトの場合ERR_INVALID_ARG_TYPEがスローされること | E-01 (L29), E-03 (L17-22) | ○ |
| C-18 | listenerが文字列の場合ERR_INVALID_ARG_TYPEがスローされること | E-01 (L29 validateFunction) | ○ |
| C-19 | listenerが数値の場合ERR_INVALID_ARG_TYPEがスローされること | E-01 (L29 validateFunction) | ○ |
| C-20 | 両引数が省略された場合ERR_INVALID_ARG_TYPEがスローされること | E-01 (L25-27), E-03 (L7-9) | ○ |

### addAbortListener関数 - 境界値テスト

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | リスナー関数が引数なしで呼び出された場合も動作すること | E-01 (L34 listener()) | ○ |
| C-22 | 複数のリスナーを同一シグナルに登録できること | E-01 (L38 addEventListener使用) | ○ |
| C-23 | dispose()を複数回呼び出しても安全なこと | E-01 (L46 removeEventListener?.()) | ○ |
| C-24 | リスナー内で例外がスローされた場合の動作 | E-01 (例外処理なし = 伝播) | ○ |
| C-25 | アロー関数リスナーが正常に動作すること | E-01 (L29 validateFunction) | ○ |
| C-26 | 通常関数リスナーが正常に動作すること | E-01 (L29 validateFunction) | ○ |
| C-27 | asyncリスナーが正常に登録・実行されること | E-01 (L29 validateFunction) | ○ |
| C-28 | boundメソッドリスナーが正常に動作すること | E-01 (L29 validateFunction) | ○ |

### symbols モジュール

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | kFirstEventParamがSymbol型であること | E-02 (L7 Symbol('kFirstEventParam')) | ○ |
| C-30 | kFirstEventParamがユニークなSymbolであること | E-02 (モジュールキャッシュによる一意性) | ○ |
| C-31 | kFirstEventParamの説明が'kFirstEventParam'であること | E-02 (L7 Symbol('kFirstEventParam')) | ○ |
| C-32 | モジュールがkFirstEventParamをエクスポートすること | E-02 (L9-11) | ○ |

### モジュールエクスポート

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | abort_listenerモジュールがaddAbortListenerをエクスポートすること | E-01 (L51-54) | ○ |
| C-34 | エクスポートオブジェクトのプロトタイプがnullであること | E-01 (L52 __proto__: null) | ○ |
| C-35 | 返却オブジェクトのプロトタイプがnullであること | E-01 (L44 __proto__: null) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースに対してソースコードまたは既存テストによる根拠が確認できました
- 不足情報はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードおよび既存テストファイルに基づいている
- 既存テスト（E-03）は6つのテストケースをカバーしており、本一覧はより網羅的なテストケースを提供

## 6) レビュアーチェックリスト（最小）
- [ ] addAbortListenerの入力検証（signal、listener）が網羅されているか確認
- [ ] Disposableインターフェースの動作確認テストが十分か確認
- [ ] kResistStopPropagationの動作確認テストが適切か確認
- [ ] マイクロタスクでの即時実行テストの非同期タイミングが適切か確認
- [ ] kFirstEventParamシンボルの使用箇所（events.js）との整合性確認
- [ ] プロトタイプ汚染対策（__proto__: null）のテストが必要か検討
