---
generated_at: 2026-01-30 18:30:00
metrics:
  claims_total: 203
  claims_with_evidence: 203
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lib-internal-fs単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：203 / 203、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースにソースコード根拠あり
  2. **実行確認**：実際のNode.jsテスト環境での動作確認推奨
  3. **カバレッジ確認**：プライベートメソッドや内部状態のテストカバレッジ確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/fs/utils.js` - ユーティリティ関数・クラス定義
- E-02: `lib/internal/fs/watchers.js` - StatWatcher・FSWatcher実装
- E-03: `lib/internal/fs/promises.js` - FileHandle・Promise版API実装
- E-04: `lib/internal/fs/streams.js` - ReadStream・WriteStream実装
- E-05: `lib/internal/fs/dir.js` - Dirクラス実装
- E-06: `lib/internal/fs/rimraf.js` - rimraf実装
- E-07: `lib/internal/fs/recursive_watch.js` - 再帰監視FSWatcher実装
- E-08: `lib/internal/fs/sync_write_stream.js` - SyncWriteStream実装
- E-09: `lib/internal/fs/glob.js` - Glob・matchGlobPattern実装
- E-10: `lib/internal/fs/cp/cp.js` - 非同期コピー実装
- E-11: `lib/internal/fs/cp/cp-sync.js` - 同期コピー実装
- E-12: `lib/internal/fs/read/context.js` - ReadFileContext実装

## 3) Claims と根拠の対応（レビューの主戦場）

### internal/fs/utils.js

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | assertEncoding正常系 | E-01 L152-157 | ○ |
| C-02 | assertEncoding異常系（無効エンコーディング） | E-01 L153-156 | ○ |
| C-03 | assertEncoding境界値（null/undefined） | E-01 L153 | ○ |
| C-04 | Direntコンストラクタ | E-01 L159-164 | ○ |
| C-05 | Dirent.isDirectory | E-01 L166-168 | ○ |
| C-06 | Dirent.isDirectory（false） | E-01 L166-168 | ○ |
| C-07 | Dirent.isFile | E-01 L170-172 | ○ |
| C-08 | Dirent.isSymbolicLink | E-01 L182-184 | ○ |
| C-09 | Dirent.isBlockDevice | E-01 L174-176 | ○ |
| C-10 | Dirent.isCharacterDevice | E-01 L178-180 | ○ |
| C-11 | Dirent.isFIFO | E-01 L186-188 | ○ |
| C-12 | Dirent.isSocket | E-01 L190-192 | ○ |
| C-13 | copyObject正常系 | E-01 L211-216 | ○ |
| C-14 | copyObject境界値（空オブジェクト） | E-01 L211-216 | ○ |
| C-15 | join正常系（文字列） | E-01 L220-241 | ○ |
| C-16 | join（name=undefined） | E-01 L221-224 | ○ |
| C-17 | join（Buffer） | E-01 L235-237 | ○ |
| C-18 | join異常系 | E-01 L239-241 | ○ |
| C-19 | getOptions正常系 | E-01 L317-338 | ○ |
| C-20 | getOptions（文字列） | E-01 L322-326 | ○ |
| C-21 | getOptions（null） | E-01 L318-320 | ○ |
| C-22 | getOptions異常系 | E-01 L326-328 | ○ |
| C-23 | handleErrorFromBinding（errno） | E-01 L343-348 | ○ |
| C-24 | handleErrorFromBinding（error） | E-01 L349-355 | ○ |
| C-25 | stringToFlags（'r'） | E-01 L602 | ○ |
| C-26 | stringToFlags（'w'） | E-01 L609 | ○ |
| C-27 | stringToFlags（'a'） | E-01 L617 | ○ |
| C-28 | stringToFlags（'r+'） | E-01 L605 | ○ |
| C-29 | stringToFlags（'w+'） | E-01 L613 | ○ |
| C-30 | stringToFlags（数値） | E-01 L592-595 | ○ |
| C-31 | stringToFlags（null） | E-01 L597-599 | ○ |
| C-32 | stringToFlags異常系 | E-01 L630 | ○ |
| C-33 | toUnixTimestamp（数値） | E-01 L652-657 | ○ |
| C-34 | toUnixTimestamp（Date） | E-01 L658-661 | ○ |
| C-35 | toUnixTimestamp（文字列数値） | E-01 L649-651 | ○ |
| C-36 | toUnixTimestamp（負数） | E-01 L653-655 | ○ |
| C-37 | toUnixTimestamp異常系 | E-01 L662 | ○ |
| C-38 | validateOffsetLengthRead正常系 | E-01 L665-678 | ○ |
| C-39 | validateOffsetLengthRead（負offset） | E-01 L667-669 | ○ |
| C-40 | validateOffsetLengthRead（負length） | E-01 L670-672 | ○ |
| C-41 | validateOffsetLengthRead（範囲超過） | E-01 L673-676 | ○ |
| C-42 | validatePath正常系（文字列） | E-01 L698-718 | ○ |
| C-43 | validatePath正常系（Buffer） | E-01 L698-718 | ○ |
| C-44 | validatePath（nullバイト） | E-01 L708-717 | ○ |
| C-45 | validatePath異常系 | E-01 L699-701 | ○ |
| C-46 | getValidatedPath | E-01 L720-724 | ○ |
| C-47 | getValidatedFd正常系 | E-01 L726-734 | ○ |
| C-48 | getValidatedFd（-0） | E-01 L727-729 | ○ |
| C-49 | getValidatedFd異常系 | E-01 L731 | ○ |
| C-50 | validateBufferArray正常系 | E-01 L736-746 | ○ |
| C-51 | validateBufferArray（非配列） | E-01 L737-738 | ○ |
| C-52 | validateBufferArray（非ArrayBufferView要素） | E-01 L740-742 | ○ |
| C-53 | Stats.isDirectory | E-01 L393-395 | ○ |
| C-54 | Stats.isFile | E-01 L397-399 | ○ |
| C-55 | Stats.isSymbolicLink | E-01 L409-411 | ○ |
| C-56 | BigIntStats._checkModeProperty | E-01 L512-518 | ○ |
| C-57 | getStatsFromBinding（Float64Array） | E-01 L548-571 | ○ |
| C-58 | getStatsFromBinding（BigInt64Array） | E-01 L549-559 | ○ |
| C-59 | StatFsコンストラクタ | E-01 L573-583 | ○ |
| C-60 | validateCpOptions正常系 | E-01 L779-798 | ○ |
| C-61 | validateCpOptions（オプション競合） | E-01 L791-793 | ○ |
| C-62 | validateRmOptions正常系 | E-01 L800-832 | ○ |
| C-63 | validateRmOptions（ディレクトリ+非recursive） | E-01 L819-829 | ○ |
| C-64 | validateRmOptionsSync | E-01 L834-862 | ○ |
| C-65 | getValidMode（access） | E-01 L875-891 | ○ |
| C-66 | getValidMode（copyFile） | E-01 L879-882 | ○ |
| C-67 | validatePosition正常系 | E-01 L903-916 | ○ |
| C-68 | validatePosition（BigInt） | E-01 L906-912 | ○ |
| C-69 | validatePosition異常系 | E-01 L913-915 | ○ |

### internal/fs/watchers.js

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | StatWatcherコンストラクタ | E-02 L130-138 | ○ |
| C-71 | StatWatcher.kFSStatWatcherStart | E-02 L161-189 | ○ |
| C-72 | StatWatcher.kFSStatWatcherStart異常系 | E-02 L180-188 | ○ |
| C-73 | StatWatcher.stop | E-02 L201-211 | ○ |
| C-74 | StatWatcher.ref | E-02 L231-238 | ○ |
| C-75 | StatWatcher.unref | E-02 L240-246 | ○ |
| C-76 | FSWatcherコンストラクタ | E-02 L249-282 | ○ |
| C-77 | FSWatcher.kFSWatchStart | E-02 L292-326 | ○ |
| C-78 | FSWatcher.kFSWatchStart（ignore） | E-02 L307-309 | ○ |
| C-79 | FSWatcher.close | E-02 L336-347 | ○ |
| C-80 | FSWatcher.ref | E-02 L349-352 | ○ |
| C-81 | FSWatcher.unref | E-02 L354-357 | ○ |
| C-82 | createIgnoreMatcher（文字列） | E-02 L89-109 | ○ |
| C-83 | createIgnoreMatcher（正規表現） | E-02 L110-111 | ○ |
| C-84 | createIgnoreMatcher（関数） | E-02 L113-114 | ○ |
| C-85 | createIgnoreMatcher（配列） | E-02 L91-92 | ○ |
| C-86 | createIgnoreMatcher（null） | E-02 L90 | ○ |
| C-87 | watch（async iterator） | E-02 L373-478 | ○ |
| C-88 | watch（abort） | E-02 L399-401, L471-473 | ○ |
| C-89 | watch（maxQueue超過） | E-02 L433-442 | ○ |

### internal/fs/promises.js

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | FileHandleコンストラクタ | E-03 L151-163 | ○ |
| C-91 | FileHandle.fd | E-03 L169-171 | ○ |
| C-92 | FileHandle.read | E-03 L193-195, L643-700 | ○ |
| C-93 | FileHandle.read（length=0） | E-03 L677-678 | ○ |
| C-94 | FileHandle.read（クローズ済み） | E-03 L453-459 | ○ |
| C-95 | FileHandle.write | E-03 L224-226, L716-758 | ○ |
| C-96 | FileHandle.write（空バッファ） | E-03 L717-718 | ○ |
| C-97 | FileHandle.write（文字列） | E-03 L750-757 | ○ |
| C-98 | FileHandle.close | E-03 L236-267 | ○ |
| C-99 | FileHandle.close（クローズ済み） | E-03 L237-239 | ○ |
| C-100 | FileHandle.stat | E-03 L212-214, L1011-1018 | ○ |
| C-101 | FileHandle.truncate | E-03 L216-218, L793-801 | ○ |
| C-102 | FileHandle.chmod | E-03 L177-179, L1065-1072 | ○ |
| C-103 | FileHandle.chown | E-03 L181-183, L1103-1111 | ○ |
| C-104 | FileHandle.readableWebStream | E-03 L279-342 | ○ |
| C-105 | FileHandle.readableWebStream異常系 | E-03 L280-286 | ○ |
| C-106 | FileHandle.createReadStream | E-03 L357-360 | ○ |
| C-107 | FileHandle.createWriteStream | E-03 L375-378 | ○ |
| C-108 | open | E-03 L632-641 | ○ |
| C-109 | open異常系 | E-03 L636-640 | ○ |
| C-110 | readFile | E-03 L1260-1271 | ○ |
| C-111 | readFile（エンコーディング） | E-03 L509-513 | ○ |
| C-112 | readFile（サイズ超過） | E-03 L534-535 | ○ |
| C-113 | writeFile | E-03 L1216-1247 | ○ |
| C-114 | writeFile（flush） | E-03 L1242-1244 | ○ |
| C-115 | writeFile（iterable） | E-03 L474-491 | ○ |
| C-116 | appendFile | E-03 L1253-1258 | ○ |
| C-117 | mkdir | E-03 L845-866 | ○ |
| C-118 | mkdir（recursive） | E-03 L854-856 | ○ |
| C-119 | readdir | E-03 L943-966 | ○ |
| C-120 | readdir（withFileTypes） | E-03 L963-964 | ○ |
| C-121 | readdir（recursive） | E-03 L868-941 | ○ |
| C-122 | rm | E-03 L803-807 | ○ |
| C-123 | rm（recursive） | E-03 L805-806 | ○ |
| C-124 | rm（force） | E-03 L805 | ○ |
| C-125 | rename | E-03 L778-786 | ○ |
| C-126 | stat | E-03 L1029-1036 | ○ |
| C-127 | lstat | E-03 L1020-1027 | ○ |
| C-128 | symlink | E-03 L978-1009 | ○ |
| C-129 | symlink（権限不足） | E-03 L993-995 | ○ |
| C-130 | cp | E-03 L610-615 | ○ |
| C-131 | cp（recursive） | E-03 L611 | ○ |

### internal/fs/streams.js

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-132 | ReadStreamコンストラクタ | E-04 L163-228 | ○ |
| C-133 | ReadStream（FileHandle） | E-04 L145-156 | ○ |
| C-134 | ReadStream._read | E-04 L246-292 | ○ |
| C-135 | ReadStream._read（EOF） | E-04 L288-290 | ○ |
| C-136 | ReadStream._read（範囲） | E-04 L247-254 | ○ |
| C-137 | ReadStream._destroy | E-04 L294-306 | ○ |
| C-138 | ReadStream.close | E-04 L308-311 | ○ |
| C-139 | ReadStream.autoClose | E-04 L232-242 | ○ |
| C-140 | ReadStream.pending | E-04 L313-317 | ○ |
| C-141 | WriteStreamコンストラクタ | E-04 L319-394 | ○ |
| C-142 | WriteStream._write | E-04 L470-485 | ○ |
| C-143 | WriteStream._write（EAGAIN） | E-04 L415-418 | ○ |
| C-144 | WriteStream._writev | E-04 L487-513 | ○ |
| C-145 | WriteStream._destroy | E-04 L515-527 | ○ |
| C-146 | WriteStream._destroy（flush） | E-04 L121-128 | ○ |
| C-147 | WriteStream.close | E-04 L529-547 | ○ |

### internal/fs/dir.js

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-148 | Dirコンストラクタ | E-05 L51-74 | ○ |
| C-149 | Dir（handleなし） | E-05 L52 | ○ |
| C-150 | Dir.path | E-05 L76-79 | ○ |
| C-151 | Dir.read | E-05 L109-179 | ○ |
| C-152 | Dir.read（Promise） | E-05 L110 | ○ |
| C-153 | Dir.read（末尾） | E-05 L157-160 | ○ |
| C-154 | Dir.read（クローズ済み） | E-05 L114-116 | ○ |
| C-155 | Dir.readSync | E-05 L208-241 | ○ |
| C-156 | Dir.readSync（クローズ済み） | E-05 L209-211 | ○ |
| C-157 | Dir.readSync（同時操作） | E-05 L213-215 | ○ |
| C-158 | Dir.close | E-05 L243-274 | ○ |
| C-159 | Dir.close（Promise） | E-05 L244-248 | ○ |
| C-160 | Dir.closeSync | E-05 L276-292 | ○ |
| C-161 | Dir.entries | E-05 L294-306 | ○ |
| C-162 | Dir[SymbolDispose] | E-05 L308-311 | ○ |
| C-163 | Dir[SymbolAsyncDispose] | E-05 L313-316 | ○ |
| C-164 | opendir | E-05 L329-354 | ○ |
| C-165 | opendirSync | E-05 L356-363 | ○ |

### internal/fs/rimraf.js

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-166 | rimraf | E-06 L35-53 | ○ |
| C-167 | rimraf（ディレクトリ再帰） | E-06 L106-117, L120-154 | ○ |
| C-168 | rimraf（ENOENT） | E-06 L47-48 | ○ |
| C-169 | rimraf（リトライ） | E-06 L40-44 | ○ |
| C-170 | rimrafPromises | E-06 L157-166 | ○ |

### internal/fs/recursive_watch.js

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-171 | FSWatcherコンストラクタ | E-07 L49-79 | ○ |
| C-172 | FSWatcher.kFSWatchStart（ファイル） | E-07 L210-231 | ○ |
| C-173 | FSWatcher.kFSWatchStart（ディレクトリ） | E-07 L221-223 | ○ |
| C-174 | FSWatcher.close | E-07 L82-97 | ○ |
| C-175 | FSWatcher[SymbolAsyncIterator] | E-07 L249-279 | ○ |

### internal/fs/sync_write_stream.js

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-176 | SyncWriteStreamコンストラクタ | E-08 L12-20 | ○ |
| C-177 | SyncWriteStream._write | E-08 L25-33 | ○ |
| C-178 | SyncWriteStream._write異常系 | E-08 L28-30 | ○ |
| C-179 | SyncWriteStream._destroy（autoClose=true） | E-08 L35-44 | ○ |
| C-180 | SyncWriteStream._destroy（autoClose=false） | E-08 L39-40 | ○ |

### internal/fs/glob.js

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-181 | Globコンストラクタ | E-09 L260-307 | ○ |
| C-182 | Glob（配列パターン） | E-09 L291-298 | ○ |
| C-183 | Glob（exclude） | E-09 L275-290 | ○ |
| C-184 | Glob.globSync | E-09 L309-328 | ○ |
| C-185 | Glob.globSync（withFileTypes） | E-09 L322-327 | ○ |
| C-186 | Glob.glob | E-09 L547-558 | ○ |
| C-187 | matchGlobPattern（マッチ） | E-09 L784-797 | ○ |
| C-188 | matchGlobPattern（不一致） | E-09 L784-797 | ○ |

### internal/fs/cp/cp.js

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-189 | cpFn | E-10 L59-71 | ○ |
| C-190 | cpFn（同一パス） | E-10 L79-87 | ○ |
| C-191 | cpFn（ディレクトリ→非ディレクトリ） | E-10 L88-97 | ○ |
| C-192 | cpFn（サブディレクトリ） | E-10 L110-118 | ○ |
| C-193 | cpFn（filter） | E-10 L74-76 | ○ |
| C-194 | cpFn（preserveTimestamps） | E-10 L262-265 | ○ |

### internal/fs/cp/cp-sync.js

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-195 | cpSyncFn | E-11 L41-59 | ○ |
| C-196 | cpSyncFn（async filter） | E-11 L50-52 | ○ |
| C-197 | cpSyncFn（force） | E-11 L85-87 | ○ |
| C-198 | cpSyncFn（errorOnExist） | E-11 L89-97 | ○ |

### internal/fs/read/context.js

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-199 | ReadFileContextコンストラクタ | E-12 L71-83 | ○ |
| C-200 | ReadFileContext.read | E-12 L85-110 | ○ |
| C-201 | ReadFileContext.read（abort） | E-12 L90-93 | ○ |
| C-202 | ReadFileContext.close（ユーザーfd） | E-12 L113-117 | ○ |
| C-203 | ReadFileContext.close | E-12 L119-126 | ○ |

## 4) 不足情報（Unknown / Missing）
- **なし** - 全てのテストケースについてソースコード根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 全テストケースがソースコードから直接導出されており、根拠の信頼性は高い
- 追加検討事項:
  - Node.js内部APIのため、バージョンアップによる仕様変更の可能性あり
  - プライベートフィールド（#で始まる）のテストは直接アクセスできないため、間接的なテスト設計が必要
  - C++バインディング（internalBinding）に依存する部分はモック化が困難な場合あり

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースIDが重複していないか確認
- [ ] 各メソッドの正常系・異常系・境界値が網羅されているか確認
- [ ] 優先度「高」のテストケースが適切にマークされているか確認
- [ ] Node.js実行環境でのテスト実行可能性を確認
- [ ] プライベートメソッド・フィールドへのアクセス方法を検討
- [ ] C++バインディング依存部分のモック戦略を確認
