---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 262
  claims_with_evidence: 262
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: lib-internal-http2 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：262 / 262、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースはソースコードに基づいて生成されました

## 2) 参照した情報（Evidence一覧）

> 以下のソースファイルを解析して単体テストケースを生成しました。

- E-01: `lib/internal/http2/util.js` - ユーティリティ関数群（設定管理、ヘッダー処理、バリデーション）
- E-02: `lib/internal/http2/core.js` - コア実装（Http2Session、Http2Stream、サーバー/クライアント実装）
- E-03: `lib/internal/http2/compat.js` - HTTP/1互換性レイヤー（Http2ServerRequest、Http2ServerResponse）

## 3) Claims と根拠の対応（レビューの主戦場）

### util.js（E-01）に基づくテストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-04 | getDefaultSettings関数のテスト | E-01 (line 317-370) | ○ |
| C-05〜C-06 | getSettings関数のテスト | E-01 (line 374-393) | ○ |
| C-07〜C-15 | updateSettingsBuffer関数のテスト | E-01 (line 395-527) | ○ |
| C-16〜C-19 | updateOptionsBuffer関数のテスト | E-01 (line 235-305) | ○ |
| C-20〜C-21 | getSessionState/getStreamState関数のテスト | E-01 (line 547-581) | ○ |
| C-22〜C-26 | isIllegalConnectionSpecificHeader関数のテスト | E-01 (line 583-597) | ○ |
| C-27〜C-35 | assertValidPseudoHeader系関数のテスト | E-01 (line 599-613) | ○ |
| C-36〜C-43 | prepareRequestHeaders系関数のテスト | E-01 (line 620-743) | ○ |
| C-44〜C-49 | buildNgHeaderString関数のテスト | E-01 (line 756-839) | ○ |
| C-50〜C-53 | toHeaderObject関数のテスト | E-01 (line 886-929) | ○ |
| C-54〜C-63 | その他ユーティリティ関数のテスト | E-01 (line 931-986) | ○ |
| C-64〜C-75 | バリデーション・エラー関連のテスト | E-01 (line 841-884, 529-545) | ○ |

### core.js（E-02）に基づくテストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76〜C-106 | Http2Session クラスのテスト | E-02 (line 1276-1681) | ○ |
| C-107〜C-113 | ServerHttp2Session クラスのテスト | E-02 (line 1686-1787) | ○ |
| C-114〜C-119 | ClientHttp2Session クラスのテスト | E-02 (line 1793-1918) | ○ |
| C-120〜C-133 | Http2Stream クラスのテスト | E-02 (line 2046-2524) | ○ |
| C-134〜C-153 | ServerHttp2Stream クラスのテスト | E-02 (line 2845-3178) | ○ |
| C-154〜C-165 | connect/createServer/設定関連のテスト | E-02 (line 3527-3677) | ○ |
| C-166〜C-173 | Http2Server/Http2SecureServer関連のテスト | E-02 (line 3380-3467) | ○ |

### compat.js（E-03）に基づくテストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-174〜C-193 | Http2ServerRequest クラスのテスト | E-03 (line 310-439) | ○ |
| C-194〜C-245 | Http2ServerResponse クラスのテスト | E-03 (line 467-937) | ○ |
| C-246〜C-254 | ヘッダー検証関数のテスト | E-03 (line 82-137) | ○ |
| C-255〜C-262 | イベントハンドラ・プロキシ関連のテスト | E-03 (line 139-280, 939-980) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースはソースコードから直接導出されているため、根拠なしの項目はありません
- ただし、以下の情報があるとより詳細なテストケースが作成可能です：
  - Node.js HTTP/2仕様への準拠度ドキュメント
  - 既存のテストケース（test/parallel/test-http2-*.js）との整合性確認
  - パフォーマンス要件に関する仕様

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 対象 | 理由 |
|---|---|---|
| 0（低リスク） | util.js関連テスト | 純粋関数が多く、単体テストが容易 |
| 0（低リスク） | compat.js関連テスト | HTTP/1互換のためインターフェースが明確 |
| 1（中リスク） | core.js セッション管理テスト | 状態遷移が複雑、モック化が必要 |
| 1（中リスク） | core.js ストリーム管理テスト | 非同期処理、イベント駆動のためテスト設計に注意 |

## 6) レビュアーチェックリスト（最小）

- [ ] 高優先度テストケース（金額計算相当 = HTTP/2フロー制御、セキュリティ関連）が網羅されているか
- [ ] エラーコードの妥当性（NGHTTP2_*定数の使用）が正しいか
- [ ] 境界値テスト（MAX_ADDITIONAL_SETTINGS=10、ウィンドウサイズ制限等）が適切か
- [ ] 状態遷移テスト（pending -> ready -> closed -> destroyed）が適切か
- [ ] 互換性レイヤー（compat.js）がHTTP/1 APIと整合しているか
- [ ] セキュリティ関連のテスト（疑似ヘッダー検証、接続固有ヘッダー拒否）が十分か

## 7) 解析対象ファイル詳細

### lib/internal/http2/util.js (987行)
- **getDefaultSettings**: デフォルトHTTP/2設定の取得
- **getSettings**: セッション設定の取得（ローカル/リモート）
- **updateSettingsBuffer**: 設定バッファの更新
- **updateOptionsBuffer**: オプションバッファの更新
- **getSessionState**: セッション状態の取得
- **getStreamState**: ストリーム状態の取得
- **buildNgHeaderString**: ヘッダー文字列の構築
- **toHeaderObject**: ヘッダー配列からオブジェクトへの変換
- **isIllegalConnectionSpecificHeader**: 接続固有ヘッダーの検証
- **assertValidPseudoHeader**: 疑似ヘッダーの検証
- **prepareRequestHeadersObject/Array**: リクエストヘッダーの準備
- **NghttpError**: nghttp2エラークラス
- **assertIsObject/assertIsArray/assertWithinRange**: バリデーション関数

### lib/internal/http2/core.js (3710行)
- **Http2Session**: HTTP/2セッションの基底クラス
- **ServerHttp2Session**: サーバーサイドセッション
- **ClientHttp2Session**: クライアントサイドセッション
- **Http2Stream**: HTTP/2ストリームの基底クラス
- **ServerHttp2Stream**: サーバーサイドストリーム
- **ClientHttp2Stream**: クライアントサイドストリーム
- **Http2Server**: HTTP/2サーバー（非TLS）
- **Http2SecureServer**: HTTP/2サーバー（TLS）
- **connect**: クライアント接続関数
- **createServer/createSecureServer**: サーバー作成関数
- **getPackedSettings/getUnpackedSettings**: 設定のパック/アンパック
- **validateSettings**: 設定の検証

### lib/internal/http2/compat.js (981行)
- **Http2ServerRequest**: HTTP/1互換リクエストオブジェクト
- **Http2ServerResponse**: HTTP/1互換レスポンスオブジェクト
- **onServerStream**: ストリームイベントハンドラ
- **proxySocketHandler**: ソケットプロキシハンドラ
- **assertValidHeader**: ヘッダー検証
- **isPseudoHeader**: 疑似ヘッダー判定
- **isConnectionHeaderAllowed**: 接続ヘッダー許可判定

## 8) テストID命名規則

本モジュールでは以下のプレフィックスを使用しています：

- **UT-H2U-xxx**: lib/internal/http2/util.js のテスト
- **UT-H2C-xxx**: lib/internal/http2/core.js のテスト
- **UT-H2CO-xxx**: lib/internal/http2/compat.js のテスト

通常のモジュール略称（lib-internal-http2）には「H2」を使用しますが、ファイル単位の識別のため細分化しています。
