---
generated_at: 2026-01-30 18:20:00
metrics:
  claims_total: 123
  claims_with_evidence: 123
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: lib-internal-main 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：123 / 123、根拠なし：0
- 優先レビュー（高）
  1. なし - すべてのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/main/repl.js` - REPLエントリポイント（67行）
- E-02: `lib/internal/main/print_help.js` - ヘルプ表示エントリポイント（239行）
- E-03: `lib/internal/main/watch_mode.js` - ウォッチモードエントリポイント（204行）
- E-04: `lib/internal/main/eval_string.js` - 文字列評価エントリポイント（79行）
- E-05: `lib/internal/main/embedding.js` - 埋め込みアプリケーションエントリポイント（119行）
- E-06: `lib/internal/main/check_syntax.js` - 構文チェックエントリポイント（78行）
- E-07: `lib/internal/main/prof_process.js` - プロファイル処理エントリポイント（38行）
- E-08: `lib/internal/main/test_runner.js` - テストランナーエントリポイント（41行）
- E-09: `lib/internal/main/worker_thread.js` - ワーカースレッドエントリポイント（302行）
- E-10: `lib/internal/main/mksnapshot.js` - スナップショット生成エントリポイント（213行）
- E-11: `lib/internal/main/inspect.js` - インスペクターエントリポイント（19行）
- E-12: `lib/internal/main/eval_stdin.js` - stdin評価エントリポイント（58行）
- E-13: `lib/internal/main/run_main_module.js` - メインモジュール実行エントリポイント（34行）

## 3) Claims と根拠の対応（レビューの主戦場）

### repl.js (UT-MAN-001 - UT-MAN-006)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NODE_REPL_EXTERNAL_MODULE環境変数で外部モジュールロード | E-01 (25-27行) | ○ |
| C-02 | --input-typeオプションでREPLエラー終了 | E-01 (30-35行) | ○ |
| C-03 | REPL起動時のWelcomeメッセージ表示 | E-01 (38-39行) | ○ |
| C-04 | exit時のhistory flushチェック | E-01 (46-53行) | ○ |
| C-05 | flushHistory待機後のexit | E-01 (47-51行) | ○ |
| C-06 | --evalと-i併用時のevalScript呼び出し | E-01 (58-63行) | ○ |

### print_help.js (UT-MAN-007 - UT-MAN-018)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | indent関数のテキストインデント処理 | E-02 (88-90行) | ○ |
| C-08 | depth=0の境界値処理 | E-02 (88-90行) | ○ |
| C-09 | fold関数のテキスト折り返し処理 | E-02 (92-98行) | ○ |
| C-10 | getArgDescriptionのkHostPort処理 | E-02 (107-108行) | ○ |
| C-11 | getArgDescriptionのkInteger等の処理 | E-02 (109-113行) | ○ |
| C-12 | getArgDescriptionのkBoolean等の処理 | E-02 (102-106行) | ○ |
| C-13 | 未知オプション型のassert.fail | E-02 (114-116行) | ○ |
| C-14 | format関数のオプション整形 | E-02 (119-201行) | ○ |
| C-15 | defaultIsTrueの--no-プレフィックス | E-02 (146-148行) | ○ |
| C-16 | currently setの表示 | E-02 (171-177行) | ○ |
| C-17 | firstColumn幅の自動調整 | E-02 (190-198行) | ○ |
| C-18 | print関数のヘルプ出力 | E-02 (203-232行) | ○ |

### watch_mode.js (UT-MAN-019 - UT-MAN-037)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | start関数の子プロセス起動 | E-03 (95-119行) | ○ |
| C-20 | IPC付きstdio設定 | E-03 (97行) | ○ |
| C-21 | WATCH_REPORT_DEPENDENCIES環境変数設定 | E-03 (101-103行) | ○ |
| C-22 | 正常終了時のメッセージ表示 | E-03 (112-113行) | ○ |
| C-23 | エラー終了時のメッセージ表示 | E-03 (114-116行) | ○ |
| C-24 | killAndWaitのnullチェック | E-03 (122-125行) | ○ |
| C-25 | killedチェックによる重複kill防止 | E-03 (126-128行) | ○ |
| C-26 | force=trueでの強制kill | E-03 (126-128行) | ○ |
| C-27 | シグナル送信処理 | E-03 (129-132行) | ○ |
| C-28 | 500ms以上の終了待機メッセージ | E-03 (139-142行) | ○ |
| C-29 | 500ms未満の高速終了 | E-03 (143-151行) | ○ |
| C-30 | stop関数のIPC破棄とフィルタクリア | E-03 (154-161行) | ○ |
| C-31 | restart関数の二重起動防止 | E-03 (164-175行) | ○ |
| C-32 | kPreserveOutput=falseでの画面クリア | E-03 (168行) | ○ |
| C-33 | Restartingメッセージ表示 | E-03 (169行) | ○ |
| C-34 | changedイベントでのrestart | E-03 (182-183行) | ○ |
| C-35 | errorイベントでのuncaughtException | E-03 (184-187行) | ○ |
| C-36 | SIGTERMハンドリング | E-03 (195-202行) | ○ |
| C-37 | SIGINTハンドリング | E-03 (203行) | ○ |

### eval_string.js (UT-MAN-038 - UT-MAN-044)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | inputType=moduleでevalModuleEntryPoint | E-04 (36-37行) | ○ |
| C-39 | inputType=module-typescriptでparseAndEvalModuleTypeScript | E-04 (38-39行) | ○ |
| C-40 | inputType=commonjsでevalScript | E-04 (60-61行) | ○ |
| C-41 | inputType=commonjs-typescriptでparseAndEvalCommonjsTypeScript | E-04 (62-63行) | ○ |
| C-42 | tsEnabledでevalTypeScript | E-04 (64-65行) | ○ |
| C-43 | crypto識別子とOpenSSLでのcrypto注入 | E-04 (43-44, 71-74行) | ○ |
| C-44 | crypto識別子とOpenSSLなしでのsetter定義 | E-04 (46-57行) | ○ |

### embedding.js (UT-MAN-045 - UT-MAN-053)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | embedderRunCjsのCJSコンパイル | E-05 (47-96行) | ○ |
| C-46 | sourceMapURLでのmaybeCacheSourceMap | E-05 (67-76行) | ○ |
| C-47 | cachedDataRejectedでの警告 | E-05 (79-81行) | ○ |
| C-48 | customModuleのfilename/paths設定 | E-05 (85-87行) | ○ |
| C-49 | embedderRequireのビルトインrequire | E-05 (100-116行) | ○ |
| C-50 | ERR_UNKNOWN_BUILTIN_MODULEスロー | E-05 (113行) | ○ |
| C-51 | SEA環境での警告出力 | E-05 (103-112行) | ○ |
| C-52 | 重複警告防止 | E-05 (103, 111行) | ○ |
| C-53 | SEA実験的警告 | E-05 (34-36行) | ○ |

### check_syntax.js (UT-MAN-054 - UT-MAN-063)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | ファイル指定時の構文チェック | E-06 (27-40行) | ○ |
| C-55 | argv[1]='-'でのstdin読み込み | E-06 (41-47行) | ○ |
| C-56 | argv[1]未指定でのstdin読み込み | E-06 (41-47行) | ○ |
| C-57 | --importオプションでのESMローダー使用 | E-06 (49-57行) | ○ |
| C-58 | --import未指定での直接コールバック | E-06 (55-56行) | ○ |
| C-59 | [stdin]でinputType=moduleのformat判定 | E-06 (61-62行) | ○ |
| C-60 | [stdin]でinputType未指定のformat判定 | E-06 (61-62行) | ○ |
| C-61 | 通常ファイルのフォーマット判定 | E-06 (64-68行) | ○ |
| C-62 | format=moduleでのModuleWrap構文チェック | E-06 (70-73行) | ○ |
| C-63 | format=commonjsでのwrapSafe構文チェック | E-06 (76行) | ○ |

### prof_process.js (UT-MAN-064 - UT-MAN-067)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | グローバルポリフィル設定 | E-07 (27-28行) | ○ |
| C-65 | openFileの呼び出し | E-07 (29行) | ○ |
| C-66 | tickprocessor-driverのインポート | E-07 (32行) | ○ |
| C-67 | Promiseリジェクト時のエラーハンドリング | E-07 (35-37行) | ○ |

### test_runner.js (UT-MAN-068 - UT-MAN-074)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | parseCommandLineでのオプションパース | E-08 (19行) | ○ |
| C-69 | isolation=noneでのinitializeModules制御 | E-08 (20-23行) | ○ |
| C-70 | インスペクター使用時のconcurrency制御 | E-08 (26-31行) | ○ |
| C-71 | インスペクター使用時の警告出力 | E-08 (27-28行) | ○ |
| C-72 | globPatternsの設定 | E-08 (33行) | ○ |
| C-73 | テスト成功時のexitCode | E-08 (36-40行) | ○ |
| C-74 | テスト失敗時のexitCode | E-08 (37-39行) | ○ |

### worker_thread.js (UT-MAN-075 - UT-MAN-094)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | LOAD_SCRIPTでのワーカースクリプトロード | E-09 (91-226行) | ○ |
| C-76 | argv追加処理 | E-09 (107-109行) | ○ |
| C-77 | parentPort/workerData設定 | E-09 (111-113行) | ○ |
| C-78 | cwdキャッシュ処理 | E-09 (121-132行) | ○ |
| C-79 | cwdキャッシュ更新処理 | E-09 (126-131行) | ○ |
| C-80 | ローダーフックワーカーのsetupModuleWorker | E-09 (150-155行) | ○ |
| C-81 | doEval=classicでのevalScript | E-09 (158-192行) | ○ |
| C-82 | TypeScript ESMワーカー処理 | E-09 (172-177行) | ○ |
| C-83 | doEval=moduleでのevalModuleEntryPoint | E-09 (196-201行) | ○ |
| C-84 | doEval=data-urlでのESMインポート | E-09 (203-215行) | ○ |
| C-85 | スクリプトファイル実行 | E-09 (217-225行) | ○ |
| C-86 | STDIO_PAYLOADメッセージ処理 | E-09 (227-231行) | ○ |
| C-87 | STDIO_WANTS_MORE_DATAメッセージ処理 | E-09 (232-239行) | ○ |
| C-88 | workerOnGlobalUncaughtExceptionのハンドル成功 | E-09 (242-256行) | ○ |
| C-89 | exitCode設定 | E-09 (258-268行) | ○ |
| C-90 | ERROR_MESSAGEポスト | E-09 (278-282行) | ○ |
| C-91 | COULD_NOT_SERIALIZE_ERRORポスト | E-09 (283-284行) | ○ |
| C-92 | process.exit呼び出し | E-09 (289行) | ○ |
| C-93 | NODE_CHANNEL_FDでのprocess.channel設定 | E-09 (72-85行) | ○ |
| C-94 | process.send/disconnect設定 | E-09 (86-88行) | ○ |

### mksnapshot.js (UT-MAN-095 - UT-MAN-107)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | supportedInUserSnapshotのtrue返却 | E-10 (99-101行) | ○ |
| C-96 | supportedInUserSnapshotのfalse返却 | E-10 (99-101行) | ○ |
| C-97 | requireForUserSnapshotのrequire呼び出し | E-10 (103-130行) | ○ |
| C-98 | MODULE_NOT_FOUNDエラー | E-10 (105-112行) | ○ |
| C-99 | 非サポートモジュール警告 | E-10 (113-127行) | ○ |
| C-100 | 重複警告防止 | E-10 (114, 125行) | ○ |
| C-101 | Error.stackTraceLimit設定 | E-10 (141-148行) | ○ |
| C-102 | シリアライズ時のstackTraceLimit削除 | E-10 (180行) | ○ |
| C-103 | stackTraceLimit変更時の警告 | E-10 (158-177行) | ○ |
| C-104 | デシリアライズ時のstackTraceLimit復元 | E-10 (183-187行) | ○ |
| C-105 | anonymousMainPathでのfilename/dirname設定 | E-10 (194-195行) | ○ |
| C-106 | 通常パスでのpath.resolve | E-10 (197-198行) | ○ |
| C-107 | compileSerializeMainでの関数実行 | E-10 (201-202行) | ○ |

### inspect.js (UT-MAN-108 - UT-MAN-110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | prepareMainThreadExecution呼び出し | E-11 (10行) | ○ |
| C-109 | markBootstrapComplete呼び出し | E-11 (13行) | ○ |
| C-110 | インスペクター起動 | E-11 (16-18行) | ○ |

### eval_stdin.js (UT-MAN-111 - UT-MAN-118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | readStdinでのコード読み込み | E-12 (24行) | ○ |
| C-112 | process._eval設定 | E-12 (27行) | ○ |
| C-113 | inputType=moduleでのevalModuleEntryPoint | E-12 (33-34行) | ○ |
| C-114 | inputType=module-typescriptでの処理 | E-12 (35-36行) | ○ |
| C-115 | inputType=commonjsでのevalScript | E-12 (40-41行) | ○ |
| C-116 | inputType=commonjs-typescriptでの処理 | E-12 (42-43行) | ○ |
| C-117 | tsEnabledでのevalTypeScript | E-12 (44-45行) | ○ |
| C-118 | デフォルトのevalScript | E-12 (46-48行) | ○ |

### run_main_module.js (UT-MAN-119 - UT-MAN-123)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | --entry-url指定時のprepareMainThreadExecution(false) | E-13 (14-15行) | ○ |
| C-120 | --entry-url未指定時のprepareMainThreadExecution(true) | E-13 (15行) | ○ |
| C-121 | --entry-url実験的警告 | E-13 (22-24行) | ○ |
| C-122 | RegExpスタティックスリセット | E-13 (20行) | ○ |
| C-123 | Module.runMain呼び出し | E-13 (33行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべてのテストケースはソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースにソースコード根拠あり
- 1: 中リスク - エントリポイントモジュールのため、外部依存（`internal/process/pre_execution`、`internal/modules/cjs/loader`等）の動作に依存するテストケースあり
- 1: 中リスク - ワーカースレッド関連のテストケースは実際のマルチスレッド環境でのテストが必要

## 6) レビュアーチェックリスト（最小）
- [ ] 各エントリポイントファイルの役割が正しく理解されているか確認
- [ ] watch_mode.jsのシグナルハンドリングテストケースが実環境で動作するか確認
- [ ] worker_thread.jsのメッセージタイプ（LOAD_SCRIPT、STDIO_PAYLOAD等）が網羅されているか確認
- [ ] mksnapshot.jsのスナップショット機能に関するテストケースの妥当性確認
- [ ] embedding.jsのSEA（Single Executable Application）関連テストケースの妥当性確認
- [ ] TypeScript関連機能（--strip-types、inputType=*-typescript）のテストケースが適切か確認
