---
generated_at: 2026-01-30 15:30:00
metrics:
  claims_total: 221
  claims_with_evidence: 218
  claims_without_evidence: 3
confidence_derived: 0.99
---

# 根拠レポート: lib-internal-modules 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：218 / 221、根拠なし：3
- 優先レビュー（高）
  1. **UT-MOD-100-101（wrapModuleLoad トレーシング）**：トレーシングチャンネルの詳細挙動は実行環境依存
  2. **UT-MOD-213-215（ESM Worker）**：ワーカースレッド間通信の詳細は実装固有
  3. **UT-MOD-220-221（shared_constants）**：定数値の変更可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `lib/internal/modules/typescript.js` - TypeScript型除去モジュール
- E-02: `lib/internal/modules/run_main.js` - エントリポイント実行モジュール
- E-03: `lib/internal/modules/package_json_reader.js` - package.json読み取りモジュール
- E-04: `lib/internal/modules/helpers.js` - ヘルパー関数群
- E-05: `lib/internal/modules/customization_hooks.js` - カスタマイズフック
- E-06: `lib/internal/modules/cjs/loader.js` - CommonJSローダー
- E-07: `lib/internal/modules/esm/module_job.js` - ESMモジュールジョブ
- E-08: `lib/internal/modules/esm/assert.js` - インポート属性検証
- E-09: `lib/internal/modules/esm/hooks.js` - 非同期ローダーフック
- E-10: `lib/internal/modules/esm/translators.js` - モジュール変換器
- E-11: `lib/internal/modules/esm/worker.js` - ESMワーカー
- E-12: `lib/internal/modules/esm/resolve.js` - ESM解決ロジック
- E-13: `lib/internal/modules/esm/create_dynamic_module.js` - 動的モジュール作成
- E-14: `lib/internal/modules/esm/shared_constants.js` - 共有定数
- E-15: `lib/internal/modules/esm/load.js` - ESMロード
- E-16: `lib/internal/modules/esm/module_map.js` - モジュールマップ/キャッシュ
- E-17: `lib/internal/modules/esm/utils.js` - ESMユーティリティ
- E-18: `lib/internal/modules/esm/get_format.js` - フォーマット取得
- E-19: `lib/internal/modules/esm/formats.js` - フォーマット定義
- E-20: `lib/internal/modules/esm/loader.js` - ESMローダー

## 3) Claims と根拠の対応（レビューの主戦場）

### TypeScript モジュール (E-01)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | parseTypeScriptが正常にパースすること | E-01 L57-82 | ○ |
| C-02 | UnsupportedSyntaxエラーがスローされること | E-01 L67-69 | ○ |
| C-03 | InvalidSyntaxエラーがスローされること | E-01 L71-73 | ○ |
| C-04 | stripTypeScriptTypesが型除去すること | E-01 L102-128 | ○ |
| C-05 | 空文字列が処理できること | E-01 L102-128 | ○ |
| C-06 | codeがstring以外でエラー | E-01 L104 validateString | ○ |
| C-07 | stripTypeScriptModuleTypesが動作すること | E-01 L180-218 | ○ |
| C-08 | node_modules配下でエラー | E-01 L182-183 | ○ |
| C-09-11 | getCachedCodeType, addSourceMapの動作 | E-01 L165-171, L227-233 | ○ |

### run_main モジュール (E-02)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | resolveMainPathがパス解決すること | E-02 L29-45 | ○ |
| C-13 | ファイルなしでundefined | E-02 L36 | ○ |
| C-14-17 | shouldUseESMLoaderの各条件判定 | E-02 L52-84 | ○ |
| C-18-19 | executeUserEntryPointの実行 | E-02 L140-165 | ○ |

### package_json_reader モジュール (E-03)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20-21 | deserializePackageJSONの動作 | E-03 L44-105 | ○ |
| C-22 | exportsの遅延パース | E-03 L74-85 | ○ |
| C-23 | readの動作 | E-03 L122-140 | ○ |
| C-24-25 | getNearestParentPackageJSONの動作 | E-03 L167-185 | ○ |
| C-26-28 | getPackageScopeConfig, getPackageTypeの動作 | E-03 L192-224 | ○ |
| C-29-30 | parsePackageNameの動作 | E-03 L233-265 | ○ |
| C-31-32 | findPackageJSONの動作 | E-03 L311-354 | ○ |

### helpers モジュール (E-04)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | toRealPathの動作 | E-04 L61-65 | ○ |
| C-34-36 | CJS条件初期化・取得 | E-04 L76-110 | ○ |
| C-37-38 | loadBuiltinModuleの動作 | E-04 L117-127 | ○ |
| C-39-40 | makeRequireFunctionの動作 | E-04 L144-188 | ○ |
| C-41-42 | stripBOMの動作 | E-04 L197-202 | ○ |
| C-43-46 | normalizeReferrerURL, urlToFilenameの動作 | E-04 L276-325 | ○ |
| C-47-48 | getBuiltinModuleの動作 | E-04 L346-350 | ○ |
| C-49-51 | assertBufferSource, stringifyの動作 | E-04 L373-402 | ○ |
| C-52-53 | enableCompileCache, getCompileCacheDirの動作 | E-04 L418-459 | ○ |

### customization_hooks モジュール (E-05)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54-55 | ModuleHooksの登録・解除 | E-05 L66-104 | ○ |
| C-56-57 | registerHooksの動作 | E-05 L111-120 | ○ |
| C-58-60 | URL変換関数の動作 | E-05 L126-157 | ○ |
| C-61 | buildHooksの動作 | E-05 L171-203 | ○ |
| C-62-65 | validate関数群の動作 | E-05 L220-323 | ○ |
| C-66-68 | resolveWithHooks, loadWithHooksの動作 | E-05 L365-418 | ○ |

### CJS Loader モジュール (E-06)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69-70 | Module constructorの動作 | E-06 L338-348 | ○ |
| C-71-75 | Module._findPath, _nodeModulePathsの動作 | E-06 L703-917 | ○ |
| C-76-77 | Module._resolveLookupPathsの動作 | E-06 L925-966 | ○ |
| C-78-81 | Module._loadの動作 | E-06 L1216-1356 | ○ |
| C-82-83 | Module._resolveFilenameの動作 | E-06 L1369-1457 | ○ |
| C-84-85 | Module.prototype.loadの動作 | E-06 L1515-1537 | ○ |
| C-86-87 | Module.prototype.requireの動作 | E-06 L1545-1557 | ○ |
| C-88-90 | Module.prototype._compileの動作 | E-06 L1759-1814 | ○ |
| C-91-94 | 拡張子ハンドラの動作 | E-06 L1905-1968 | ○ |
| C-95-96 | Module.createRequireの動作 | E-06 L2006-2027 | ○ |
| C-97-99 | _initPaths, _preloadModules, syncBuiltinESMExportsの動作 | E-06 L2049-2116 | ○ |
| C-100-101 | wrapModuleLoadの動作 | E-06 L238-259 | ○ |
| C-102-107 | 各種ヘルパー関数の動作 | E-06 各所 | ○ |

### ESM module_job モジュール (E-07)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108-115 | ModuleJobBase, ModuleJob, ModuleJobSyncの動作 | E-07 L129-541 | ○ |

### ESM assert モジュール (E-08)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116-119 | validateAttributesの動作 | E-08 L55-110 | ○ |

### ESM hooks モジュール (E-09)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-120-129 | AsyncLoaderHooks関連クラスの動作 | E-09 L133-868 | ○ |

### ESM translators モジュール (E-10)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-130-144 | 各translatorの動作 | E-10 L90-635 | ○ |

### ESM resolve モジュール (E-12)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-145-164 | defaultResolve, moduleResolve等の動作 | E-12 L946-1054 | ○ |

### ESM load モジュール (E-15)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-165-171 | defaultLoad, getSourceSync等の動作 | E-15 L32-216 | ○ |

### ESM get_format モジュール (E-18)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-172-179 | defaultGetFormat, extname等の動作 | E-18 L37-220 | ○ |

### ESM formats モジュール (E-19)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-180-183 | extensionFormatMap, mimeToFormat等の動作 | E-19 L14-64 | ○ |

### ESM module_map モジュール (E-16)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-184-189 | ResolveCache, LoadCacheの動作 | E-16 L25-127 | ○ |

### ESM utils モジュール (E-17)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-190-197 | 各種ユーティリティ関数の動作 | E-17 L48-341 | ○ |

### ESM loader モジュール (E-20)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-198-210 | ModuleLoader, register等の動作 | E-20 L167-983 | ○ |

### ESM create_dynamic_module モジュール (E-13)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-211-212 | createDynamicModuleの動作 | E-13 L54-96 | ○ |

### ESM worker モジュール (E-11)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-213-215 | setupModuleWorker, customizedModuleWorkerの動作 | E-11 L143-319 | △ |
| C-216-219 | transferArrayBuffer, wrapMessageの動作 | E-11 L88-133 | ○ |

### ESM shared_constants モジュール (E-14)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-220-221 | 共有定数の値 | E-14 L21-25 | △ |

## 4) 不足情報（Unknown / Missing）
- **ワーカースレッド間通信の詳細**: ESM Workerの通信プロトコルの詳細はAtomics APIに依存しており、実行環境によって挙動が異なる可能性がある
  - 候補：Node.js Worker Threads ドキュメント / V8 Atomics 仕様
- **定数値の安定性**: shared_constantsの定数値は内部実装の詳細であり、将来のバージョンで変更される可能性がある
  - 候補：Node.js リリースノート / 内部API変更履歴
- **トレーシング詳細**: diagnostics_channelのトレーシング挙動は購読者の有無に依存
  - 候補：diagnostics_channel ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分のテストケース（約98%）はソースコードから直接確認可能
- **1: 中リスク** - ESM Workerのスレッド間通信テスト（UT-MOD-213-219）は実行環境依存
- **0: 低リスク** - 定数値テスト（UT-MOD-220-221）は単純な値確認

## 6) レビュアーチェックリスト（最小）
- [ ] TypeScript型除去機能（UT-MOD-001-011）のエラーハンドリングが網羅されているか
- [ ] CJSローダー（UT-MOD-069-107）の循環参照処理が十分にテストされているか
- [ ] ESM/CJS相互運用（UT-MOD-198-207）のエッジケースが網羅されているか
- [ ] カスタマイズフック（UT-MOD-054-068）のチェーン処理が正しくテストされているか
- [ ] パッケージ解決（UT-MOD-145-164）のexports/imports処理が網羅されているか
- [ ] ワーカー通信テスト（UT-MOD-213-219）の非同期処理が適切か確認
