---
generated_at: 2026-01-30 18:30:00
metrics:
  claims_total: 95
  claims_with_evidence: 95
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lib-internal-per_context.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：95 / 95、根拠なし：0
- 優先レビュー（高）
  1. **UT-PRC-003〜006**: emitMessageのWorker間メッセージング処理（実行時テストで動作確認推奨）
  2. **UT-PRC-008〜009**: uncurryThis/applyBindのセキュリティ関連機能
  3. **UT-PRC-050**: SafeArrayPrototypePushApplyの大量データ処理（パフォーマンステスト推奨）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/per_context/messageport.js` - MessageEvent クラスとemitMessage関数
- E-02: `lib/internal/per_context/primordials.js` - primordialsオブジェクトとユーティリティ関数群
- E-03: `lib/internal/per_context/domexception.js` - DOMExceptionクラス実装

## 3) Claims と根拠の対応（レビューの主戦場）

### messageport.js 関連 (UT-PRC-001〜007)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MessageEventコンストラクタがdata, target, type, portsを設定 | E-01 L6-13 | ○ |
| C-02 | portsがundefinedの場合空配列になる | E-01 L11 `this.ports = ports ?? []` | ○ |
| C-03 | kHybridDispatchが存在する場合にdispatchされる | E-01 L20-28 | ○ |
| C-04 | onmessageハンドラが呼び出される | E-01 L31-33 | ○ |
| C-05 | onmessageerrorハンドラが呼び出される | E-01 L35-37 | ○ |
| C-06 | finallyでkCurrentlyReceivingPortsがクリアされる | E-01 L24-26 `finally` | ○ |
| C-07 | portsが空配列の場合の動作 | E-01 L19-39 | ○ |

### primordials.js - コア関数 (UT-PRC-008〜018)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | uncurryThisが関数をuncurryする | E-02 L19-24 | ○ |
| C-09 | applyBindがapplyをバインドする | E-02 L26-30 | ○ |
| C-10 | getNewKeyが文字列キーを変換する | E-02 L54-58 | ○ |
| C-11 | getNewKeyがSymbolキーを変換する | E-02 L55-56 | ○ |
| C-12 | copyAccessorがゲッターをコピーする | E-02 L60-73 | ○ |
| C-13 | copyAccessorがセッターをコピーする | E-02 L66-72 | ○ |
| C-14 | セッターがundefinedの場合コピーされない | E-02 L66 `if (set !== undefined)` | ○ |
| C-15 | copyPropsRenamedがプロパティをリネームコピー | E-02 L75-95 | ○ |
| C-16 | varargsMethods対象にApply版が作成される | E-02 L84-92 | ○ |
| C-17 | copyPropsRenamedBoundが関数をバインドコピー | E-02 L97-119 | ○ |
| C-18 | copyPrototypeがuncurryしてコピー | E-02 L121-143 | ○ |

### primordials.js - SafeIterator (UT-PRC-019〜025)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | createSafeIteratorがSafeIteratorクラスを作成 | E-02 L328-344 | ○ |
| C-20 | SafeIteratorのnextが正しく動作 | E-02 L333-335 | ○ |
| C-21 | SafeIteratorがSymbol.iteratorを実装 | E-02 L336-338 | ○ |
| C-22 | SafeArrayIteratorが配列を安全にイテレート | E-02 L346-349 | ○ |
| C-23 | SafeStringIteratorが文字列を安全にイテレート | E-02 L350-353 | ○ |
| C-24 | copyPropsがプロパティをコピー | E-02 L355-364 | ○ |
| C-25 | copyPropsが既存プロパティを上書きしない | E-02 L357 `if (!ReflectGetOwnPropertyDescriptor(dest, key))` | ○ |

### primordials.js - makeSafe (UT-PRC-026〜029)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | makeSafeが安全なコレクションを作成 | E-02 L369-401 | ○ |
| C-27 | イテラブルクラスのイテレータが安全化される | E-02 L370-391 | ○ |
| C-28 | プロトタイプがnullに設定される | E-02 L397 | ○ |
| C-29 | 返却オブジェクトがfreezeされる | E-02 L398-399 | ○ |

### primordials.js - SafePromise系 (UT-PRC-030〜042)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | SafePromisePrototypeFinallyが安全にfinallyを実行 | E-02 L447-454 | ○ |
| C-31 | SafePromiseプロトタイプが露出しない | E-02 L448-449 コメント参照 | ○ |
| C-32 | SafePromiseAllがすべてのPromiseを解決 | E-02 L476-481 | ○ |
| C-33 | SafePromiseAllでmapFnが適用される | E-02 L461-468 | ○ |
| C-34 | SafePromiseAllでreject伝播 | E-02 L480 `.then(a, b)` | ○ |
| C-35 | SafePromiseAllReturnArrayLikeが配列風オブジェクトを返却 | E-02 L492-508 | ○ |
| C-36 | SafePromiseAllReturnArrayLikeで空配列が即座に解決 | E-02 L498 | ○ |
| C-37 | SafePromiseAllReturnVoidがvoidで解決 | E-02 L518-531 | ○ |
| C-38 | SafePromiseAllReturnVoidで空配列が即座に解決 | E-02 L521 | ○ |
| C-39 | SafePromiseAllSettledがすべての結果を返却 | E-02 L539-544 | ○ |
| C-40 | SafePromiseAllSettledReturnVoidがvoidで解決 | E-02 L554-564 | ○ |
| C-41 | SafePromiseAnyが最初の解決値を返却 | E-02 L572-577 | ○ |
| C-42 | SafePromiseRaceが最初の完了結果を返却 | E-02 L585-590 | ○ |

### primordials.js - hardenRegExp (UT-PRC-043〜048)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | hardenRegExpが正規表現を強化 | E-02 L625-711 | ○ |
| C-44 | flagsプロパティが設定される | E-02 L705-709 | ○ |
| C-45 | constructorにRegExpLikeForStringSplittingが設定 | E-02 L652-658 | ○ |
| C-46 | SafeStringPrototypeSearchが文字列検索を実行 | E-02 L719-723 | ○ |
| C-47 | マッチしない場合-1が返却される | E-02 L722 | ○ |
| C-48 | lastIndexが0にリセットされる | E-02 L720 | ○ |

### primordials.js - SafeArrayPrototypePushApply (UT-PRC-049〜051)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | SafeArrayPrototypePushApplyが配列に要素を追加 | E-02 L733-744 | ○ |
| C-50 | 大量の要素(65536以上)が追加できる | E-02 L734-741 チャンク処理 | ○ |
| C-51 | チャンクサイズ境界での動作 | E-02 L734 `0x10000` | ○ |

### primordials.js - RegExpLikeForStringSplitting (UT-PRC-052〜055)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | RegExpLikeForStringSplittingがRegExpを内部作成 | E-02 L602-618 | ○ |
| C-53 | lastIndex getterが内部RegExpのlastIndexを取得 | E-02 L608-610 | ○ |
| C-54 | lastIndex setterが内部RegExpのlastIndexを設定 | E-02 L611-613 | ○ |
| C-55 | execが内部RegExpのexecを呼び出す | E-02 L615-617 | ○ |

### domexception.js - DOMException (UT-PRC-056〜078)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | デフォルトオプションでエラーが作成される | E-03 L72 `options = 'Error'` | ○ |
| C-57 | 文字列オプションでエラーが作成される | E-03 L97-101 | ○ |
| C-58 | オブジェクトオプションでエラーが作成される | E-03 L81-96 | ○ |
| C-59 | causeオプションが設定される | E-03 L88-96 | ○ |
| C-60 | [[ErrorData]]内部スロットが設定される | E-03 L76 `new Error()` | ○ |
| C-61 | new.target.prototypeが使用される | E-03 L78 | ○ |
| C-62 | name getterがnameを取得 | E-03 L130-136 | ○ |
| C-63 | 無効なthisでTypeErrorがスローされる(name) | E-03 L132-133 | ○ |
| C-64 | message getterがmessageを取得 | E-03 L138-144 | ○ |
| C-65 | 無効なthisでTypeErrorがスローされる(message) | E-03 L140-141 | ○ |
| C-66 | 標準エラー名のコードが取得できる | E-03 L146-158 | ○ |
| C-67 | 非標準エラー名の場合0が返却される | E-03 L157 | ○ |
| C-68 | 廃止されたエラー名の場合0が返却される | E-03 L152-154, L56-61 | ○ |
| C-69 | 無効なthisでTypeErrorがスローされる(code) | E-03 L148-149 | ○ |
| C-70 | messaging_clone_symbolがクローン用データを返却 | E-03 L108-119 | ○ |
| C-71 | messaging_deserialize_symbolがデシリアライズ | E-03 L121-128 | ○ |
| C-72 | INDEX_SIZE_ERRが1である | E-03 L171 | ○ |
| C-73 | DATA_CLONE_ERRが25である | E-03 L195 | ○ |
| C-74 | プロトタイプにも定数が定義されている | E-03 L201 | ○ |
| C-75 | toStringTagが"DOMException"である | E-03 L164 | ○ |
| C-76 | throwInvalidThisErrorがERR_INVALID_THISをスロー | E-03 L28-51 | ○ |
| C-77 | エラーメッセージに型名が含まれる | E-03 L34 | ○ |
| C-78 | toStringメソッドが正しい形式を返す | E-03 L39-43 | ○ |

### primordials.js - グローバルコピー (UT-PRC-079〜095)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | globalThisがコピーされる | E-02 L146-152 | ○ |
| C-80 | Proxyがコピーされる | E-02 L146-152 | ○ |
| C-81 | encodeURIがコピーされる | E-02 L154-162 | ○ |
| C-82 | decodeURIComponentがコピーされる | E-02 L154-162 | ○ |
| C-83 | escapeがコピーされる | E-02 L164-171 | ○ |
| C-84 | MathメソッドがコピーされるMath | E-02 L173-183 | ○ |
| C-85 | JSONメソッドがコピーされる | E-02 L173-183 | ○ |
| C-86 | Arrayがコピーされる | E-02 L185-230 | ○ |
| C-87 | ArrayPrototypeMapがuncurryされる | E-02 L229 copyPrototype | ○ |
| C-88 | Promiseがバインドコピーされる | E-02 L236-244 | ○ |
| C-89 | TypedArrayがコピーされる | E-02 L246-263 | ○ |
| C-90 | ArrayIteratorPrototypeがコピーされる | E-02 L251-253 | ○ |
| C-91 | StringIteratorPrototypeがコピーされる | E-02 L254-256 | ○ |
| C-92 | IteratorPrototypeが設定される | E-02 L265 | ○ |
| C-93 | AsyncIteratorPrototypeが設定される | E-02 L456-459 | ○ |
| C-94 | primordialsがfreezeされる | E-02 L747 | ○ |
| C-95 | primordialsのプロトタイプがnullである | E-02 L746 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 補足: 以下の情報があるとより詳細なテストケース設計が可能
  - Node.jsの内部APIドキュメント（非公開）
  - Worker間メッセージングの詳細仕様
  - プロトタイプ汚染攻撃のテストベクトル

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 静的コピー系の関数（globalThis, URI関数等）
- **1: 中リスク** - イテレータ・アクセサ関連（SafeIterator, copyAccessor等）
- **2: 高リスク** - セキュリティ重要機能（uncurryThis, makeSafe, hardenRegExp, DOMException）
  - 理由: プロトタイプ汚染攻撃への防御を担う機能のため、テスト漏れは重大なセキュリティ問題につながる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] UT-PRC-003〜006: emitMessageのkHybridDispatch/finally処理が正しくテストされているか
- [ ] UT-PRC-008〜009: uncurryThis/applyBindのセキュリティ影響を理解しているか
- [ ] UT-PRC-026〜029: makeSafeのプロトタイプチェーン切断・freeze処理が正しいか
- [ ] UT-PRC-043〜045: hardenRegExpのSymbol.species対策が正しく機能するか
- [ ] UT-PRC-050: 大量データ処理でのスタックオーバーフロー対策が有効か
- [ ] UT-PRC-056〜069: DOMExceptionの[[ErrorData]]内部スロット処理が正しいか
- [ ] UT-PRC-070〜071: Worker間転送でのシリアライズ/デシリアライズが正しいか
- [ ] primordialsの不変性（freeze/null prototype）が維持されているか
