---
generated_at: 2026-01-30 18:20:00
metrics:
  claims_total: 183
  claims_with_evidence: 183
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lib-internal-perf 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：183 / 183、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースにソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/perf/performance.js` - Performanceクラス定義
- E-02: `lib/internal/perf/performance_entry.js` - PerformanceEntry基底クラス定義
- E-03: `lib/internal/perf/nodetiming.js` - PerformanceNodeTimingクラス定義
- E-04: `lib/internal/perf/usertiming.js` - PerformanceMark/PerformanceMeasureクラス定義、mark/measure関数
- E-05: `lib/internal/perf/observe.js` - PerformanceObserver/PerformanceObserverEntryListクラス定義、バッファ管理関数
- E-06: `lib/internal/perf/timerify.js` - timerify関数定義
- E-07: `lib/internal/perf/utils.js` - now/getMilestoneTimestamp/getTimeOriginTimestamp関数定義
- E-08: `lib/internal/perf/event_loop_delay.js` - ELDHistogramクラス、monitorEventLoopDelay関数定義
- E-09: `lib/internal/perf/resource_timing.js` - PerformanceResourceTimingクラス定義、markResourceTiming関数
- E-10: `lib/internal/perf/event_loop_utilization.js` - eventLoopUtilization関数定義

## 3) Claims と根拠の対応（レビューの主戦場）

### Performance クラス (UT-PERF-001 - UT-PERF-026)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Performance.constructorがERR_ILLEGAL_CONSTRUCTORをスロー | E-01 L52-54 | ○ |
| C-02 | Performance.clearMarksがclearMarkTimings/clearEntriesFromBufferを呼び出す | E-01 L70-77 | ○ |
| C-03 | Performance.clearMeasuresがclearEntriesFromBufferを呼び出す | E-01 L79-85 | ○ |
| C-04 | Performance.clearResourceTimingsがclearEntriesFromBufferを呼び出す | E-01 L87-93 | ○ |
| C-05 | Performance.getEntriesがfilterBufferMapByNameAndTypeを呼び出す | E-01 L95-98 | ○ |
| C-06 | Performance.getEntriesByNameが引数チェックしてfilterを呼び出す | E-01 L100-109 | ○ |
| C-07 | Performance.getEntriesByTypeが引数チェックしてfilterを呼び出す | E-01 L112-118 | ○ |
| C-08 | Performance.markがmark関数を呼び出す | E-01 L121-127 | ○ |
| C-09 | Performance.measureがmeasure関数を呼び出す | E-01 L129-135 | ○ |
| C-10 | Performance.nowがutils.nowを呼び出す | E-01 L137-140 | ○ |
| C-11 | Performance.setResourceTimingBufferSizeがconvertToIntで変換して設定 | E-01 L142-150 | ○ |
| C-12 | Performance.timeOriginがgetTimeOriginTimestampを呼び出す | E-01 L152-155 | ○ |
| C-13 | Performance.toJSONがnodeTiming/timeOrigin/eventLoopUtilizationを返却 | E-01 L157-164 | ○ |
| C-14 | Performance.eventLoopUtilizationがモジュールからexport | E-01 L189-196 | ○ |
| C-15 | Performance.nodeTimingがモジュールからexport | E-01 L197-204 | ○ |
| C-16 | Performance.markResourceTimingがモジュールからexport | E-01 L205-214 | ○ |
| C-17 | Performance.timerifyがモジュールからexport | E-01 L215-222 | ○ |

### PerformanceEntry クラス (UT-PERF-027 - UT-PERF-037)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | PerformanceEntry.constructorがkSkipThrowをチェック | E-02 L33-49 | ○ |
| C-19 | PerformanceEntry.nameがkNameシンボルの値を返却 | E-02 L51-54 | ○ |
| C-20 | PerformanceEntry.entryTypeがkEntryTypeシンボルの値を返却 | E-02 L56-59 | ○ |
| C-21 | PerformanceEntry.startTimeがkStartTimeシンボルの値を返却 | E-02 L61-64 | ○ |
| C-22 | PerformanceEntry.durationがkDurationシンボルの値を返却 | E-02 L66-69 | ○ |
| C-23 | PerformanceEntry.toJSONが4プロパティを含むオブジェクト返却 | E-02 L82-90 | ○ |
| C-24 | createPerformanceEntryがkSkipThrowでインスタンス生成 | E-02 L100-102 | ○ |
| C-25 | isPerformanceEntryがkNameの存在をチェック | E-02 L29-31 | ○ |
| C-26 | PerformanceNodeEntry.detailがkDetailシンボルの値を返却 | E-02 L107-111 | ○ |
| C-27 | PerformanceNodeEntry.toJSONがdetailを含む | E-02 L113-122 | ○ |

### PerformanceNodeTiming クラス (UT-PERF-038 - UT-PERF-050)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | PerformanceNodeTiming.nameが'node'を返却 | E-03 L37-42 | ○ |
| C-29 | PerformanceNodeTiming.entryTypeが'node'を返却 | E-03 L44-49 | ○ |
| C-30 | PerformanceNodeTiming.startTimeが0を返却 | E-03 L51-56 | ○ |
| C-31 | PerformanceNodeTiming.durationがnow()を返却 | E-03 L58-63 | ○ |
| C-32 | PerformanceNodeTiming.nodeStartがgetMilestoneTimestamp呼び出し | E-03 L65-72 | ○ |
| C-33 | PerformanceNodeTiming.v8StartがgetMilestoneTimestamp呼び出し | E-03 L74-81 | ○ |
| C-34 | PerformanceNodeTiming.environmentがgetMilestoneTimestamp呼び出し | E-03 L83-90 | ○ |
| C-35 | PerformanceNodeTiming.loopStartがgetMilestoneTimestamp呼び出し | E-03 L92-99 | ○ |
| C-36 | PerformanceNodeTiming.loopExitがgetMilestoneTimestamp呼び出し | E-03 L101-108 | ○ |
| C-37 | PerformanceNodeTiming.bootstrapCompleteがgetMilestoneTimestamp呼び出し | E-03 L110-118 | ○ |
| C-38 | PerformanceNodeTiming.idleTimeがloopIdleTime呼び出し | E-03 L120-125 | ○ |
| C-39 | PerformanceNodeTiming.uvMetricsInfoがuvMetricsInfo呼び出し | E-03 L127-139 | ○ |
| C-40 | PerformanceNodeTiming.toJSONが全プロパティを含む | E-03 L154-168 | ○ |

### PerformanceMark/PerformanceMeasure クラス (UT-PERF-051 - UT-PERF-082)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | PerformanceMark.constructorが名前必須チェック | E-04 L70-73 | ○ |
| C-42 | PerformanceMark.constructorが予約名チェック | E-04 L74-76 | ○ |
| C-43 | PerformanceMark.constructorがoptions.startTimeを検証 | E-04 L80-83 | ○ |
| C-44 | PerformanceMark.constructorがdetailをstructuredClone | E-04 L86-89 | ○ |
| C-45 | PerformanceMark.detailがkDetailシンボルの値を返却 | E-04 L95-98 | ○ |
| C-46 | PerformanceMeasure.constructorがkSkipThrowをチェック | E-04 L120-133 | ○ |
| C-47 | mark関数がPerformanceMarkを作成してenqueue | E-04 L167-172 | ○ |
| C-48 | measure関数がcalculateStartDurationを使用 | E-04 L225-237 | ○ |
| C-49 | calculateStartDurationが複数のオプションパターンを処理 | E-04 L174-223 | ○ |
| C-50 | getMark関数が数値/文字列/nodeTiming属性を処理 | E-04 L53-67 | ○ |
| C-51 | clearMarkTimingsが予約名チェックを実施 | E-04 L239-248 | ○ |

### PerformanceObserver クラス (UT-PERF-083 - UT-PERF-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | PerformanceObserver.constructorがコールバック検証 | E-05 L242-244 | ○ |
| C-53 | PerformanceObserver.observeがentryTypes/type排他チェック | E-05 L247-260 | ○ |
| C-54 | PerformanceObserver.observeが観測タイプ変更エラー | E-05 L262-279 | ○ |
| C-55 | PerformanceObserver.observeがbufferedオプション処理 | E-05 L301-307 | ○ |
| C-56 | PerformanceObserver.disconnectがクリーンアップ実施 | E-05 L316-323 | ○ |
| C-57 | PerformanceObserver.takeRecordsがバッファを返却してクリア | E-05 L325-329 | ○ |
| C-58 | PerformanceObserver.supportedEntryTypesが固定配列返却 | E-05 L331-333, L81-91 | ○ |
| C-59 | PerformanceObserverEntryList.constructorがkSkipThrowをチェック | E-05 L171-178 | ○ |
| C-60 | PerformanceObserverEntryList.getEntriesがソート済み配列返却 | E-05 L180-183 | ○ |
| C-61 | PerformanceObserverEntryList.getEntriesByTypeがフィルタ | E-05 L185-194 | ○ |
| C-62 | PerformanceObserverEntryList.getEntriesByNameがフィルタ | E-05 L196-210 | ○ |
| C-63 | enqueue関数がisPerformanceEntryでチェック | E-05 L384-391 | ○ |
| C-64 | bufferUserTimingがmarkEntryBuffer/measureEntryBufferに追加 | E-05 L396-425 | ○ |
| C-65 | bufferResourceTimingがバッファフル処理 | E-05 L434-466 | ○ |
| C-66 | clearEntriesFromBufferがtype別にバッファクリア | E-05 L480-495 | ○ |
| C-67 | filterBufferMapByNameAndTypeがフィルタしてソート | E-05 L497-521 | ○ |
| C-68 | hasObserverがobserverCountsをチェック | E-05 L537-540 | ○ |
| C-69 | startPerfがstartTimeを設定 | E-05 L543-548 | ○ |
| C-70 | stopPerfがエントリを作成してenqueue | E-05 L550-564 | ○ |

### timerify 関数 (UT-PERF-125 - UT-PERF-133)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | timerifyがfn/optionsを検証 | E-06 L55-69 | ○ |
| C-72 | timerifyがPromise.finally対応 | E-06 L77-86 | ○ |
| C-73 | timerifyがコンストラクタ呼び出し対応 | E-06 L72-76 | ○ |
| C-74 | timerifyがhistogramオプション対応 | E-06 L63-69, L39-40 | ○ |
| C-75 | timerifyがname/lengthを保持 | E-06 L91-104 | ○ |
| C-76 | processCompleteがエントリ作成してenqueue | E-06 L37-53 | ○ |

### utils モジュール (UT-PERF-134 - UT-PERF-137)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | nowがinternalBinding('performance').nowを使用 | E-07 L9 | ○ |
| C-78 | getMilestoneTimestampがミリ秒変換して返却 | E-07 L19-24 | ○ |
| C-79 | getMilestoneTimestampが-1をそのまま返却 | E-07 L21-22 | ○ |
| C-80 | getTimeOriginTimestampがミリ秒変換して返却 | E-07 L26-28 | ○ |

### ELDHistogram クラス (UT-PERF-138 - UT-PERF-149)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | monitorEventLoopDelayがoptions/resolutionを検証 | E-08 L81-85 | ○ |
| C-82 | monitorEventLoopDelayがReflectConstructでインスタンス生成 | E-08 L87-94 | ○ |
| C-83 | ELDHistogram.constructorがERR_ILLEGAL_CONSTRUCTORをスロー | E-08 L42-44 | ○ |
| C-84 | ELDHistogram.enableがkEnabledをチェック | E-08 L49-56 | ○ |
| C-85 | ELDHistogram.disableがkEnabledをチェック | E-08 L61-68 | ○ |
| C-86 | ELDHistogram[Symbol.dispose]がdisableを呼び出す | E-08 L70-72 | ○ |

### PerformanceResourceTiming クラス (UT-PERF-150 - UT-PERF-178)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | PerformanceResourceTiming.constructorがkSkipThrowをチェック | E-09 L27-34 | ○ |
| C-88 | PerformanceResourceTiming.nameがkRequestedUrlを返却 | E-09 L36-39 | ○ |
| C-89 | PerformanceResourceTiming.startTimeがtimingInfo.startTimeを返却 | E-09 L41-44 | ○ |
| C-90 | PerformanceResourceTiming.durationがendTime - startTimeを返却 | E-09 L46-49 | ○ |
| C-91 | PerformanceResourceTiming.transferSizeがcacheModeで分岐 | E-09 L133-139 | ○ |
| C-92 | PerformanceResourceTiming.toJSONが全プロパティを含む | E-09 L151-178 | ○ |
| C-93 | createPerformanceResourceTimingがインスタンス生成 | E-09 L209-231 | ○ |
| C-94 | markResourceTimingがcacheModeをassert | E-09 L245-248 | ○ |
| C-95 | markResourceTimingがenqueue/bufferResourceTimingを呼び出す | E-09 L259-261 | ○ |

### eventLoopUtilization 関数 (UT-PERF-179 - UT-PERF-183)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | eventLoopUtilizationがloopStart/loopIdleTimeを取得 | E-10 L11-20 | ○ |
| C-97 | internalEventLoopUtilizationがloopStart <= 0でゼロ値返却 | E-10 L23-25 | ○ |
| C-98 | internalEventLoopUtilizationがutil2指定で差分計算 | E-10 L27-31 | ○ |
| C-99 | internalEventLoopUtilizationがutil1指定で差分計算 | E-10 L46-54 | ○ |
| C-100 | internalEventLoopUtilizationが引数なしで現在値計算 | E-10 L39-45 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全テストケースにソースコードの根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいて生成されている
- internalBinding依存の関数（now, getMilestoneTimestamp等）はネイティブコード依存のため、実際の動作確認が必要
- GC関連のobserverテスト（UT-PERF-120, UT-PERF-121）はinstallGarbageCollectionTracking/removeGarbageCollectionTrackingの動作に依存

## 6) レビュアーチェックリスト（最小）
- [ ] ERR_ILLEGAL_CONSTRUCTORのテストケースが全クラスに対して存在するか確認
- [ ] validateThisInternalFieldのブランドチェックテストが網羅されているか確認
- [ ] ERR_MISSING_ARGSのテストケースが必須引数を持つ全メソッドに対して存在するか確認
- [ ] boundary value（境界値）テストが数値パラメータを持つ関数に対して存在するか確認
- [ ] PerformanceObserverの観測タイプ変更制約のテストが網羅されているか確認
- [ ] bufferResourceTimingのバッファフル時の動作テストが十分か確認
- [ ] timerifyの同期/非同期/コンストラクタの各パターンがテストされているか確認
