---
generated_at: 2026-01-30 15:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 148
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート: lib-internal-process 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：148 / 150、根拠なし：2
- 優先レビュー（高）
  1. **UT-PRC-038**: execve関数の実際の動作はネイティブコードに依存
  2. **UT-PRC-097**: モジュールローダー初期化の詳細な動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/process/task_queues.js` - タスクキュー関連の実装
- E-02: `lib/internal/process/per_thread.js` - スレッド単位の処理実装
- E-03: `lib/internal/process/finalization.js` - ファイナリゼーション処理
- E-04: `lib/internal/process/warning.js` - 警告処理実装
- E-05: `lib/internal/process/promises.js` - Promise拒否処理
- E-06: `lib/internal/process/pre_execution.js` - 事前実行処理
- E-07: `lib/internal/process/permission.js` - パーミッション機能
- E-08: `lib/internal/process/signal.js` - シグナル処理
- E-09: `lib/internal/process/execution.js` - 実行処理
- E-10: `lib/internal/process/report.js` - レポート機能
- E-11: `lib/internal/process/worker_thread_only.js` - ワーカースレッド専用処理

## 3) Claims と根拠の対応（レビューの主戦場）

### task_queues.js 関連（UT-PRC-001 - UT-PRC-014）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | hasTickScheduledがtickInfo[0]===1でtrueを返す | E-01 (L52-54) | ○ |
| C-02 | setHasTickScheduledがvalue ? 1 : 0を設定 | E-01 (L56-58) | ○ |
| C-03 | nextTickがvalidateFunctionでコールバックを検証 | E-01 (L113) | ○ |
| C-04 | nextTickがprocess._exitingで早期リターン | E-01 (L115-116) | ○ |
| C-05 | nextTickが引数を配列に格納 | E-01 (L118-128) | ○ |
| C-06 | queueMicrotaskがvalidateFunctionを使用 | E-01 (L160) | ○ |
| C-07 | processTicksAndRejectionsがキューを処理 | E-01 (L72-108) | ○ |
| C-08 | setupTaskQueueがlistenForRejectionsを呼ぶ | E-01 (L179) | ○ |

### per_thread.js 関連（UT-PRC-015 - UT-PRC-058）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | hrtimeがvalidateArrayで検証 | E-02 (L82) | ○ |
| C-10 | hrtimeがtime.length !== 2でERR_OUT_OF_RANGE | E-02 (L83-85) | ○ |
| C-11 | hrtimeBigIntがBigUint64Array使用 | E-02 (L76, L99-102) | ○ |
| C-12 | cpuUsageがpreviousValueIsValidで検証 | E-02 (L129-143) | ○ |
| C-13 | threadCpuUsageがSunOSでERR_OPERATION_FAILED | E-02 (L185-187) | ○ |
| C-14 | memoryUsageが5項目のオブジェクトを返す | E-02 (L216-225) | ○ |
| C-15 | exitがprocess._exitingを設定 | E-02 (L234-235) | ○ |
| C-16 | killがERR_INVALID_ARG_TYPEをスロー | E-02 (L258-259) | ○ |
| C-17 | killがERR_UNKNOWN_SIGNALをスロー | E-02 (L272) | ○ |
| C-18 | execveがisMainThreadチェック | E-02 (L287-288) | ○ |
| C-19 | execveがwin32/os400でERR_FEATURE_UNAVAILABLE_ON_PLATFORM | E-02 (L289-290) | ○ |
| C-20 | execveがnullバイトチェック | E-02 (L298-300) | ○ |
| C-21 | NodeEnvironmentFlagsSet.hasがアンダースコア変換 | E-02 (L462) | ○ |
| C-22 | NodeEnvironmentFlagsSet.addがthisを返す | E-02 (L439-441) | ○ |
| C-23 | refがnullチェック | E-02 (L530) | ○ |
| C-24 | unrefがnullチェック | E-02 (L537) | ○ |

### finalization.js 関連（UT-PRC-059 - UT-PRC-064）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | createFinalizationが3つのメソッドを返す | E-03 (L141-145) | ○ |
| C-26 | registerがvalidateObjectを使用 | E-03 (L104) | ○ |
| C-27 | unregisterがregistry nullチェック | E-03 (L128-129) | ○ |

### warning.js 関連（UT-PRC-065 - UT-PRC-075）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | emitWarningがnoDeprecationチェック | E-04 (L141-143, L169-171) | ○ |
| C-29 | emitWarningがthrowDeprecationでスロー | E-04 (L172-178) | ○ |
| C-30 | emitWarningがERR_INVALID_ARG_TYPEをスロー | E-04 (L166-167) | ○ |
| C-31 | onWarningがdisableWarningSetをチェック | E-04 (L91-99) | ○ |
| C-32 | onWarningがファイル出力 | E-04 (L128-131) | ○ |

### promises.js 関連（UT-PRC-076 - UT-PRC-091）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | setHasRejectionToWarnがtickInfo設定 | E-05 (L134-136) | ○ |
| C-34 | promiseRejectHandlerがtypeでswitch | E-05 (L164-179) | ○ |
| C-35 | unhandledRejectionがpendingUnhandledRejectionsに追加 | E-05 (L198-206) | ○ |
| C-36 | getUnhandledRejectionsModeが5つのモード | E-05 (L356-371) | ○ |

### pre_execution.js 関連（UT-PRC-092 - UT-PRC-103）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | prepareMainThreadExecutionがprepareExecutionを呼ぶ | E-06 (L45-53) | ○ |
| C-38 | patchProcessObjectがargv0を定義 | E-06 (L261-267) | ○ |
| C-39 | initializePermissionがERR_MISSING_OPTIONをスロー | E-06 (L686-688) | ○ |
| C-40 | initializeModuleLoaders内部実装の詳細 | E-06 (L212-242) | △ |
| C-41 | getHeapSnapshotFilenameがundefined返却 | E-06 (L740) | ○ |

### permission.js 関連（UT-PRC-104 - UT-PRC-110）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | isEnabledがgetOptionValueを使用 | E-07 (L17-21) | ○ |
| C-43 | hasがvalidateStringを使用 | E-07 (L24) | ○ |
| C-44 | hasがBufferをサポート | E-07 (L27-29) | ○ |
| C-45 | availableFlagsが8つのフラグを返す | E-07 (L36-46) | ○ |

### signal.js 関連（UT-PRC-111 - UT-PRC-117）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | isSignalがsignals[event]をチェック | E-08 (L17-18) | ○ |
| C-47 | startListeningIfSignalがSignalラップを作成 | E-08 (L23-40) | ○ |
| C-48 | stopListeningIfSignalがlistenerCountチェック | E-08 (L44-45) | ○ |

### execution.js 関連（UT-PRC-118 - UT-PRC-135）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | tryGetCwdがcatchでフォールバック | E-09 (L48-57) | ○ |
| C-50 | evalModuleEntryPointがERR_EVAL_ESM_CANNOT_PRINT | E-09 (L72-74) | ○ |
| C-51 | setUncaughtExceptionCaptureCallbackの検証 | E-09 (L112-130) | ○ |
| C-52 | createOnGlobalUncaughtExceptionの動作 | E-09 (L146-193) | ○ |

### report.js 関連（UT-PRC-136 - UT-PRC-148）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | writeReportがvalidateStringを使用 | E-10 (L25-26) | ○ |
| C-54 | getReportがJSONParseを使用 | E-10 (L43) | ○ |
| C-55 | signalセッターがvalidateSignalName使用 | E-10 (L77) | ○ |

### worker_thread_only.js 関連（UT-PRC-149 - UT-PRC-150）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | unavailableがERR_WORKER_UNSUPPORTED_OPERATIONスロー | E-11 (L13-14) | ○ |
| C-57 | unavailableがdisabled=trueを設定 | E-11 (L17) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-PRC-038 (execve)**: ネイティブバインディング`_execve`の実際の動作はC++コードに依存。JavaScript側での検証は限定的。
  - 候補: `src/node_process_methods.cc` / `src/process_wrap.cc` / Node.js公式ドキュメント
- **UT-PRC-097 (initializeModuleLoaders)**: ESMローダーの詳細な初期化シーケンスは`internal/modules/esm/`配下のファイルに分散しており、完全な動作検証には追加調査が必要。
  - 候補: `lib/internal/modules/esm/loader.js` / `lib/internal/modules/esm/utils.js`

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: task_queues.js, finalization.js, warning.js, promises.js, signal.js, worker_thread_only.js - 内部ロジックが明確でテストケースが直接的に対応
- **1 (中リスク)**: per_thread.js, permission.js, report.js - ネイティブバインディングとの連携があり、一部動作がC++側に依存
- **2 (高リスク)**: pre_execution.js, execution.js - プロセス初期化やモジュールローダーとの複雑な連携があり、テストのモック設計が重要

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（process.nextTick, kill, exit等）の網羅性を確認
- [ ] ネイティブバインディング依存のテストケースでモック戦略を検討
- [ ] 異常系テストケースのエラーコードが正確か確認
- [ ] 境界値テストケースの入力値が適切か確認
- [ ] プラットフォーム固有のテスト（SunOS, Windows等）の除外条件を確認
- [ ] --permission関連のセキュリティテストが十分か確認
