---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 303
  claims_with_evidence: 303
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lib-internal-quic 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：303 / 303、根拠なし：0
- 優先レビュー（高）
  1. **QuicEndpoint / QuicSession / QuicStream クラス**：QUIC通信の中核機能
  2. **validateBody関数**：データ転送の入力検証
  3. **TLSオプション処理（processTlsOptions）**：セキュリティに関わる重要なバリデーション

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/quic/quic.js` - メインQUIC実装ファイル
- E-02: `lib/internal/quic/state.js` - 状態管理クラス定義ファイル
- E-03: `lib/internal/quic/stats.js` - 統計情報クラス定義ファイル
- E-04: `lib/internal/quic/symbols.js` - Symbol定義ファイル

## 3) Claims と根拠の対応（レビューの主戦場）

### QuicEndpoint クラス（UT-QUIC-001 〜 UT-QUIC-032）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QuicEndpointのconstructorはEndpoint_を使用してハンドルを作成する | E-01 (L1748-1762) | ○ |
| C-02 | stats プロパティは QuicEndpointStats を返す | E-01 (L1768-1771) | ○ |
| C-03 | busy の getter/setter でビジー状態を制御できる | E-01 (L1782-1808) | ○ |
| C-04 | address プロパティでローカルアドレスを取得できる | E-01 (L1814-1822) | ○ |
| C-05 | close() はグレースフルクローズを実行する | E-01 (L1881-1897) | ○ |
| C-06 | destroy() は即座にエンドポイントを破棄する | E-01 (L1933-1950) | ○ |
| C-07 | [kListen] はサーバーモードを開始する | E-01 (L1829-1845) | ○ |
| C-08 | [kConnect] はクライアント接続を開始する | E-01 (L1853-1871) | ○ |
| C-09 | [kFinishClose] はクローズ処理を完了する | E-01 (L1976-2030) | ○ |

### QuicSession クラス（UT-QUIC-033 〜 UT-QUIC-083）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | QuicSessionのconstructorはプライベートシンボルを要求する | E-01 (L1028-1044) | ○ |
| C-11 | onstream/ondatagram コールバックを設定できる | E-01 (L1061-1092) | ○ |
| C-12 | createBidirectionalStream で双方向ストリームを作成できる | E-01 (L1176-1179) | ○ |
| C-13 | createUnidirectionalStream で単方向ストリームを作成できる | E-01 (L1185-1188) | ○ |
| C-14 | sendDatagram でデータグラムを送信できる | E-01 (L1201-1231) | ○ |
| C-15 | updateKey でTLSキー更新ができる | E-01 (L1236-1250) | ○ |
| C-16 | close() はグレースフルクローズを実行する | E-01 (L1262-1277) | ○ |
| C-17 | destroy() は即座にセッションを破棄する | E-01 (L1309-1367) | ○ |
| C-18 | [kFinishClose] はエラータイプに応じた処理を行う | E-01 (L1374-1410) | ○ |
| C-19 | [kHandshake] はハンドシェイク完了時にopenedを解決する | E-01 (L1512-1541) | ○ |

### QuicStream クラス（UT-QUIC-084 〜 UT-QUIC-134）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | QuicStreamのconstructorはプライベートシンボルを要求する | E-01 (L633-651) | ○ |
| C-21 | readable プロパティで ReadableStream を取得できる | E-01 (L657-664) | ○ |
| C-22 | onblocked/onreset コールバックを設定できる | E-01 (L677-710) | ○ |
| C-23 | setOutbound でデータソースを設定できる | E-01 (L810-819) | ○ |
| C-24 | stopSending で送信停止リクエストを送信できる | E-01 (L828-832) | ○ |
| C-25 | resetStream でストリームリセットを送信できる | E-01 (L841-845) | ○ |
| C-26 | priority で優先度を取得/設定できる | E-01 (L853-869) | ○ |
| C-27 | [kSendHeaders] でヘッダーを送信できる | E-01 (L883-892) | ○ |
| C-28 | [kHeaders] でヘッダーを解析してコールバックを呼ぶ | E-01 (L938-956) | ○ |

### QuicEndpointState クラス（UT-QUIC-135 〜 UT-QUIC-149）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | QuicEndpointStateのconstructorはプライベートシンボルを要求する | E-02 (L133-141) | ○ |
| C-30 | 各状態プロパティ（isBound, isReceiving等）が取得できる | E-02 (L143-182) | ○ |
| C-31 | toJSON/toString でシリアライズできる | E-02 (L184-199) | ○ |
| C-32 | [kFinishClose] でハンドルを空のDataViewに置換する | E-02 (L224-229) | ○ |

### QuicSessionState クラス（UT-QUIC-150 〜 UT-QUIC-169）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | QuicSessionStateのconstructorはプライベートシンボルを要求する | E-02 (L240-248) | ○ |
| C-34 | リスナー有無プロパティは読み書き可能 | E-02 (L251-296) | ○ |
| C-35 | 状態プロパティ（isClosing, isHandshakeCompleted等）が取得できる | E-02 (L298-356) | ○ |
| C-36 | [kFinishClose] でハンドルを空のDataViewに置換する | E-02 (L416-421) | ○ |

### QuicStreamState クラス（UT-QUIC-170 〜 UT-QUIC-188）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | QuicStreamStateのconstructorはプライベートシンボルを要求する | E-02 (L432-440) | ○ |
| C-38 | 各状態プロパティ（id, pending, finSent等）が取得できる | E-02 (L442-530) | ○ |
| C-39 | wantsBlock/wantsReset は読み書き可能 | E-02 (L503-536) | ○ |
| C-40 | [kFinishClose] でハンドルを空のDataViewに置換する | E-02 (L602-607) | ○ |

### QuicEndpointStats クラス（UT-QUIC-189 〜 UT-QUIC-209）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | QuicEndpointStatsのconstructorはプライベートシンボルを要求する | E-03 (L155-165) | ○ |
| C-42 | 各統計プロパティ（createdAt, bytesReceived等）が取得できる | E-03 (L167-230) | ○ |
| C-43 | isConnected で接続状態を確認できる | E-03 (L291-293) | ○ |
| C-44 | [kFinishClose] でスナップショットを作成する | E-03 (L295-300) | ○ |

### QuicSessionStats クラス（UT-QUIC-210 〜 UT-QUIC-238）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | QuicSessionStatsのconstructorはプライベートシンボルを要求する | E-03 (L313-323) | ○ |
| C-46 | 各統計プロパティ（createdAt, bytesReceived, latestRtt等）が取得できる | E-03 (L325-438) | ○ |
| C-47 | [kFinishClose] でスナップショットを作成する | E-03 (L527-532) | ○ |

### QuicStreamStats クラス（UT-QUIC-239 〜 UT-QUIC-255）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | QuicStreamStatsのconstructorはプライベートシンボルを要求する | E-03 (L545-555) | ○ |
| C-49 | 各統計プロパティ（createdAt, bytesReceived等）が取得できる | E-03 (L557-610) | ○ |
| C-50 | [kFinishClose] でスナップショットを作成する | E-03 (L671-676) | ○ |

### ヘルパー関数（UT-QUIC-256 〜 UT-QUIC-284）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | validateBody は各種バッファ型を適切に処理する | E-01 (L546-582) | ○ |
| C-52 | processEndpointOption はエンドポイントを適切に処理する | E-01 (L2080-2089) | ○ |
| C-53 | processTlsOptions はTLSオプションを検証・処理する | E-01 (L2096-2204) | ○ |
| C-54 | getPreferredAddressPolicy はポリシーを数値に変換する | E-01 (L2210-2217) | ○ |
| C-55 | processSessionOptions はセッションオプションを処理する | E-01 (L2224-2275) | ○ |
| C-56 | listen はサーバーを開始する | E-01 (L2284-2300) | ○ |
| C-57 | connect はクライアント接続を開始する | E-01 (L2307-2336) | ○ |

### Symbols（UT-QUIC-285 〜 UT-QUIC-287）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | 各シンボルがSymbol()で定義されている | E-04 (L27-51) | ○ |
| C-59 | 全シンボルがmodule.exportsでエクスポートされている | E-04 (L53-82) | ○ |

### コールバック関数（UT-QUIC-288 〜 UT-QUIC-303）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | setCallbacks で各コールバックが登録される | E-01 (L379-544) | ○ |
| C-61 | onEndpointClose はkFinishCloseを呼び出す | E-01 (L388-391) | ○ |
| C-62 | onSessionNew はkNewSessionを呼び出す | E-01 (L396-399) | ○ |
| C-63 | onStreamCreated はセッション状態を確認してからkNewStreamを呼び出す | E-01 (L503-512) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：全てのテストケースはソースコードの実装に基づいて生成されている

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: シンボル定義、統計情報取得系のテストケース
- **1 (中リスク)**: 状態管理、コールバック処理系のテストケース
- **2 (高リスク)**:
  - UT-QUIC-019〜025: エンドポイントのリスニング/接続処理（ネットワーク通信の起点）
  - UT-QUIC-046〜054: ストリーム作成とデータグラム送信（データ転送の信頼性）
  - UT-QUIC-077: ハンドシェイク完了処理（TLSセキュリティ）
  - UT-QUIC-268〜271: TLSオプション検証（セキュリティパラメータ）

## 6) レビュアーチェックリスト（最小）
- [ ] QuicEndpoint, QuicSession, QuicStreamの状態遷移が網羅されているか
- [ ] エラーハンドリング（ERR_INVALID_STATE, ERR_INVALID_ARG_TYPE等）のテストケースが十分か
- [ ] TLS関連のバリデーション（keys, certs必須チェック）が正しくテストされているか
- [ ] コールバック関数の呼び出しタイミングと引数が正しくテストされているか
- [ ] クローズ処理の冪等性（複数回呼び出し可能）がテストされているか
- [ ] 破棄済みオブジェクトへのアクセス時のエラーハンドリングがテストされているか
- [ ] 診断チャンネル（diagnostics_channel）へのパブリッシュがテストされているか（低優先度）
