---
generated_at: 2026-01-30 18:25:00
metrics:
  claims_total: 150
  claims_with_evidence: 147
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：lib-internal-readline.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：147 / 150、根拠なし：3
- 優先レビュー（高）
  1. **UT-RDL-039, 040（履歴ナビゲーション）**：historyManagerの詳細実装が別ファイル（internal/repl/history）にあるため
  2. **UT-RDL-150（setupHistoryManager）**：ReplHistoryクラスの詳細が別モジュールにあるため
  3. **UT-RDL-133（エスケープコードタイムアウト）**：タイムアウトの動作検証に実行時テストが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `lib/internal/readline/interface.js` - Interfaceクラス、InterfaceConstructor、各種Symbol定義
- E-02: `lib/internal/readline/promises.js` - Readlineクラス（Promise対応版）
- E-03: `lib/internal/readline/utils.js` - CSI、charLengthLeft、charLengthAt、commonPrefix、emitKeys、reverseString
- E-04: `lib/internal/readline/emitKeypressEvents.js` - emitKeypressEvents関数
- E-05: `lib/internal/readline/callbacks.js` - cursorTo、moveCursor、clearLine、clearScreenDown関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Interface constructorがオプション指定でインスタンス生成 | E-01 (L160-356) | ○ |
| C-002 | オプションオブジェクト形式のインスタンス生成 | E-01 (L176-216) | ○ |
| C-003 | completerが関数でない場合のエラー | E-01 (L220-222) | ○ |
| C-004 | escapeCodeTimeoutが数値でない場合のエラー | E-01 (L195-204) | ○ |
| C-005 | signal指定でAbortSignal設定 | E-01 (L206-208, L342-350) | ○ |
| C-006 | tabSizeが0の場合のエラー | E-01 (L188-191) | ○ |
| C-007 | setPromptでプロンプト設定 | E-01 (L372-374) | ○ |
| C-008 | getPromptでプロンプト取得 | E-01 (L380-382) | ○ |
| C-009 | promptメソッドでプロンプト出力 | E-01 (L429-437) | ○ |
| C-010 | preserveCursor=trueでカーソル位置保持 | E-01 (L432) | ○ |
| C-011 | closeでcloseイベント発火 | E-01 (L548-556) | ○ |
| C-012 | 既にクローズ済みの場合の早期リターン | E-01 (L549) | ○ |
| C-013 | pauseで入力ストリームポーズ | E-01 (L562-571) | ○ |
| C-014 | クローズ後のpauseでエラー | E-01 (L563-565) | ○ |
| C-015 | resumeで入力ストリーム再開 | E-01 (L577-586) | ○ |
| C-016 | クローズ後のresumeでエラー | E-01 (L578-580) | ○ |
| C-017 | writeで文字列処理 | E-01 (L600-610) | ○ |
| C-018 | writeでキーオブジェクト処理 | E-01 (L605-607) | ○ |
| C-019 | クローズ後のwriteでエラー | E-01 (L601-603) | ○ |
| C-020 | kQuestionでコールバック設定 | E-01 (L439-451) | ○ |
| C-021 | クローズ後のquestionでエラー | E-01 (L440-442) | ○ |
| C-022 | kOnLineでquestionコールバック呼び出し | E-01 (L458-467) | ○ |
| C-023 | kOnLineでlineイベント発火 | E-01 (L465) | ○ |
| C-024 | kInsertStringで文字列挿入 | E-01 (L659-699) | ○ |
| C-025 | kInsertStringでカーソル途中挿入 | E-01 (L677-686) | ○ |
| C-026 | kDeleteLeftで左削除 | E-01 (L808-820) | ○ |
| C-027 | kDeleteLeft境界値（カーソル先頭） | E-01 (L809) | ○ |
| C-028 | kDeleteRightで右削除 | E-01 (L822-836) | ○ |
| C-029 | kDeleteRight境界値（カーソル末尾） | E-01 (L823) | ○ |
| C-030 | kDeleteWordLeftで単語左削除 | E-01 (L838-860) | ○ |
| C-031 | kDeleteWordRightで単語右削除 | E-01 (L862-872) | ○ |
| C-032 | kDeleteLineLeftで行左削除 | E-01 (L874-881) | ○ |
| C-033 | kDeleteLineRightで行右削除 | E-01 (L883-889) | ○ |
| C-034 | kWordLeftで単語先頭移動 | E-01 (L786-798) | ○ |
| C-035 | kWordRightで次の単語移動 | E-01 (L800-806) | ○ |
| C-036 | kMoveCursorでカーソル移動 | E-01 (L1231-1254) | ○ |
| C-037 | kMoveCursor下限境界 | E-01 (L1239-1240) | ○ |
| C-038 | kMoveCursor上限境界 | E-01 (L1241-1242) | ○ |
| C-039 | kHistoryPrevで履歴前移動 | E-01 (L1168-1175), **historyManager詳細は別ファイル** | △ |
| C-040 | kHistoryNextで履歴次移動 | E-01 (L1148-1155), **historyManager詳細は別ファイル** | △ |
| C-041 | kUndoで前の状態に戻る | E-01 (L1064-1077) | ○ |
| C-042 | kUndo境界値（空スタック） | E-01 (L1065) | ○ |
| C-043 | kRedoで状態復元 | E-01 (L1079-1092) | ○ |
| C-044 | kRedo境界値（空スタック） | E-01 (L1080) | ○ |
| C-045 | kYankでkillRing内容挿入 | E-01 (L899-904) | ○ |
| C-046 | kYankPopで次の項目置換 | E-01 (L906-925) | ○ |
| C-047 | kPushToKillRingで削除テキスト追加 | E-01 (L891-897) | ○ |
| C-048 | kPushToKillRing最大長制限 | E-01 (L895-896), kMaxLengthOfKillRing (L98) | ○ |
| C-049 | kPushToUndoStackで状態追加 | E-01 (L1057-1062) | ○ |
| C-050 | kPushToUndoStack最大長制限 | E-01 (L1058-1061), kMaxUndoRedoStackSize (L78) | ○ |
| C-051 | kTabCompleteでcompleter呼び出し | E-01 (L701-714) | ○ |
| C-052 | kTabCompleterで共通プレフィックス挿入 | E-01 (L716-784) | ○ |
| C-053 | kTabCompleter空の補完候補 | E-01 (L719-721) | ○ |
| C-054 | kTtyWriteでCtrl+Cでclose | E-01 (L1325-1332) | ○ |
| C-055 | kTtyWriteでCtrl+CでSIGINT | E-01 (L1326-1328) | ○ |
| C-056 | kTtyWriteでCtrl+Dで空行時close | E-01 (L1339-1346) | ○ |
| C-057 | kTtyWriteでCtrl+Uで行左削除 | E-01 (L1349-1351) | ○ |
| C-058 | kTtyWriteでCtrl+Kで行右削除 | E-01 (L1353-1355) | ○ |
| C-059 | kTtyWriteでCtrl+Aで行頭移動 | E-01 (L1357-1358) | ○ |
| C-060 | kTtyWriteでCtrl+Eで行末移動 | E-01 (L1361-1362) | ○ |
| C-061 | kTtyWriteでCtrl+Bで左移動 | E-01 (L1365-1366) | ○ |
| C-062 | kTtyWriteでCtrl+Fで右移動 | E-01 (L1369-1370) | ○ |
| C-063 | kTtyWriteでreturnキーでlineイベント | E-01 (L1467-1469) | ○ |
| C-064 | kTtyWriteでbackspaceで左削除 | E-01 (L1483-1484) | ○ |
| C-065 | kTtyWriteでdeleteで右削除 | E-01 (L1487-1488) | ○ |
| C-066 | kTtyWriteでleftで左移動 | E-01 (L1491-1493) | ○ |
| C-067 | kTtyWriteでrightで右移動 | E-01 (L1496-1497) | ○ |
| C-068 | kTtyWriteでupで履歴遡り | E-01 (L1508-1510) | ○ |
| C-069 | kTtyWriteでdownで履歴進行 | E-01 (L1513-1515) | ○ |
| C-070 | kTtyWriteでhomeで行頭移動 | E-01 (L1500-1501) | ○ |
| C-071 | kTtyWriteでendで行末移動 | E-01 (L1504-1505) | ○ |
| C-072 | kTtyWriteでescapeキー無視 | E-01 (L1306) | ○ |
| C-073 | kNormalWriteで改行でlineイベント | E-01 (L612-657) | ○ |
| C-074 | kNormalWriteで改行なしでバッファ | E-01 (L649-656) | ○ |
| C-075 | kNormalWriteでCRLF処理 | E-01 (L617-623, L634-636) | ○ |
| C-076 | getCursorPosでカーソル位置取得 | E-01 (L1223-1227) | ○ |
| C-077 | kGetDisplayPosで表示位置計算 | E-01 (L1178-1213) | ○ |
| C-078 | kGetDisplayPosで複数行計算 | E-01 (L1185-1190) | ○ |
| C-079 | kGetDisplayPosでタブ計算 | E-01 (L1193-1195) | ○ |
| C-080 | kGetDisplayPosで全角文字幅 | E-01 (L1197-1206) | ○ |
| C-081 | clearLineで行クリア | E-01 (L939-945) | ○ |
| C-082 | kRefreshLineで行再描画 | E-01 (L493-542) | ○ |
| C-083 | kSetRawModeでrawモード設定 | E-01 (L414-422) | ○ |
| C-084 | kWriteToOutputで出力書き込み | E-01 (L481-487) | ○ |
| C-085 | kWriteToOutput文字列以外エラー | E-01 (L482) | ○ |
| C-086 | SymbolAsyncIteratorでAsyncIterator返却 | E-01 (L1560-1571) | ○ |
| C-087 | columns getterでoutput.columns返却 | E-01 (L362-365) | ○ |
| C-088 | columns getter境界値 | E-01 (L364) | ○ |
| C-089 | kIsMultilineで複数行検出 | E-01 (L455) | ○ |
| C-090 | kAddNewLineOnTTYでTTY改行追加 | E-01 (L966-1055) | ○ |
| C-091 | kMultilineMoveで上方向移動 | E-01 (L1094-1128) | ○ |
| C-092 | kMultilineMoveで下方向移動 | E-01 (L1094-1128) | ○ |
| C-093 | Readline constructorでインスタンス生成 | E-02 (L28-36) | ○ |
| C-094 | Readline constructor非Writableエラー | E-02 (L29-30) | ○ |
| C-095 | Readline autoCommitオプション | E-02 (L32-35) | ○ |
| C-096 | Readline cursorToでカーソル移動 | E-02 (L44-53) | ○ |
| C-097 | Readline cursorTo autoCommit | E-02 (L49) | ○ |
| C-098 | Readline cursorTo xバリデーション | E-02 (L45) | ○ |
| C-099 | Readline moveCursorで相対移動 | E-02 (L61-83) | ○ |
| C-100 | Readline moveCursor境界値 | E-02 (L62) | ○ |
| C-101 | Readline clearLine左クリア | E-02 (L93-103) | ○ |
| C-102 | Readline clearLine右クリア | E-02 (L93-103) | ○ |
| C-103 | Readline clearLine全行クリア | E-02 (L93-103) | ○ |
| C-104 | Readline clearLineバリデーション | E-02 (L94) | ○ |
| C-105 | Readline clearScreenDownで画面下クリア | E-02 (L109-116) | ○ |
| C-106 | Readline commitでストリーム書き込み | E-02 (L124-129) | ○ |
| C-107 | Readline commit後todoクリア | E-02 (L127) | ○ |
| C-108 | Readline rollbackで破棄 | E-02 (L136-139) | ○ |
| C-109 | charLengthLeftでASCII文字長 | E-03 (L39-48) | ○ |
| C-110 | charLengthLeftでサロゲートペア | E-03 (L42-45) | ○ |
| C-111 | charLengthLeft境界値 | E-03 (L40-41) | ○ |
| C-112 | charLengthAtでASCII文字長 | E-03 (L50-57) | ○ |
| C-113 | charLengthAtでサロゲートペア | E-03 (L56) | ○ |
| C-114 | charLengthAt境界値 | E-03 (L51-54) | ○ |
| C-115 | commonPrefixで共通プレフィックス | E-03 (L381-397) | ○ |
| C-116 | commonPrefix空配列 | E-03 (L382-384) | ○ |
| C-117 | commonPrefix単一要素 | E-03 (L385-387) | ○ |
| C-118 | commonPrefix共通なし | E-03 (L388-396) | ○ |
| C-119 | emitKeysで通常文字keypress | E-03 (L86-378) | ○ |
| C-120 | emitKeysでCtrl+文字 | E-03 (L350-355) | ○ |
| C-121 | emitKeysでエスケープシーケンス | E-03 (L108-326) | ○ |
| C-122 | emitKeysでファンクションキー | E-03 (L224-260) | ○ |
| C-123 | emitKeysで修飾キー付きシーケンス | E-03 (L216-218) | ○ |
| C-124 | emitKeysでShift+矢印 | E-03 (L297-300) | ○ |
| C-125 | emitKeysでペーストブラケット開始 | E-03 (L242) | ○ |
| C-126 | emitKeysでペーストブラケット終了 | E-03 (L243) | ○ |
| C-127 | CSIでシーケンス生成 | E-03 (L19-27) | ○ |
| C-128 | CSIで引数付きシーケンス | E-03 (L19-27) | ○ |
| C-129 | reverseStringで逆順 | E-03 (L399-411) | ○ |
| C-130 | emitKeypressEventsでkeypress設定 | E-04 (L34-97) | ○ |
| C-131 | emitKeypressEvents重複設定防止 | E-04 (L35) | ○ |
| C-132 | emitKeypressEvents遅延設定 | E-04 (L92-96) | ○ |
| C-133 | emitKeypressEventsエスケープタイムアウト | E-04 (L43-44, L67), **タイムアウト動作は実行時テスト必要** | △ |
| C-134 | cursorTo (callbacks)で絶対移動 | E-05 (L33-55) | ○ |
| C-135 | cursorTo (callbacks)で列のみ移動 | E-05 (L53) | ○ |
| C-136 | cursorTo (callbacks) NaNエラー | E-05 (L43-44) | ○ |
| C-137 | cursorTo (callbacks) null stream | E-05 (L46-48) | ○ |
| C-138 | cursorTo (callbacks)コールバック | E-05 (L54) | ○ |
| C-139 | moveCursor (callbacks)で相対移動 | E-05 (L61-86) | ○ |
| C-140 | moveCursor (callbacks)ゼロ移動 | E-05 (L66-68) | ○ |
| C-141 | clearLine (callbacks)左クリア | E-05 (L95-108) | ○ |
| C-142 | clearLine (callbacks)右クリア | E-05 (L95-108) | ○ |
| C-143 | clearLine (callbacks)全行クリア | E-05 (L95-108) | ○ |
| C-144 | clearLine (callbacks) null stream | E-05 (L100-102) | ○ |
| C-145 | clearScreenDown (callbacks)画面下クリア | E-05 (L114-125) | ○ |
| C-146 | clearScreenDown (callbacks) null stream | E-05 (L119-121) | ○ |
| C-147 | clearScreenDown (callbacks)コールバック | E-05 (L124) | ○ |
| C-148 | kQuestionCancelでquestion取り消し | E-01 (L473-479) | ○ |
| C-149 | kLineで行確定処理 | E-01 (L947-954) | ○ |
| C-150 | setupHistoryManagerでhistoryManager初期化 | E-01 (L384-412), **ReplHistory詳細は別ファイル** | △ |

## 4) 不足情報（Unknown / Missing）
- **historyManagerの詳細実装**：`internal/repl/history`モジュールにReplHistoryクラスが定義されており、履歴ナビゲーションの詳細ロジックはそちらに依存
  - 候補：`lib/internal/repl/history.js`の解析
- **エスケープコードタイムアウトの動作検証**：setTimeoutによるタイムアウト処理は実行時の動作確認が必要
  - 候補：統合テストでの検証

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：大部分のテストケースがソースコードで直接確認可能
- 1（中リスク）：履歴管理機能（UT-RDL-039, 040, 150）は外部モジュール依存
- 0（低リスク）：タイムアウト機能（UT-RDL-133）は単体テストでは検証困難だが、機能的には明確

## 6) レビュアーチェックリスト（最小）
- [ ] Interfaceクラスのコンストラクタオプションのバリデーションテストが網羅されているか
- [ ] キーボードショートカット（Ctrl+*, Meta+*）のテストが漏れなく記載されているか
- [ ] 境界値テスト（カーソル位置0/末尾、空文字列、最大スタック長等）が適切に設定されているか
- [ ] historyManager関連のテストは、ReplHistoryクラスの単体テストと分離されているか
- [ ] サロゲートペア（絵文字等）の処理テストが含まれているか
- [ ] TTYモードと非TTYモードの両方のパスがテストされているか
- [ ] Readlineクラス（Promise版）とcallbacks版の両方の関数がテストされているか
