---
generated_at: 2026-01-30 10:00:00
metrics:
  claims_total: 200
  claims_with_evidence: 200
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lib-internal-root 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：200 / 200、根拠なし：0
- 優先レビュー（高）
  1. **特になし**：全テストケースがソースコードの関数・メソッドに対応

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/linkedlist.js` - 双方向リンクリストの実装（init, peek, remove, append, isEmpty）
- E-02: `lib/internal/fixed_queue.js` - 固定サイズ循環バッファとキューの実装（FixedCircularBuffer, FixedQueue）
- E-03: `lib/internal/priority_queue.js` - 優先度キュー（バイナリヒープ）の実装（PriorityQueue）
- E-04: `lib/internal/validators.js` - 引数バリデーション関数群（validateInteger, validateString, validatePort等）
- E-05: `lib/internal/util.js` - 汎用ユーティリティ関数群（normalizeEncoding, deprecate, promisify, isError, once, sleep等）
- E-06: `lib/internal/abort_controller.js` - AbortController/AbortSignal実装
- E-07: `lib/internal/freelist.js` - オブジェクトプールの実装（FreeList）
- E-08: `lib/internal/cli_table.js` - CLIテーブルフォーマット（table, renderRow）
- E-09: `lib/internal/blob.js` - Blob API実装（Blob, isBlob, resolveObjectURL）
- E-10: `lib/internal/event_target.js` - Event/EventTarget/CustomEvent実装
- E-11: `lib/internal/histogram.js` - Histogram/RecordableHistogram実装
- E-12: `lib/internal/querystring.js` - URLエンコード関数（encodeStr, hexTable, isHexTable）
- E-13: `lib/internal/mime.js` - MIME型パース/パラメータ処理（MIMEParams, parseTypeAndSubtype）
- E-14: `lib/internal/buffer.js` - Bufferプロトタイプメソッド群（read/write系）

## 3) Claims と根拠の対応（レビューの主戦場）

### linkedlist.js (UT-LIR-001 〜 UT-LIR-008)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | init関数がリストを初期化する | E-01 (line 3-7) | ○ |
| C-02 | peek関数が末尾アイテムを返す | E-01 (line 10-13) | ○ |
| C-03 | remove関数がアイテムを削除する | E-01 (line 16-27) | ○ |
| C-04 | append関数がアイテムを追加する | E-01 (line 30-43) | ○ |
| C-05 | isEmpty関数が空判定を行う | E-01 (line 45-47) | ○ |

### fixed_queue.js (UT-LIR-009 〜 UT-LIR-020)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | FixedCircularBufferが循環バッファを実装 | E-02 (line 60-89) | ○ |
| C-07 | FixedQueueがリンク連結キューを実装 | E-02 (line 91-119) | ○ |
| C-08 | push/shift操作が正しく動作 | E-02 (line 76-88, 100-118) | ○ |

### priority_queue.js (UT-LIR-021 〜 UT-LIR-029)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | PriorityQueueがバイナリヒープを実装 | E-03 (line 9-119) | ○ |
| C-10 | percolateUp/Downがヒープ特性を維持 | E-03 (line 38-92) | ○ |
| C-11 | insert/shift/removeAtが正しく動作 | E-03 (line 22-118) | ○ |

### validators.js (UT-LIR-030 〜 UT-LIR-066)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | isInt32/isUint32が32ビット整数判定 | E-04 (line 46-56) | ○ |
| C-13 | parseFileModeが8進数をパース | E-04 (line 72-83) | ○ |
| C-14 | validateInteger/Int32/Uint32が整数検証 | E-04 (line 95-153) | ○ |
| C-15 | validateString/Number/Booleanが型検証 | E-04 (line 163-222) | ○ |
| C-16 | validateObjectがオブジェクト検証 | E-04 (line 242-272) | ○ |
| C-17 | validateArrayが配列検証 | E-04 (line 302-310) | ○ |
| C-18 | validateFunctionが関数検証 | E-04 (line 461-464) | ○ |
| C-19 | validatePortがポート番号検証 | E-04 (line 426-435) | ○ |
| C-20 | validateAbortSignalがAbortSignal検証 | E-04 (line 444-451) | ○ |
| C-21 | validateOneOfが列挙値検証 | E-04 (line 200-209) | ○ |

### util.js (UT-LIR-067 〜 UT-LIR-099)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | normalizeEncodingがエンコーディング正規化 | E-05 (line 259-316) | ○ |
| C-23 | deprecateが非推奨警告を実装 | E-05 (line 178-219) | ○ |
| C-24 | promisifyがコールバック関数をPromise化 | E-05 (line 476-535) | ○ |
| C-25 | isErrorがエラー判定 | E-05 (line 100-105) | ○ |
| C-26 | onceが一度だけ実行を保証 | E-05 (line 596-606) | ○ |
| C-27 | sleepが同期スリープを実装 | E-05 (line 610-617) | ○ |
| C-28 | joinが配列を結合 | E-05 (line 540-552) | ○ |
| C-29 | spliceOneが要素を削除 | E-05 (line 556-560) | ○ |
| C-30 | getConstructorOfがコンストラクタを取得 | E-05 (line 413-426) | ○ |
| C-31 | filterDuplicateStringsが重複を除去 | E-05 (line 334-346) | ○ |
| C-32 | cachedResultがキャッシュを実装 | E-05 (line 348-355) | ○ |
| C-33 | convertToValidSignalがシグナル変換 | E-05 (line 390-400) | ○ |
| C-34 | WeakReferenceが弱参照を実装 | E-05 (line 906-937) | ○ |

### abort_controller.js (UT-LIR-100 〜 UT-LIR-116)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | AbortControllerがsignal/abortを実装 | E-06 (line 491-521) | ○ |
| C-36 | AbortSignalがaborted/reason/throwIfAbortedを実装 | E-06 (line 163-408) | ○ |
| C-37 | AbortSignal.abort/timeout/anyが静的メソッド | E-06 (line 229-327) | ○ |
| C-38 | aborted関数が非同期待機を実装 | E-06 (line 548-557) | ○ |

### freelist.js (UT-LIR-117 〜 UT-LIR-121)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | FreeListがalloc/freeを実装 | E-07 (line 7-28) | ○ |

### cli_table.js (UT-LIR-122 〜 UT-LIR-123)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | table関数がテーブルをフォーマット | E-08 (line 54-92) | ○ |
| C-41 | renderRow関数が行をレンダリング | E-08 (line 38-52) | ○ |

### blob.js (UT-LIR-124 〜 UT-LIR-136)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | Blobがconstructor/type/size/sliceを実装 | E-09 (line 129-274) | ○ |
| C-43 | Blobがarraybuffer/text/bytes/streamを実装 | E-09 (line 279-319) | ○ |
| C-44 | isBlobがBlob判定を実装 | E-09 (line 104-106) | ○ |

### event_target.js (UT-LIR-137 〜 UT-LIR-166)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | Eventがtype/target/preventDefaultを実装 | E-10 (line 99-337) | ○ |
| C-46 | CustomEventがdetailを実装 | E-10 (line 392-417) | ○ |
| C-47 | EventTargetがaddEventListener/removeEventListener/dispatchEventを実装 | E-10 (line 560-878) | ○ |
| C-48 | NodeEventTargetがon/off/emit/onceを実装 | E-10 (line 897-1040) | ○ |

### histogram.js (UT-LIR-167 〜 UT-LIR-180)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | Histogramがcount/min/max/mean/stddev/percentileを実装 | E-11 (line 58-268) | ○ |
| C-50 | RecordableHistogramがrecord/recordDelta/addを実装 | E-11 (line 271-328) | ○ |
| C-51 | createHistogramがRecordableHistogramを作成 | E-11 (line 367-384) | ○ |

### querystring.js (UT-LIR-181 〜 UT-LIR-183)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | encodeStrがURL文字列をエンコード | E-12 (line 45-113) | ○ |
| C-53 | hexTableがパーセントエンコーディング用テーブル | E-12 (line 14-18) | ○ |

### mime.js (UT-LIR-184 〜 UT-LIR-189)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | MIMEParamsがget/set/has/deleteを実装 | E-13 (line 126-200) | ○ |

### buffer.js (UT-LIR-190 〜 UT-LIR-200)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | readBigUInt64LE/BEがBigInt読み取りを実装 | E-14 (line 98-136) | ○ |
| C-56 | readBigInt64LE/BEが符号付きBigInt読み取りを実装 | E-14 (line 138-172) | ○ |
| C-57 | readUIntLE/BE系が可変長読み取りを実装 | E-14 (line 174-341) | ○ |
| C-58 | writeBigUInt64LE/BEがBigInt書き込みを実装 | E-14 (line 584-644) | ○ |
| C-59 | writeUInt系が整数書き込みを実装 | E-14 (line 646-901) | ○ |
| C-60 | readFloat/writeFloat系が浮動小数点数を処理 | E-14 (line 519-958) | ○ |
| C-61 | boundsError/checkIntが境界チェックを実装 | E-14 (line 58-95) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全てのテストケースはソースコードの関数・メソッドに基づいて作成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードから直接導出されており、主要な関数・メソッドをカバーしている

## 6) レビュアーチェックリスト（最小）
- [ ] 全200件のテストケースがlib/internal/直下の52ファイルをカバーしているか確認
- [ ] 高優先度のテストケース（validators, abort_controller, blob, event_target）が適切に定義されているか確認
- [ ] 境界値テストと異常系テストが主要な関数に対して定義されているか確認
- [ ] テストIDの命名規則（UT-LIR-XXX）が一貫しているか確認
