---
generated_at: 2026-01-30 18:25:00
metrics:
  claims_total: 109
  claims_with_evidence: 109
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lib-internal-source_map 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：109 / 109、根拠なし：0
- 優先レビュー（高）
  1. **VLQデコード関連テスト（UT-SMP-024〜027）**：base64Map初期化の前提条件の確認が必要
  2. **GC関連テスト（UT-SMP-038, 041）**：WeakRef/FinalizationRegistryの動作はランタイム依存
  3. **ファイルI/O関連テスト（UT-SMP-086〜088）**：テスト環境でのファイル準備が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/source_map/source_map.js` (394行)
- E-02: `lib/internal/source_map/source_map_cache_map.js` (118行)
- E-03: `lib/internal/source_map/prepare_stack_trace.js` (204行)
- E-04: `lib/internal/source_map/source_map_cache.js` (468行)
- E-05: Source Map V3 仕様 (https://github.com/google/closure-compiler/wiki/Source-Maps)
- E-06: TC39 Source Map 仕様 (https://tc39.es/ecma426/)

## 3) Claims と根拠の対応（レビューの主戦場）

### source_map.js 関連（UT-SMP-001〜032）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StringCharIteratorがコンストラクタで文字列と位置を初期化する | E-01 (L89-96) | ○ |
| C-02 | nextメソッドが現在位置の文字を返し位置を進める | E-01 (L98-103) | ○ |
| C-03 | peekメソッドが位置を変えずに現在文字を返す | E-01 (L105-110) | ○ |
| C-04 | hasNextが残り文字の有無を判定する | E-01 (L112-117) | ○ |
| C-05 | SourceMapコンストラクタがpayloadをクローンして保持する | E-01 (L136-149) | ○ |
| C-06 | lineLengthsオプションが配列の場合のみ設定される | E-01 (L146-148) | ○ |
| C-07 | payloadゲッターがクローンを返す | E-01 (L154-156) | ○ |
| C-08 | lineLengthsゲッターがスライスを返すかundefined | E-01 (L165-170) | ○ |
| C-09 | findEntryがバイナリサーチで位置を検索する | E-01 (L196-226) | ○ |
| C-10 | findOriginが1-indexedから0-indexedに変換して検索する | E-01 (L233-252) | ○ |
| C-11 | isSeparatorがカンマとセミコロンを判定する | E-01 (L323-325) | ○ |
| C-12 | decodeVLQがbase64エンコードされたVLQ値をデコードする | E-01 (L331-357) | ○ |
| C-13 | cloneSourceMapV3がオブジェクトを検証しクローンする | E-01 (L363-373) | ○ |
| C-14 | compareSourceMapEntryが行・列番号で比較する | E-01 (L381-388) | ○ |

### source_map_cache_map.js 関連（UT-SMP-033〜041）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | SourceMapCacheMapがSafeMapとWeakRefで実装される | E-02 (L31-53) | ○ |
| C-16 | setメソッドが複数キーで同一WeakRefを登録する | E-02 (L63-68) | ○ |
| C-17 | getメソッドがWeakRefからモジュールインスタンスを取得する | E-02 (L75-82) | ○ |
| C-18 | sizeゲッターがweakModuleMapのサイズを返す | E-02 (L89-91) | ○ |
| C-19 | イテレータが有効なエントリのみを返す | E-02 (L93-110) | ○ |
| C-20 | FinalizationRegistryでGC時にエントリが削除される | E-02 (L42-52) | ○ |

### prepare_stack_trace.js 関連（UT-SMP-042〜057）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | prepareStackTraceWithSourceMapsがエラー文字列とトレースを結合する | E-03 (L28-70) | ○ |
| C-22 | NodeErrorの場合codeを含むエラー文字列になる | E-03 (L30-34) | ○ |
| C-23 | traceが空の場合エラー文字列のみ返す | E-03 (L36-38) | ○ |
| C-24 | SourceMapが見つからない場合デフォルト形式を使用する | E-03 (L59-67) | ○ |
| C-25 | serializeJSStackFrameが元ソース位置に変換する | E-03 (L82-118) | ○ |
| C-26 | isAsyncでasyncプレフィックスを付加する | E-03 (L102-105) | ○ |
| C-27 | isConstructorでnewプレフィックスを付加する | E-03 (L106-108) | ○ |
| C-28 | getOriginalSymbolNameがenclosingEntryまたはcallerCallSiteから名前を取得する | E-03 (L122-138) | ○ |
| C-29 | getErrorSourceがソース行とポインタを含む文字列を生成する | E-03 (L149-176) | ○ |
| C-30 | getSourceMapErrorSourceがfindSourceMapとgetErrorSourceを組み合わせる | E-03 (L185-197) | ○ |

### source_map_cache.js 関連（UT-SMP-058〜109）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | sourceMapsSupport状態がObjectFreezeで不変になる | E-04 (L53-58) | ○ |
| C-32 | setSourceMapsSupportがenabledとオプションを検証する | E-04 (L71-95) | ○ |
| C-33 | extractSourceURLMagicCommentが最後のsourceURLを抽出する | E-04 (L105-121) | ○ |
| C-34 | extractSourceMapURLMagicCommentが最後のsourceMappingURLを抽出する | E-04 (L131-143) | ○ |
| C-35 | maybeCacheSourceMapがサポート状態とオプションを確認してキャッシュする | E-04 (L157-200) | ○ |
| C-36 | maybeCacheGeneratedSourceMapがeval済みソースをキャッシュする | E-04 (L206-227) | ○ |
| C-37 | dataFromUrlがdata URLとファイルURLを処理する | E-04 (L237-252) | ○ |
| C-38 | lineLengthsが改行コードで行長を計算する | E-04 (L257-275) | ○ |
| C-39 | sourceMapFromFileがファイルを読み込みJSONパースする | E-04 (L282-291) | ○ |
| C-40 | sourceMapFromDataUrlがbase64またはプレーンテキストをデコードする | E-04 (L295-316) | ○ |
| C-41 | sourcesToAbsoluteが相対パスを絶対URLに変換する | E-04 (L322-334) | ○ |
| C-42 | sourceMapCacheToObjectがキャッシュをオブジェクトに変換する | E-04 (L343-359) | ○ |
| C-43 | findSourceMapが登録済みSourceMapを検索して返す | E-04 (L369-404) | ○ |
| C-44 | getOriginalSourceがsourcesContentまたはファイルからソースを取得する | E-04 (L412-433) | ○ |
| C-45 | getSourceLineが指定行のソースを返す | E-04 (L442-457) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
- 全てのテストケースがソースコードから直接導出されている

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいて作成されている
- **1: 中リスク（環境依存）**:
  - GC関連テスト（UT-SMP-038, 041）: WeakRef/FinalizationRegistryの動作はJSエンジンのGCタイミングに依存
  - ファイルI/O関連テスト: テスト実行環境でのファイル準備が必要
- **1: 中リスク（外部仕様依存）**:
  - VLQデコード（UT-SMP-024〜027）: Source Map V3仕様に準拠した実装
  - data URL処理（UT-SMP-079, 089〜092）: RFC 2397仕様に準拠

## 6) レビュアーチェックリスト（最小）
- [ ] VLQデコードのテストケースがSource Map V3仕様の全エッジケースをカバーしているか
- [ ] WeakRef/FinalizationRegistry関連のテストが確定的に実行可能か（またはスキップ条件があるか）
- [ ] ファイルI/Oテストのためのテストフィクスチャが適切に準備されているか
- [ ] node_modules配下のソースマップ除外ロジックのテストが網羅的か
- [ ] 複数行に跨るマッピングのテストケース（UT-SMP-017）の入力値が十分に複雑か
- [ ] data URL処理でbase64とプレーンテキストの両方のケースがカバーされているか
- [ ] エラーハンドリング（debug関数でのログ出力）が適切にテストされているか
