---
generated_at: 2026-01-30 12:30:00
metrics:
  claims_total: 220
  claims_with_evidence: 215
  claims_without_evidence: 5
confidence_derived: 0.98
---

# 根拠レポート：lib-internal-streams 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：215 / 220、根拠なし：5
- 優先レビュー（高）
  1. **UT-STR-072, 073 (sleep関数)**：sleep関数は内部ヘルパーであり、実際のテスト必要性は要検討
  2. **UT-STR-159, 160 (setDefaultHighWaterMark)**：グローバル状態を変更するため、テストの副作用に注意
  3. **UT-STR-070, 071 (Utf8Stream.reopen)**：ファイル操作に依存するため、モック化が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `lib/internal/streams/add-abort-signal.js` - AbortSignal関連の実装
- E-02: `lib/internal/streams/compose.js` - compose関数の実装
- E-03: `lib/internal/streams/destroy.js` - destroy、construct関連の実装
- E-04: `lib/internal/streams/duplex.js` - Duplexクラスの実装
- E-05: `lib/internal/streams/duplexify.js` - duplexify関数の実装
- E-06: `lib/internal/streams/duplexpair.js` - DuplexSide、duplexPairの実装
- E-07: `lib/internal/streams/end-of-stream.js` - eos、finished関数の実装
- E-08: `lib/internal/streams/fast-utf8-stream.js` - Utf8Streamクラスの実装
- E-09: `lib/internal/streams/from.js` - from関数の実装
- E-10: `lib/internal/streams/lazy_transform.js` - LazyTransformクラスの実装
- E-11: `lib/internal/streams/legacy.js` - Stream、pipe、prependListenerの実装
- E-12: `lib/internal/streams/operators.js` - map、filter、reduce等の演算子実装
- E-13: `lib/internal/streams/passthrough.js` - PassThroughクラスの実装
- E-14: `lib/internal/streams/pipeline.js` - pipeline関数の実装
- E-15: `lib/internal/streams/readable.js` - Readable、ReadableStateクラスの実装
- E-16: `lib/internal/streams/state.js` - highWaterMark関連の実装
- E-17: `lib/internal/streams/transform.js` - Transformクラスの実装
- E-18: `lib/internal/streams/utils.js` - 型判定ユーティリティの実装
- E-19: `lib/internal/streams/writable.js` - Writable、WritableStateクラスの実装

## 3) Claims と根拠の対応（レビューの主戦場）

### add-abort-signal.js (UT-STR-001 〜 UT-STR-008)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | validateAbortSignalが'aborted'プロパティを検証する | E-01 (L26-31) | ○ |
| C-002 | addAbortSignalがisNodeStreamとisWebStreamで検証する | E-01 (L35-37) | ○ |
| C-003 | abort時にstream.destroyが呼ばれる | E-01 (L45-51) | ○ |
| C-004 | signal.abortedがtrueの場合に即座にonAbortが呼ばれる | E-01 (L52-58) | ○ |

### compose.js (UT-STR-009 〜 UT-STR-015)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-005 | 引数なしでERR_MISSING_ARGSがスローされる | E-02 (L29-31) | ○ |
| C-006 | 単一ストリームでDuplex.fromが返る | E-02 (L33-35) | ○ |
| C-007 | 中間ストリームのreadable/writable検証 | E-02 (L53-80) | ○ |
| C-008 | WebストリームとNodeストリームの組み合わせ対応 | E-02 (L149-172) | ○ |

### destroy.js (UT-STR-016 〜 UT-STR-028)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-009 | destroyでkDestroyedビットが設定される | E-03 (L71-76) | ○ |
| C-010 | construction中はdestroyが遅延される | E-03 (L78-85) | ○ |
| C-011 | undestroyで状態がリセットされる | E-03 (L173-202) | ○ |
| C-012 | errorOrDestroyでautoDestroyに応じた処理 | E-03 (L204-241) | ○ |
| C-013 | constructでkConstructイベントが発火 | E-03 (L244-306) | ○ |
| C-014 | destroyerがストリームタイプに応じた処理 | E-03 (L322-353) | ○ |

### duplex.js (UT-STR-029 〜 UT-STR-037)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-015 | newなしでnew Duplexが返る | E-04 (L64-66) | ○ |
| C-016 | readable/writableオプションの処理 | E-04 (L92-103) | ○ |
| C-017 | allowHalfOpenのデフォルト値 | E-04 (L90, L126) | ○ |
| C-018 | Duplex.from/fromWeb/toWebの実装 | E-04 (L188-203) | ○ |

### duplexify.js (UT-STR-038 〜 UT-STR-045)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-019 | DuplexNodeStreamはそのまま返る | E-05 (L61-63) | ○ |
| C-020 | Readable/Writable/Blob/Iterable等の変換 | E-05 (L65-153) | ○ |
| C-021 | 無効な型でERR_INVALID_ARG_TYPE | E-05 (L204-208) | ○ |

### duplexpair.js (UT-STR-046 〜 UT-STR-049)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-022 | duplexPairが2つのDuplexSideを返す | E-06 (L55-61) | ○ |
| C-023 | 一方への書き込みが他方で読める | E-06 (L38-46) | ○ |
| C-024 | _finalで他方にpush(null) | E-06 (L49-52) | ○ |

### end-of-stream.js (UT-STR-050 〜 UT-STR-059)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-025 | eosがストリーム終了を検出 | E-07 (L69-289) | ○ |
| C-026 | Webストリーム対応(eosWeb) | E-07 (L291-322) | ○ |
| C-027 | AbortSignal対応 | E-07 (L266-286) | ○ |
| C-028 | finishedがPromiseを返す | E-07 (L324-345) | ○ |

### fast-utf8-stream.js (UT-STR-060 〜 UT-STR-073)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-029 | fd/destオプションでの初期化 | E-08 (L225-232) | ○ |
| C-030 | write/flush/flushSync/end/destroy/reopenの動作 | E-08 (L254-350) | ○ |
| C-031 | maxLengthでdropイベント発火 | E-08 (L831-834, L865-867) | ○ |
| C-032 | sleep関数の実装 | E-08 (L55-67) | △ |

### from.js (UT-STR-074 〜 UT-STR-080)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-033 | 文字列/BufferからReadable作成 | E-09 (L15-26) | ○ |
| C-034 | 同期/非同期Iterableからの変換 | E-09 (L28-37, L93-204) | ○ |
| C-035 | nullでERR_STREAM_NULL_VALUES | E-09 (L108-110, L131-133, L162-164, L189-191) | ○ |

### lazy_transform.js (UT-STR-081 〜 UT-STR-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-036 | 遅延初期化の実装 | E-10 (L22-40) | ○ |
| C-037 | decodeStrings=false設定 | E-10 (L25) | ○ |

### legacy.js (UT-STR-084 〜 UT-STR-090)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-038 | StreamがEventEmitterを継承 | E-11 (L11-15) | ○ |
| C-039 | pipe実装 | E-11 (L17-96) | ○ |
| C-040 | prependListenerの実装 | E-11 (L108-124) | ○ |

### operators.js (UT-STR-091 〜 UT-STR-111)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-041 | map/filter/some/every/find/forEach/reduce/toArray/flatMap/drop/take | E-12 | ○ |
| C-042 | concurrencyオプション | E-12 (L46-59) | ○ |
| C-043 | AbortSignal対応 | E-12 (L42-44, L62) | ○ |
| C-044 | ReduceAwareErrMissingArgs | E-12 (L229-234, L272-273) | ○ |

### passthrough.js (UT-STR-112 〜 UT-STR-114)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-045 | _transformでcb(null, chunk) | E-13 (L45-47) | ○ |

### pipeline.js (UT-STR-115 〜 UT-STR-123)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-046 | 複数ストリームのパイプライン接続 | E-14 (L182-415) | ○ |
| C-047 | エラー伝播と全ストリームdestroy | E-14 (L229-250) | ○ |
| C-048 | 引数検証 | E-14 (L191-193) | ○ |
| C-049 | AbortSignal対応 | E-14 (L203-213) | ○ |

### readable.js (UT-STR-124 〜 UT-STR-152)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-050 | Readableコンストラクタ | E-15 (L323-365) | ○ |
| C-051 | push/unshift/read/pipe/unpipe | E-15 | ○ |
| C-052 | pause/resume/isPaused | E-15 (L1237-1296) | ○ |
| C-053 | setEncoding | E-15 (L590-610) | ○ |
| C-054 | AsyncIterator対応 | E-15 (L1350-1419) | ○ |
| C-055 | from/fromWeb/toWeb/wrap | E-15 (L1764-1798) | ○ |

### state.js (UT-STR-153 〜 UT-STR-160)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-056 | getHighWaterMarkの実装 | E-16 (L33-45) | ○ |
| C-057 | getDefaultHighWaterMark | E-16 (L20-22) | ○ |
| C-058 | setDefaultHighWaterMark | E-16 (L24-31) | △ |

### transform.js (UT-STR-161 〜 UT-STR-168)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-059 | Transformコンストラクタ | E-17 (L82-124) | ○ |
| C-060 | _transform未実装でERR_METHOD_NOT_IMPLEMENTED | E-17 (L162-164) | ○ |
| C-061 | _write/_read/_finalの実装 | E-17 (L166-204) | ○ |

### utils.js (UT-STR-169 〜 UT-STR-198)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-062 | isReadableNodeStream/isWritableNodeStream/isDuplexNodeStream | E-18 (L36-66) | ○ |
| C-063 | isNodeStream/isWebStream | E-18 (L68-110) | ○ |
| C-064 | isIterable | E-18 (L112-118) | ○ |
| C-065 | isDestroyed/isFinished/isClosed | E-18 (L120-259) | ○ |
| C-066 | isReadable/isWritable | E-18 (L173-189) | ○ |
| C-067 | willEmitClose/isDisturbed/isErrored | E-18 (L285-316) | ○ |

### writable.js (UT-STR-199 〜 UT-STR-220)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-068 | Writableコンストラクタ | E-19 (L390-434) | ○ |
| C-069 | write/end/cork/uncork | E-19 (L451-866) | ○ |
| C-070 | setDefaultEncoding | E-19 (L533-541) | ○ |
| C-071 | pipeでERR_STREAM_CANNOT_PIPE | E-19 (L447-449) | ○ |
| C-072 | _writeでERR_METHOD_NOT_IMPLEMENTED | E-19 (L796-802) | ○ |
| C-073 | fromWeb/toWeb | E-19 (L1142-1150) | ○ |

## 4) 不足情報（Unknown / Missing）

以下の項目は根拠不足または追加確認が必要です：

1. **sleep関数 (UT-STR-072, 073)**
   - fast-utf8-stream.js内の内部ヘルパー関数
   - AtomicsWaitを使用したブロッキング処理
   - 実際のテストでこの関数を直接テストする必要性は低い可能性あり
   - 候補：テスト対象から除外 / 統合テストで間接的に確認

2. **setDefaultHighWaterMark (UT-STR-159, 160)**
   - グローバル状態を変更する関数
   - テスト後のクリーンアップが必要
   - 候補：テスト前後で元の値を保存・復元するフィクスチャが必要

3. **Utf8Stream.reopen (UT-STR-070, 071)**
   - ファイルシステムへの依存
   - 実際のファイル操作が必要
   - 候補：fsモックを使用 / 一時ディレクトリでのテスト

4. **Webストリームとの互換性テスト**
   - ReadableStream/WritableStream/TransformStreamの存在を前提
   - Node.jsバージョンによっては利用不可
   - 候補：ポリフィルの使用 / 条件付きテスト

5. **AbortController/AbortSignalの動作**
   - タイミング依存のテストが困難
   - 候補：fake timersの使用

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 説明 |
|---|---|---|
| 2: 高リスク | ファイルシステム操作 | Utf8Stream関連テストでは実ファイル操作が発生する可能性 |
| 2: 高リスク | グローバル状態変更 | setDefaultHighWaterMarkはグローバル状態を変更 |
| 1: 中リスク | 非同期タイミング | AbortSignal、ストリーム終了検出はタイミング依存 |
| 1: 中リスク | Web API依存 | WebStreamsはNode.jsバージョンに依存 |
| 0: 低リスク | 型判定ユーティリティ | 純粋関数で副作用なし |

## 6) レビュアーチェックリスト（最小）

- [ ] 各テストケースが対応するソースコードの行を特定できるか
- [ ] エラーコード（ERR_*）がソースコードと一致しているか
- [ ] 境界値テストが適切に設計されているか（特にhighWaterMark関連）
- [ ] AbortSignal関連テストのタイミング処理が適切か
- [ ] Webストリームとの互換性テストがNode.jsバージョンを考慮しているか
- [ ] ファイルシステム操作を含むテストがモック化または一時ディレクトリを使用しているか
- [ ] グローバル状態を変更するテストが適切にクリーンアップされるか
- [ ] 非同期処理のテストがPromise/async-awaitを適切に使用しているか
- [ ] エッジケース（null、undefined、空配列等）が網羅されているか
- [ ] Duplexストリームの双方向性が正しくテストされているか
