---
generated_at: 2026-01-30 18:25:00
metrics:
  claims_total: 33
  claims_with_evidence: 33
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lib-internal-test.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：33 / 33、根拠なし：0
- 優先レビュー（高）
  1. **UT-TST-030, UT-TST-031**: Worker間転送の統合テストは実行環境依存
  2. **UT-TST-005, UT-TST-006**: 境界値・異常系テストは実際のinternalBinding実装に依存
  3. **UT-TST-026**: kDeserializeにnullを渡した場合の動作は実装詳細に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/test/binding.js` - filteredInternalBinding関数定義（13-26行目）
- E-02: `lib/internal/test/binding.js` - module.isPreloading条件分岐（28-31行目）
- E-03: `lib/internal/test/binding.js` - module.exports定義（33行目）
- E-04: `lib/internal/test/binding.js` - process.emitWarning呼び出し（9-11行目）
- E-05: `lib/internal/test/transfer.js` - クラスE定義（17-21行目）
- E-06: `lib/internal/test/transfer.js` - クラスF定義（23-39行目）
- E-07: `lib/internal/test/transfer.js` - kCloneメソッド定義（29-34行目）
- E-08: `lib/internal/test/transfer.js` - kDeserializeメソッド定義（36-38行目）
- E-09: `lib/internal/test/transfer.js` - markTransferMode呼び出し（26行目）
- E-10: `lib/internal/test/transfer.js` - module.exports定義（41行目）
- E-11: `lib/internal/test/transfer.js` - process.emitWarning呼び出し（9-11行目）
- E-12: `lib/internal/worker/js_transferable` - kClone, kDeserialize, markTransferModeのインポート元

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | filteredInternalBinding: 通常のバインディングIDで内部バインディング取得 | E-01 | ○ |
| C-02 | filteredInternalBinding: internal_onlyで始まらないIDで正常取得 | E-01 | ○ |
| C-03 | filteredInternalBinding: internal_onlyで始まるIDでエラースロー | E-01 | ○ |
| C-04 | filteredInternalBinding: internal_only_で始まるIDでエラースロー | E-01 | ○ |
| C-05 | filteredInternalBinding: 空文字列IDの境界ケース | E-01 | ○ |
| C-06 | filteredInternalBinding: 存在しないバインディングIDの処理 | E-01 | ○ |
| C-07 | module.isPreloading: グローバルinternalBinding設定 | E-02 | ○ |
| C-08 | module.isPreloading: グローバルprimordials設定 | E-02 | ○ |
| C-09 | module.isPreloading: 非プリロード時のグローバル未設定 | E-02 | ○ |
| C-10 | module.exports: internalBindingエクスポート | E-03 | ○ |
| C-11 | module.exports: primordialsエクスポート | E-03 | ○ |
| C-12 | binding.js: process.emitWarning呼び出し | E-04 | ○ |
| C-13 | E.constructor: インスタンス生成 | E-05 | ○ |
| C-14 | E.constructor: 任意型の値サポート | E-05 | ○ |
| C-15 | E.constructor: null値の境界ケース | E-05 | ○ |
| C-16 | E.constructor: undefined値の境界ケース | E-05 | ○ |
| C-17 | F.constructor: インスタンス生成 | E-06 | ○ |
| C-18 | F.constructor: Eクラス継承確認 | E-06 | ○ |
| C-19 | F.constructor: markTransferMode呼び出し | E-09 | ○ |
| C-20 | F[kClone]: クローンデータ返却 | E-07 | ○ |
| C-21 | F[kClone]: deserializeInfo正確性 | E-07 | ○ |
| C-22 | F[kClone]: オブジェクトプロパティのクローン | E-07 | ○ |
| C-23 | F[kDeserialize]: インスタンス復元 | E-08 | ○ |
| C-24 | F[kDeserialize]: プロパティ上書き | E-08 | ○ |
| C-25 | F[kDeserialize]: 空オブジェクトの境界ケース | E-08 | ○ |
| C-26 | F[kDeserialize]: null入力の異常系 | E-08 | ○ |
| C-27 | transfer.js: Eクラスエクスポート | E-10 | ○ |
| C-28 | transfer.js: Fクラスエクスポート | E-10 | ○ |
| C-29 | transfer.js: process.emitWarning呼び出し | E-11 | ○ |
| C-30 | F transfer: Worker間転送可能性 | E-06, E-07, E-08, E-09 | ○ |
| C-31 | F transfer: 転送後メソッド利用可能性 | E-06, E-07, E-08 | ○ |
| C-32 | filteredInternalBinding: 'internal_only'完全一致ケース | E-01 | ○ |
| C-33 | filteredInternalBinding: 'internal_'プレフィックス判定正確性 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全テストケースにソースコードの根拠あり
- Worker間転送の詳細な動作検証には `lib/internal/worker/js_transferable` の追加解析が有効
  - 候補：`lib/internal/worker/js_transferable.js` / `test/parallel/test-messaging-maketransferable.js`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードから直接導出されている
- **1: 中リスク** - Worker間転送テスト（UT-TST-030, UT-TST-031）は実行環境に依存する統合テスト的性質を持つ
- **0: 低リスク** - internalBinding関連テストはNode.js内部APIの動作に依存するが、フィルタリングロジック自体は明確

## 6) レビュアーチェックリスト（最小）
- [ ] filteredInternalBindingのStringPrototypeStartsWith判定ロジックが正しく理解されているか確認
- [ ] FクラスのmarkTransferModeの引数(true, false)の意味を確認（transferable=true, cloneable=false）
- [ ] kCloneの返却オブジェクト構造（data, deserializeInfo）がjs_transferableの仕様と一致しているか確認
- [ ] Worker間転送テストの実行方法（test/parallel/test-messaging-maketransferable.js参照）を確認
- [ ] process.emitWarningの警告カテゴリがテストで正しく検証されるか確認
