---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 194
  claims_with_evidence: 194
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: lib-internal-test_runner 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧CSVの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：194 / 194、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースにソースコードからの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/test_runner/assert.js`
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/test_runner/test.js`
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/test_runner/coverage.js`
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/test_runner/runner.js`
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/test_runner/harness.js`
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/test_runner/utils.js`
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/test_runner/tests_stream.js`
- E-08: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/test_runner/snapshot.js`
- E-09: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/test_runner/mock/mock.js`
- E-10: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/test_runner/mock/mock_timers.js`
- E-11: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/test_runner/mock/loader.js`
- E-12: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/test_runner/reporter/spec.js`
- E-13: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/test_runner/reporter/tap.js`
- E-14: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/test_runner/reporter/dot.js`
- E-15: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/test_runner/reporter/junit.js`
- E-16: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/test_runner/reporter/lcov.js`
- E-17: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/test_runner/reporter/utils.js`
- E-18: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/test_runner/reporter/rerun.js`
- E-19: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/test_runner/reporter/v8-serializer.js`

## 3) Claims と根拠の対応（レビューの主戦場）

### assert.js 関連 (UT-TRN-001 - UT-TRN-005)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getAssertionMapでアサーションマップが初期化される | E-01 (L31-41: assertMapの初期化ロジック) | ○ |
| C-02 | getAssertionMapはキャッシュを返す | E-01 (L32-33: assertMapがundefinedでない場合早期return) | ○ |
| C-03 | registerでカスタムアサーションが登録できる | E-01 (L43-48: map.set(name, fn)) | ○ |
| C-04 | registerでnameが文字列でない場合エラー | E-01 (L44: validateString(name)) | ○ |
| C-05 | registerでfnが関数でない場合エラー | E-01 (L45: validateFunction(fn)) | ○ |

### test.js / TestPlan 関連 (UT-TRN-006 - UT-TRN-010)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | TestPlan constructorでexpectedが設定される | E-02 (L173-177: this.expected = count) | ○ |
| C-07 | TestPlan constructorで負の数はエラー | E-02 (L174: validateUint32(count)) | ○ |
| C-08 | check()で計画満了時にPromise解決 | E-02 (L205-217: #planMet()チェックとresolve) | ○ |
| C-09 | check()で計画未満・待機なしでエラー | E-02 (L219-224: ERR_TEST_FAILURE) | ○ |
| C-10 | count()でactualがインクリメント | E-02 (L238-239: this.actual++) | ○ |

### test.js / TestContext 関連 (UT-TRN-011 - UT-TRN-027)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | TestContext.signalでAbortSignal取得 | E-02 (L259-261: get signal()) | ○ |
| C-12 | TestContext.nameでテスト名取得 | E-02 (L263-265: get name()) | ○ |
| C-13 | TestContext.filePathでファイルパス取得 | E-02 (L267-269: get filePath()) | ○ |
| C-14 | TestContext.fullNameで完全名取得 | E-02 (L271-273: getFullName(this.#test)) | ○ |
| C-15 | TestContext.planでTestPlan作成 | E-02 (L291-300: this.#test.plan = new TestPlan) | ○ |
| C-16 | 二度目のplan設定でエラー | E-02 (L292-296: plan !== null時エラー) | ○ |
| C-17 | TestContext.assertでアサーションオブジェクト取得 | E-02 (L302-331: get assert()) | ○ |
| C-18 | TestContext.mockでMockTracker取得 | E-02 (L334-337: get mock()) | ○ |
| C-19 | TestContext.skipでテストスキップ | E-02 (L343-345: skip()) | ○ |
| C-20 | TestContext.todoでTODOマーク | E-02 (L347-349: todo()) | ○ |
| C-21 | TestContext.testでサブテスト作成 | E-02 (L351-368: test()) | ○ |
| C-22 | TestContext.beforeでフック登録 | E-02 (L370-378: before()) | ○ |
| C-23 | TestContext.afterでフック登録 | E-02 (L380-388: after()) | ○ |
| C-24 | TestContext.beforeEachでフック登録 | E-02 (L390-398: beforeEach()) | ○ |
| C-25 | TestContext.afterEachでフック登録 | E-02 (L400-408: afterEach()) | ○ |
| C-26 | TestContext.waitForで条件待機 | E-02 (L410-462: waitFor()) | ○ |
| C-27 | waitForタイムアウトでエラー | E-02 (L438-447: setTimeout + reject) | ○ |

### test.js / Test クラス関連 (UT-TRN-028 - UT-TRN-059)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | Test constructorでテスト初期化 | E-02 (L495-716: constructor) | ○ |
| C-29 | 親なしでルートテスト設定 | E-02 (L522-534: parent === null分岐) | ○ |
| C-30 | 親ありでネストレベル設定 | E-02 (L535-580: parent !== null分岐) | ○ |
| C-31 | concurrency数値で設定 | E-02 (L583-587: case 'number') | ○ |
| C-32 | concurrency=trueで並列数計算 | E-02 (L589-596: case 'boolean') | ○ |
| C-33 | concurrency無効型でエラー | E-02 (L598-601: default分岐) | ○ |
| C-34 | timeout設定 | E-02 (L603-612: timeout処理) | ○ |
| C-35 | skip=trueでfn=noop | E-02 (L614-616: skip処理) | ○ |
| C-36 | hasConcurrency判定 | E-02 (L766-768: hasConcurrency()) | ○ |
| C-37 | hasConcurrency境界値 | E-02 (L767: concurrency > activeSubtests) | ○ |
| C-38 | createSubtestでサブテスト作成 | E-02 (L838-881: createSubtest()) | ○ |
| C-39 | 終了済み親へのサブテスト作成でエラー | E-02 (L870-877: preventAddingSubtests) | ○ |
| C-40 | failでテスト失敗マーク | E-02 (L945-957: fail()) | ○ |
| C-41 | expectFailure=trueでpassed=true | E-02 (L950-951: expectFailure分岐) | ○ |
| C-42 | 二度目のfailで変更なし | E-02 (L946-948: error !== null早期return) | ○ |
| C-43 | passでテスト成功マーク | E-02 (L959-965: pass()) | ○ |
| C-44 | error設定済みでpass変更なし | E-02 (L960-962: error !== null早期return) | ○ |
| C-45 | diagnosticでメッセージ追加 | E-02 (L977-979: diagnostic()) | ○ |
| C-46 | startでテスト開始 | E-02 (L981-1007: start()) | ○ |
| C-47 | フィルタ時にfilteredRun | E-02 (L984-990: filtered分岐) | ○ |
| C-48 | runでテスト関数実行 | E-02 (L1046-1193: run()) | ○ |
| C-49 | beforeEach/afterEachフック実行 | E-02 (L1079-1085, L1070-1074: フック実行) | ○ |
| C-50 | タイムアウトでキャンセル | E-02 (L1137-1139: kTestTimeoutFailure) | ○ |
| C-51 | テスト関数エラーでfail | E-02 (L1143-1145: kTestCodeFailure) | ○ |
| C-52 | runHookでフック実行 | E-02 (L1021-1037: runHook()) | ○ |
| C-53 | フックエラーでERR_TEST_FAILURE | E-02 (L1032-1036: kHookFailure) | ○ |
| C-54 | postRunでendTime設定 | E-02 (L1198-1199: endTime設定) | ○ |
| C-55 | サブテスト失敗で親も失敗 | E-02 (L1217-1222: kSubtestsFailed) | ○ |
| C-56 | durationでミリ秒返却 | E-02 (L1339-1342: duration()) | ○ |
| C-57 | getTestNameWithAncestorsで祖先含む名前 | E-02 (L757-761: getTestNameWithAncestors()) | ○ |
| C-58 | willBeFilteredByNameパターンマッチ | E-02 (L738-748: willBeFilteredByName()) | ○ |
| C-59 | testSkipPatternsマッチでtrue | E-02 (L744-745: testSkipPatterns分岐) | ○ |

### test.js / TestHook, Suite 関連 (UT-TRN-060 - UT-TRN-065)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | TestHook初期化 | E-02 (L1407-1422: TestHook constructor) | ○ |
| C-61 | TestHook.run実行 | E-02 (L1423-1434: run()) | ○ |
| C-62 | エラー後再実行可能 | E-02 (L1424-1430: AbortControllerリセット) | ○ |
| C-63 | Suite初期化 | E-02 (L1460-1477: Suite constructor) | ○ |
| C-64 | Suiteサブテスト実行 | E-02 (L1497-1540: Suite.run()) | ○ |
| C-65 | beforeフック先行実行 | E-02 (L1518: runHook('before')) | ○ |

### coverage.js 関連 (UT-TRN-066 - UT-TRN-079)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | CoverageLine初期化 | E-03 (L48-59: CoverageLine constructor) | ○ |
| C-67 | getLines行取得 | E-03 (L73-134: getLines()) | ○ |
| C-68 | getLinesキャッシュ | E-03 (L77-79: #sourceLines.has(fileUrl)) | ○ |
| C-69 | ファイル読めない場合null | E-03 (L81-88: catch分岐でnull設定) | ○ |
| C-70 | ignoreコメント処理 | E-03 (L102-118: kIgnoreRegex処理) | ○ |
| C-71 | summaryサマリー生成 | E-03 (L136-286: summary()) | ○ |
| C-72 | cleanupディレクトリ削除 | E-03 (L315-319: rmSync) | ○ |
| C-73 | cleanup環境変数復元 | E-03 (L293-296: NODE_V8_COVERAGE復元) | ○ |
| C-74 | shouldSkipFileCoverageでnode:スキップ | E-03 (L471: file:で始まらないとtrue) | ○ |
| C-75 | node_modulesスキップ | E-03 (L507: StringPrototypeIncludes check) | ○ |
| C-76 | excludeGlobsフィルタ | E-03 (L481-487: excludeGlobs処理) | ○ |
| C-77 | setupCoverageでTestCoverage作成 | E-03 (L519-545: setupCoverage()) | ○ |
| C-78 | mapRangeToLinesマッピング | E-03 (L547-586: mapRangeToLines()) | ○ |
| C-79 | mergeCoverageScriptsマージ | E-03 (L588-634: mergeCoverageScripts()) | ○ |

### runner.js 関連 (UT-TRN-080 - UT-TRN-090)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | runでテストファイル実行 | E-04 (L595-911: run()) | ○ |
| C-81 | globPatternsフィルタ | E-04 (L647-649: globPatterns処理) | ○ |
| C-82 | shardオプション分割 | E-04 (L764-766: shard処理) | ○ |
| C-83 | files+globPatternsでエラー | E-04 (L653-658: ERR_INVALID_ARG_VALUE) | ○ |
| C-84 | forceExit+watchでエラー | E-04 (L638-643: ERR_INVALID_ARG_VALUE) | ○ |
| C-85 | isolation=noneでインプロセス | E-04 (L814-894: isolation === 'none'分岐) | ○ |
| C-86 | FileTest.parseMessage | E-04 (L310-396: parseMessage()) | ○ |
| C-87 | FileTest.addToReport | E-04 (L288-296: addToReport()) | ○ |
| C-88 | createTestFileListファイルリスト | E-04 (L120-138: createTestFileList()) | ○ |
| C-89 | node_modules除外 | E-04 (L128: exclude: (name) => name === 'node_modules') | ○ |
| C-90 | watchFilesウォッチャー作成 | E-04 (L501-593: watchFiles()) | ○ |

### harness.js 関連 (UT-TRN-091 - UT-TRN-099)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | createTestTreeでテストツリー作成 | E-05 (L43-113: createTestTree()) | ○ |
| C-92 | カウンター初期化 | E-05 (L57-68: resetCounters()) | ○ |
| C-93 | testでテスト登録 | E-05 (L372-379: test()) | ○ |
| C-94 | suiteでスイート登録 | E-05 (L410: suite: runInParentContext(Suite)) | ○ |
| C-95 | beforeフック登録 | E-05 (L411: before: hook('before')) | ○ |
| C-96 | afterフック登録 | E-05 (L412: after: hook('after')) | ○ |
| C-97 | beforeEachフック登録 | E-05 (L413: beforeEach: hook('beforeEach')) | ○ |
| C-98 | afterEachフック登録 | E-05 (L414: afterEach: hook('afterEach')) | ○ |
| C-99 | startSubtestAfterBootstrap | E-05 (L336-359: startSubtestAfterBootstrap()) | ○ |

### utils.js 関連 (UT-TRN-100 - UT-TRN-111)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | createDeferredCallback作成 | E-06 (L69-96: createDeferredCallback()) | ○ |
| C-101 | コールバック多重呼び出しエラー | E-06 (L77-85: kMultipleCallbackInvocations) | ○ |
| C-102 | isTestFailureError判定 | E-06 (L98-100: isTestFailureError()) | ○ |
| C-103 | 通常エラーでfalse | E-06 (L99: code === 'ERR_TEST_FAILURE') | ○ |
| C-104 | convertStringToRegExp変換 | E-06 (L102-118: convertStringToRegExp()) | ○ |
| C-105 | 正規表現リテラル解析 | E-06 (L103-105: kRegExpPattern) | ○ |
| C-106 | 無効正規表現でエラー | E-06 (L107-117: try/catch) | ○ |
| C-107 | parseCommandLine解析 | E-06 (L208-369: parseCommandLine()) | ○ |
| C-108 | countCompletedTestカウント | E-06 (L381-405: countCompletedTest()) | ○ |
| C-109 | スキップテストカウント | E-06 (L391-392: skipped分岐) | ○ |
| C-110 | 失敗テストカウント | E-06 (L398-400: !passed分岐) | ○ |
| C-111 | getCoverageReportレポート生成 | E-06 (L481-626: getCoverageReport()) | ○ |

### tests_stream.js 関連 (UT-TRN-112 - UT-TRN-118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | TestsStreamオブジェクトモード | E-07 (L16-19: objectMode: true) | ○ |
| C-113 | failでtest:failイベント | E-07 (L37-47: fail()) | ○ |
| C-114 | okでtest:passイベント | E-07 (L49-59: ok()) | ○ |
| C-115 | planでtest:planイベント | E-07 (L73-80: plan()) | ○ |
| C-116 | diagnosticでtest:diagnosticイベント | E-07 (L123-131: diagnostic()) | ○ |
| C-117 | coverageでtest:coverageイベント | E-07 (L133-140: coverage()) | ○ |
| C-118 | endでストリーム終了 | E-07 (L152-154: end()) | ○ |

### snapshot.js 関連 (UT-TRN-119 - UT-TRN-130)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | SnapshotFile.getSnapshotスナップショット取得 | E-08 (L67-77: getSnapshot()) | ○ |
| C-120 | 存在しないスナップショットでエラー | E-08 (L68-73: ERR_INVALID_STATE) | ○ |
| C-121 | setSnapshotスナップショット設定 | E-08 (L79-81: setSnapshot()) | ○ |
| C-122 | nextId連番ID生成 | E-08 (L83-87: nextId()) | ○ |
| C-123 | readFileファイル読み込み | E-08 (L89-115: readFile()) | ○ |
| C-124 | writeFileファイル書き込み | E-08 (L117-129: writeFile()) | ○ |
| C-125 | resolveSnapshotFileパス解決 | E-08 (L140-158: resolveSnapshotFile()) | ○ |
| C-126 | serializeシリアライズ | E-08 (L160-167: serialize()) | ○ |
| C-127 | createAssertアサーション作成 | E-08 (L188-209: createAssert()) | ○ |
| C-128 | createFileAssertアサーション作成 | E-08 (L211-242: createFileAssert()) | ○ |
| C-129 | setResolveSnapshotPathカスタマイズ | E-08 (L49-52: setResolveSnapshotPath()) | ○ |
| C-130 | setDefaultSnapshotSerializersカスタマイズ | E-08 (L54-57: setDefaultSnapshotSerializers()) | ○ |

### mock/mock.js 関連 (UT-TRN-131 - UT-TRN-153)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | MockFunctionContext.calls取得 | E-09 (L89-91: get calls()) | ○ |
| C-132 | callCount呼び出し回数 | E-09 (L97-99: callCount()) | ○ |
| C-133 | mockImplementation実装置換 | E-09 (L105-108: mockImplementation()) | ○ |
| C-134 | mockImplementationOnce一回限り実装 | E-09 (L115-121: mockImplementationOnce()) | ○ |
| C-135 | restore復元 | E-09 (L126-137: restore()) | ○ |
| C-136 | resetCallsリセット | E-09 (L142-144: resetCalls()) | ○ |
| C-137 | MockTracker.fnモック作成 | E-09 (L426-447: fn()) | ○ |
| C-138 | times自動復元 | E-09 (L163-166: nextImpl()でrestore) | ○ |
| C-139 | MockTracker.methodメソッドモック | E-09 (L459-537: method()) | ○ |
| C-140 | getterモック | E-09 (L523-525: getter分岐) | ○ |
| C-141 | setterモック | E-09 (L526-528: setter分岐) | ○ |
| C-142 | getter+setterでエラー | E-09 (L489-493: ERR_INVALID_ARG_VALUE) | ○ |
| C-143 | MockTracker.getterモック | E-09 (L551-577: getter()) | ○ |
| C-144 | MockTracker.setterモック | E-09 (L579-617: setter()) | ○ |
| C-145 | MockTracker.propertyモック | E-09 (L700-726: property()) | ○ |
| C-146 | resetリセット | E-09 (L731-735: reset()) | ○ |
| C-147 | restoreAll復元 | E-09 (L740-746: restoreAll()) | ○ |
| C-148 | timersプロパティ | E-09 (L413-416: get timers()) | ○ |
| C-149 | MockPropertyContext.accesses取得 | E-09 (L324-327: get accesses()) | ○ |
| C-150 | mockImplementation値設定 | E-09 (L342-358: mockImplementation()) | ○ |
| C-151 | mockImplementationOnce一回限り | E-09 (L377-382: mockImplementationOnce()) | ○ |
| C-152 | MockPropertyContext.restore復元 | E-09 (L394-400: restore()) | ○ |
| C-153 | MockModuleContext.restore復元 | E-09 (L249-272: restore()) | ○ |

### mock/mock_timers.js 関連 (UT-TRN-154 - UT-TRN-164)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-154 | MockTimers.enable有効化 | E-10 (L675-711: enable()) | ○ |
| C-155 | 既に有効化済みでエラー | E-10 (L677-679: ERR_INVALID_STATE) | ○ |
| C-156 | now初期時刻設定 | E-10 (L703-708: #now設定) | ○ |
| C-157 | tick時間進行 | E-10 (L640-664: tick()) | ○ |
| C-158 | tickでタイマー実行 | E-10 (L646-663: while loop) | ○ |
| C-159 | 未有効化でエラー | E-10 (L641: #assertTimersAreEnabled) | ○ |
| C-160 | 負の時間でエラー | E-10 (L642: #assertTimeArg) | ○ |
| C-161 | setTime時刻設定 | E-10 (L717-723: setTime()) | ○ |
| C-162 | resetリセット | E-10 (L736-749: reset()) | ○ |
| C-163 | runAll全実行 | E-10 (L755-760: runAll()) | ○ |
| C-164 | Timeout初期化 | E-10 (L71-78: Timeout constructor) | ○ |

### mock/loader.js 関連 (UT-TRN-165 - UT-TRN-167)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-165 | resolve mockURL解決 | E-11 (L18-43: resolve()) | ○ |
| C-166 | resolve通常解決 | E-11 (L27-29: mock?.active !== true分岐) | ○ |
| C-167 | loadモックモジュールロード | E-11 (L45-85: load()) | ○ |

### reporter/spec.js 関連 (UT-TRN-168 - UT-TRN-171)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-168 | _transformでtest:pass変換 | E-12 (L86-87: case 'test:pass') | ○ |
| C-169 | _transformでtest:fail変換 | E-12 (L81-85: case 'test:fail') | ○ |
| C-170 | test:diagnostic変換 | E-12 (L94-97: case 'test:diagnostic') | ○ |
| C-171 | test:coverage変換 | E-12 (L98-100: case 'test:coverage') | ○ |

### reporter/tap.js 関連 (UT-TRN-172 - UT-TRN-177)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-172 | TAPヘッダー出力 | E-13 (L32: TAP version) | ○ |
| C-173 | test:passでok出力 | E-13 (L40-42: case 'test:pass') | ○ |
| C-174 | test:failでnot ok出力 | E-13 (L35-39: case 'test:fail') | ○ |
| C-175 | skipディレクティブ | E-13 (L75-76: SKIP分岐) | ○ |
| C-176 | todoディレクティブ | E-13 (L77-78: TODO分岐) | ○ |
| C-177 | tapEscapeエスケープ | E-13 (L118-128: tapEscape()) | ○ |

### reporter/dot.js 関連 (UT-TRN-178 - UT-TRN-180)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-178 | test:passで緑ドット | E-14 (L14-15: colors.green + '.') | ○ |
| C-179 | test:failで赤X | E-14 (L17-19: colors.red + 'X') | ○ |
| C-180 | 行末改行 | E-14 (L21-27: count === columns分岐) | ○ |

### reporter/junit.js 関連 (UT-TRN-181 - UT-TRN-184)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-181 | XMLヘッダー出力 | E-15 (L65: xml version) | ○ |
| C-182 | testsuites出力 | E-15 (L66, L162: <testsuites>) | ○ |
| C-183 | test:passでtestcase | E-15 (L117: tag = 'testcase') | ○ |
| C-184 | test:failでfailure | E-15 (L134-145: failure処理) | ○ |

### reporter/lcov.js 関連 (UT-TRN-185 - UT-TRN-187)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-185 | test:coverageでLCOV出力 | E-16 (L15-104: _transform()) | ○ |
| C-186 | 関数カバレッジ出力 | E-16 (L49-56: FN, FNDA) | ○ |
| C-187 | 行カバレッジ出力 | E-16 (L83-87: DA) | ○ |

### reporter/utils.js 関連 (UT-TRN-188 - UT-TRN-191)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-188 | formatTestReportフォーマット | E-17 (L70-92: formatTestReport()) | ○ |
| C-189 | skip灰色表示 | E-17 (L87-89: skip分岐) | ○ |
| C-190 | formatErrorエラーフォーマット | E-17 (L60-68: formatError()) | ○ |
| C-191 | indentインデント | E-17 (L51-58: indent()) | ○ |

### reporter/rerun.js, v8-serializer.js 関連 (UT-TRN-192 - UT-TRN-194)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-192 | reportRerunsレポーター作成 | E-18 (L11-72: reportReruns()) | ○ |
| C-193 | v8Reporterシリアライズ出力 | E-19 (L11-45: v8Reporter()) | ○ |
| C-194 | エラーシリアライズ | E-19 (L17-23: serializeError) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全テストケースにソースコードからの根拠あり

## 5) リスクフラグ（レビュー観点）
- 0 (低リスク): 全テストケースがソースコードに基づいて生成されており、実装との整合性が高い
- Node.jsのtest_runnerモジュールは内部APIであり、バージョン間で変更される可能性がある点に注意

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがソースコードの主要なパブリックAPIをカバーしているか確認
- [ ] 正常系・異常系・境界値のテスト観点が適切にバランスされているか確認
- [ ] モック機能のテストケースが実際のユースケースをカバーしているか確認
- [ ] カバレッジ関連のテストケースがエッジケースを考慮しているか確認
- [ ] レポーター関連のテストケースが各フォーマットの仕様を正しく反映しているか確認
