---
generated_at: 2026-01-30 18:25:00
metrics:
  claims_total: 176
  claims_with_evidence: 176
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lib-internal-tls 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：176 / 176、根拠なし：0
- 優先レビュー（高）
  1. **TLS接続のセキュリティ関連テスト**：認証、暗号化、証明書検証のテストケースを重点的にレビュー
  2. **PSK/ALPN関連テスト**：プロトコル拡張機能のテストケースを確認
  3. **エラーハンドリング関連テスト**：セキュリティ攻撃防止（再ネゴ攻撃等）のテストを確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/tls/common.js` - SecureContext、createSecureContext、translatePeerCertificate の実装
- E-02: `lib/internal/tls/secure-context.js` - configSecureContext、validateKeyOrCertOption、processCiphers の実装
- E-03: `lib/internal/tls/wrap.js` - TLSSocket、Server、connect、各種イベントハンドラの実装
- E-04: `internalBinding('constants')` - TLS1_VERSION, TLS1_1_VERSION, TLS1_2_VERSION, TLS1_3_VERSION定数
- E-05: `internal/errors` - ERR_TLS_* エラーコード定義
- E-06: `internal/validators` - validateString, validateInt32, validateBuffer, validateObject, validateFunction等

## 3) Claims と根拠の対応（レビューの主戦場）

### internal/tls/common.js

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SecureContextが正しく生成される | E-01 L72-95 | ○ |
| C-02 | new演算子なしでもインスタンス生成される | E-01 L73-76 | ○ |
| C-03 | secureProtocolとminVersionの同時指定でエラー | E-01 L79-80 | ○ |
| C-04 | secureProtocolとmaxVersionの同時指定でエラー | E-01 L81-82 | ○ |
| C-05 | secureOptionsの不正値でエラー | E-01 L92 | ○ |
| C-06-C-12 | toV関数のバージョン変換 | E-01 L59-66 | ○ |
| C-13-C-17 | createSecureContextの動作 | E-01 L97-117 | ○ |
| C-18-C-23 | translatePeerCertificateの変換処理 | E-01 L122-151 | ○ |

### internal/tls/secure-context.js

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24-C-25 | getDefaultEcdhCurve/getDefaultCiphersの遅延評価 | E-02 L46-58 | ○ |
| C-26-C-30 | validateKeyOrCertOptionのバリデーション | E-02 L74-87 | ○ |
| C-31-C-35 | addCACerts/setCerts/setKeyの動作 | E-02 L60-94 | ○ |
| C-36-C-40 | processCiphersの暗号スイート分類 | E-02 L96-127 | ○ |
| C-41-C-60 | configSecureContextの各種設定 | E-02 L129-322 | ○ |

### internal/tls/wrap.js - TLSSocket

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61-C-65 | TLSSocketコンストラクタの動作 | E-03 L521-625 | ○ |
| C-66 | disableRenegotiationの動作 | E-03 L686-688 | ○ |
| C-67-C-69 | _wrapHandleの動作 | E-03 L697-736 | ○ |
| C-70-C-72 | _destroySSLの動作 | E-03 L785-795 | ○ |
| C-73-C-79 | _initの初期化処理 | E-03 L824-974 | ○ |
| C-80-C-83 | renegotiateの動作 | E-03 L976-1024 | ○ |
| C-84-C-86 | exportKeyingMaterialの動作 | E-03 L1026-1036 | ○ |
| C-87-C-88 | setMaxSendFragmentの動作 | E-03 L1038-1041 | ○ |
| C-89-C-91 | setServernameの動作 | E-03 L1118-1126 | ○ |
| C-92-C-93 | setSessionの動作 | E-03 L1128-1132 | ○ |
| C-94-C-100 | 証明書取得メソッドの動作 | E-03 L1134-1161 | ○ |
| C-101-C-102 | setKeyCertの動作 | E-03 L1163-1172 | ○ |
| C-103-C-109 | _finishInit/_startの動作 | E-03 L1068-1116 | ○ |
| C-110-C-111 | _releaseControlの動作 | E-03 L1060-1066 | ○ |

### internal/tls/wrap.js - Server

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112-C-121 | Serverコンストラクタの動作 | E-03 L1340-1400 | ○ |
| C-122-C-124 | setSecureContextの動作 | E-03 L1410-1530 | ○ |
| C-125-C-128 | getTicketKeys/setTicketKeysの動作 | E-03 L1545-1555 | ○ |
| C-129-C-132 | addContextの動作 | E-03 L1558-1572 | ○ |
| C-133-C-135 | SNICallbackの動作 | E-03 L1586-1598 | ○ |

### internal/tls/wrap.js - connect

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-136-C-145 | connect関数の動作 | E-03 L1713-1798 | ○ |

### internal/tls/wrap.js - イベントハンドラ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-146-C-149 | onhandshakestartの動作 | E-03 L120-149 | ○ |
| C-150-C-152 | callALPNCallbackの動作 | E-03 L233-275 | ○ |
| C-153-C-158 | onPskServerCallback/onPskClientCallbackの動作 | E-03 L379-450 | ○ |
| C-159-C-163 | onConnectSecureの動作 | E-03 L1634-1694 | ○ |
| C-164-C-165 | normalizeConnectArgsの動作 | E-03 L1615-1632 | ○ |
| C-166-C-171 | createServer/tlsConnectionListener/onServerSocketSecureの動作 | E-03 L1201-1273, L1405-1407 | ○ |
| C-172-C-176 | onerror/initReadの動作 | E-03 L462-515 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのテストケースがソースコードに基づいて生成されています）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全てのテストケースがソースコードの実装に基づいており、信頼度は高い

追加の確認推奨事項：
1. **セキュリティ関連テスト（高優先度）**
   - 証明書検証（C-94-C-100, C-159-C-163, C-169-C-171）
   - 再ネゴシエーション攻撃防止（C-146-C-149）
   - PSK/ALPN認証（C-150-C-158）

2. **エラーハンドリングテスト（中優先度）**
   - 各種ERR_TLS_*エラーの発生条件
   - ソケットのdestroy処理

3. **境界値テスト（中優先度）**
   - ticketKeysの48バイト制限（C-56-C-57, C-128）
   - DHパラメータサイズ制限（C-162）

## 6) レビュアーチェックリスト（最小）
- [ ] SecureContextの生成とオプション設定が正しくテストされているか
- [ ] TLSバージョン変換（toV関数）の境界値テストが十分か
- [ ] 証明書チェーン検証（translatePeerCertificate）の再帰処理テストが適切か
- [ ] TLSSocketのライフサイクル（作成、接続、ハンドシェイク、終了）がカバーされているか
- [ ] サーバーモードとクライアントモードの両方のテストが存在するか
- [ ] SNI/ALPN/PSKの各拡張機能のテストが網羅されているか
- [ ] 再ネゴシエーション攻撃防止のテスト（CLIENT_RENEG_LIMIT）が適切か
- [ ] エラーハンドリング（onerror、各種例外）のテストが十分か
- [ ] セキュリティ警告（SecurityWarning）のテストが含まれているか
- [ ] 48バイトticketKeys制限のテストが正常系・異常系両方存在するか
