---
generated_at: 2026-01-30 18:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 45
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: lib-internal-v8

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：45 / 45、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/v8/startup_snapshot.js` - メインソースファイル（131行）
- E-02: `lib/internal/errors.js` - エラー定義（ERR_DUPLICATE_STARTUP_SNAPSHOT_MAIN_FUNCTION, ERR_NOT_BUILDING_SNAPSHOT, ERR_NOT_SUPPORTED_IN_SNAPSHOT）
- E-03: `lib/internal/validators.js` - validateFunction関数定義
- E-04: `internalBinding('mksnapshot')` - C++バインディング（setSerializeCallback, setDeserializeCallback, setDeserializeMainFunction, isBuildingSnapshotBuffer）

## 3) Claims と根拠の対応（レビューの主戦場）

### isBuildingSnapshot関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | isBuildingSnapshot()はisBuildingSnapshotBuffer[0]の値を返す | E-01 (L21-23) | ○ |
| C-02 | スナップショットビルド中はtrueを返す | E-01 (L21-23) | ○ |

### throwIfNotBuildingSnapshot関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-03 | スナップショットビルド中でない場合ERR_NOT_BUILDING_SNAPSHOTをスロー | E-01 (L25-29), E-02 | ○ |
| C-04 | スナップショットビルド中は例外をスローしない | E-01 (L25-29) | ○ |

### throwIfBuildingSnapshot関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | スナップショットビルド中はERR_NOT_SUPPORTED_IN_SNAPSHOTをスロー | E-01 (L31-35), E-02 | ○ |
| C-06 | reason引数がエラーメッセージに含まれる | E-01 (L33), E-02 (L1632) | ○ |

### addDeserializeCallback関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | throwIfNotBuildingSnapshot()を呼び出す | E-01 (L47) | ○ |
| C-08 | validateFunctionでcallback引数を検証 | E-01 (L48), E-03 | ○ |
| C-09 | 最初の呼び出し時にsetDeserializeCallbackを設定 | E-01 (L49-56) | ○ |
| C-10 | deserializeCallbacks配列にpush | E-01 (L57) | ○ |
| C-11 | callbackが関数でない場合ERR_INVALID_ARG_TYPEをスロー | E-03 (L461-463) | ○ |

### runDeserializeCallbacks関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | whileループでコールバックを順次実行 | E-01 (L39-44) | ○ |
| C-13 | shift()で配列から取り出し実行 | E-01 (L41) | ○ |
| C-14 | callback(data)の形式で呼び出し | E-01 (L42) | ○ |

### addSerializeCallback関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | throwIfNotBuildingSnapshot()を呼び出す | E-01 (L74) | ○ |
| C-16 | validateFunctionでcallback引数を検証 | E-01 (L75), E-03 | ○ |
| C-17 | serializeCallbacks配列にpush | E-01 (L76) | ○ |

### runSerializeCallbacks関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | serializeCallbacksを先に全て実行 | E-01 (L62-66) | ○ |
| C-19 | その後afterUserSerializeCallbacksを実行 | E-01 (L67-70) | ○ |
| C-20 | 実行順序が保証される | E-01 (L62-71) | ○ |

### addAfterUserSerializeCallback関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | afterUserSerializeCallbacks配列にpush | E-01 (L80) | ○ |
| C-22 | バリデーションなし（isBuildingSnapshot確認なし） | E-01 (L79-81) | ○ |

### initializeCallbacks関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | isBuildingSnapshot()がtrueの場合のみsetSerializeCallbackを呼ぶ | E-01 (L83-89) | ○ |
| C-24 | runSerializeCallbacksをコールバックとして設定 | E-01 (L87) | ○ |

### setDeserializeMainFunction関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | throwIfNotBuildingSnapshot()を呼び出す | E-01 (L93) | ○ |
| C-26 | validateFunctionでcallback引数を検証 | E-01 (L97), E-03 | ○ |
| C-27 | deserializeMainIsSetがtrueの場合ERR_DUPLICATE_STARTUP_SNAPSHOT_MAIN_FUNCTIONをスロー | E-01 (L98-100), E-02 | ○ |
| C-28 | deserializeMainIsSetをtrueに設定 | E-01 (L101) | ○ |
| C-29 | _setDeserializeMainFunctionを呼び出す | E-01 (L103-115) | ○ |
| C-30 | deserializeMain内でprepareMainThreadExecutionを呼ぶ | E-01 (L112) | ○ |
| C-31 | deserializeMain内でmarkBootstrapCompleteを呼ぶ | E-01 (L113) | ○ |
| C-32 | deserializeMain内でcallback(data)を呼ぶ | E-01 (L114) | ○ |

### module.exports
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | runDeserializeCallbacksがエクスポートされる | E-01 (L120) | ○ |
| C-34 | throwIfBuildingSnapshotがエクスポートされる | E-01 (L121) | ○ |
| C-35 | namespaceオブジェクトがエクスポートされる | E-01 (L123-128) | ○ |
| C-36 | namespace.addDeserializeCallbackが存在 | E-01 (L124) | ○ |
| C-37 | namespace.addSerializeCallbackが存在 | E-01 (L125) | ○ |
| C-38 | namespace.setDeserializeMainFunctionが存在 | E-01 (L126) | ○ |
| C-39 | namespace.isBuildingSnapshotが存在 | E-01 (L127) | ○ |
| C-40 | addAfterUserSerializeCallbackがエクスポートされる | E-01 (L129) | ○ |

### エラーハンドリング・境界値
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | コールバック配列が空の場合はwhileループが実行されない | E-01 (L40, L63, L67) | ○ |
| C-42 | nullコールバックはvalidateFunctionで拒否される | E-03 (L461-463) | ○ |
| C-43 | undefinedコールバックはvalidateFunctionで拒否される | E-03 (L461-463) | ○ |
| C-44 | 数値コールバックはvalidateFunctionで拒否される | E-03 (L461-463) | ○ |
| C-45 | オブジェクトコールバックはvalidateFunctionで拒否される | E-03 (L461-463) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません。全てのテストケースはソースコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- **リスクレベル: 0（低リスク）**
  - 全てのテストケースがソースコードから直接導出されている
  - エラー定義もerrors.jsで確認済み
  - バリデーション関数もvalidators.jsで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] internalBinding('mksnapshot')のモック方法を検討（C++バインディングのため）
- [ ] isBuildingSnapshotBuffer[0]の状態切り替えテスト環境の確認
- [ ] 'internal/process/pre_execution'モジュールのモック方法を検討
- [ ] 複数コールバック登録時の実行順序テストの実装方法を確認
- [ ] エラーがスローされた場合のコールバック配列状態の確認
