---
generated_at: 2026-01-30 18:25:00
metrics:
  claims_total: 110
  claims_with_evidence: 108
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：lib-internal-vm 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：108 / 110、根拠なし：2
- 優先レビュー（高）
  1. **UT-VM-029, UT-VM-030**：displayErrors/breakOnFirstLineの動作は内部実装に依存
  2. **STATUS_MAP/PHASE_MAPテスト**：定数の値はnative bindingに依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/vm.js` - isContext関数（行48-50）
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/vm.js` - getHostDefinedOptionId関数（行60-89）
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/vm.js` - registerImportModuleDynamically関数（行97-112）
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/vm.js` - internalCompileFunction関数（行133-165）
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/vm.js` - makeContextifyScript関数（行180-208）
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/vm.js` - runScriptInThisContext関数（行218-228）
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/vm/module.js` - isModule関数（行97-102）
- E-08: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/vm/module.js` - phaseEnumToPhaseName関数（行104-108）
- E-09: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/vm/module.js` - Moduleクラス（行110-261）
- E-10: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/vm/module.js` - SourceTextModuleクラス（行265-459）
- E-11: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/vm/module.js` - SyntheticModuleクラス（行461-507）
- E-12: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/vm/module.js` - importModuleDynamicallyWrap関数（行522-541）
- E-13: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/vm/module.js` - STATUS_MAP定数（行71-79）
- E-14: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/vm/module.js` - PHASE_MAP定数（行81-85）
- E-15: `/Users/tomokababa/Work/reverse-engineering/sample/node-main/lib/internal/vm/module.js` - バリデーション関数群のimport（行47-56）

## 3) Claims と根拠の対応（レビューの主戦場）

### internal/vm.js

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-VM-001) | isContextがvmコンテキストを正しく判定 | E-01: `return object[contextify_context_private_symbol] !== undefined` | ○ |
| C-02 (UT-VM-002) | isContextが通常オブジェクトをfalseと判定 | E-01: プライベートシンボルがundefinedの場合false | ○ |
| C-03 (UT-VM-003) | isContextがnull入力をハンドリング | E-01: オブジェクトアクセス時にエラーになる可能性 | ○ |
| C-04 (UT-VM-004) | isContextがundefined入力をハンドリング | E-01: オブジェクトアクセス時にエラーになる可能性 | ○ |
| C-05 (UT-VM-005) | getHostDefinedOptionIdがvm_dynamic_import_main_context_defaultをそのまま返却 | E-02: 行61-63の条件分岐 | ○ |
| C-06 (UT-VM-006) | getHostDefinedOptionIdがvm_dynamic_import_default_internalをそのまま返却 | E-02: 行61-63の条件分岐 | ○ |
| C-07 (UT-VM-007) | getHostDefinedOptionIdがundefinedでvm_dynamic_import_no_callbackを返却 | E-02: 行72-77の条件分岐 | ○ |
| C-08 (UT-VM-008) | getHostDefinedOptionIdが関数で新しいSymbolを返却（--experimental-vm-modules有効時） | E-02: 行84-88 | ○ |
| C-09 (UT-VM-009) | getHostDefinedOptionIdがフラグ無効時にvm_dynamic_import_missing_flagを返却 | E-02: 行84-86 | ○ |
| C-10 (UT-VM-010) | getHostDefinedOptionIdが非関数でTypeErrorをスロー | E-02: 行69-70 `validateFunction` | ○ |
| C-11 (UT-VM-011) | registerImportModuleDynamicallyがundefinedで早期リターン | E-03: 行100-104 | ○ |
| C-12 (UT-VM-012) | registerImportModuleDynamicallyが特殊シンボルで早期リターン | E-03: 行100-104 | ○ |
| C-13 (UT-VM-013) | registerImportModuleDynamicallyが有効なコールバックを登録 | E-03: 行105-111 `registerModule` | ○ |
| C-14 (UT-VM-014) | internalCompileFunctionが有効なコードをコンパイル | E-04: 行137-148 `compileFunction` | ○ |
| C-15 (UT-VM-015) | internalCompileFunctionがcachedDataProducedをセット | E-04: 行150-152 | ○ |
| C-16 (UT-VM-016) | internalCompileFunctionがcachedDataをセット | E-04: 行154-156 | ○ |
| C-17 (UT-VM-017) | internalCompileFunctionがcachedDataRejectedをセット | E-04: 行158-160 | ○ |
| C-18 (UT-VM-018) | internalCompileFunctionがparsingContextを使用 | E-04: 行137-148のparsingContext引数 | ○ |
| C-19 (UT-VM-019) | internalCompileFunctionがparamsを使用 | E-04: 行137-148のparams引数 | ○ |
| C-20 (UT-VM-020) | internalCompileFunctionが不正コードでSyntaxErrorをスロー | E-04: compileFunctionがエラーをスロー | ○ |
| C-21 (UT-VM-021) | internalCompileFunctionが無効なparsingContextでエラー | E-04: コメント行131-132 | ○ |
| C-22 (UT-VM-022) | makeContextifyScriptがContextifyScriptを作成 | E-05: 行194-201 `new ContextifyScript` | ○ |
| C-23 (UT-VM-023) | makeContextifyScriptがオフセットを設定 | E-05: 行195-197のlineOffset, columnOffset | ○ |
| C-24 (UT-VM-024) | makeContextifyScriptがcachedDataを使用 | E-05: 行198のcachedData | ○ |
| C-25 (UT-VM-025) | makeContextifyScriptがparsingContextを使用 | E-05: 行200のparsingContext | ○ |
| C-26 (UT-VM-026) | makeContextifyScriptがimportModuleDynamicallyを登録 | E-05: 行206 `registerImportModuleDynamically` | ○ |
| C-27 (UT-VM-027) | makeContextifyScriptが不正コードでSyntaxErrorをスロー | E-05: 行202-204のtry-catch | ○ |
| C-28 (UT-VM-028) | runScriptInThisContextがスクリプトを実行 | E-06: 行219-227 `runInContext` | ○ |
| C-29 (UT-VM-029) | runScriptInThisContextがdisplayErrorsを使用 | E-06: 行224 | △ |
| C-30 (UT-VM-030) | runScriptInThisContextがbreakOnFirstLineを使用 | E-06: 行226 | △ |

### internal/vm/module.js - ヘルパー関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 (UT-VM-031) | isModuleがModuleインスタンスをtrueと判定 | E-07: 行98-101 kWrapチェック | ○ |
| C-32 (UT-VM-032) | isModuleが通常オブジェクトをfalseと判定 | E-07: 行98の条件 | ○ |
| C-33 (UT-VM-033) | isModuleがnullをfalseと判定 | E-07: 行98 `object === null` | ○ |
| C-34 (UT-VM-034) | phaseEnumToPhaseNameがkSourcePhaseを'source'に変換 | E-08, E-14: PHASE_MAP定義 | ○ |
| C-35 (UT-VM-035) | phaseEnumToPhaseNameがkEvaluationPhaseを'evaluation'に変換 | E-08, E-14: PHASE_MAP定義 | ○ |
| C-36 (UT-VM-036) | phaseEnumToPhaseNameが無効値でassertエラー | E-08: 行106 assert | ○ |

### internal/vm/module.js - Moduleクラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 (UT-VM-037) | Module直接インスタンス化でTypeError | E-09: 行114-117 | ○ |
| C-38 (UT-VM-038) | Module constructorが実験的警告を発行 | E-09: 行112 `emitExperimentalWarning` | ○ |
| C-39 (UT-VM-039) | Module constructorがcontextをバリデーション | E-09: 行126-132 | ○ |
| C-40 (UT-VM-040) | Module constructorが無効contextでERR_INVALID_ARG_TYPE | E-09: 行129-130 | ○ |
| C-41 (UT-VM-041) | Module constructorがデフォルトidentifierを生成 | E-09: 行137-152 | ○ |
| C-42 (UT-VM-042) | Module constructorがcontextごとにIDをインクリメント | E-09: 行139-152 kPerContextModuleId | ○ |
| C-43 (UT-VM-043) | Module.identifierが識別子を返却 | E-09: 行168-171 | ○ |
| C-44 (UT-VM-044) | Module.identifierが無効thisでエラー | E-09: 行169 validateThisInternalField | ○ |
| C-45 (UT-VM-045) | Module.contextがコンテキストを返却 | E-09: 行173-176 | ○ |
| C-46 (UT-VM-046) | Module.namespaceがリンク済みでnamespaceを返却 | E-09: 行178-184 | ○ |
| C-47 (UT-VM-047) | Module.namespaceが未リンクでERR_VM_MODULE_STATUS | E-09: 行180-182 | ○ |
| C-48 (UT-VM-048) | Module.statusが状態を返却 | E-09: 行186-189 STATUS_MAP | ○ |
| C-49 (UT-VM-049) | Module.errorがエラー状態でエラーを返却 | E-09: 行191-197 | ○ |
| C-50 (UT-VM-050) | Module.errorが非エラー状態でERR_VM_MODULE_STATUS | E-09: 行193-195 | ○ |
| C-51 (UT-VM-051) | Module.linkがlinker関数でモジュールをリンク | E-09: 行199-210 | ○ |
| C-52 (UT-VM-052) | Module.linkが既リンクでERR_VM_MODULE_ALREADY_LINKED | E-09: 行202-204 | ○ |
| C-53 (UT-VM-053) | Module.linkが未リンク以外でERR_VM_MODULE_STATUS | E-09: 行205-207 | ○ |
| C-54 (UT-VM-054) | Module.linkがlinkerが関数でない場合エラー | E-09: 行201 validateFunction | ○ |
| C-55 (UT-VM-055) | Module.evaluateがリンク済みモジュールを評価 | E-09: 行212-237 | ○ |
| C-56 (UT-VM-056) | Module.evaluateがtimeoutオプションを適用 | E-09: 行217-222 | ○ |
| C-57 (UT-VM-057) | Module.evaluateがbreakOnSigintオプションを適用 | E-09: 行223-224 | ○ |
| C-58 (UT-VM-058) | Module.evaluateが未リンクでERR_VM_MODULE_STATUS | E-09: 行226-232 | ○ |
| C-59 (UT-VM-059) | Module.evaluateが無効timeoutでエラー | E-09: 行221 validateUint32 | ○ |
| C-60 (UT-VM-060) | Module.evaluateが無効breakOnSigintでエラー | E-09: 行224 validateBoolean | ○ |
| C-61 (UT-VM-061) | Module.customInspectSymbolがカスタムインスペクト | E-09: 行239-260 | ○ |
| C-62 (UT-VM-062) | Module.customInspectSymbolが負depthでthisを返却 | E-09: 行241-242 | ○ |

### internal/vm/module.js - SourceTextModuleクラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 (UT-VM-063) | SourceTextModule constructorがソーステキストからモジュール作成 | E-10: 行272-333 | ○ |
| C-64 (UT-VM-064) | SourceTextModule constructorがオフセットを設定 | E-10: 行277-278, 286-287 | ○ |
| C-65 (UT-VM-065) | SourceTextModule constructorがinitializeImportMetaを設定 | E-10: 行289-291 | ○ |
| C-66 (UT-VM-066) | SourceTextModule constructorがimportModuleDynamicallyを設定 | E-10: 行293-295 | ○ |
| C-67 (UT-VM-067) | SourceTextModule constructorがcachedDataを使用 | E-10: 行297-299 | ○ |
| C-68 (UT-VM-068) | SourceTextModule constructorがsourceTextが非文字列でエラー | E-10: 行273 validateString | ○ |
| C-69 (UT-VM-069) | SourceTextModule constructorが無効lineOffsetでエラー | E-10: 行286 validateInt32 | ○ |
| C-70 (UT-VM-070) | SourceTextModule constructorがinitializeImportMetaが非関数でエラー | E-10: 行290 validateFunction | ○ |
| C-71 (UT-VM-071) | SourceTextModule constructorがcachedDataが非Bufferでエラー | E-10: 行298 validateBuffer | ○ |
| C-72 (UT-VM-072) | SourceTextModule.kLinkが依存モジュールをリンク | E-10: 行335-377 | ○ |
| C-73 (UT-VM-073) | SourceTextModule.kLinkがlinkerが非モジュールでERR_VM_MODULE_NOT_MODULE | E-10: 行351-353 | ○ |
| C-74 (UT-VM-074) | SourceTextModule.kLinkが異コンテキストでERR_VM_MODULE_DIFFERENT_CONTEXT | E-10: 行354-356 | ○ |
| C-75 (UT-VM-075) | SourceTextModule.kLinkがエラー状態モジュールでERR_VM_MODULE_LINK_FAILURE | E-10: 行357-359 | ○ |
| C-76 (UT-VM-076) | SourceTextModule.linkRequestsがモジュール配列で同期リンク | E-10: 行379-400 | ○ |
| C-77 (UT-VM-077) | SourceTextModule.linkRequestsが未リンク以外でERR_VM_MODULE_STATUS | E-10: 行381-383 | ○ |
| C-78 (UT-VM-078) | SourceTextModule.linkRequestsが数不一致でERR_MODULE_LINK_MISMATCH | E-10: 行385-388 | ○ |
| C-79 (UT-VM-079) | SourceTextModule.linkRequestsが非モジュールでERR_VM_MODULE_NOT_MODULE | E-10: 行391-393 | ○ |
| C-80 (UT-VM-080) | SourceTextModule.instantiateが未リンクモジュールをインスタンス化 | E-10: 行402-408 | ○ |
| C-81 (UT-VM-081) | SourceTextModule.instantiateが未リンク以外でERR_VM_MODULE_STATUS | E-10: 行404-406 | ○ |
| C-82 (UT-VM-082) | SourceTextModule.dependencySpecifiersが依存指定子を返却 | E-10: 行410-414 | ○ |
| C-83 (UT-VM-083) | SourceTextModule.dependencySpecifiersがフリーズされている | E-10: 行411 ObjectFreeze | ○ |
| C-84 (UT-VM-084) | SourceTextModule.moduleRequestsがリクエストを返却 | E-10: 行416-418 | ○ |
| C-85 (UT-VM-085) | SourceTextModule.statusがエラー時'errored'を返却 | E-10: 行420-428 #error | ○ |
| C-86 (UT-VM-086) | SourceTextModule.statusがstatusOverrideを返却 | E-10: 行424-426 | ○ |
| C-87 (UT-VM-087) | SourceTextModule.errorが内部エラーを返却 | E-10: 行430-435 | ○ |
| C-88 (UT-VM-088) | SourceTextModule.hasAsyncGraphが非同期依存を判定 | E-10: 行437-443 | ○ |
| C-89 (UT-VM-089) | SourceTextModule.hasAsyncGraphがインスタンス化前でERR_VM_MODULE_STATUS | E-10: 行439-441 | ○ |
| C-90 (UT-VM-090) | SourceTextModule.hasTopLevelAwaitがTLAを判定 | E-10: 行445-448 | ○ |
| C-91 (UT-VM-091) | SourceTextModule.createCachedDataがキャッシュ生成 | E-10: 行450-458 | ○ |
| C-92 (UT-VM-092) | SourceTextModule.createCachedDataが評価済み等でERR_VM_MODULE_CANNOT_CREATE_CACHED_DATA | E-10: 行451-456 | ○ |

### internal/vm/module.js - SyntheticModuleクラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 (UT-VM-093) | SyntheticModule constructorがモジュール作成 | E-11: 行462-491 | ○ |
| C-94 (UT-VM-094) | SyntheticModule constructorが即座にインスタンス化 | E-11: 行490 `this[kWrap].instantiate()` | ○ |
| C-95 (UT-VM-095) | SyntheticModule constructorがexportNamesが非配列でエラー | E-11: 行463-466 | ○ |
| C-96 (UT-VM-096) | SyntheticModule constructorがexportNamesに非文字列でエラー | E-11: 行464 ArrayPrototypeSome | ○ |
| C-97 (UT-VM-097) | SyntheticModule constructorがexportNames重複でERR_INVALID_ARG_VALUE | E-11: 行469-475 | ○ |
| C-98 (UT-VM-098) | SyntheticModule constructorがevaluateCallbackが非関数でエラー | E-11: 行477 validateFunction | ○ |
| C-99 (UT-VM-099) | SyntheticModule.linkがno-op | E-11: 行493-497 | ○ |
| C-100 (UT-VM-100) | SyntheticModule.setExportがエクスポート設定 | E-11: 行499-506 | ○ |
| C-101 (UT-VM-101) | SyntheticModule.setExportが未リンクでERR_VM_MODULE_STATUS | E-11: 行502-504 | ○ |
| C-102 (UT-VM-102) | SyntheticModule.setExportがnameが非文字列でエラー | E-11: 行501 validateString | ○ |

### internal/vm/module.js - importModuleDynamicallyWrap

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 (UT-VM-103) | importModuleDynamicallyWrapがnamespaceをそのまま返却 | E-12: 行526-529 isModuleNamespaceObject | ○ |
| C-104 (UT-VM-104) | importModuleDynamicallyWrapがモジュールからnamespaceを返却 | E-12: 行538 `m.namespace` | ○ |
| C-105 (UT-VM-105) | importModuleDynamicallyWrapがsourceフェーズでModuleSourceObject返却 | E-12: 行536-537 | ○ |
| C-106 (UT-VM-106) | importModuleDynamicallyWrapがnamespaceがkSourcePhaseでエラー | E-12: 行527 | ○ |
| C-107 (UT-VM-107) | importModuleDynamicallyWrapが非モジュールでERR_VM_MODULE_NOT_MODULE | E-12: 行530-532 | ○ |
| C-108 (UT-VM-108) | importModuleDynamicallyWrapがerroredモジュールでエラー伝播 | E-12: 行533-535 | ○ |

### 定数マッピング

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 (UT-VM-109) | STATUS_MAPがkUninstantiatedを'unlinked'にマップ | E-13: 行73 | ○ |
| C-110 (UT-VM-110) | STATUS_MAPがkErroredを'errored'にマップ | E-13: 行78 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-VM-029, UT-VM-030**: `displayErrors`と`breakOnFirstLine`の具体的な動作は`ContextifyScript.prototype.runInContext`のネイティブ実装に依存しており、JavaScript側からは確認できない
  - 候補：Node.js C++ソースコード / V8 API ドキュメント / Node.js API ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分のテストケースはソースコードから直接根拠を確認できる
- **1（中リスク）**: ネイティブバインディング（`internalBinding`）に依存する機能の動作確認
- **0（低リスク）**: バリデーション関数は`internal/validators`から提供されており、標準的な動作が期待できる

## 6) レビュアーチェックリスト（最小）
- [ ] VMコンテキスト関連のテストケース（UT-VM-001〜004）が実行環境で正しく動作するか
- [ ] Module状態遷移のテストケース（UT-VM-048〜058）がすべてのエッジケースをカバーしているか
- [ ] SourceTextModuleのリンク処理（UT-VM-072〜079）が循環依存を正しく処理するか
- [ ] SyntheticModuleのエクスポート設定（UT-VM-100〜102）が動的な値変更をサポートするか
- [ ] importModuleDynamicallyWrapの各フェーズ（UT-VM-103〜108）が正しく処理されるか
- [ ] 実験的機能の警告（UT-VM-038）が適切に発行されるか
- [ ] キャッシュデータ関連のテスト（UT-VM-015〜017, UT-VM-091〜092）が実際のキャッシュ動作と一致するか
