---
generated_at: 2026-01-30 18:30:00
metrics:
  claims_total: 60
  claims_with_evidence: 58
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：lib-internal-watch_mode 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：58 / 60、根拠なし：2
- 優先レビュー（高）
  1. **UT-WTM-057**：captureRejectionsの具体的動作確認が必要
  2. **UT-WTM-059**：unref()の呼び出し確認がコードから直接推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/watch_mode/files_watcher.js` (FilesWatcherクラス定義)
- E-02: `lib/internal/watch_mode/files_watcher.js:48-61` (constructor定義)
- E-03: `lib/internal/watch_mode/files_watcher.js:51-52` (validateNumber, validateOneOf呼び出し)
- E-04: `lib/internal/watch_mode/files_watcher.js:63-75` (#isPathWatched定義)
- E-05: `lib/internal/watch_mode/files_watcher.js:77-84` (#removeWatchedChildren定義)
- E-06: `lib/internal/watch_mode/files_watcher.js:86-89` (#unwatch定義)
- E-07: `lib/internal/watch_mode/files_watcher.js:91-107` (#onChange定義)
- E-08: `lib/internal/watch_mode/files_watcher.js:109-111` (watchedPaths getter)
- E-09: `lib/internal/watch_mode/files_watcher.js:113-127` (watchPath定義)
- E-10: `lib/internal/watch_mode/files_watcher.js:129-147` (filterFile定義)
- E-11: `lib/internal/watch_mode/files_watcher.js:150-159` (#setupIPC定義)
- E-12: `lib/internal/watch_mode/files_watcher.js:161-167` (destroyIPC定義)
- E-13: `lib/internal/watch_mode/files_watcher.js:169-186` (watchChildProcessModules定義)
- E-14: `lib/internal/watch_mode/files_watcher.js:187-200` (unfilterFilesOwnedBy定義)
- E-15: `lib/internal/watch_mode/files_watcher.js:201-203` (clearFileFilters定義)
- E-16: `lib/internal/watch_mode/files_watcher.js:204-210` (clear定義)
- E-17: `lib/internal/watch_mode/files_watcher.js:25-27` (supportsRecursiveWatching定義)
- E-18: `lib/internal/watch_mode/files_watcher.js:28-33` (isParentPath定義)
- E-19: `lib/internal/watch_mode/files_watcher.js:58-60` (AbortSignal処理)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-WTM-001) | デフォルトオプションでインスタンス生成 | E-02 | ○ |
| C-02 (UT-WTM-002) | カスタムdebounceでインスタンス生成 | E-02, E-03 | ○ |
| C-03 (UT-WTM-003) | mode='all'でインスタンス生成 | E-02, E-03 | ○ |
| C-04 (UT-WTM-004) | AbortSignal連携 | E-02, E-19 | ○ |
| C-05 (UT-WTM-005) | debounce負値でエラー | E-03 | ○ |
| C-06 (UT-WTM-006) | debounce上限超過でエラー | E-03 | ○ |
| C-07 (UT-WTM-007) | 無効mode指定でエラー | E-03 | ○ |
| C-08 (UT-WTM-008) | debounce=0境界値 | E-03 | ○ |
| C-09 (UT-WTM-009) | debounce=TIMEOUT_MAX境界値 | E-03 | ○ |
| C-10 (UT-WTM-010) | watchedPaths空配列 | E-08 | ○ |
| C-11 (UT-WTM-011) | watchedPaths一覧取得 | E-08 | ○ |
| C-12 (UT-WTM-012) | 新しいパス監視 | E-09 | ○ |
| C-13 (UT-WTM-013) | recursive=false監視 | E-09 | ○ |
| C-14 (UT-WTM-014) | 重複追加防止 | E-04, E-09 | ○ |
| C-15 (UT-WTM-015) | 親パスrecursive監視時の子パス追加防止 | E-04 | ○ |
| C-16 (UT-WTM-016) | recursive追加時の子パス監視削除 | E-05, E-09 | ○ |
| C-17 (UT-WTM-017) | ファイルフィルタ追加 | E-10 | ○ |
| C-18 (UT-WTM-018) | owner指定フィルタ追加 | E-10 | ○ |
| C-19 (UT-WTM-019) | 複数owner対応 | E-10 | ○ |
| C-20 (UT-WTM-020) | file=null時の安全性 | E-10 (129行目) | ○ |
| C-21 (UT-WTM-021) | recursive対応プラットフォーム動作 | E-10, E-17 | ○ |
| C-22 (UT-WTM-022) | recursive非対応プラットフォーム動作 | E-10, E-17 | ○ |
| C-23 (UT-WTM-023) | mode='filter'変更検知 | E-07 | ○ |
| C-24 (UT-WTM-024) | mode='filter'未登録無視 | E-07 (92-94行目) | ○ |
| C-25 (UT-WTM-025) | mode='all'全検知 | E-07 | ○ |
| C-26 (UT-WTM-026) | デバウンス機能 | E-07 (101-106行目) | ○ |
| C-27 (UT-WTM-027) | owner通知 | E-07 (95-100行目) | ○ |
| C-28 (UT-WTM-028) | 指定ownerのフィルタ削除 | E-14 | ○ |
| C-29 (UT-WTM-029) | 複数owner部分削除 | E-14 (192-194行目) | ○ |
| C-30 (UT-WTM-030) | owner依存関係削除 | E-14 | ○ |
| C-31 (UT-WTM-031) | 全フィルタクリア | E-15 | ○ |
| C-32 (UT-WTM-032) | 全監視フィルタクリア | E-16 | ○ |
| C-33 (UT-WTM-033) | watcherのclose呼び出し | E-06, E-16 | ○ |
| C-34 (UT-WTM-034) | AbortSignalでclear呼び出し | E-19 | ○ |
| C-35 (UT-WTM-035) | watch:requireメッセージ処理 | E-13 (176-177行目) | ○ |
| C-36 (UT-WTM-036) | watch:importメッセージ処理 | E-13 (179-180行目) | ○ |
| C-37 (UT-WTM-037) | key指定のowner設定 | E-13 (169行目) | ○ |
| C-38 (UT-WTM-038) | 非配列watch:require無視 | E-13 (176行目, ArrayIsArray) | ○ |
| C-39 (UT-WTM-039) | 不正URLエラーハンドリング | E-13 (182-184行目) | ○ |
| C-40 (UT-WTM-040) | IPCパススルー設定 | E-11 | ○ |
| C-41 (UT-WTM-041) | IPCハンドラ削除 | E-12 | ○ |
| C-42 (UT-WTM-042) | passthroughIPC=false時動作 | E-12 (163行目) | ○ |
| C-43 (UT-WTM-043) | ハンドラ未設定時動作 | E-12 (163行目) | ○ |
| C-44 (UT-WTM-044) | isParentPath正常判定 | E-18 | ○ |
| C-45 (UT-WTM-045) | isParentPath同一パス判定 | E-18 | ○ |
| C-46 (UT-WTM-046) | isParentPath無関係パス判定 | E-18 | ○ |
| C-47 (UT-WTM-047) | セパレータ処理 | E-18 (31行目) | ○ |
| C-48 (UT-WTM-048) | 直接監視パス確認 | E-04 (64-66行目) | ○ |
| C-49 (UT-WTM-049) | recursive監視子パス確認 | E-04 (68-72行目) | ○ |
| C-50 (UT-WTM-050) | non-recursive監視子パス確認 | E-04 (69行目) | ○ |
| C-51 (UT-WTM-051) | 子パス監視削除 | E-05 | ○ |
| C-52 (UT-WTM-052) | 自己削除防止 | E-05 (79行目) | ○ |
| C-53 (UT-WTM-053) | リスナー削除 | E-06 (87行目) | ○ |
| C-54 (UT-WTM-054) | watcher終了 | E-06 (88行目) | ○ |
| C-55 (UT-WTM-055) | null fileName対応 | E-09 (121行目, fileName ?? '') | ○ |
| C-56 (UT-WTM-056) | EventEmitter継承 | E-02 (49行目, super呼び出し) | ○ |
| C-57 (UT-WTM-057) | captureRejections設定 | E-02 | △ |
| C-58 (UT-WTM-058) | eventType含有 | E-07 (104行目) | ○ |
| C-59 (UT-WTM-059) | unref()呼び出し | E-07 (106行目) | △ |
| C-60 (UT-WTM-060) | filterFile重複防止 | E-10 (SafeSet使用) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-WTM-057 (C-57)**: captureRejectionsの動作はEventEmitterの内部実装に依存。コード上は設定されているが、実際の動作検証には追加調査が必要
  - 候補：Node.js EventEmitterドキュメント / 既存テストコード
- **UT-WTM-059 (C-59)**: unref()の呼び出しは確認できるが、実行時のプロセス終了への影響は実行時テストが必要
  - 候補：Node.js Timerドキュメント / 統合テスト

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分のテストケースはソースコードから直接導出可能
- **1 (中リスク)**: プラットフォーム依存の動作（supportsRecursiveWatching）は実行環境での検証が必要
- **0 (低リスク)**: IPCパススルー機能はprocess.sendの有無で分岐するため、両環境でのテストが推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] constructor のバリデーションエラーメッセージが適切か確認
- [ ] プラットフォーム依存テスト（darwin/win32 vs その他）のモック方法を確認
- [ ] AbortSignalによるリソース解放が確実に行われるか確認
- [ ] デバウンスタイマーのエッジケース（連続変更、タイムアウト境界）を確認
- [ ] IPC通信のエラーハンドリングが十分か確認
- [ ] 子プロセス監視時のメモリリーク可能性を確認
