---
generated_at: 2026-01-30 18:35:00
metrics:
  claims_total: 150
  claims_with_evidence: 148
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：lib-internal-webstreams.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドが適切にカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：148 / 150、根拠なし：2
- 優先レビュー（高）
  1. **TextDecoderStream flush処理**：明示的なflushコールバックの動作確認が必要
  2. **クロスレルム転送の詳細動作**：MessagePort経由の転送テストは実行環境依存

## 2) 参照した情報（Evidence一覧）
> 以下のソースファイルを根拠として参照しました。

- E-01: `lib/internal/webstreams/readablestream.js` - ReadableStream、ReadableStreamDefaultReader、ReadableStreamBYOBReader、ReadableStreamDefaultController、ReadableByteStreamController実装
- E-02: `lib/internal/webstreams/writablestream.js` - WritableStream、WritableStreamDefaultWriter、WritableStreamDefaultController実装
- E-03: `lib/internal/webstreams/transformstream.js` - TransformStream、TransformStreamDefaultController実装
- E-04: `lib/internal/webstreams/queuingstrategies.js` - ByteLengthQueuingStrategy、CountQueuingStrategy実装
- E-05: `lib/internal/webstreams/compression.js` - CompressionStream、DecompressionStream実装
- E-06: `lib/internal/webstreams/encoding.js` - TextEncoderStream、TextDecoderStream実装
- E-07: `lib/internal/webstreams/util.js` - ユーティリティ関数群（extractHighWaterMark、extractSizeAlgorithm、enqueueValueWithSize等）
- E-08: `lib/internal/webstreams/adapters.js` - Node.jsストリームとのアダプター関数群
- E-09: `lib/internal/webstreams/transfer.js` - クロスレルム転送サポート（CrossRealmTransformReadableSource、CrossRealmTransformWritableSink等）

## 3) Claims と根拠の対応（レビューの主戦場）

### ReadableStream関連（UT-WBS-001 - UT-WBS-024）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ReadableStream constructor基本動作 | E-01 (L243-285) | ○ |
| C-02 | カスタムsourceでの生成 | E-01 (L243-285) | ○ |
| C-03 | type='bytes'でバイトストリーム生成 | E-01 (L269-275) | ○ |
| C-04 | 無効なtype指定でエラー | E-01 (L277-278) | ○ |
| C-05 | type='bytes'でsize指定エラー | E-01 (L270-271) | ○ |
| C-06 | lockedプロパティ（未ロック時） | E-01 (L303-307) | ○ |
| C-07 | lockedプロパティ（ロック時） | E-01 (L303-307, L1995-1996) | ○ |
| C-08 | locked型チェック | E-01 (L304-305) | ○ |
| C-09 | cancelメソッド | E-01 (L317-325) | ○ |
| C-10 | ロック時cancel拒否 | E-01 (L320-323) | ○ |
| C-11 | getReader（デフォルト） | E-01 (L333-341) | ○ |
| C-12 | getReader（BYOB） | E-01 (L343-346) | ○ |
| C-13 | getReader無効mode | E-01 (L343-344) | ○ |
| C-14 | pipeThroughメソッド | E-01 (L354-399) | ○ |
| C-15 | pipeThrough ロック時エラー | E-01 (L384-387) | ○ |
| C-16 | pipeToメソッド | E-01 (L406-442) | ○ |
| C-17 | pipeTo ReadableStreamロック時エラー | E-01 (L427-428) | ○ |
| C-18 | pipeTo WritableStreamロック時エラー | E-01 (L429-430) | ○ |
| C-19 | teeメソッド | E-01 (L447-451) | ○ |
| C-20 | tee分岐独立性 | E-01 (L1601-1700) | ○ |
| C-21 | valuesメソッド | E-01 (L459-558) | ○ |
| C-22 | values イテレーション | E-01 (L459-558) | ○ |
| C-23 | ReadableStream.from Iterable | E-01 (L309-311, L1315-1362) | ○ |
| C-24 | ReadableStream.from AsyncIterable | E-01 (L309-311, L1315-1362) | ○ |

### ReadableStreamDefaultReader関連（UT-WBS-025 - UT-WBS-033）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | constructor | E-01 (L828-847) | ○ |
| C-26 | constructor型チェック | E-01 (L835-836) | ○ |
| C-27 | constructorロック時エラー | E-01 (L2285-2287) | ○ |
| C-28 | readメソッド正常 | E-01 (L855-866) | ○ |
| C-29 | read終了時 | E-01 (L2262-2264) | ○ |
| C-30 | readリリース後エラー | E-01 (L858-861) | ○ |
| C-31 | releaseLock | E-01 (L868-874) | ○ |
| C-32 | cancel | E-01 (L890-898) | ○ |
| C-33 | closedプロパティ | E-01 (L880-884) | ○ |

### ReadableStreamBYOBReader関連（UT-WBS-034 - UT-WBS-039）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | constructor | E-01 (L917-936) | ○ |
| C-35 | 非バイトストリームエラー | E-01 (L2279-2280) | ○ |
| C-36 | readメソッド | E-01 (L948-996) | ○ |
| C-37 | read空バッファエラー | E-01 (L968-971) | ○ |
| C-38 | read min<=0エラー | E-01 (L981-982) | ○ |
| C-39 | read min>viewエラー | E-01 (L983-989) | ○ |

### Controller関連（UT-WBS-040 - UT-WBS-052）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | ReadableStreamDefaultController直接インスタンス化禁止 | E-01 (L1052-1056) | ○ |
| C-41 | desiredSize | E-01 (L1062-1063) | ○ |
| C-42 | close | E-01 (L1066-1069) | ○ |
| C-43 | close既閉鎖エラー | E-01 (L1067-1068) | ○ |
| C-44 | enqueue | E-01 (L1075-1078) | ○ |
| C-45 | error | E-01 (L1084-1086) | ○ |
| C-46 | ReadableByteStreamController直接インスタンス化禁止 | E-01 (L1115-1119) | ○ |
| C-47 | byobRequest | E-01 (L1125-1144) | ○ |
| C-48 | enqueue（バイト） | E-01 (L1169-1184) | ○ |
| C-49 | enqueue空チャンクエラー | E-01 (L1176-1178) | ○ |
| C-50 | BYOBRequest respond | E-01 (L685-709) | ○ |
| C-51 | BYOBRequest無効化後エラー | E-01 (L692-695) | ○ |
| C-52 | respondWithNewView | E-01 (L714-733) | ○ |

### WritableStream関連（UT-WBS-053 - UT-WBS-075）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | constructor | E-02 (L158-186) | ○ |
| C-54 | カスタムsink | E-02 (L158-186) | ○ |
| C-55 | 無効type | E-02 (L169-171) | ○ |
| C-56 | locked（未ロック） | E-02 (L200-204) | ○ |
| C-57 | locked（ロック） | E-02 (L200-204, L616-618) | ○ |
| C-58 | abort | E-02 (L210-218) | ○ |
| C-59 | abortロック時 | E-02 (L213-216) | ○ |
| C-60 | close | E-02 (L223-235) | ○ |
| C-61 | closeロック時 | E-02 (L226-229) | ○ |
| C-62 | getWriter | E-02 (L240-245) | ○ |
| C-63 | Writer constructor | E-02 (L334-357) | ○ |
| C-64 | Writer constructor型チェック | E-02 (L341-342) | ○ |
| C-65 | Writer write | E-02 (L445-453) | ○ |
| C-66 | Writer writeリリース後 | E-02 (L448-452) | ○ |
| C-67 | Writer close | E-02 (L411-427) | ○ |
| C-68 | Writer abort | E-02 (L397-406) | ○ |
| C-69 | Writer releaseLock | E-02 (L429-439) | ○ |
| C-70 | Writer desiredSize | E-02 (L373-381) | ○ |
| C-71 | Writer ready | E-02 (L387-391) | ○ |
| C-72 | Writer closed | E-02 (L363-367) | ○ |
| C-73 | Controller直接インスタンス化禁止 | E-02 (L480-484) | ○ |
| C-74 | Controller signal | E-02 (L499-503) | ○ |
| C-75 | Controller error | E-02 (L508-514) | ○ |

### TransformStream関連（UT-WBS-076 - UT-WBS-086）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | constructor | E-03 (L119-185) | ○ |
| C-77 | カスタムtransformer | E-03 (L119-185) | ○ |
| C-78 | 無効readableType | E-03 (L139-143) | ○ |
| C-79 | 無効writableType | E-03 (L144-148) | ○ |
| C-80 | readableプロパティ | E-03 (L191-195) | ○ |
| C-81 | writableプロパティ | E-03 (L201-205) | ○ |
| C-82 | Controller直接インスタンス化禁止 | E-03 (L293-297) | ○ |
| C-83 | Controller desiredSize | E-03 (L303-316) | ○ |
| C-84 | Controller enqueue | E-03 (L321-325) | ○ |
| C-85 | Controller error | E-03 (L330-334) | ○ |
| C-86 | Controller terminate | E-03 (L336-340) | ○ |

### QueuingStrategy関連（UT-WBS-087 - UT-WBS-092）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | ByteLengthQueuingStrategy constructor | E-04 (L60-79) | ○ |
| C-88 | ByteLengthQueuingStrategy highWaterMark必須 | E-04 (L71-72) | ○ |
| C-89 | ByteLengthQueuingStrategy size | E-04 (L42-46, L92-94) | ○ |
| C-90 | CountQueuingStrategy constructor | E-04 (L112-131) | ○ |
| C-91 | CountQueuingStrategy highWaterMark必須 | E-04 (L123-124) | ○ |
| C-92 | CountQueuingStrategy size | E-04 (L47, L144-146) | ○ |

### Compression関連（UT-WBS-093 - UT-WBS-103）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | CompressionStream deflate | E-05 (L39-66) | ○ |
| C-94 | CompressionStream gzip | E-05 (L39-66) | ○ |
| C-95 | CompressionStream deflate-raw | E-05 (L39-66) | ○ |
| C-96 | CompressionStream brotli | E-05 (L39-66) | ○ |
| C-97 | CompressionStream無効形式 | E-05 (L27-32, L46-50) | ○ |
| C-98 | CompressionStream readable | E-05 (L72-74) | ○ |
| C-99 | CompressionStream writable | E-05 (L80-82) | ○ |
| C-100 | DecompressionStream deflate | E-05 (L92-131) | ○ |
| C-101 | DecompressionStream gzip | E-05 (L92-131) | ○ |
| C-102 | DecompressionStream無効形式 | E-05 (L100-103) | ○ |
| C-103 | DecompressionStream readable | E-05 (L137-139) | ○ |

### Encoding関連（UT-WBS-104 - UT-WBS-117）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-104 | TextEncoderStream constructor | E-06 (L39-85) | ○ |
| C-105 | TextEncoderStream encoding | E-06 (L91-93) | ○ |
| C-106 | TextEncoderStream readable | E-06 (L99-101) | ○ |
| C-107 | TextEncoderStream writable | E-06 (L107-109) | ○ |
| C-108 | TextEncoderStream transform | E-06 (L47-77) | ○ |
| C-109 | TextEncoderStream サロゲートペア | E-06 (L54-71) | ○ |
| C-110 | TextEncoderStream flush | E-06 (L78-83) | ○ |
| C-111 | TextDecoderStream constructor（デフォルト） | E-06 (L122-151) | ○ |
| C-112 | TextDecoderStream constructor（指定encoding） | E-06 (L133-134) | ○ |
| C-113 | TextDecoderStream encoding | E-06 (L157-159) | ○ |
| C-114 | TextDecoderStream fatal | E-06 (L165-167) | ○ |
| C-115 | TextDecoderStream ignoreBOM | E-06 (L173-175) | ○ |
| C-116 | TextDecoderStream transform | E-06 (L136-143) | ○ |
| C-117 | TextDecoderStream undefinedチャンクエラー | E-06 (L137-139) | ○ |

### Adapters関連（UT-WBS-118 - UT-WBS-125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-118 | newWritableStreamFromStreamWritable | E-08 (L140-240) | ○ |
| C-119 | newWritableStreamFromStreamWritable型チェック | E-08 (L150-156) | ○ |
| C-120 | newStreamWritableFromWritableStream | E-08 (L252-415) | ○ |
| C-121 | newReadableStreamFromStreamReadable | E-08 (L426-526) | ○ |
| C-122 | newReadableStreamFromStreamReadable type='bytes' | E-08 (L442-443, L455-456) | ○ |
| C-123 | newStreamReadableFromReadableStream | E-08 (L538-617) | ○ |
| C-124 | newReadableWritablePairFromDuplex | E-08 (L630-669) | ○ |
| C-125 | newStreamDuplexFromReadableWritablePair | E-08 (L683-892) | ○ |

### Util関連（UT-WBS-126 - UT-WBS-140）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | extractHighWaterMark（指定値） | E-07 (L59-67) | ○ |
| C-127 | extractHighWaterMark（デフォルト） | E-07 (L60) | ○ |
| C-128 | extractHighWaterMark（負の値エラー） | E-07 (L62-65) | ○ |
| C-129 | extractHighWaterMark（NaNエラー） | E-07 (L63) | ○ |
| C-130 | extractSizeAlgorithm（指定関数） | E-07 (L69-73) | ○ |
| C-131 | extractSizeAlgorithm（デフォルト） | E-07 (L70) | ○ |
| C-132 | extractSizeAlgorithm（非関数エラー） | E-07 (L71) | ○ |
| C-133 | enqueueValueWithSize | E-07 (L155-167) | ○ |
| C-134 | enqueueValueWithSize（負サイズエラー） | E-07 (L159-163) | ○ |
| C-135 | enqueueValueWithSize（Infinityエラー） | E-07 (L162) | ○ |
| C-136 | dequeueValue | E-07 (L128-139) | ○ |
| C-137 | resetQueue | E-07 (L141-146) | ○ |
| C-138 | getIterator（同期） | E-07 (L225-254) | ○ |
| C-139 | getIterator（非同期） | E-07 (L225-254) | ○ |
| C-140 | getIterator（非Iterableエラー） | E-07 (L244-246) | ○ |

### Transfer関連（UT-WBS-141 - UT-WBS-150）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-141 | CrossRealmTransformReadableSource chunk | E-09 (L101-144) | ○ |
| C-142 | CrossRealmTransformReadableSource close | E-09 (L123-126) | ○ |
| C-143 | CrossRealmTransformWritableSink write | E-09 (L226-251) | ○ |
| C-144 | CrossRealmTransformWritableSink close | E-09 (L253-256) | ○ |
| C-145 | CloneableDOMException | E-09 (L46-91) | ○ |
| C-146 | ReadableStream転送 | E-01 (L571-598) | ○ |
| C-147 | ReadableStreamロック時転送エラー | E-01 (L574-581) | ○ |
| C-148 | WritableStream転送 | E-02 (L254-281) | ○ |
| C-149 | WritableStreamロック時転送エラー | E-02 (L257-264) | ○ |
| C-150 | TransformStream転送 | E-03 (L215-240) | △ |

## 4) 不足情報（Unknown / Missing）
- **TransformStream転送のテスト環境依存**：TransformStream転送はMessageChannel経由で行われるため、Worker環境でのテストが必要
  - 候補：test/parallel/test-webstreams-transfer.js / Worker環境でのE2Eテスト
- **TextDecoderStream flush動作の詳細確認**：flush時の不完全なマルチバイト文字の処理
  - 候補：test/parallel/test-webstreams-encoding.js

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはWHATWG Streams Standardに準拠した実装に基づいている
- 1: 中リスク - クロスレルム転送とMessagePort関連のテストは実行環境に依存する可能性がある
- 0: 低リスク - エンコーディング関連のテストはTextEncoder/TextDecoderの標準仕様に基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] ReadableStream/WritableStreamの基本操作（生成、ロック、キャンセル）が正しくテストされているか
- [ ] BYOBリーダーのバッファサイズ検証が適切か
- [ ] バックプレッシャー関連のテストケース（desiredSize、ready）が十分か
- [ ] 圧縮/解凍ストリームの各フォーマット（deflate、gzip、brotli）がカバーされているか
- [ ] Node.jsストリームとのアダプターが双方向でテストされているか
- [ ] エラー状態遷移（erroring -> errored）のテストケースが含まれているか
- [ ] 構造化クローン/転送のテストケースがWorker環境で動作するか確認が必要
