---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 100
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lib-internal-worker 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：100 / 100、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースがソースコードに基づいて生成されている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/internal/worker/io.js` - Worker I/O、MessagePort、BroadcastChannel実装
- E-02: `lib/internal/worker/js_transferable.js` - 構造化クローン、転送モード設定
- E-03: `lib/internal/worker/messaging.js` - スレッド間メッセージング
- E-04: `lib/internal/worker/clone_dom_exception.js` - DOMExceptionエクスポート

## 3) Claims と根拠の対応（レビューの主戦場）

### io.js関連（UT-WRK-001 - UT-WRK-057, UT-WRK-097 - UT-WRK-100）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MessagePort.close()がコールバックを受け取りcloseイベント後に実行する | E-01 (io.js:183-187) | ○ |
| C-02 | MessagePort.hasRef()がブール値を返す | E-01 (io.js:125-127) | ○ |
| C-03 | MessagePort.[kCreateEvent]がmessage/messageerrorタイプでMessageEventを作成する | E-01 (io.js:135-142) | ○ |
| C-04 | MessagePort.[inspect.custom]がアクティブ状態に応じた情報を返す | E-01 (io.js:189-209) | ○ |
| C-05 | setupPortReferencing()がリスナー追加/削除時にref/unrefを管理する | E-01 (io.js:211-247) | ○ |
| C-06 | ReadableWorkerStdioが正しく初期化され_read()でメッセージを送信する | E-01 (io.js:250-277) | ○ |
| C-07 | WritableWorkerStdioが_writev()と_final()でメッセージを送信する | E-01 (io.js:279-330) | ○ |
| C-08 | createWorkerStdio()がstdin/stdout/stderrを作成する | E-01 (io.js:332-340) | ○ |
| C-09 | receiveMessageOnPort()がメッセージの有無に応じて適切な値を返す | E-01 (io.js:342-346) | ○ |
| C-10 | BroadcastChannelが名前付きチャンネルとして初期化される | E-01 (io.js:360-372) | ○ |
| C-11 | BroadcastChannel.close()がハンドルをクローズする | E-01 (io.js:403-414) | ○ |
| C-12 | BroadcastChannel.postMessage()がメッセージを送信する | E-01 (io.js:421-429) | ○ |
| C-13 | BroadcastChannel.ref()/unref()がハンドルのref状態を管理する | E-01 (io.js:439-460) | ○ |
| C-14 | markAsUncloneable()がオブジェクトのクローン可能フラグを削除する | E-01 (io.js:472-477) | ○ |
| C-15 | MessagePortCloseEventがcloseタイプのEventを作成する | E-01 (io.js:165-169) | ○ |
| C-16 | oninit()がNodeEventTargetを初期化する | E-01 (io.js:149-153) | ○ |
| C-17 | onclose()がMessagePortCloseEventをディスパッチする | E-01 (io.js:172-174) | ○ |

### js_transferable.js関連（UT-WRK-058 - UT-WRK-070）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | setup()がデシリアライザを設定する | E-02 (js_transferable.js:33-50) | ○ |
| C-19 | デシリアライザが有効なdeserializeInfoで新インスタンスを作成する | E-02 (js_transferable.js:37-48) | ○ |
| C-20 | デシリアライザが不正なdeserializeInfoでエラーをスローする | E-02 (js_transferable.js:40-46) | ○ |
| C-21 | markTransferMode()がクローン/転送フラグを設定する | E-02 (js_transferable.js:91-98) | ○ |
| C-22 | structuredClone()が値をクローンする | E-02 (js_transferable.js:112-128) | ○ |
| C-23 | structuredClone()が引数なしでエラーをスローする | E-02 (js_transferable.js:113-115) | ○ |

### messaging.js関連（UT-WRK-071 - UT-WRK-095）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | handleMessageFromThread()がREGISTER_MAIN_THREAD_PORTでポートを登録する | E-03 (messaging.js:58-77) | ○ |
| C-25 | handleMessageFromThread()がUNREGISTER_MAIN_THREAD_PORTでポートを登録解除する | E-03 (messaging.js:78-81) | ○ |
| C-26 | handleMessageFromThread()がSEND_MESSAGE_TO_WORKERでメッセージを送信する | E-03 (messaging.js:82-88) | ○ |
| C-27 | handleMessageFromMainThread()がRECEIVE_MESSAGE_FROM_WORKERでメッセージを受信する | E-03 (messaging.js:92-98) | ○ |
| C-28 | sendMessageToWorker()がdestination=0で直接処理する | E-03 (messaging.js:100-105) | ○ |
| C-29 | sendMessageToWorker()が宛先ポートにメッセージを送信する | E-03 (messaging.js:107-127) | ○ |
| C-30 | sendMessageToWorker()が宛先ポートがない場合NO_LISTENERSを返す | E-03 (messaging.js:110-116) | ○ |
| C-31 | receiveMessageFromWorker()がworkerMessageイベントを発火する | E-03 (messaging.js:130-146) | ○ |
| C-32 | createMainThreadPort()がMessageChannelを作成しポートを返す | E-03 (messaging.js:148-168) | ○ |
| C-33 | destroyMainThreadPort()がポートを破棄する | E-03 (messaging.js:170-181) | ○ |
| C-34 | setupMainThreadPort()がメインスレッドポートを設定する | E-03 (messaging.js:183-189) | ○ |
| C-35 | postMessageToThread()がスレッド間でメッセージを送信する | E-03 (messaging.js:191-234) | ○ |
| C-36 | postMessageToThread()が同一スレッドへの送信でエラーをスローする | E-03 (messaging.js:201-202) | ○ |
| C-37 | postMessageToThread()がタイムアウト時にエラーをスローする | E-03 (messaging.js:227-228) | ○ |
| C-38 | postMessageToThread()がリスナーなしでエラーをスローする | E-03 (messaging.js:229-230) | ○ |
| C-39 | postMessageToThread()がリスナーエラー時にエラーをスローする | E-03 (messaging.js:231-232) | ○ |

### clone_dom_exception.js関連（UT-WRK-096）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | DOMExceptionがinternalBindingからエクスポートされる | E-04 (clone_dom_exception.js:4-6) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全テストケースはソースコードに基づいて生成されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに直接対応しており、根拠が明確

### 注意点
- Node.js内部APIのため、internalBindingやprimordialsへの依存がある
- C++バインディング（MessagePort、broadcastChannel等）のモック化が必要
- AtomicsやSharedArrayBufferを使用したテストは環境依存性がある

## 6) レビュアーチェックリスト（最小）
- [ ] 全100テストケースがlib/internal/worker/配下の4ファイルをカバーしているか確認
- [ ] MessagePortの継承チェーン（NodeEventTarget）が正しくテストされているか確認
- [ ] BroadcastChannelのERR_INVALID_THIS検証が全メソッドで行われているか確認
- [ ] postMessageToThread()の非同期処理とエラーハンドリングが網羅されているか確認
- [ ] structuredClone()のwebidlオプション変換が正しくテストされているか確認
- [ ] スレッド間メッセージング（Atomics使用部分）のテスト実行環境を確認

## 7) 解析対象ファイル詳細

### lib/internal/worker/io.js（497行）
Worker I/Oの中核モジュール。以下のクラス・関数を含む：
- **MessagePort**: NodeEventTargetを継承したメッセージポート
- **BroadcastChannel**: 名前付きブロードキャストチャンネル
- **ReadableWorkerStdio/WritableWorkerStdio**: Worker標準入出力ストリーム
- **setupPortReferencing**: ポートのref/unref管理
- **receiveMessageOnPort**: 同期メッセージ受信
- **createWorkerStdio**: Worker stdio作成
- **markAsUncloneable**: クローン不可マーキング

### lib/internal/worker/js_transferable.js（139行）
構造化クローンと転送の設定モジュール：
- **setup**: デシリアライザの初期化
- **markTransferMode**: オブジェクトの転送モード設定
- **structuredClone**: 構造化クローンAPI

### lib/internal/worker/messaging.js（242行）
スレッド間メッセージングモジュール：
- **handleMessageFromThread**: メインスレッドでのメッセージ処理
- **handleMessageFromMainThread**: ワーカースレッドでのメッセージ処理
- **sendMessageToWorker**: ワーカーへのメッセージ送信
- **receiveMessageFromWorker**: ワーカーからのメッセージ受信
- **createMainThreadPort/destroyMainThreadPort**: ポート管理
- **setupMainThreadPort**: ポートセットアップ
- **postMessageToThread**: スレッド間メッセージ送信API

### lib/internal/worker/clone_dom_exception.js（7行）
DOMExceptionエクスポート用の薄いラッパー
