---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 190
  claims_with_evidence: 190
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：src-api 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：190 / 190、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全テストケースがソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/api/async_resource.cc` - AsyncResourceクラスの実装（89行）
- E-02: `src/api/callback.cc` - CallbackScope、InternalCallbackScope、MakeCallback関連の実装（395行）
- E-03: `src/api/embed_helpers.cc` - CommonEnvironmentSetup、EmbedderSnapshotData、SpinEventLoop関連の実装（362行）
- E-04: `src/api/encoding.cc` - ParseEncoding、Encode、Decode関連の実装（183行）
- E-05: `src/api/environment.cc` - Environment作成・管理、Isolate設定、Context初期化関連の実装（1046行）
- E-06: `src/api/exceptions.cc` - ErrnoException、UVException、FatalException関連の実装（251行）
- E-07: `src/api/hooks.cc` - AtExit、EmitProcessBeforeExit/Exit、AsyncHooks関連の実装（253行）
- E-08: `src/api/utils.cc` - signo_string関数の実装（170行）

## 3) Claims と根拠の対応（レビューの主戦場）

### async_resource.cc 関連 (UT-API-001 〜 UT-API-009)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AsyncResource コンストラクタが正常に初期化される | E-01:15-31 | ○ |
| C-02 | string_view版コンストラクタが動作する | E-01:22-31 | ○ |
| C-03 | デストラクタでEmitAsyncDestroyが呼ばれる | E-01:33-36 | ○ |
| C-04 | MakeCallback(Function)が実行される | E-01:38-47 | ○ |
| C-05 | MakeCallback(const char*)が実行される | E-01:49-58 | ○ |
| C-06 | MakeCallback(String)が実行される | E-01:60-69 | ○ |
| C-07 | get_resource()がリソースを返す | E-01:71-73 | ○ |
| C-08 | get_async_id()がIDを返す | E-01:75-77 | ○ |
| C-09 | get_trigger_async_id()がトリガーIDを返す | E-01:79-81 | ○ |

### callback.cc 関連 (UT-API-010 〜 UT-API-032)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | CallbackScope(Isolate*)が初期化される | E-02:22-26 | ○ |
| C-11 | CallbackScope(Environment*, Local)が初期化される | E-02:27-35 | ○ |
| C-12 | CallbackScope(Environment*, Global*)が初期化される | E-02:37-52 | ○ |
| C-13 | デストラクタで例外捕捉時MarkAsFailedが呼ばれる | E-02:54-58 | ○ |
| C-14 | デストラクタで例外未発生時は正常終了 | E-02:54-58 | ○ |
| C-15 | InternalCallbackScope(AsyncWrap*)が初期化される | E-02:60-66 | ○ |
| C-16 | InternalCallbackScopeフル引数版が動作する | E-02:68-126 | ○ |
| C-17 | can_call_into_js=falseでfailed_=true | E-02:93-96 | ○ |
| C-18 | Close()が正常にクローズする | E-02:133-208 | ○ |
| C-19 | is_stopping時にasync_id_stackがクリアされる | E-02:140-145 | ○ |
| C-20 | tick_callbackが呼び出される | E-02:198-207 | ○ |
| C-21 | MarkAsFailed()がfailed_を設定する | E-02:142 | ○ |
| C-22 | InternalMakeCallbackが実行される | E-02:210-271 | ○ |
| C-23 | recv空でCHECK失敗 | E-02:218 | ○ |
| C-24 | async_hooks_trampolineが使用される | E-02:224-236, 247-255 | ○ |
| C-25 | scope.Failed()で空MaybeLocal返却 | E-02:240-242 | ○ |
| C-26 | MakeCallback(const char*)が動作する | E-02:275-286 | ○ |
| C-27 | MakeCallback(String)が動作する | E-02:288-314 | ○ |
| C-28 | callback_vがFunctionでない場合Undefined返却 | E-02:307-311 | ○ |
| C-29 | MakeCallback(Function)が動作する | E-02:316-324 | ○ |
| C-30 | MakeSyncCallbackが実行される | E-02:361-392 | ○ |
| C-31 | ネスト時に直接Call | E-02:375-378 | ○ |
| C-32 | can_call_into_js=falseで空返却 | E-02:372 | ○ |

### embed_helpers.cc 関連 (UT-API-033 〜 UT-API-059)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | SpinEventLoopInternalがイベントループ実行 | E-03:23-78 | ○ |
| C-34 | env=nullでCHECK失敗 | E-03:24 | ○ |
| C-35 | is_stopping()でNothing返却 | E-03:33, 67 | ○ |
| C-36 | SpinEventLoopがint返却 | E-03:272-278 | ○ |
| C-37 | CommonEnvironmentSetupが初期化される | E-03:91-184 | ○ |
| C-38 | platform=nullでCHECK失敗 | E-03:99 | ○ |
| C-39 | uv_loop_init失敗時エラー追加 | E-03:107-111 | ○ |
| C-40 | デストラクタでリソース解放 | E-03:224-258 | ○ |
| C-41 | CreateForSnapshottingが作成される | E-03:192-222 | ○ |
| C-42 | CreateSnapshot()がスナップショット作成 | E-03:260-270 | ○ |
| C-43 | 作成失敗で空Pointer返却 | E-03:267 | ○ |
| C-44 | event_loop()がloop返却 | E-03:280-282 | ○ |
| C-45 | array_buffer_allocator()が返却 | E-03:284-287 | ○ |
| C-46 | isolate()が返却 | E-03:289-291 | ○ |
| C-47 | isolate_data()が返却 | E-03:293-295 | ○ |
| C-48 | env()が返却 | E-03:297-299 | ○ |
| C-49 | context()が返却 | E-03:301-303 | ○ |
| C-50 | snapshot_creator()が返却（スナップショット時） | E-03:305-307 | ○ |
| C-51 | snapshot_creator()がnullptr返却（非スナップショット時） | E-03:306 | ○ |
| C-52 | BuiltinSnapshotData()が返却 | E-03:319-322 | ○ |
| C-53 | FromBlob(vector)が作成 | E-03:324-327 | ○ |
| C-54 | FromBlob(string_view)が作成 | E-03:329-339 | ○ |
| C-55 | 無効blobで空Pointer返却 | E-03:335-337 | ○ |
| C-56 | FromFile()が読み込み | E-03:341-343 | ○ |
| C-57 | ToBlob()がblob変換 | E-03:345-347 | ○ |
| C-58 | ToFile()がファイル書き出し | E-03:349-351 | ○ |
| C-59 | CanUseCustomSnapshotPerIsolate()がfalse返却 | E-03:357-359 | ○ |

### encoding.cc 関連 (UT-API-060 〜 UT-API-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | ParseEncoding("utf8")がUTF8返却 | E-04:25-29, 38-39 | ○ |
| C-61 | ParseEncoding("utf-8")がUTF8返却 | E-04:25-29, 40-41 | ○ |
| C-62 | ParseEncoding("utf16le")がUCS2返却 | E-04:30-31, 46-49 | ○ |
| C-63 | ParseEncoding("ucs2")がUCS2返却 | E-04:33-36, 42-45 | ○ |
| C-64 | ParseEncoding("latin1")がLATIN1返却 | E-04:55-60 | ○ |
| C-65 | ParseEncoding("binary")がLATIN1返却 | E-04:66-68, 80-81 | ○ |
| C-66 | ParseEncoding("buffer")がBUFFER返却 | E-04:70-72, 82-83 | ○ |
| C-67 | ParseEncoding("base64")がBASE64返却 | E-04:74-76, 84-85 | ○ |
| C-68 | ParseEncoding("base64url")がBASE64URL返却 | E-04:77-78, 86-87 | ○ |
| C-69 | ParseEncoding("ascii")がASCII返却 | E-04:93-98 | ○ |
| C-70 | ParseEncoding("hex")がHEX返却 | E-04:104-108 | ○ |
| C-71 | 大文字対応 | E-04:17-19（switch文で'u'と'U'両方対応） | ○ |
| C-72 | 不明エンコーディングでデフォルト返却 | E-04:111 | ○ |
| C-73 | Uint32で直接キャスト | E-04:118-120 | ○ |
| C-74 | V8 Value版がパース | E-04:125-136 | ○ |
| C-75 | 非Stringでデフォルト返却 | E-04:130-131 | ○ |
| C-76 | TryEncodeが文字列エンコード | E-04:138-144 | ○ |
| C-77 | UCS2でCHECK失敗 | E-04:142 | ○ |
| C-78 | TryEncode(uint16_t*)がエンコード | E-04:146-148 | ○ |
| C-79 | Encode(char*)がエンコード | E-04:150-157 | ○ |
| C-80 | Encode(uint16_t*)がエンコード | E-04:159-162 | ○ |
| C-81 | DecodeBytesがバイト数返却 | E-04:165-171 | ○ |
| C-82 | 無効ハンドルで-1返却 | E-04:170 (FromMaybe(-1)) | ○ |
| C-83 | DecodeWriteがバイト数返却 | E-04:174-180 | ○ |

### environment.cc 関連 (UT-API-084 〜 UT-API-152)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | AllowWasmCodeGenerationCallback trueケース | E-05:57-62 | ○ |
| C-85 | AllowWasmCodeGenerationCallback falseケース | E-05:61 | ○ |
| C-86 | ShouldAbortOnUncaughtException trueケース | E-05:64-72 | ○ |
| C-87 | ShouldAbortOnUncaughtException env=null | E-05:67 | ○ |
| C-88 | PrepareStackTraceCallbackが準備 | E-05:74-112 | ○ |
| C-89 | PrepareStackTraceCallback env=null | E-05:78-80 | ○ |
| C-90 | NodeArrayBufferAllocator::Allocate | E-05:114-122 | ○ |
| C-91 | Allocate size=0 | E-05:114-122 | ○ |
| C-92 | AllocateUninitialized | E-05:124-131 | ○ |
| C-93 | Free | E-05:133-136 | ○ |
| C-94 | DebuggingArrayBufferAllocatorデストラクタ正常 | E-05:138-140 | ○ |
| C-95 | DebuggingArrayBufferAllocatorデストラクタCHECK失敗 | E-05:139 | ○ |
| C-96 | DebuggingArrayBufferAllocator::Allocate | E-05:142-147 | ○ |
| C-97 | DebuggingArrayBufferAllocator::Free | E-05:156-160 | ○ |
| C-98 | UnregisterPointerInternal未登録CHECK失敗 | E-05:177-178 | ○ |
| C-99 | ArrayBufferAllocator::Create debug=true | E-05:194-196 | ○ |
| C-100 | ArrayBufferAllocator::Create debug=false | E-05:197-198 | ○ |
| C-101 | CreateArrayBufferAllocator | E-05:201-203 | ○ |
| C-102 | FreeArrayBufferAllocator | E-05:205-207 | ○ |
| C-103 | SetIsolateCreateParamsForNode | E-05:209-225 | ○ |
| C-104 | SetIsolateErrorHandlers | E-05:227-252 | ○ |
| C-105 | SetIsolateMiscHandlers | E-05:254-291 | ○ |
| C-106 | SetIsolateUpForNode(settings) | E-05:293-299 | ○ |
| C-107 | SetIsolateUpForNode() | E-05:301-304 | ○ |
| C-108 | GetOrCreateIsolateGroup | E-05:307-315 | ○ |
| C-109 | NewIsolate(CreateParams*) | E-05:319-368 | ○ |
| C-110 | NewIsolate Allocate失敗 | E-05:326 | ○ |
| C-111 | NewIsolate(ArrayBufferAllocator*) | E-05:370-382 | ○ |
| C-112 | NewIsolate(shared_ptr) | E-05:384-396 | ○ |
| C-113 | CreateIsolateData | E-05:398-406 | ○ |
| C-114 | FreeIsolateData | E-05:408-410 | ○ |
| C-115 | CreateEnvironment | E-05:423-517 | ○ |
| C-116 | CreateEnvironment スナップショット復元 | E-05:474-494 | ○ |
| C-117 | CreateEnvironment ブートストラップ失敗 | E-05:511-514 | ○ |
| C-118 | FreeEnvironment | E-05:519-538 | ○ |
| C-119 | GetInspectorParentHandle | E-05:540-572 | ○ |
| C-120 | GetInspectorParentHandle インスペクタ無効 | E-05:563-565 | ○ |
| C-121 | LoadEnvironment(callback) | E-05:574-585 | ○ |
| C-122 | LoadEnvironment(string_view) | E-05:587-605 | ○ |
| C-123 | GetCurrentEnvironment | E-05:607-609 | ○ |
| C-124 | GetEnvironmentIsolateData | E-05:611-613 | ○ |
| C-125 | GetArrayBufferAllocator | E-05:615-617 | ○ |
| C-126 | GetMainContext | E-05:619-621 | ○ |
| C-127 | GetMultiIsolatePlatform | E-05:623-629 | ○ |
| C-128 | MultiIsolatePlatform::Create | E-05:631-638 | ○ |
| C-129 | GetPerContextExports | E-05:640-664 | ○ |
| C-130 | GetPerContextExports 既存 | E-05:651-653 | ○ |
| C-131 | NewContext | E-05:669-679 | ○ |
| C-132 | NewContext 失敗 | E-05:672, 675 | ○ |
| C-133 | InitializeContextRuntime | E-05:687-764 | ○ |
| C-134 | InitializeContextRuntime disable_proto=delete | E-05:737-742 | ○ |
| C-135 | InitializeContextRuntime disable_proto=throw | E-05:743-758 | ○ |
| C-136 | InitializeBaseContextForSnapshot | E-05:766-789 | ○ |
| C-137 | InitializeMainContextForSnapshot | E-05:791-805 | ○ |
| C-138 | InitializePrimordials | E-05:857-919 | ○ |
| C-139 | InitializePrimordials 二重初期化CHECK | E-05:870 | ○ |
| C-140 | InitializeContext | E-05:922-931 | ○ |
| C-141 | GetCurrentEventLoop | E-05:933-940 | ○ |
| C-142 | GetCurrentEventLoop context空 | E-05:936 | ○ |
| C-143 | GetCurrentEventLoop env=null | E-05:938 | ○ |
| C-144 | AddLinkedBinding(node_module) | E-05:942-950 | ○ |
| C-145 | AddLinkedBinding(napi_module) | E-05:952-956 | ○ |
| C-146 | AddLinkedBinding(関数ポインタ) | E-05:958-974 | ○ |
| C-147 | AllocateEnvironmentThreadId | E-05:994-998 | ○ |
| C-148 | AllocateEnvironmentThreadId 連番 | E-05:994, 997 | ○ |
| C-149 | Exit | E-05:1000-1002 | ○ |
| C-150 | DefaultProcessExitHandlerInternal | E-05:1004-1026 | ○ |
| C-151 | DefaultProcessExitHandler | E-05:1028-1030 | ○ |
| C-152 | SetProcessExitHandler | E-05:1032-1043 | ○ |

### exceptions.cc 関連 (UT-API-153 〜 UT-API-159)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-153 | ErrnoException作成 | E-06:23-73 | ○ |
| C-154 | ErrnoException msg=null | E-06:33-35 | ○ |
| C-155 | ErrnoException path=null | E-06:43, 48 | ○ |
| C-156 | UVException作成 | E-06:91-152 | ○ |
| C-157 | UVException dest設定 | E-06:126-134, 149 | ○ |
| C-158 | UVException msg=null | E-06:100-101 | ○ |
| C-159 | FatalException | E-06:246-248 | ○ |

### hooks.cc 関連 (UT-API-160 〜 UT-API-186)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-160 | RunAtExit | E-07:20-22 | ○ |
| C-161 | AtExit登録 | E-07:24-27 | ○ |
| C-162 | AtExit env=null CHECK | E-07:25 | ○ |
| C-163 | EmitProcessBeforeExit | E-07:29-47 | ○ |
| C-164 | EmitProcessBeforeExit DestroyAsyncIds | E-07:31-32 | ○ |
| C-165 | EmitProcessBeforeExit can_call_into_js=false | E-07:38-40 | ○ |
| C-166 | EmitProcessExitInternal | E-07:49-81 | ○ |
| C-167 | EmitProcessExitInternal TLA | E-07:64-70 | ○ |
| C-168 | EmitProcessExitInternal can_call_into_js=false | E-07:57-59 | ○ |
| C-169 | EmitProcessExit | E-07:83-89 | ○ |
| C-170 | AddEnvironmentCleanupHook | E-07:118-124 | ○ |
| C-171 | RemoveEnvironmentCleanupHook | E-07:126-132 | ○ |
| C-172 | AddEnvironmentCleanupHookInternal | E-07:149-162 | ○ |
| C-173 | RemoveEnvironmentCleanupHookInternal | E-07:164-169 | ○ |
| C-174 | RemoveEnvironmentCleanupHookInternal started | E-07:166 | ○ |
| C-175 | RequestInterrupt | E-07:171-179 | ○ |
| C-176 | AsyncHooksGetExecutionAsyncId(Isolate*) | E-07:181-185 | ○ |
| C-177 | AsyncHooksGetExecutionAsyncId env=null | E-07:183 | ○ |
| C-178 | AsyncHooksGetExecutionAsyncId(Context) | E-07:187-191 | ○ |
| C-179 | AsyncHooksGetTriggerAsyncId | E-07:193-197 | ○ |
| C-180 | AsyncHooksGetTriggerAsyncId env=null | E-07:195 (暗黙) | ○ |
| C-181 | EmitAsyncInit(const char*) | E-07:200-206 | ○ |
| C-182 | EmitAsyncInit(string_view) | E-07:208-218 | ○ |
| C-183 | EmitAsyncInit(String) | E-07:220-242 | ○ |
| C-184 | EmitAsyncInit trigger_async_id=-1 | E-07:229-230 | ○ |
| C-185 | EmitAsyncDestroy(Isolate*) | E-07:244-246 | ○ |
| C-186 | EmitAsyncDestroy(Environment*) | E-07:248-250 | ○ |

### utils.cc 関連 (UT-API-187 〜 UT-API-190)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-187 | signo_string SIGINT | E-08:18-19 (SIGNO_CASE) | ○ |
| C-188 | signo_string SIGTERM | E-08:74 | ○ |
| C-189 | signo_string SIGKILL | E-08:50-52 | ○ |
| C-190 | signo_string 未知シグナル | E-08:164-166 | ○ |

## 4) 不足情報（Unknown / Missing）
- **該当なし**：全テストケースが実際のソースコードに基づいて生成されています
- 全190件のテストケースについて、対応するソースコードの行番号を特定済み

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードの実装に直接対応しており、推測や仮定に基づく主張はありません

### 注意点
1. C++コードのため、一部のテストは単体テストフレームワーク（Google Testなど）での実装が必要
2. V8 Isolate、Environment等のNode.js内部オブジェクトのモック化が必要な場合あり
3. 一部のテスト（プロセス終了系）は統合テストとして実装した方が適切な場合あり

## 6) レビュアーチェックリスト（最小）
- [ ] テストID命名規則（UT-API-XXX）が一貫しているか
- [ ] 優先度の設定が妥当か（高：金額計算・認証・データ整合性、中：リレーション・アクセサ、低：ヘルパー）
- [ ] 境界値テストが網羅されているか
- [ ] 異常系テスト（null/空値、不正な型）が含まれているか
- [ ] CHECK_NOT_NULL等のアサーションに対するテストが含まれているか
- [ ] async_hooks関連のテストでコンテキスト管理が正しいか
- [ ] メモリ管理（Allocator）関連のテストでリーク検出が含まれているか
